/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.BatchResult;
import astro.tool.box.enumeration.AsynchResult;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.enumeration.LookupTable;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.lookup.SpectralTypeLookupEntry;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import astro.tool.box.util.FileTypeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class BatchQueryTab
implements Tab {
    public static final String TAB_NAME = "Batch Search";
    private static final int MAX_SEARCH_RADIUS = 10;
    private static final int MAX_INPUT_ROWS = 50000;
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryTab catalogQueryTab;
    private final ImageViewerTab imageViewerTab;
    private JPanel bottomRow;
    private JPanel centerPanel;
    private JTextField echoField;
    private JCheckBox includeColors;
    private JComboBox lookupTables;
    private JProgressBar progressBar;
    private JButton cancelButton;
    private File file;
    private List<String> selectedCatalogs;
    private List<BatchResult> batchResults;
    private final CatalogQueryService catalogQueryService;
    private SpectralTypeLookupService spectralTypeLookupService;
    private final Map<String, CatalogEntry> catalogInstances;
    private boolean isProcessing;
    private boolean toCancel;
    private int raColumnIndex;
    private int decColumnIndex;
    private double searchRadius;

    public BatchQueryTab(JFrame baseFrame, JTabbedPane tabbedPane, CatalogQueryTab catalogQueryTab, ImageViewerTab imageViewerTab) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryTab = catalogQueryTab;
        this.imageViewerTab = imageViewerTab;
        this.catalogInstances = ToolboxHelper.getCatalogInstances();
        this.catalogQueryService = new CatalogQueryService();
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new GridLayout(4, 1));
            mainPanel.add((Component)topPanel, "First");
            JPanel topRow = new JPanel(new FlowLayout(0));
            topPanel.add(topRow);
            JPanel centerRow = new JPanel(new FlowLayout(0));
            topPanel.add(centerRow);
            this.bottomRow = new JPanel(new FlowLayout(0));
            topPanel.add(this.bottomRow);
            JPanel echoPanel = new JPanel(new FlowLayout(0));
            topPanel.add(echoPanel);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileTypeFilter(".csv", ".csv files"));
            JTextField fileNameField = new JTextField(50);
            fileNameField.setEditable(false);
            JButton importButton = new JButton("Import csv file with header");
            topRow.add(importButton);
            importButton.addActionListener(evt -> {
                int returnVal = fileChooser.showOpenDialog(topRow);
                if (returnVal == 0) {
                    this.file = fileChooser.getSelectedFile();
                    fileNameField.setText(this.file.getName());
                }
            });
            topRow.add(new JLabel("Imported file:"));
            topRow.add(fileNameField);
            centerRow.add(new JLabel("RA position:"));
            JTextField raColumnPosition = new JTextField(2);
            centerRow.add(raColumnPosition);
            centerRow.add(new JLabel("dec position:"));
            JTextField decColumnPosition = new JTextField(2);
            centerRow.add(decColumnPosition);
            centerRow.add(new JLabel("Search radius:"));
            JTextField radiusField = new JTextField("5", 3);
            centerRow.add(radiusField);
            centerRow.add(new JLabel("Include colors:"));
            this.includeColors = new JCheckBox();
            centerRow.add(this.includeColors);
            centerRow.add(new JLabel("Relations table:"));
            this.lookupTables = new JComboBox<LookupTable>(new LookupTable[]{LookupTable.MAIN_SEQUENCE, LookupTable.MLT_DWARFS});
            centerRow.add(this.lookupTables);
            JButton queryButton = new JButton("Start query");
            centerRow.add(queryButton);
            queryButton.addActionListener(evt -> {
                if (this.isProcessing) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "There's still a query being processed!");
                    return;
                }
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No file selected!");
                    return;
                }
                if (!this.file.getName().endsWith(".csv")) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "The selected file is not a .csv file!");
                    return;
                }
                int rows = 0;
                try (Scanner scanner2 = new Scanner(this.file);){
                    while (scanner2.hasNextLine()) {
                        scanner2.nextLine();
                        ++rows;
                    }
                }
                catch (FileNotFoundException scanner2) {
                    // empty catch block
                }
                if (rows > 50000) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "The selected file contains " + rows + " rows! Max. allowed: 50000");
                    return;
                }
                StringBuilder errors = new StringBuilder();
                try {
                    this.raColumnIndex = NumericFunctions.toInteger(raColumnPosition.getText()) - 1;
                    if (this.raColumnIndex < 0) {
                        errors.append("RA position must be greater than 0.").append(Constants.LINE_SEP);
                    }
                }
                catch (Exception ex) {
                    errors.append("Invalid RA position!").append(Constants.LINE_SEP);
                }
                try {
                    this.decColumnIndex = NumericFunctions.toInteger(decColumnPosition.getText()) - 1;
                    if (this.decColumnIndex < 0) {
                        errors.append("Dec position must be greater than 0.").append(Constants.LINE_SEP);
                    }
                }
                catch (Exception ex) {
                    errors.append("Invalid dec position!").append(Constants.LINE_SEP);
                }
                try {
                    this.searchRadius = NumericFunctions.toDouble(radiusField.getText());
                    if (this.searchRadius > 10.0) {
                        errors.append("Radius must not be larger than ").append(10).append(" arcsec.").append(Constants.LINE_SEP);
                    }
                }
                catch (Exception ex) {
                    errors.append("Invalid radius!").append(Constants.LINE_SEP);
                }
                if (errors.length() > 0) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, errors.toString());
                    return;
                }
                this.selectedCatalogs = new ArrayList<String>();
                for (Component component : this.bottomRow.getComponents()) {
                    JCheckBox catalogBox;
                    if (!(component instanceof JCheckBox) || !(catalogBox = (JCheckBox)component).isSelected()) continue;
                    this.selectedCatalogs.add(catalogBox.getText());
                }
                if (this.selectedCatalogs.isEmpty()) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No catalog selected!");
                    return;
                }
                this.batchResults = null;
                if (this.centerPanel != null) {
                    mainPanel.remove(this.centerPanel);
                }
                this.centerPanel = new JPanel(new GridLayout(1, 1));
                mainPanel.add(this.centerPanel);
                if (this.progressBar != null) {
                    centerRow.remove(this.progressBar);
                }
                this.progressBar = new JProgressBar(0, rows);
                centerRow.add(this.progressBar);
                this.progressBar.setStringPainted(true);
                if (this.cancelButton != null) {
                    centerRow.remove(this.cancelButton);
                }
                this.cancelButton = new JButton("Cancel query");
                centerRow.add(this.cancelButton);
                this.cancelButton.addActionListener(e -> {
                    this.toCancel = true;
                });
                this.baseFrame.setVisible(true);
                CompletableFuture.supplyAsync(() -> this.queryCatalogs());
            });
            this.bottomRow.add(new JLabel("Catalogs:"));
            for (String catalogKey : this.catalogInstances.keySet()) {
                JCheckBox catalog = new JCheckBox(catalogKey);
                catalog.setSelected(true);
                this.bottomRow.add(catalog);
            }
            echoPanel.add(new JLabel("Status:"));
            this.echoField = new JTextField(90);
            echoPanel.add(this.echoField);
            this.echoField.setEditable(false);
            JButton exportButton = new JButton("Export results");
            echoPanel.add(exportButton);
            exportButton.addActionListener(evt -> {
                if (this.batchResults == null || this.batchResults.isEmpty()) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Nothing to export yet!");
                } else {
                    Object content = this.batchResults.stream().map(result -> result.getValues()).collect(Collectors.joining(Constants.LINE_SEP));
                    content = this.batchResults.get(0).getTitles() + Constants.LINE_SEP + (String)content;
                    try {
                        File tmpFile = File.createTempFile("AstroToolBox_", ".csv");
                        try (FileWriter writer = new FileWriter(tmpFile);){
                            writer.write((String)content);
                        }
                        Desktop.getDesktop().open(tmpFile);
                    }
                    catch (IOException ex) {
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                }
            });
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(mainPanel));
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Future<AsynchResult> queryCatalogs() {
        this.toCancel = false;
        this.isProcessing = true;
        this.echoField.setText("Query is running ...");
        this.echoField.setBackground(JColor.LIGHT_BLUE.val);
        CompletableFuture<AsynchResult> future = new CompletableFuture<AsynchResult>();
        this.batchResults = new ArrayList<BatchResult>();
        int rowNumber = 1;
        int objectNumber = 1;
        LookupTable selectedTable = (LookupTable)((Object)this.lookupTables.getSelectedItem());
        switch (selectedTable) {
            case MAIN_SEQUENCE: {
                List<SpectralTypeLookup> entries;
                Stream<String> stream;
                InputStream input;
                try {
                    input = this.getClass().getResourceAsStream("/SpectralTypeLookupTable.csv");
                    try {
                        stream = new BufferedReader(new InputStreamReader(input)).lines();
                        entries = stream.skip(1L).map(line -> new SpectralTypeLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                        this.spectralTypeLookupService = new SpectralTypeLookupService(entries);
                        break;
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (IOException e) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, e);
                    throw new RuntimeException(e);
                }
            }
            case MLT_DWARFS: {
                List<SpectralTypeLookup> entries;
                Stream<String> stream;
                InputStream input;
                try {
                    input = this.getClass().getResourceAsStream("/BrownDwarfLookupTable.csv");
                    try {
                        stream = new BufferedReader(new InputStreamReader(input)).lines();
                        entries = stream.skip(1L).map(line -> new BrownDwarfLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                        this.spectralTypeLookupService = new SpectralTypeLookupService(entries);
                        break;
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (IOException e) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, e);
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)selectedTable));
            }
        }
        try (Scanner scanner = new Scanner(this.file);){
            String[] columns = scanner.nextLine().split(",");
            StringBuilder errors = new StringBuilder();
            int numberOfColumns = columns.length;
            int lastColumnIndex = numberOfColumns - 1;
            if (this.raColumnIndex > lastColumnIndex) {
                errors.append("RA position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (this.decColumnIndex > lastColumnIndex) {
                errors.append("Dec position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (errors.length() > 0) {
                this.handleError(future, errors.toString());
                CompletableFuture<AsynchResult> completableFuture = future;
                return completableFuture;
            }
            while (scanner.hasNextLine()) {
                if (this.toCancel) {
                    this.echoField.setText("Query cancelled!");
                    this.echoField.setBackground(JColor.LIGHT_YELLOW.val);
                    future.complete(AsynchResult.CANCELLED);
                    this.isProcessing = false;
                    CompletableFuture<AsynchResult> completableFuture = future;
                    return completableFuture;
                }
                columns = scanner.nextLine().split(",", -1);
                String raValue = columns[this.raColumnIndex];
                String decValue = columns[this.decColumnIndex];
                if (!NumericFunctions.isNumeric(raValue) || !NumericFunctions.isNumeric(decValue)) {
                    this.handleError(future, "RA and dec must be numeric!");
                    CompletableFuture<AsynchResult> completableFuture = future;
                    return completableFuture;
                }
                double targetRa = NumericFunctions.toDouble(raValue);
                double targetDec = NumericFunctions.toDouble(decValue);
                int resultCount = 0;
                ListIterator<String> iter = this.selectedCatalogs.listIterator();
                while (iter.hasNext()) {
                    Object entry;
                    CatalogEntry catalogEntry = this.catalogInstances.get(iter.next());
                    catalogEntry.setRa(targetRa);
                    catalogEntry.setDec(targetDec);
                    catalogEntry.setSearchRadius(this.searchRadius);
                    catalogEntry = this.performQuery(catalogEntry);
                    if (catalogEntry == null) continue;
                    List<String> spectralTypes = ToolboxHelper.lookupSpectralTypes(catalogEntry.getColors(true), this.spectralTypeLookupService, this.includeColors.isSelected());
                    if (catalogEntry instanceof SimbadCatalogEntry) {
                        SimbadCatalogEntry simbadEntry = (SimbadCatalogEntry)catalogEntry;
                        StringBuilder simbadType = new StringBuilder();
                        simbadType.append(simbadEntry.getObjectType());
                        if (!simbadEntry.getSpectralType().isEmpty()) {
                            simbadType.append(" ").append(simbadEntry.getSpectralType());
                        }
                        simbadType.append("; ");
                        spectralTypes.add(0, simbadType.toString());
                    }
                    if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN(((AllWiseCatalogEntry)(entry = (AllWiseCatalogEntry)catalogEntry)).getW1_W2(), ((AllWiseCatalogEntry)entry).getW2_W3())) {
                        spectralTypes.add("Possible AGN!");
                    }
                    if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry.getBP_RP())) {
                        spectralTypes.add("Possible white dwarf!");
                    }
                    BatchResult batchResult = new BatchResult.Builder().setRowNumber(rowNumber).setObjectNumber(objectNumber).setCatalogName(catalogEntry.getCatalogName()).setTargetRa(targetRa).setTargetDec(targetDec).setTargetDistance(catalogEntry.getTargetDistance()).setRa(catalogEntry.getRa()).setDec(catalogEntry.getDec()).setSourceId(catalogEntry.getSourceId() + " ").setPlx(catalogEntry.getPlx()).setPmra(catalogEntry.getPmra()).setPmdec(catalogEntry.getPmdec()).setMagnitudes(catalogEntry.getMagnitudes()).setSpectralTypes(spectralTypes).build();
                    this.batchResults.add(batchResult);
                    ++resultCount;
                    ++rowNumber;
                }
                if (resultCount == 0) {
                    this.batchResults.add(new BatchResult(rowNumber, objectNumber, targetRa, targetDec));
                    ++rowNumber;
                }
                this.progressBar.setValue(++objectNumber);
            }
        }
        catch (Exception ex) {
            this.handleError(future, ex.toString());
            return future;
        }
        this.displayQueryResults();
        this.echoField.setText("Query completed successfully!");
        this.echoField.setBackground(JColor.LIGHT_GREEN.val);
        future.complete(AsynchResult.SUCCESS);
        this.baseFrame.setVisible(true);
        this.isProcessing = false;
        return future;
    }

    private void handleError(CompletableFuture<AsynchResult> future, String message) {
        this.echoField.setText(message);
        this.echoField.setBackground(JColor.LIGHT_RED.val);
        future.complete(AsynchResult.ERROR);
        this.isProcessing = false;
    }

    private CatalogEntry performQuery(CatalogEntry catalogQuery) throws IOException {
        List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
        catalogEntries.forEach(catalogEntry -> {
            catalogEntry.setTargetRa(catalogQuery.getRa());
            catalogEntry.setTargetDec(catalogQuery.getDec());
        });
        if (!catalogEntries.isEmpty()) {
            catalogEntries.sort(Comparator.comparingDouble(CatalogEntry::getTargetDistance));
            return catalogEntries.get(0);
        }
        return null;
    }

    private void displayQueryResults() {
        ArrayList list = new ArrayList();
        this.batchResults.forEach(entry -> list.add(entry.getColumnValues()));
        BatchResult result = this.batchResults.get(0);
        Object[] columns = result.getColumnTitles();
        Object[][] rows = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])list.toArray((T[])rows), columns);
        JTable resultTable = new JTable(defaultTableModel);
        ToolboxHelper.alignResultColumns(resultTable);
        resultTable.setAutoCreateRowSorter(true);
        resultTable.setAutoResizeMode(0);
        resultTable.setRowSorter(ToolboxHelper.createResultTableSorter(defaultTableModel));
        resultTable.setSelectionMode(0);
        resultTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int rowNumber = Integer.parseInt((String)resultTable.getValueAt(resultTable.getSelectedRow(), 0));
                BatchResult selected = this.batchResults.stream().filter(entry -> entry.getRowNumber() == rowNumber).findFirst().get();
                if (selected != null) {
                    String coords = selected.getTargetRa() + " " + selected.getTargetDec();
                    this.imageViewerTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getRadiusField().setText(NumericFunctions.roundTo2DecNZ(this.searchRadius));
                    this.catalogQueryTab.getSearchLabel().setText("");
                    this.catalogQueryTab.removeAndRecreateCenterPanel();
                    this.catalogQueryTab.removeAndRecreateBottomPanel();
                }
            }
        });
        ToolboxHelper.resizeColumnWidth(resultTable);
        JScrollPane resultScrollPanel = new JScrollPane(resultTable);
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Batch query results", 1, 2));
        this.centerPanel.add(resultScrollPanel);
    }

    public JPanel getBottomRow() {
        return this.bottomRow;
    }
}

