/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.catalog.GaiaCmd;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.enumeration.ObjectType;
import astro.tool.box.exception.ExtinctionException;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.DistanceLookupResult;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.lookup.SpectralTypeLookupEntry;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.panel.GaiaCmdPanel;
import astro.tool.box.panel.ReferencesPanel;
import astro.tool.box.panel.SedUcdPanel;
import astro.tool.box.panel.SedWdPanel;
import astro.tool.box.panel.WiseCcdPanel;
import astro.tool.box.panel.WiseLcPanel;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.DistanceLookupService;
import astro.tool.box.service.DustExtinctionService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class CatalogQueryTab
implements Tab {
    public static final String TAB_NAME = "Catalog Search";
    private static final int BOTTOM_PANEL_HEIGHT = 375;
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final Map<String, CatalogEntry> catalogInstances;
    private final CatalogQueryService catalogQueryService;
    private final SpectralTypeLookupService mainSequenceSpectralTypeLookupService;
    private final SpectralTypeLookupService brownDwarfsSpectralTypeLookupService;
    private final DistanceLookupService distanceLookupService;
    private final DustExtinctionService dustExtinctionService;
    private final List<SpectralTypeLookup> brownDwarfLookupEntries;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel searchLabel;
    private JButton searchButton;
    private JTextField coordsField;
    private JTextField radiusField;
    private JTable collectionTable;
    private JTable currentTable;
    private CatalogEntry selectedEntry;
    private double targetRa;
    private double targetDec;
    private double searchRadius;
    private int windowShift;
    private boolean copyCoordsToClipboard;

    public CatalogQueryTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        Stream<String> stream;
        InputStream input;
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogInstances = ToolboxHelper.getCatalogInstances();
        this.catalogQueryService = new CatalogQueryService();
        this.dustExtinctionService = new DustExtinctionService();
        try {
            input = this.getClass().getResourceAsStream("/SpectralTypeLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                List<SpectralTypeLookup> entries = stream.skip(1L).map(line -> new SpectralTypeLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.mainSequenceSpectralTypeLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
        try {
            input = this.getClass().getResourceAsStream("/BrownDwarfLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                this.brownDwarfLookupEntries = stream.skip(1L).map(line -> new BrownDwarfLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.brownDwarfsSpectralTypeLookupService = new SpectralTypeLookupService(this.brownDwarfLookupEntries);
                this.distanceLookupService = new DistanceLookupService(this.brownDwarfLookupEntries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(boolean visible) {
        try {
            this.mainPanel = new JPanel(new BorderLayout());
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(this.mainPanel));
            }
            this.topPanel = new JPanel(new FlowLayout(0));
            this.topPanel.setPreferredSize(new Dimension(1000, 60));
            JLabel coordsLabel = new JLabel("Coordinates:");
            this.topPanel.add(coordsLabel);
            this.coordsField = new JTextField(25);
            this.topPanel.add(this.coordsField);
            this.coordsField.addActionListener(e -> this.searchCatalogs());
            JLabel radiusLabel = new JLabel("Search radius (arcsec):");
            this.topPanel.add(radiusLabel);
            this.radiusField = new JTextField(5);
            this.topPanel.add(this.radiusField);
            this.radiusField.addActionListener(e -> this.searchCatalogs());
            JLabel catalogLabel = new JLabel("Catalogs:");
            this.topPanel.add(catalogLabel);
            for (String catalogKey : this.catalogInstances.keySet()) {
                JCheckBox catalog = new JCheckBox(catalogKey);
                catalog.setSelected(true);
                this.topPanel.add(catalog);
            }
            this.searchButton = new JButton("Search");
            this.topPanel.add(this.searchButton);
            this.searchButton.addActionListener(e -> this.searchCatalogs());
            this.searchLabel = new JLabel();
            this.topPanel.add(this.searchLabel);
            this.baseFrame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    String coords = CatalogQueryTab.this.coordsField.getText();
                    if (!coords.isEmpty() && CatalogQueryTab.this.selectedEntry != null) {
                        CatalogQueryTab.this.removeAndRecreateBottomPanel();
                        CatalogQueryTab.this.displayCatalogDetails(CatalogQueryTab.this.selectedEntry);
                        CatalogQueryTab.this.displaySpectralTypes(CatalogQueryTab.this.selectedEntry, true);
                    }
                }
            });
            this.mainPanel.add((Component)this.topPanel, "First");
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void searchCatalogs() {
        try {
            String coords = this.coordsField.getText();
            if (coords.isEmpty()) {
                ToolboxHelper.showErrorDialog(this.baseFrame, "Coordinates must not be empty!");
                return;
            }
            String radius = this.radiusField.getText();
            if (radius.isEmpty()) {
                ToolboxHelper.showErrorDialog(this.baseFrame, "Search radius must not be empty!");
                return;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            try {
                NumberPair coordinates = ToolboxHelper.getCoordinates(coords);
                this.targetRa = coordinates.getX();
                this.targetDec = coordinates.getY();
                if (this.targetRa < 0.0) {
                    errorMessages.add("RA must not be smaller than 0 deg.");
                }
                if (this.targetRa > 360.0) {
                    errorMessages.add("RA must not be greater than 360 deg.");
                }
                if (this.targetDec < -90.0) {
                    errorMessages.add("Dec must not be smaller than -90 deg.");
                }
                if (this.targetDec > 90.0) {
                    errorMessages.add("Dec must not be greater than 90 deg.");
                }
            }
            catch (Exception ex) {
                this.targetRa = 0.0;
                this.targetDec = 0.0;
                errorMessages.add("Invalid coordinates!");
            }
            try {
                this.searchRadius = Double.parseDouble(radius);
                if (this.searchRadius > 300.0) {
                    errorMessages.add("Radius must not be larger than 300 arcsec.");
                }
            }
            catch (NumberFormatException ex) {
                this.searchRadius = 0.0;
                errorMessages.add("Invalid radius!");
            }
            ArrayList<String> selectedCatalogs = new ArrayList<String>();
            for (Component component : this.topPanel.getComponents()) {
                JCheckBox catalogBox;
                if (!(component instanceof JCheckBox) || !(catalogBox = (JCheckBox)component).isSelected()) continue;
                selectedCatalogs.add(catalogBox.getText());
            }
            if (selectedCatalogs.isEmpty()) {
                errorMessages.add("No catalog selected!");
            }
            if (!errorMessages.isEmpty()) {
                this.searchLabel.setText("");
                String message = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                ToolboxHelper.showErrorDialog(this.baseFrame, message);
            } else {
                this.selectedEntry = null;
                if (this.copyCoordsToClipboard) {
                    ToolboxHelper.copyCoordsToClipboard(this.targetRa, this.targetDec);
                }
                this.removeAndRecreateCenterPanel();
                this.removeAndRecreateBottomPanel();
                CompletableFuture.supplyAsync(() -> {
                    this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
                    this.coordsField.setCursor(Cursor.getPredefinedCursor(3));
                    this.radiusField.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        int count = 0;
                        StringBuilder resultsPerCatalog = new StringBuilder();
                        ListIterator iter = selectedCatalogs.listIterator();
                        while (iter.hasNext()) {
                            CatalogEntry catalogQuery = this.catalogInstances.get(iter.next());
                            catalogQuery.setRa(this.targetRa);
                            catalogQuery.setDec(this.targetDec);
                            catalogQuery.setSearchRadius(this.searchRadius);
                            int results = this.queryCatalog(catalogQuery);
                            count += results;
                            resultsPerCatalog.append(catalogQuery.getCatalogName()).append(": ").append(results);
                            if (!iter.hasNext()) continue;
                            resultsPerCatalog.append("; ");
                        }
                        String searchLabelText = "RA=" + this.targetRa + "\u00b0 dec=" + this.targetDec + "\u00b0 radius=" + this.searchRadius + " arcsec";
                        if (count > 0) {
                            this.searchLabel.setText(count + " result(s) for " + searchLabelText + " (" + String.valueOf(resultsPerCatalog) + ")");
                        } else {
                            this.searchLabel.setText("No results for " + searchLabelText);
                        }
                        this.baseFrame.setVisible(true);
                    }
                    catch (IOException ex) {
                        ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    }
                    finally {
                        this.baseFrame.setCursor(Cursor.getDefaultCursor());
                        this.coordsField.setCursor(Cursor.getPredefinedCursor(2));
                        this.radiusField.setCursor(Cursor.getPredefinedCursor(2));
                    }
                    return null;
                });
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private int queryCatalog(CatalogEntry catalogQuery) throws IOException {
        List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
        catalogEntries.forEach(catalogEntry -> {
            catalogEntry.setTargetRa(catalogQuery.getRa());
            catalogEntry.setTargetDec(catalogQuery.getDec());
            catalogEntry.loadCatalogElements();
        });
        if (!catalogEntries.isEmpty()) {
            this.displayCatalogResults(catalogEntries);
            this.baseFrame.setVisible(true);
        }
        return catalogEntries.size();
    }

    private void displayCatalogResults(List<CatalogEntry> catalogEntries) {
        this.selectedEntry = null;
        ArrayList list = new ArrayList();
        catalogEntries.forEach(entry -> list.add(entry.getColumnValues()));
        CatalogEntry catalogEntry = catalogEntries.get(0);
        Object[] columns = catalogEntry.getColumnTitles();
        Object[][] rows = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])list.toArray((T[])rows), columns);
        JTable catalogTable = new JTable(defaultTableModel);
        ToolboxHelper.alignCatalogColumns(catalogTable, catalogEntry);
        catalogTable.setAutoCreateRowSorter(true);
        catalogTable.setAutoResizeMode(0);
        catalogTable.setRowSorter(ToolboxHelper.createCatalogTableSorter(defaultTableModel, catalogEntry));
        catalogTable.getRowSorter().toggleSortOrder(0);
        catalogTable.setSelectionMode(0);
        catalogTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != catalogTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = catalogTable;
                String sourceId = (String)catalogTable.getValueAt(catalogTable.getSelectedRow(), 1);
                CatalogEntry selected = catalogEntries.stream().filter(entry -> entry.getSourceId().equals(sourceId)).findFirst().get();
                if (selected != null) {
                    this.selectedEntry = selected;
                    this.removeAndRecreateBottomPanel();
                    if (this.copyCoordsToClipboard) {
                        ToolboxHelper.copyCoordsToClipboard(selected.getRa(), selected.getDec());
                    }
                    this.displayCatalogDetails(selected);
                    this.displaySpectralTypes(selected, true);
                    this.baseFrame.setVisible(true);
                }
            }
        });
        ToolboxHelper.resizeColumnWidth(catalogTable);
        JButton saveButton = new JButton("Save as CSV file");
        saveButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save CSV File");
            FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV Files", "csv");
            fileChooser.setFileFilter(filter);
            int userSelection = fileChooser.showSaveDialog(null);
            if (userSelection == 0) {
                File fileToSave = fileChooser.getSelectedFile();
                if (!fileToSave.getName().toLowerCase().endsWith(".csv")) {
                    fileToSave = new File(fileToSave.getAbsolutePath() + ".csv");
                }
                try (FileWriter csvWriter = new FileWriter(fileToSave);){
                    for (int i = 0; i < catalogTable.getColumnCount(); ++i) {
                        csvWriter.append(catalogTable.getColumnName(i));
                        if (i < catalogTable.getColumnCount() - 1) {
                            csvWriter.append(',');
                            continue;
                        }
                        csvWriter.append('\n');
                    }
                    for (int row = 0; row < catalogTable.getRowCount(); ++row) {
                        for (int col = 0; col < catalogTable.getColumnCount(); ++col) {
                            csvWriter.append(catalogTable.getValueAt(row, col).toString());
                            if (col < catalogTable.getColumnCount() - 1) {
                                csvWriter.append(',');
                                continue;
                            }
                            csvWriter.append('\n');
                        }
                    }
                }
                catch (Exception ex) {
                    ToolboxHelper.writeErrorLog(ex);
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(saveButton);
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(BorderFactory.createTitledBorder(new LineBorder(catalogEntry.getCatalogColor(), 3), catalogEntry.getCatalogName() + " results", 1, 2));
        container.add((Component)new JScrollPane(catalogTable), "Center");
        container.add((Component)buttonPanel, "South");
        this.centerPanel.add(container);
    }

    private void displayCatalogDetails(CatalogEntry selectedEntry) {
        List<CatalogElement> catalogElements = selectedEntry.getCatalogElements();
        int size = catalogElements.size();
        int rows = size / 2;
        int remainder = size % 2;
        int maxRows = (rows += remainder) > 20 ? rows : 20;
        JPanel detailPanel = new JPanel(new GridLayout(0, 4));
        detailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), selectedEntry.getCatalogName() + " entry (Computed values are shown in green; (*) Further info: mouse pointer)", 1, 2));
        catalogElements.forEach(element -> {
            ToolboxHelper.addLabelToPanel(element, detailPanel);
            ToolboxHelper.addFieldToPanel(element, detailPanel);
        });
        if (remainder == 1) {
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
        }
        for (int i = 0; i < maxRows - rows; ++i) {
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
        }
        JScrollPane scrollPanel = new JScrollPane(detailPanel);
        scrollPanel.setBorder(new LineBorder(selectedEntry.getCatalogColor(), 3));
        scrollPanel.setPreferredSize(new Dimension(650, 375));
        this.bottomPanel.add(scrollPanel);
    }

    private void displaySpectralTypes(CatalogEntry catalogEntry, boolean addExtinctionCheckbox) {
        try {
            List<LookupResult> brownDwarfsResults;
            JPanel messagePanel;
            JPanel container = new JPanel();
            container.setLayout(new BoxLayout(container, 1));
            container.setBorder(new LineBorder(this.selectedEntry.getCatalogColor(), 3));
            container.setPreferredSize(new Dimension(700, 375));
            List<LookupResult> mainSequenceResults = this.mainSequenceSpectralTypeLookupService.lookup(catalogEntry.getColors(true));
            if (!mainSequenceResults.isEmpty()) {
                Object entry;
                container.add(this.createMainSequenceSpectralTypePanel(mainSequenceResults, catalogEntry));
                if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN(((AllWiseCatalogEntry)(entry = (AllWiseCatalogEntry)catalogEntry)).getW1_W2(), ((AllWiseCatalogEntry)entry).getW2_W3())) {
                    messagePanel = new JPanel(new FlowLayout(0));
                    messagePanel.add(ToolboxHelper.createLabel("Possible AGN!", JColor.RED));
                    container.add(messagePanel);
                }
                if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry.getBP_RP())) {
                    messagePanel = new JPanel(new FlowLayout(0));
                    messagePanel.add(ToolboxHelper.createLabel("Possible white dwarf!", JColor.RED));
                    container.add(messagePanel);
                }
            }
            if (!(brownDwarfsResults = this.brownDwarfsSpectralTypeLookupService.lookup(catalogEntry.getColors(true))).isEmpty()) {
                container.add(this.createBrownDwarfsSpectralTypePanel(brownDwarfsResults, catalogEntry));
            }
            if (mainSequenceResults.isEmpty() && brownDwarfsResults.isEmpty()) {
                container.add(this.createMainSequenceSpectralTypePanel(mainSequenceResults, catalogEntry));
                messagePanel = new JPanel(new FlowLayout(0));
                messagePanel.add(ToolboxHelper.createLabel("No colors available / No match", JColor.RED));
                container.add(messagePanel);
            }
            JPanel toolsPanel = new JPanel();
            toolsPanel.setLayout(new BoxLayout(toolsPanel, 1));
            container.add(toolsPanel);
            JPanel collectPanel = new JPanel(new FlowLayout(0));
            toolsPanel.add(collectPanel);
            collectPanel.add(new JLabel("Object type:"));
            JComboBox<String> objectTypes = new JComboBox<String>(ObjectType.labels());
            collectPanel.add(objectTypes);
            JButton collectButton = new JButton("Add to collection");
            collectPanel.add(collectButton);
            Timer collectTimer = new Timer(3000, e -> collectButton.setText("Add to collection"));
            collectButton.addActionListener(evt -> {
                String selectedObjectType = (String)objectTypes.getSelectedItem();
                ToolboxHelper.collectObject(selectedObjectType, catalogEntry, this.baseFrame, this.mainSequenceSpectralTypeLookupService, this.collectionTable);
                collectButton.setText("Added!");
                collectTimer.restart();
            });
            if (catalogEntry instanceof SimbadCatalogEntry) {
                JButton referencesButton = new JButton("Literature Ref.");
                collectPanel.add(referencesButton);
                referencesButton.addActionListener(evt -> {
                    JFrame referencesFrame = new JFrame();
                    referencesFrame.setDefaultCloseOperation(2);
                    referencesFrame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    referencesFrame.setIconImage(ToolboxHelper.getToolBoxImage());
                    referencesFrame.setTitle("Measurements and references for " + catalogEntry.getSourceId() + " (" + NumericFunctions.roundTo7DecNZ(catalogEntry.getRa()) + " " + NumericFunctions.roundTo7DecNZ(catalogEntry.getDec()) + ")");
                    referencesFrame.add(new JScrollPane(new ReferencesPanel(catalogEntry, referencesFrame)));
                    referencesFrame.setSize(ToolboxHelper.BASE_FRAME_WIDTH, ToolboxHelper.BASE_FRAME_HEIGHT);
                    referencesFrame.setLocation(0, 0);
                    referencesFrame.setAlwaysOnTop(false);
                    referencesFrame.setResizable(true);
                    referencesFrame.setVisible(true);
                });
            }
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            toolsPanel.add(buttonPanel);
            JButton copyCoordsButton = new JButton("Copy coords");
            buttonPanel.add(copyCoordsButton);
            Timer copyCoordsTimer = new Timer(3000, e -> copyCoordsButton.setText("Copy coords"));
            copyCoordsButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectCoordinates(catalogEntry));
                copyCoordsButton.setText("Copied to clipboard!");
                copyCoordsTimer.restart();
            });
            JButton copyInfoButton = new JButton("Copy summary");
            buttonPanel.add(copyInfoButton);
            Timer copyInfoTimer = new Timer(3000, e -> copyInfoButton.setText("Copy summary"));
            copyInfoButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectSummary(catalogEntry));
                copyInfoButton.setText("Copied to clipboard!");
                copyInfoTimer.restart();
            });
            JButton copyAllButton = new JButton("Copy all");
            buttonPanel.add(copyAllButton);
            Timer copyAllTimer = new Timer(3000, e -> copyAllButton.setText("Copy all"));
            copyAllButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectInfo(catalogEntry, mainSequenceResults, brownDwarfsResults, this.distanceLookupService));
                copyAllButton.setText("Copied to clipboard!");
                copyAllTimer.restart();
            });
            JButton fillFormButton = new JButton("TYGO form");
            buttonPanel.add(fillFormButton);
            fillFormButton.addActionListener(evt -> ToolboxHelper.fillTygoForm(catalogEntry, this.catalogQueryService, this.baseFrame));
            JButton createSedButton = new JButton("Ultracool Dwarf SED");
            buttonPanel.add(createSedButton);
            createSedButton.addActionListener(evt -> {
                createSedButton.setCursor(Cursor.getPredefinedCursor(3));
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                frame.setIconImage(ToolboxHelper.getToolBoxImage());
                frame.setTitle("Ultracool Dwarf SED");
                frame.add(new SedUcdPanel(this.brownDwarfLookupEntries, this.catalogQueryService, catalogEntry, this.baseFrame));
                frame.setSize(1050, 900);
                frame.setLocation(0, 0);
                frame.setAlwaysOnTop(false);
                frame.setResizable(true);
                frame.setVisible(true);
                createSedButton.setCursor(Cursor.getDefaultCursor());
            });
            JButton createWdSedButton = new JButton("White Dwarf SED");
            buttonPanel.add(createWdSedButton);
            createWdSedButton.addActionListener(evt -> {
                createWdSedButton.setCursor(Cursor.getPredefinedCursor(3));
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                frame.setIconImage(ToolboxHelper.getToolBoxImage());
                frame.setTitle("White Dwarf SED");
                frame.add(new SedWdPanel(this.catalogQueryService, catalogEntry, this.baseFrame));
                frame.setSize(1050, 900);
                frame.setLocation(0, 0);
                frame.setAlwaysOnTop(false);
                frame.setResizable(true);
                frame.setVisible(true);
                createWdSedButton.setCursor(Cursor.getDefaultCursor());
            });
            JButton createCcdButton = new JButton("WISE CCD");
            collectPanel.add(createCcdButton);
            createCcdButton.addActionListener(evt -> {
                try {
                    createCcdButton.setCursor(Cursor.getPredefinedCursor(3));
                    JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    frame.setIconImage(ToolboxHelper.getToolBoxImage());
                    frame.setTitle("WISE CCD");
                    frame.add(new WiseCcdPanel(this.catalogQueryService, catalogEntry, this.baseFrame));
                    frame.setSize(1000, 900);
                    frame.setLocation(0, 0);
                    frame.setAlwaysOnTop(false);
                    frame.setResizable(true);
                    frame.setVisible(true);
                }
                catch (HeadlessException | SecurityException ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                }
                finally {
                    createCcdButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            JButton createLcButton = new JButton("WISE Light Curves");
            collectPanel.add(createLcButton);
            createLcButton.addActionListener(evt -> {
                try {
                    createLcButton.setCursor(Cursor.getPredefinedCursor(3));
                    JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    frame.setIconImage(ToolboxHelper.getToolBoxImage());
                    frame.setTitle("WISE Light Curves");
                    frame.add(new WiseLcPanel(catalogEntry, this.baseFrame));
                    frame.setSize(1000, 900);
                    frame.setLocation(0, 0);
                    frame.setAlwaysOnTop(false);
                    frame.setResizable(true);
                    frame.setVisible(true);
                }
                catch (HeadlessException | SecurityException ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                }
                finally {
                    createLcButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            if (catalogEntry instanceof GaiaCmd) {
                GaiaCmd cmd = (GaiaCmd)catalogEntry;
                JButton createCmdButton = new JButton("Gaia CMD");
                collectPanel.add(createCmdButton);
                createCmdButton.addActionListener(evt -> {
                    try {
                        createCmdButton.setCursor(Cursor.getPredefinedCursor(3));
                        JFrame frame = new JFrame();
                        frame.setDefaultCloseOperation(2);
                        frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                        frame.setIconImage(ToolboxHelper.getToolBoxImage());
                        frame.setTitle("Gaia CMD");
                        frame.add(new GaiaCmdPanel(cmd));
                        frame.setSize(1000, 900);
                        frame.setLocation(0, 0);
                        frame.setAlwaysOnTop(false);
                        frame.setResizable(true);
                        frame.setVisible(true);
                    }
                    catch (HeadlessException | SecurityException ex) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                    }
                    finally {
                        createCmdButton.setCursor(Cursor.getDefaultCursor());
                    }
                });
            }
            if (addExtinctionCheckbox && catalogEntry instanceof Extinction) {
                Extinction entry = (Extinction)catalogEntry.copy();
                JPanel extinctionPanel = new JPanel(new FlowLayout(0));
                toolsPanel.add(extinctionPanel);
                JCheckBox dustExtinction = new JCheckBox("Apply extinction correction for bands u, g, r, i, z, J, H, K, W1 & W2 (Schlafly & Finkbeiner, 2011)");
                extinctionPanel.add(dustExtinction);
                dustExtinction.addActionListener(evt -> {
                    if (dustExtinction.isSelected()) {
                        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            Map<String, Double> extinctionsByBand = this.dustExtinctionService.getExtinctionsByBand(entry.getRa(), entry.getDec(), 2.0);
                            try {
                                entry.applyExtinctionCorrection(extinctionsByBand);
                                entry.loadCatalogElements();
                                this.bottomPanel.remove(container);
                                this.displaySpectralTypes(entry, false);
                            }
                            catch (ExtinctionException ex) {
                                extinctionPanel.add(ToolboxHelper.createLabel("No extinction values for " + entry.getCatalogName() + " bands.", JColor.RED));
                            }
                        }
                        catch (Exception ex) {
                            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                        }
                        finally {
                            this.baseFrame.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }
            this.bottomPanel.add(container);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private JScrollPane createMainSequenceSpectralTypePanel(List<LookupResult> results, CatalogEntry catalogEntry) {
        ArrayList<String[]> spectralTypes = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedColor = entry.getColorKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getColorValue());
            String spectralType = entry.getSpt() + "," + matchedColor + "," + NumericFunctions.roundTo3Dec(entry.getNearest()) + "," + NumericFunctions.roundTo3DecLZ(entry.getGap()) + "," + entry.getTeff() + "," + NumericFunctions.roundTo3Dec(entry.getRsun()) + "," + NumericFunctions.roundTo3Dec(entry.getMsun());
            spectralTypes.add(spectralType.split(",", -1));
        });
        String titles = "spt,matched color,nearest color,offset,teff,radius (Rsun),mass (Msun)";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable spectralTypeTable = new JTable((Object[][])spectralTypes.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(spectralTypeTable, spectralTypes);
        spectralTypeTable.setAutoCreateRowSorter(true);
        spectralTypeTable.setAutoResizeMode(0);
        TableColumnModel columnModel = spectralTypeTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(75);
        columnModel.getColumn(3).setPreferredWidth(50);
        columnModel.getColumn(4).setPreferredWidth(50);
        columnModel.getColumn(5).setPreferredWidth(75);
        columnModel.getColumn(6).setPreferredWidth(75);
        spectralTypeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != spectralTypeTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = spectralTypeTable;
                String spt = (String)spectralTypeTable.getValueAt(spectralTypeTable.getSelectedRow(), 0);
                List<DistanceLookupResult> distanceResults = this.distanceLookupService.lookup(spt, catalogEntry.getBands());
                this.createDistanceEstimatesPanel(distanceResults, spt, catalogEntry.getCatalogColor());
            }
        });
        JScrollPane spectralTypePanel = new JScrollPane(spectralTypeTable);
        spectralTypePanel.setToolTipText("Clicking on a table row displays photometric distance estimates for the specified spectral type.");
        spectralTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolboxHelper.html("Main sequence spectral type estimates <span style='color:red'>&#9432;</span>"), 1, 2));
        return spectralTypePanel;
    }

    private JScrollPane createBrownDwarfsSpectralTypePanel(List<LookupResult> results, CatalogEntry catalogEntry) {
        ArrayList<String[]> spectralTypes = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedColor = entry.getColorKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getColorValue());
            String spectralType = entry.getSpt() + "," + matchedColor + "," + NumericFunctions.roundTo3Dec(entry.getNearest()) + "," + NumericFunctions.roundTo3DecLZ(entry.getGap());
            spectralTypes.add(spectralType.split(",", -1));
        });
        String titles = "spt,matched color,nearest color,offset";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable spectralTypeTable = new JTable((Object[][])spectralTypes.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(spectralTypeTable, spectralTypes);
        spectralTypeTable.setAutoCreateRowSorter(true);
        spectralTypeTable.setAutoResizeMode(0);
        TableColumnModel columnModel = spectralTypeTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(75);
        columnModel.getColumn(3).setPreferredWidth(50);
        spectralTypeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != spectralTypeTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = spectralTypeTable;
                String spt = (String)spectralTypeTable.getValueAt(spectralTypeTable.getSelectedRow(), 0);
                List<DistanceLookupResult> distanceResults = this.distanceLookupService.lookup(spt, catalogEntry.getBands());
                this.createDistanceEstimatesPanel(distanceResults, spt, catalogEntry.getCatalogColor());
            }
        });
        JScrollPane spectralTypePanel = new JScrollPane(spectralTypeTable);
        spectralTypePanel.setToolTipText("Clicking on a table row displays photometric distance estimates for the specified spectral type.");
        spectralTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolboxHelper.html("M, L & T dwarfs spectral type estimates <span style='color:red'>&#9432;</span>"), 1, 2));
        return spectralTypePanel;
    }

    private void createDistanceEstimatesPanel(List<DistanceLookupResult> results, String spt, Color color) {
        ArrayList<String[]> distances = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedBand = entry.getBandKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getBandValue());
            Object distance = NumericFunctions.roundTo3Dec(entry.getDistance());
            if (entry.getDistanceError() > 0.0) {
                distance = (String)distance + "\u00b1" + NumericFunctions.roundTo3Dec(entry.getDistanceError());
            }
            String resutValues = (String)distance + "," + matchedBand;
            distances.add(resutValues.split(",", -1));
        });
        String titles = "distance (pc),matched bands";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable distanceTable = new JTable((Object[][])distances.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(distanceTable, distances);
        distanceTable.setAutoCreateRowSorter(true);
        distanceTable.setAutoResizeMode(0);
        TableColumnModel columnModel = distanceTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(100);
        columnModel.getColumn(1).setPreferredWidth(100);
        JScrollPane distancePanel = new JScrollPane(distanceTable);
        distancePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Spectral type: " + spt, 1, 2));
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(new LineBorder(color, 3));
        container.add(distancePanel);
        JFrame detailsFrame = new JFrame();
        detailsFrame.setDefaultCloseOperation(2);
        detailsFrame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
        detailsFrame.setIconImage(ToolboxHelper.getToolBoxImage());
        detailsFrame.setTitle("Photometric distance estimates");
        detailsFrame.add(container);
        detailsFrame.setSize(500, 300);
        detailsFrame.setLocation(this.windowShift, this.windowShift);
        detailsFrame.setAlwaysOnTop(true);
        detailsFrame.setResizable(true);
        detailsFrame.setVisible(true);
        this.windowShift += 10;
    }

    public void removeAndRecreateCenterPanel() {
        if (this.centerPanel != null) {
            this.mainPanel.remove(this.centerPanel);
        }
        this.centerPanel = new JPanel(new GridLayout(2, 0));
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.setPreferredSize(new Dimension(this.centerPanel.getWidth(), 250));
    }

    public void removeAndRecreateBottomPanel() {
        if (this.bottomPanel != null) {
            this.mainPanel.remove(this.bottomPanel);
        }
        this.bottomPanel = new JPanel(new FlowLayout(0));
        this.mainPanel.add((Component)this.bottomPanel, "Last");
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    public JButton getSearchButton() {
        return this.searchButton;
    }

    public JTextField getCoordsField() {
        return this.coordsField;
    }

    public JTextField getRadiusField() {
        return this.radiusField;
    }

    public JLabel getSearchLabel() {
        return this.searchLabel;
    }

    public void setCollectionTable(JTable collectionTable) {
        this.collectionTable = collectionTable;
    }

    public void setCopyCoordsToClipboard(boolean copyCoordsToClipboard) {
        this.copyCoordsToClipboard = copyCoordsToClipboard;
    }
}

