/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import astro.tool.box.util.FileTypeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FileBrowserTab
implements Tab {
    public static final String TAB_NAME = "File Browser";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryTab catalogQueryTab;
    private final ImageViewerTab imageViewerTab;
    private JPanel centerPanel;
    private JTable resultTable;
    private JTextField raColumnPosition;
    private JTextField decColumnPosition;
    private File file;
    private int raColumnIndex;
    private int decColumnIndex;

    public FileBrowserTab(JFrame baseFrame, JTabbedPane tabbedPane, CatalogQueryTab catalogQueryTab, ImageViewerTab imageViewerTab) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryTab = catalogQueryTab;
        this.imageViewerTab = imageViewerTab;
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new FlowLayout(0));
            mainPanel.add((Component)topPanel, "First");
            JPanel bottomPanel = new JPanel(new FlowLayout(0));
            mainPanel.add((Component)bottomPanel, "Last");
            topPanel.add(new JLabel("RA position:"));
            this.raColumnPosition = new JTextField(2);
            topPanel.add(this.raColumnPosition);
            topPanel.add(new JLabel("dec position:"));
            this.decColumnPosition = new JTextField(2);
            topPanel.add(this.decColumnPosition);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileTypeFilter(".csv", ".csv files"));
            JButton importButton = new JButton("Import csv file with header");
            topPanel.add(importButton);
            importButton.addActionListener(evt -> {
                int returnVal = fileChooser.showOpenDialog(topPanel);
                if (returnVal == 0) {
                    if (this.raColumnPosition.getText().isEmpty() || this.decColumnPosition.getText().isEmpty()) {
                        this.raColumnIndex = 0;
                        this.decColumnIndex = 0;
                    } else {
                        StringBuilder errors = new StringBuilder();
                        this.checkRaAndDecColumnPositions(errors);
                        if (errors.length() > 0) {
                            ToolboxHelper.showErrorDialog(this.baseFrame, errors.toString());
                            return;
                        }
                    }
                    this.file = fileChooser.getSelectedFile();
                    this.removeAndRecreateCenterPanel(mainPanel);
                    this.readFileContents("");
                    this.baseFrame.setVisible(true);
                }
            });
            topPanel.add(new JLabel("Columns to add:"));
            JTextField addColumnsField = new JTextField(15);
            topPanel.add(addColumnsField);
            JLabel topPanelMessage = ToolboxHelper.createMessageLabel();
            JLabel bottomPanelMessage = ToolboxHelper.createMessageLabel();
            Timer timer = new Timer(3000, e -> {
                topPanelMessage.setText("");
                bottomPanelMessage.setText("");
            });
            JButton reloadButton = new JButton("Reload file");
            topPanel.add(reloadButton);
            reloadButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No file imported yet!");
                    return;
                }
                String confirmMessage = "Any unsaved changes will be lost!" + Constants.LINE_SEP + "Do you really want to reload file " + this.file.getName() + "?";
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, confirmMessage)) {
                    return;
                }
                StringBuilder errors = new StringBuilder();
                this.checkRaAndDecColumnPositions(errors);
                if (errors.length() > 0) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, errors.toString());
                    return;
                }
                this.removeAndRecreateCenterPanel(mainPanel);
                this.readFileContents(addColumnsField.getText());
                addColumnsField.setText("");
                topPanelMessage.setText("File reloaded!");
                timer.restart();
                this.baseFrame.setVisible(true);
            });
            JButton saveButton = new JButton("Save file");
            topPanel.add(saveButton);
            saveButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No file imported yet!");
                    return;
                }
                boolean hasFileBeenSaved = this.saveFile();
                if (hasFileBeenSaved) {
                    topPanelMessage.setText("File saved!");
                    timer.restart();
                }
            });
            topPanel.add(topPanelMessage);
            JButton addButton = new JButton("Add row");
            bottomPanel.add(addButton);
            addButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No file imported yet!");
                    return;
                }
                DefaultTableModel tableModel = (DefaultTableModel)this.resultTable.getModel();
                tableModel.addRow((Object[])null);
                bottomPanelMessage.setText("Row added!");
                timer.restart();
            });
            JButton deleteButton = new JButton("Delete selected row");
            bottomPanel.add(deleteButton);
            deleteButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No file imported yet!");
                    return;
                }
                if (this.resultTable.getSelectedRow() == -1) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No row selected yet!");
                    return;
                }
                int selectedRow = this.resultTable.getSelectedRow();
                String confirmMessage = "Do you really want to delete row # " + String.valueOf(this.resultTable.getValueAt(selectedRow, 0));
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, confirmMessage)) {
                    return;
                }
                DefaultTableModel tableModel = (DefaultTableModel)this.resultTable.getModel();
                int rowToDelete = this.resultTable.convertRowIndexToModel(selectedRow);
                tableModel.removeRow(rowToDelete);
                boolean hasFileBeenSaved = this.saveFile();
                if (hasFileBeenSaved) {
                    bottomPanelMessage.setText("Row deleted!");
                    timer.restart();
                }
            });
            bottomPanel.add(bottomPanelMessage);
            this.baseFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    FileBrowserTab.this.saveFile();
                }
            });
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(mainPanel));
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void checkRaAndDecColumnPositions(StringBuilder errors) {
        try {
            this.raColumnIndex = NumericFunctions.toInteger(this.raColumnPosition.getText()) - 1;
            if (this.raColumnIndex < 0) {
                errors.append("RA position must be greater than 0.").append(Constants.LINE_SEP);
            }
        }
        catch (Exception ex) {
            errors.append("Invalid RA position!").append(Constants.LINE_SEP);
        }
        try {
            this.decColumnIndex = NumericFunctions.toInteger(this.decColumnPosition.getText()) - 1;
            if (this.decColumnIndex < 0) {
                errors.append("Dec position must be greater than 0.").append(Constants.LINE_SEP);
            }
        }
        catch (Exception ex) {
            errors.append("Invalid dec position!").append(Constants.LINE_SEP);
        }
    }

    private boolean saveFile() {
        if (this.file != null) {
            boolean bl;
            int i;
            StringBuilder fileContent = new StringBuilder();
            TableModel model = this.resultTable.getModel();
            int columnCount = model.getColumnCount();
            for (i = 1; i < columnCount; ++i) {
                String columnName = model.getColumnName(i);
                this.appendCellValue(fileContent, i, columnCount, columnName);
            }
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int y = 1; y < columnCount; ++y) {
                    String cellValue = (String)model.getValueAt(i, y);
                    this.appendCellValue(fileContent, y, columnCount, cellValue);
                }
            }
            FileWriter writer = new FileWriter(this.file);
            try {
                writer.write(fileContent.toString());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            }
            writer.close();
            return bl;
        }
        return false;
    }

    private void appendCellValue(StringBuilder fileContent, int columnIndex, int columnCount, String cellValue) {
        if (cellValue != null) {
            fileContent.append(cellValue);
        }
        if (columnIndex < columnCount - 1) {
            fileContent.append(",");
        } else {
            fileContent.append(Constants.LINE_SEP);
        }
    }

    private void readFileContents(String columnsToAdd) {
        try (Scanner scanner = new Scanner(this.file);){
            String[] columnNames = scanner.nextLine().split(",");
            StringBuilder errors = new StringBuilder();
            int numberOfColumns = columnNames.length;
            int lastColumnIndex = numberOfColumns - 1;
            if (this.raColumnIndex > lastColumnIndex) {
                errors.append("RA position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (this.decColumnIndex > lastColumnIndex) {
                errors.append("Dec position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (errors.length() > 0) {
                ToolboxHelper.showErrorDialog(this.baseFrame, errors.toString());
                return;
            }
            String[] newNames = columnsToAdd.split(",");
            int columnCount = newNames.length;
            if (columnCount == 1 && newNames[0].isEmpty()) {
                columnCount = 0;
            }
            Object valuesToAppend = "";
            for (int i = 1; i < columnCount; ++i) {
                valuesToAppend = (String)valuesToAppend + ",";
            }
            String[] newValues = ((String)valuesToAppend).split(",", -1);
            int rowNumber = 0;
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",", -1);
                String[] values = ToolboxHelper.concatArrays(new String[]{String.valueOf(++rowNumber)}, columnValues);
                if (columnCount > 0) {
                    values = ToolboxHelper.concatArrays(values, newValues);
                }
                rows.add(values);
            }
            String[] names = ToolboxHelper.concatArrays(new String[]{"row#"}, columnNames);
            if (columnCount > 0) {
                names = ToolboxHelper.concatArrays(names, newNames);
            }
            this.displayQueryResults(names, rows);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void displayQueryResults(String[] columnNames, List<String[]> rows) {
        Object[][] data = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])rows.toArray((T[])data), columnNames);
        this.resultTable = new JTable(defaultTableModel);
        ToolboxHelper.alignResultColumns(this.resultTable, rows);
        this.resultTable.setAutoCreateRowSorter(true);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setRowSorter(ToolboxHelper.createResultTableSorter(defaultTableModel, rows));
        this.resultTable.setSelectionMode(0);
        if (this.raColumnIndex > 0 || this.decColumnIndex > 0) {
            this.resultTable.getSelectionModel().addListSelectionListener(e -> {
                int selectedRow = this.resultTable.getSelectedRow();
                if (!e.getValueIsAdjusting() && selectedRow > -1 && selectedRow < this.resultTable.getRowCount()) {
                    String ra = (String)this.resultTable.getValueAt(selectedRow, this.raColumnIndex + 1);
                    String dec = (String)this.resultTable.getValueAt(selectedRow, this.decColumnIndex + 1);
                    String coords = ra + " " + dec;
                    this.imageViewerTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getSearchLabel().setText("");
                    this.catalogQueryTab.removeAndRecreateCenterPanel();
                    this.catalogQueryTab.removeAndRecreateBottomPanel();
                }
            });
        }
        ToolboxHelper.resizeColumnWidth(this.resultTable);
        JScrollPane resultScrollPanel = new JScrollPane(this.resultTable);
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.file.getName(), 1, 2));
        this.centerPanel.add(resultScrollPanel);
    }

    private void removeAndRecreateCenterPanel(JPanel mainPanel) {
        if (this.centerPanel != null) {
            mainPanel.remove(this.centerPanel);
        }
        this.centerPanel = new JPanel(new GridLayout(1, 1));
        mainPanel.add(this.centerPanel);
    }
}

