/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.GaiaDR3CatalogEntry;
import astro.tool.box.catalog.NoirlabCatalogEntry;
import astro.tool.box.catalog.PanStarrsCatalogEntry;
import astro.tool.box.catalog.ProperMotionCatalog;
import astro.tool.box.catalog.SdssCatalogEntry;
import astro.tool.box.catalog.TwoMassCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.container.Couple;
import astro.tool.box.container.FlipbookComponent;
import astro.tool.box.container.NirImage;
import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.ImageType;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import astro.tool.box.util.Counter;
import astro.tool.box.util.ExternalResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

public class ImageSeriesTab
implements Tab {
    public static final String TAB_NAME = "Image Series";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final ImageViewerTab imageViewerTab;
    private final Map<String, CatalogEntry> catalogInstances;
    private final CatalogQueryService catalogQueryService;
    private List<Couple<String, NirImage>> timeSeries;
    private List<Couple<String, BufferedImage>> desiImages;
    private List<Couple<String, BufferedImage>> wiseImages;
    private Timer timeSeriesTimer;
    private Timer desiTimeSeriesTimer;
    private Timer wiseTimeSeriesTimer;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JScrollPane scrollPanel;
    private JTabbedPane bottomPanel;
    private JButton searchButton;
    private JTextField coordsField;
    private JTextField fovField;
    private JTable currentTable;
    private TwoMassCatalogEntry twoMassEntry;
    private AllWiseCatalogEntry allWiseEntry;
    private SdssCatalogEntry sdssEntry;
    private PanStarrsCatalogEntry panStarrsEntry;
    private GaiaDR3CatalogEntry gaiaDR3Entry;
    private CatWiseCatalogEntry catWiseEntry;
    private NoirlabCatalogEntry noirlabEntry;
    private UkidssCatalogEntry ukidssEntry;
    private double targetRa;
    private double targetDec;
    private int fieldOfView;
    private double prevTargetRa;
    private double prevTargetDec;
    private int prevFieldOfView;

    public ImageSeriesTab(JFrame baseFrame, JTabbedPane tabbedPane, ImageViewerTab imageViewerTab) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.imageViewerTab = imageViewerTab;
        this.catalogInstances = ToolboxHelper.getCatalogInstances();
        this.catalogQueryService = new CatalogQueryService();
    }

    @Override
    public void init(boolean visible) {
        try {
            this.mainPanel = new JPanel(new BorderLayout());
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, this.mainPanel);
            }
            this.topPanel = new JPanel(new FlowLayout(0));
            this.mainPanel.add((Component)this.topPanel, "First");
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
            this.scrollPanel = new JScrollPane(this.centerPanel);
            this.mainPanel.add((Component)this.scrollPanel, "Center");
            this.bottomPanel = new JTabbedPane(1, 1);
            this.bottomPanel.setPreferredSize(new Dimension(this.bottomPanel.getWidth(), 200));
            this.mainPanel.add((Component)this.bottomPanel, "Last");
            JLabel coordsLabel = new JLabel("Coordinates:");
            this.topPanel.add(coordsLabel);
            this.coordsField = new JTextField(25);
            this.topPanel.add(this.coordsField);
            JLabel fovLabel = new JLabel("Field of view (arcsec):");
            this.topPanel.add(fovLabel);
            this.fovField = new JTextField(5);
            this.topPanel.add(this.fovField);
            this.fovField.setText("30");
            this.searchButton = new JButton("Search");
            this.topPanel.add(this.searchButton);
            this.searchButton.addActionListener(e -> {
                try {
                    String coords = this.coordsField.getText();
                    if (coords.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Coordinates must not be empty!");
                        return;
                    }
                    String fov = this.fovField.getText();
                    if (fov.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Field of view must not be empty!");
                        return;
                    }
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    try {
                        NumberPair coordinates = ToolboxHelper.getCoordinates(coords);
                        this.targetRa = coordinates.getX();
                        this.targetDec = coordinates.getY();
                        if (this.targetRa < 0.0) {
                            errorMessages.add("RA must not be smaller than 0 deg.");
                        }
                        if (this.targetRa > 360.0) {
                            errorMessages.add("RA must not be greater than 360 deg.");
                        }
                        if (this.targetDec < -90.0) {
                            errorMessages.add("Dec must not be smaller than -90 deg.");
                        }
                        if (this.targetDec > 90.0) {
                            errorMessages.add("Dec must not be greater than 90 deg.");
                        }
                    }
                    catch (Exception ex) {
                        this.targetRa = 0.0;
                        this.targetDec = 0.0;
                        errorMessages.add("Invalid coordinates!");
                    }
                    try {
                        this.fieldOfView = Integer.parseInt(fov);
                        if (this.fieldOfView < 10) {
                            errorMessages.add("Field of view must not be smaller than 10 arcsec.");
                        }
                        if (this.fieldOfView > 300) {
                            errorMessages.add("Field of view must not be larger than 300 arcsec.");
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.fieldOfView = 0;
                        errorMessages.add("Invalid field of view!");
                    }
                    if (this.targetRa == this.prevTargetRa && this.targetDec == this.prevTargetDec && this.fieldOfView == this.prevFieldOfView) {
                        return;
                    }
                    this.timeSeries = new ArrayList<Couple<String, NirImage>>();
                    this.desiImages = new ArrayList<Couple<String, BufferedImage>>();
                    this.wiseImages = new ArrayList<Couple<String, BufferedImage>>();
                    this.timeSeriesTimer = null;
                    this.desiTimeSeriesTimer = null;
                    this.wiseTimeSeriesTimer = null;
                    if (this.centerPanel.getComponentCount() > 0) {
                        this.centerPanel.removeAll();
                    }
                    if (this.bottomPanel.getComponentCount() > 0) {
                        this.bottomPanel.removeAll();
                    }
                    this.twoMassEntry = null;
                    this.allWiseEntry = null;
                    this.sdssEntry = null;
                    this.panStarrsEntry = null;
                    this.gaiaDR3Entry = null;
                    this.catWiseEntry = null;
                    this.noirlabEntry = null;
                    this.ukidssEntry = null;
                    this.prevTargetRa = this.targetRa;
                    this.prevTargetDec = this.targetDec;
                    this.prevFieldOfView = this.fieldOfView;
                    this.stopTimers();
                    if (!errorMessages.isEmpty()) {
                        String message = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                        ToolboxHelper.showErrorDialog(this.baseFrame, message);
                    } else {
                        this.imageViewerTab.setWaitCursor(false);
                        JTextField coordinateField = this.imageViewerTab.getCoordsField();
                        ActionListener actionListener = coordinateField.getActionListeners()[0];
                        coordinateField.removeActionListener(actionListener);
                        coordinateField.setText(NumericFunctions.roundTo7DecNZ(this.targetRa) + " " + NumericFunctions.roundTo7DecNZ(this.targetDec));
                        coordinateField.addActionListener(actionListener);
                        JTextField sizeField = this.imageViewerTab.getSizeField();
                        actionListener = sizeField.getActionListeners()[0];
                        sizeField.removeActionListener(actionListener);
                        sizeField.setText(String.valueOf(this.fieldOfView));
                        sizeField.addActionListener(actionListener);
                        this.imageViewerTab.getZoomSlider().setValue(250);
                        this.imageViewerTab.getSkipIntermediateEpochs().setSelected(false);
                        this.imageViewerTab.createFlipbook();
                        CompletableFuture.supplyAsync(() -> {
                            try {
                                this.setWaitCursor();
                                this.displayImages(this.targetRa, this.targetDec, this.fieldOfView);
                                this.baseFrame.setVisible(true);
                            }
                            catch (Exception ex) {
                                ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                            }
                            finally {
                                this.imageViewerTab.setWaitCursor(true);
                                this.setDefaultCursor();
                            }
                            return null;
                        });
                        CompletableFuture.supplyAsync(() -> {
                            try {
                                double tpm;
                                double pmDec;
                                NumberPair properMotions;
                                List<String> selectedCatalogs = SettingsTab.getSelectedCatalogs(this.catalogInstances);
                                for (CatalogEntry catalogEntry : this.catalogInstances.values()) {
                                    if (!selectedCatalogs.contains(catalogEntry.getCatalogName())) continue;
                                    double searchRadius = (double)this.fieldOfView * Math.sqrt(2.0) / 2.0;
                                    catalogEntry.setRa(this.targetRa);
                                    catalogEntry.setDec(this.targetDec);
                                    catalogEntry.setSearchRadius(searchRadius);
                                    List<CatalogEntry> results = this.performQuery(catalogEntry);
                                    if (results == null) continue;
                                    this.displayCatalogResults(results);
                                }
                                ArrayList<String[]> resultRows = new ArrayList<String[]>();
                                if (this.twoMassEntry != null && this.allWiseEntry != null) {
                                    long days = Duration.between(this.twoMassEntry.getObsDate(), AstrometricFunctions.convertMJDToDateTime(new BigDecimal("55400"))).toDays();
                                    properMotions = AstrometricFunctions.calculateProperMotions(new NumberPair(this.twoMassEntry.getRa(), this.twoMassEntry.getDec()), new NumberPair(this.allWiseEntry.getRa_pm(), this.allWiseEntry.getDec_pm()), 0, (int)days, 3600000.0);
                                    double pmRa = properMotions.getX();
                                    pmDec = properMotions.getY();
                                    tpm = AstrometricFunctions.calculateTotalProperMotion(pmRa, pmDec);
                                    resultRows.add(new String[]{"Calculated from 2MASS and AllWISE coordinates", this.twoMassEntry.getSourceId(), NumericFunctions.roundTo3DecLZ(this.twoMassEntry.getTargetDistance()), this.allWiseEntry.getSourceId(), NumericFunctions.roundTo3DecLZ(this.allWiseEntry.getTargetDistance()), NumericFunctions.roundTo3DecLZ(tpm), NumericFunctions.roundTo3DecLZ(pmRa), NumericFunctions.roundTo3DecLZ(pmDec), "N/A", "N/A"});
                                }
                                if (this.sdssEntry != null && this.panStarrsEntry != null) {
                                    long days = Duration.between(this.sdssEntry.getObsDate(), this.panStarrsEntry.getObsDate()).toDays();
                                    properMotions = AstrometricFunctions.calculateProperMotions(new NumberPair(this.sdssEntry.getRa(), this.sdssEntry.getDec()), new NumberPair(this.panStarrsEntry.getRa(), this.panStarrsEntry.getDec()), 0, (int)days, 3600000.0);
                                    double pmRa = properMotions.getX();
                                    pmDec = properMotions.getY();
                                    tpm = AstrometricFunctions.calculateTotalProperMotion(pmRa, pmDec);
                                    resultRows.add(new String[]{"Calculated from SDSS DR17 and Pan-STARRS coordinates", this.sdssEntry.getSourceId(), NumericFunctions.roundTo3DecLZ(this.sdssEntry.getTargetDistance()), this.panStarrsEntry.getSourceId(), NumericFunctions.roundTo3DecLZ(this.panStarrsEntry.getTargetDistance()), NumericFunctions.roundTo3DecLZ(tpm), NumericFunctions.roundTo3DecLZ(pmRa), NumericFunctions.roundTo3DecLZ(pmDec), "N/A", "N/A"});
                                }
                                this.addProperMotionEntry(this.gaiaDR3Entry, resultRows);
                                this.addProperMotionEntry(this.catWiseEntry, resultRows);
                                if (this.noirlabEntry != null && this.noirlabEntry.getNdet() >= 5 && this.noirlabEntry.getDelta_mjd() >= 180.0) {
                                    this.addProperMotionEntry(this.noirlabEntry, resultRows);
                                }
                                this.addProperMotionEntry(this.ukidssEntry, resultRows);
                                if (!resultRows.isEmpty()) {
                                    Object[] columns = new String[]{"Proper motion origin", "source 1", "dist. from target (arcsec)", "source 2", "dist. from target (arcsec)", "tpm (mas/yr)", "pmRA (mas/yr)", "pmDE (mas/yr)", "pmRA error", "pmDE error"};
                                    Object[][] rows = new Object[][]{};
                                    JTable resultTable = new JTable((Object[][])resultRows.toArray((T[])rows), columns);
                                    resultTable.setAutoCreateRowSorter(true);
                                    resultTable.setAutoResizeMode(0);
                                    resultTable.getSelectionModel().addListSelectionListener(event -> {
                                        if (!event.getValueIsAdjusting()) {
                                            String label = (String)resultTable.getValueAt(resultTable.getSelectedRow(), 0);
                                            if (label.isEmpty()) {
                                                return;
                                            }
                                            this.deselectedCatalogOverlay(this.imageViewerTab);
                                            if (label.contains("2MASS")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.twoMassEntry);
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.allWiseEntry);
                                            } else if (label.contains("SDSS DR17")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.sdssEntry);
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.panStarrsEntry);
                                            } else if (label.contains("Gaia DR3")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.gaiaDR3Entry);
                                            } else if (label.contains("CatWISE2020")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.catWiseEntry);
                                            } else if (label.contains("NSC DR2")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.noirlabEntry);
                                            } else if (label.contains("UKIDSS DR11")) {
                                                this.activateSelectedCatalogOverlay(this.imageViewerTab, this.ukidssEntry);
                                            }
                                            this.tabbedPane.setSelectedIndex(0);
                                        }
                                    });
                                    TableColumnModel columnModel = resultTable.getColumnModel();
                                    DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
                                    leftRenderer.setHorizontalAlignment(2);
                                    DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
                                    rightRenderer.setHorizontalAlignment(4);
                                    columnModel.getColumn(0).setPreferredWidth(325);
                                    columnModel.getColumn(1).setPreferredWidth(150);
                                    columnModel.getColumn(2).setPreferredWidth(100);
                                    columnModel.getColumn(3).setPreferredWidth(150);
                                    columnModel.getColumn(4).setPreferredWidth(100);
                                    columnModel.getColumn(5).setPreferredWidth(100);
                                    columnModel.getColumn(6).setPreferredWidth(100);
                                    columnModel.getColumn(7).setPreferredWidth(100);
                                    columnModel.getColumn(8).setPreferredWidth(100);
                                    columnModel.getColumn(9).setPreferredWidth(100);
                                    columnModel.getColumn(0).setCellRenderer(leftRenderer);
                                    columnModel.getColumn(1).setCellRenderer(leftRenderer);
                                    columnModel.getColumn(2).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(3).setCellRenderer(leftRenderer);
                                    columnModel.getColumn(4).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(5).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(6).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(7).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(8).setCellRenderer(rightRenderer);
                                    columnModel.getColumn(9).setCellRenderer(rightRenderer);
                                    JPanel container = new JPanel();
                                    container.setLayout(new BoxLayout(container, 1));
                                    container.add(new JScrollPane(resultTable));
                                    JPanel messagePanel = new JPanel(new FlowLayout(0));
                                    messagePanel.add(new JLabel(ToolboxHelper.red("Warning:")));
                                    messagePanel.add(new JLabel("The entries listed above do not necessarily belong to the same object."));
                                    messagePanel.add(new JLabel("Clicking on an entry will take you to the Image Viewer with the appropriate overlays enabled."));
                                    container.add(messagePanel);
                                    this.bottomPanel.addTab("Proper motions", container);
                                    this.bottomPanel.setSelectedIndex(this.bottomPanel.getTabCount() - 1);
                                }
                                this.baseFrame.setVisible(true);
                            }
                            catch (IOException ex) {
                                ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                            }
                            return null;
                        });
                    }
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            this.coordsField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.fovField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.tabbedPane.addChangeListener(evt -> {
                int index;
                JTabbedPane sourceTabbedPane = (JTabbedPane)evt.getSource();
                if (sourceTabbedPane.getTitleAt(index = sourceTabbedPane.getSelectedIndex()).equals(TAB_NAME)) {
                    this.restartTimers();
                } else {
                    this.stopTimers();
                }
            });
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void restartTimers() {
        if (this.timeSeriesTimer != null) {
            this.timeSeriesTimer.restart();
        }
        if (this.desiTimeSeriesTimer != null) {
            this.desiTimeSeriesTimer.restart();
        }
        if (this.wiseTimeSeriesTimer != null) {
            this.wiseTimeSeriesTimer.restart();
        }
    }

    private void stopTimers() {
        if (this.timeSeriesTimer != null) {
            this.timeSeriesTimer.stop();
        }
        if (this.desiTimeSeriesTimer != null) {
            this.desiTimeSeriesTimer.stop();
        }
        if (this.wiseTimeSeriesTimer != null) {
            this.wiseTimeSeriesTimer.stop();
        }
    }

    private void setWaitCursor() {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.coordsField.setCursor(Cursor.getPredefinedCursor(3));
        this.fovField.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.baseFrame.setCursor(Cursor.getDefaultCursor());
        this.coordsField.setCursor(Cursor.getPredefinedCursor(2));
        this.fovField.setCursor(Cursor.getPredefinedCursor(2));
    }

    private void addProperMotionEntry(ProperMotionCatalog entry, List<String[]> resultRows) {
        if (entry != null && entry.getTotalProperMotion() > 0.0) {
            double tpm = entry.getTotalProperMotion();
            double pmRa = entry.getPmra();
            double pmDec = entry.getPmdec();
            double pmRaErr = entry.getPmraErr();
            double pmDecErr = entry.getPmdecErr();
            resultRows.add(new String[]{entry.getCatalogName(), entry.getSourceId(), NumericFunctions.roundTo3DecLZ(entry.getTargetDistance()), "N/A", "N/A", NumericFunctions.roundTo3DecLZ(tpm), NumericFunctions.roundTo3DecLZ(pmRa), NumericFunctions.roundTo3DecLZ(pmDec), NumericFunctions.roundTo3DecLZ(pmRaErr), NumericFunctions.roundTo3DecLZ(pmDecErr)});
        }
    }

    private void displayImages(double targetRa, double targetDec, int size) throws Exception {
        List<FlipbookComponent> flipbook;
        JButton saveButton;
        Map<String, String> imageInfos;
        int year;
        NirImage nirImage;
        String band;
        Map<String, NirImage> images;
        int year_2ir;
        int year_1b = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss1_blue");
        int year_1r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss1_red");
        int year_2b = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_blue");
        int year_2r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_red");
        int year_2ir_1r_1b = year_2ir = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir");
        JPanel bandPanel = new JPanel(new FlowLayout(0));
        BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss1_blue&type=jpgurl");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS1 B", year_1b)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss1_red&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS1 R", year_1r)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_blue&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS2 B", year_2b)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_red&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS2 R", year_2r)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS IR", year_2ir)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DSS IR", year_2ir), new NirImage(year_2ir, image)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "file_type=colorimage")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS IR-R-B", year_2ir_1r_1b)));
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        int year_j = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=j");
        int year_h = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=h");
        int year_k = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=k");
        int year_k_h_j = ToolboxHelper.getMeanEpoch(year_k, year_h, year_j);
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=j&type=jpgurl");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS J", year_j)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=h&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS H", year_h)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=k&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS K", year_k)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("2MASS K", year_k), new NirImage(year_k, image)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "file_type=colorimage")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS K-H-J", year_k_h_j)));
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        int year_u = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=u");
        int year_g = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=g");
        int year_r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=r");
        int year_i = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=i");
        int year_z = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=z");
        int year_z_g_u = ToolboxHelper.getMeanEpoch(year_z, year_g, year_u);
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=u&type=jpgurl");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS u", year_u)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=g&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS g", year_g)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=r&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS r", year_r)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=i&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS i", year_i)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=z&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS z", year_z)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("SDSS z", year_z), new NirImage(year_z, image)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "file_type=colorimage")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS z-g-u", year_z_g_u)));
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        int year_ch1 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC1");
        int year_ch2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC2");
        int year_ch3 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC3");
        int year_ch4 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4");
        int year_mips24 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:MIPS24");
        int year_ch3_ch2_ch1 = ToolboxHelper.getMeanEpoch(year_ch3, year_ch2, year_ch1);
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC1&type=jpgurl");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC1", year_ch1)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC2&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC2", year_ch2)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC3&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC3", year_ch3)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC4", year_ch4)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("IIRAC4", year_ch4), new NirImage(2003, image)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:MIPS24&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("MIPS24", year_mips24)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "file_type=colorimage")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC3-2-1", year_ch3_ch2_ch1)));
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        int year_w1 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=1");
        int year_w2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=2");
        int year_w3 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=3");
        int year_w4 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=4");
        int year_w4_w2_w1 = ToolboxHelper.getMeanEpoch(year_w4, year_w2, year_w1);
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=1&type=jpgurl");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W1", year_w1)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=2&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W2", year_w2)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("WISE W2", year_w2), new NirImage(2010, image)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=3&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W3", year_w3)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=4&type=jpgurl")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W4", year_w4)));
        }
        if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "file_type=colorimage")) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W4-W2-W1", year_w4_w2_w1)));
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        if (targetDec > -5.0 && !(images = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS")).isEmpty()) {
            bandPanel = new JPanel(new FlowLayout(0));
            for (Map.Entry<String, NirImage> entry : images.entrySet()) {
                band = entry.getKey();
                nirImage = entry.getValue();
                image = nirImage.getImage();
                year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("UKIDSS " + band, year)));
                if (!band.equals("K")) continue;
                this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UKIDSS " + band, year), new NirImage(year, image)));
            }
            if (bandPanel.getComponentCount() > 0) {
                this.centerPanel.add(bandPanel);
                this.baseFrame.setVisible(true);
                this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
            }
        }
        if (targetDec > -5.0 && !(images = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS")).isEmpty()) {
            bandPanel = new JPanel(new FlowLayout(0));
            for (Map.Entry<String, NirImage> entry : images.entrySet()) {
                band = entry.getKey();
                nirImage = entry.getValue();
                image = nirImage.getImage();
                year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("UHS " + band, year)));
                if (!band.equals("K")) continue;
                this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UHS " + band, year), new NirImage(year, image)));
            }
            if (bandPanel.getComponentCount() > 0) {
                this.centerPanel.add(bandPanel);
                this.baseFrame.setVisible(true);
                this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
            }
        }
        if (targetDec < 5.0 && !(images = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS")).isEmpty()) {
            bandPanel = new JPanel(new FlowLayout(0));
            for (Map.Entry<String, NirImage> entry : images.entrySet()) {
                band = entry.getKey();
                nirImage = entry.getValue();
                image = nirImage.getImage();
                year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("VHS " + band, year)));
                if (!band.equals("K")) continue;
                this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("VHS " + band, year), new NirImage(year, image)));
            }
            if (bandPanel.getComponentCount() > 0) {
                this.centerPanel.add(bandPanel);
                this.baseFrame.setVisible(true);
                this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
            }
        }
        if (!(imageInfos = ToolboxHelper.getPs1FileNames(targetRa, targetDec)).isEmpty()) {
            Map<String, Double> years = ToolboxHelper.getPs1Epochs(targetRa, targetDec);
            year_g = years.get("g").intValue();
            year_r = years.get("r").intValue();
            year_i = years.get("i").intValue();
            year_z = years.get("z").intValue();
            int year_y = years.get("y").intValue();
            int year_y_i_g = ToolboxHelper.getMeanEpoch(year_y, year_i, year_g);
            bandPanel = new JPanel(new FlowLayout(0));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("g")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 g", year_g)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("r")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 r", year_r)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("i")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 i", year_i)));
            image = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("z")), targetRa, targetDec, size, true);
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("PS1 z", year_z)));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("PS1 z", year_z), new NirImage(year_z, image)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("y")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 y", year_y)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s&green=%s&blue=%s".formatted(imageInfos.get("y"), imageInfos.get("i"), imageInfos.get("g")), targetRa, targetDec, size, false), ToolboxHelper.getImageLabel("PS1 y-i-g", year_y_i_g)));
            if (bandPanel.getComponentCount() > 0) {
                bandPanel.add(ToolboxHelper.createHyperlink("WARP images", ExternalResources.getPanstarrsUrl(targetRa, targetDec, size, ImageType.WARP)));
                this.centerPanel.add(bandPanel);
                this.baseFrame.setVisible(true);
                this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
            }
        }
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "g", true);
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS g", "DR10")));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "r", true)) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS r", "DR10")));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "z", true)) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS z", "DR10")));
            this.timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DECaLS z", "DR10"), new NirImage(2017, image)));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false)) != null) {
            bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS", "DR10")));
        }
        if (bandPanel.getComponentCount() > 0) {
            bandPanel.add(ToolboxHelper.createHyperlink("Single exposures", ExternalResources.getLegacySingleExposuresUrl(targetRa, targetDec, "ls-dr10")));
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        bandPanel = new JPanel(new FlowLayout(0));
        this.timeSeries.sort(Comparator.comparing(c -> ((NirImage)c.getB()).getYear()));
        ArrayList<Couple<String, BufferedImage>> imageList = new ArrayList<Couple<String, BufferedImage>>();
        for (Couple<String, NirImage> couple : this.timeSeries) {
            bandPanel.add(this.buildImagePanel(couple.getB().getImage(), couple.getA()));
            imageList.add(new Couple<String, BufferedImage>(couple.getA(), couple.getB().getImage()));
        }
        this.timeSeriesTimer = new Timer(500, null);
        this.createTimeSeriesTimer(bandPanel, imageList, this.timeSeriesTimer);
        if (this.timeSeries.size() > 1) {
            saveButton = new JButton("Save as GIF");
            bandPanel.add(saveButton);
            saveButton.addActionListener(evt -> {
                try {
                    ToolboxHelper.saveAnimatedGif(imageList, saveButton);
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        bandPanel = new JPanel(new FlowLayout(0));
        image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false, "decals-dr5");
        if (image != null) {
            bandPanel.add(this.buildImagePanel(image, "DECaLS DR5"));
            this.desiImages.add(new Couple<String, BufferedImage>("DECaLS DR5", image));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false, "decals-dr7")) != null) {
            bandPanel.add(this.buildImagePanel(image, "DECaLS DR7"));
            this.desiImages.add(new Couple<String, BufferedImage>("DECaLS DR7", image));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false, "ls-dr8")) != null) {
            bandPanel.add(this.buildImagePanel(image, "LS DR8"));
            this.desiImages.add(new Couple<String, BufferedImage>("LS DR8", image));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false, "ls-dr9")) != null) {
            bandPanel.add(this.buildImagePanel(image, "LS DR9"));
            this.desiImages.add(new Couple<String, BufferedImage>("LS DR9", image));
        }
        if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false, "ls-dr10")) != null) {
            bandPanel.add(this.buildImagePanel(image, "LS DR10"));
            this.desiImages.add(new Couple<String, BufferedImage>("LS DR10", image));
        }
        if (this.desiImages.size() > 2) {
            this.desiTimeSeriesTimer = new Timer(500, null);
            this.createTimeSeriesTimer(bandPanel, this.desiImages, this.desiTimeSeriesTimer);
            saveButton = new JButton("Save as GIF");
            bandPanel.add(saveButton);
            saveButton.addActionListener(evt -> {
                try {
                    ToolboxHelper.saveAnimatedGif(this.desiImages, saveButton);
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
        }
        if (bandPanel.getComponentCount() > 0) {
            this.centerPanel.add(bandPanel);
            this.baseFrame.setVisible(true);
            this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
        }
        if ((flipbook = this.imageViewerTab.getFlipbook()) != null) {
            bandPanel = new JPanel(new FlowLayout(0));
            for (int i = 0; i < flipbook.size(); ++i) {
                FlipbookComponent component = flipbook.get(i);
                image = this.imageViewerTab.processImage(component, i);
                bandPanel.add(this.buildImagePanel(image, component.getTitle()));
                this.wiseImages.add(new Couple<String, BufferedImage>(component.getTitle(), image));
            }
            this.wiseTimeSeriesTimer = new Timer(500, null);
            this.createTimeSeriesTimer(bandPanel, this.wiseImages, this.wiseTimeSeriesTimer);
            JButton saveButton2 = new JButton("Save as GIF");
            bandPanel.add(saveButton2);
            saveButton2.addActionListener(evt -> {
                try {
                    ToolboxHelper.saveAnimatedGif(this.wiseImages, saveButton2);
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            if (bandPanel.getComponentCount() > 0) {
                this.centerPanel.add(bandPanel);
                this.baseFrame.setVisible(true);
                this.scrollPanel.getVerticalScrollBar().setValue(this.centerPanel.getHeight());
            }
        }
    }

    private void createTimeSeriesTimer(JPanel bandPanel, List<Couple<String, BufferedImage>> imageList, Timer timer) {
        int componentCount = imageList.size();
        if (componentCount > 1) {
            JPanel displayPanel = new JPanel();
            bandPanel.add(displayPanel);
            Counter imageCounter = new Counter();
            timer.addActionListener(e -> {
                if (imageCounter.value() > componentCount - 1) {
                    imageCounter.init();
                }
                displayPanel.removeAll();
                Couple imageData = (Couple)imageList.get(imageCounter.value());
                displayPanel.add(this.buildImagePanel((BufferedImage)imageData.getB(), (String)imageData.getA()));
                this.baseFrame.repaint();
                imageCounter.add();
            });
            timer.start();
        }
    }

    private JPanel buildImagePanel(BufferedImage image, String imageLabel) {
        JLabel label = ToolboxHelper.addTextToImage(image, imageLabel);
        JPanel panel = new JPanel();
        panel.add(label);
        return panel;
    }

    private List<CatalogEntry> performQuery(CatalogEntry catalogQuery) throws IOException {
        List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
        catalogEntries.forEach(catalogEntry -> {
            catalogEntry.setTargetRa(catalogQuery.getRa());
            catalogEntry.setTargetDec(catalogQuery.getDec());
            catalogEntry.loadCatalogElements();
        });
        if (!catalogEntries.isEmpty()) {
            catalogEntries.sort(Comparator.comparingDouble(CatalogEntry::getTargetDistance));
            CatalogEntry nearestEntry = catalogEntries.get(0);
            if (nearestEntry.getTargetDistance() < 10.0) {
                switch (nearestEntry.getCatalogName()) {
                    case "2MASS": {
                        this.twoMassEntry = (TwoMassCatalogEntry)nearestEntry;
                        break;
                    }
                    case "AllWISE": {
                        this.allWiseEntry = (AllWiseCatalogEntry)nearestEntry;
                        break;
                    }
                    case "SDSS DR17": {
                        this.sdssEntry = (SdssCatalogEntry)nearestEntry;
                        break;
                    }
                    case "Pan-STARRS": {
                        this.panStarrsEntry = (PanStarrsCatalogEntry)nearestEntry;
                        break;
                    }
                    case "Gaia DR3": {
                        this.gaiaDR3Entry = (GaiaDR3CatalogEntry)nearestEntry;
                        break;
                    }
                    case "CatWISE2020": {
                        this.catWiseEntry = (CatWiseCatalogEntry)nearestEntry;
                        break;
                    }
                    case "NSC DR2": {
                        this.noirlabEntry = (NoirlabCatalogEntry)nearestEntry;
                        break;
                    }
                    case "UKIDSS DR11": {
                        this.ukidssEntry = (UkidssCatalogEntry)nearestEntry;
                    }
                }
            }
            return catalogEntries;
        }
        return null;
    }

    private void displayCatalogResults(List<CatalogEntry> catalogEntries) {
        ArrayList list = new ArrayList();
        catalogEntries.forEach(entry -> list.add(entry.getColumnValues()));
        CatalogEntry catalogEntry = catalogEntries.get(0);
        Object[] columns = catalogEntry.getColumnTitles();
        Object[][] rows = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])list.toArray((T[])rows), columns);
        JTable catalogTable = new JTable(defaultTableModel);
        ToolboxHelper.alignCatalogColumns(catalogTable, catalogEntry);
        catalogTable.setAutoCreateRowSorter(true);
        catalogTable.setAutoResizeMode(0);
        catalogTable.setRowSorter(ToolboxHelper.createCatalogTableSorter(defaultTableModel, catalogEntry));
        catalogTable.setSelectionMode(0);
        catalogTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != catalogTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = catalogTable;
                String sourceId = (String)catalogTable.getValueAt(catalogTable.getSelectedRow(), 1);
                CatalogEntry selected = catalogEntries.stream().filter(entry -> entry.getSourceId().equals(sourceId)).findFirst().get();
                if (selected != null) {
                    this.activateSelectedCatalogOverlay(this.imageViewerTab, selected);
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
        });
        ToolboxHelper.resizeColumnWidth(catalogTable);
        JScrollPane catalogScrollPanel = new JScrollPane(catalogTable);
        catalogScrollPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(catalogEntry.getCatalogColor(), 3), catalogEntry.getCatalogName() + " results", 1, 2));
        this.bottomPanel.addTab(catalogEntry.getCatalogName(), catalogScrollPanel);
    }

    private void activateSelectedCatalogOverlay(ImageViewerTab imageViewerTab, CatalogEntry selected) {
        switch (selected.getCatalogName()) {
            case "SIMBAD": {
                imageViewerTab.getSimbadOverlay().setSelected(true);
                break;
            }
            case "AllWISE": {
                imageViewerTab.getAllWiseOverlay().setSelected(true);
                break;
            }
            case "CatWISE2020": {
                imageViewerTab.getCatWiseOverlay().setSelected(true);
                break;
            }
            case "unWISE": {
                imageViewerTab.getUnWiseOverlay().setSelected(true);
                break;
            }
            case "Gaia DR2": {
                imageViewerTab.getGaiaOverlay().setSelected(true);
                break;
            }
            case "Gaia DR3": {
                imageViewerTab.getGaiaDR3Overlay().setSelected(true);
                break;
            }
            case "NSC DR2": {
                imageViewerTab.getNoirlabOverlay().setSelected(true);
                break;
            }
            case "Pan-STARRS": {
                imageViewerTab.getPanStarrsOverlay().setSelected(true);
                break;
            }
            case "SDSS DR17": {
                imageViewerTab.getSdssOverlay().setSelected(true);
                break;
            }
            case "VHS DR5": {
                imageViewerTab.getVhsOverlay().setSelected(true);
                break;
            }
            case "UHS DR3": {
                imageViewerTab.getUhsOverlay().setSelected(true);
                break;
            }
            case "UKIDSS DR11": {
                imageViewerTab.getUkidssOverlay().setSelected(true);
                break;
            }
            case "2MASS": {
                imageViewerTab.getTwoMassOverlay().setSelected(true);
                break;
            }
            case "TESS Input Catalog": {
                imageViewerTab.getTessOverlay().setSelected(true);
                break;
            }
            case "DES DR2": {
                imageViewerTab.getDesOverlay().setSelected(true);
                break;
            }
            case "Gaia EDR3 WD": {
                imageViewerTab.getGaiaWDOverlay().setSelected(true);
                break;
            }
            case "MOCA DB": {
                imageViewerTab.getMocaOverlay().setSelected(true);
            }
        }
    }

    private void deselectedCatalogOverlay(ImageViewerTab imageViewerTab) {
        imageViewerTab.getSimbadOverlay().setSelected(false);
        imageViewerTab.getGaiaOverlay().setSelected(false);
        imageViewerTab.getGaiaDR3Overlay().setSelected(false);
        imageViewerTab.getAllWiseOverlay().setSelected(false);
        imageViewerTab.getCatWiseOverlay().setSelected(false);
        imageViewerTab.getUnWiseOverlay().setSelected(false);
        imageViewerTab.getPanStarrsOverlay().setSelected(false);
        imageViewerTab.getSdssOverlay().setSelected(false);
        imageViewerTab.getTwoMassOverlay().setSelected(false);
        imageViewerTab.getVhsOverlay().setSelected(false);
        imageViewerTab.getGaiaWDOverlay().setSelected(false);
        imageViewerTab.getNoirlabOverlay().setSelected(false);
        imageViewerTab.getTessOverlay().setSelected(false);
        imageViewerTab.getDesOverlay().setSelected(false);
    }
}

