/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.Artifact;
import astro.tool.box.catalog.CatWiseCatalogEntry;
import astro.tool.box.catalog.CatWiseRejectEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.DesCatalogEntry;
import astro.tool.box.catalog.Extinction;
import astro.tool.box.catalog.GaiaCmd;
import astro.tool.box.catalog.GaiaDR2CatalogEntry;
import astro.tool.box.catalog.GaiaDR3CatalogEntry;
import astro.tool.box.catalog.GaiaWDCatalogEntry;
import astro.tool.box.catalog.GenericCatalogEntry;
import astro.tool.box.catalog.MocaCatalogEntry;
import astro.tool.box.catalog.NoirlabCatalogEntry;
import astro.tool.box.catalog.PanStarrsCatalogEntry;
import astro.tool.box.catalog.ProperMotionQuery;
import astro.tool.box.catalog.SdssCatalogEntry;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.SsoCatalogEntry;
import astro.tool.box.catalog.TessCatalogEntry;
import astro.tool.box.catalog.TwoMassCatalogEntry;
import astro.tool.box.catalog.UhsCatalogEntry;
import astro.tool.box.catalog.UkidssCatalogEntry;
import astro.tool.box.catalog.UnWiseCatalogEntry;
import astro.tool.box.catalog.VhsCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.component.TextPrompt;
import astro.tool.box.container.CatalogElement;
import astro.tool.box.container.Couple;
import astro.tool.box.container.CustomOverlay;
import astro.tool.box.container.Epoch;
import astro.tool.box.container.FlipbookComponent;
import astro.tool.box.container.ImageContainer;
import astro.tool.box.container.NirImage;
import astro.tool.box.container.NumberPair;
import astro.tool.box.container.Overlays;
import astro.tool.box.container.Tile;
import astro.tool.box.enumeration.ImageType;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.enumeration.ObjectType;
import astro.tool.box.enumeration.Shape;
import astro.tool.box.enumeration.WiseBand;
import astro.tool.box.exception.ExtinctionException;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.function.StatisticFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.DistanceLookupResult;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.lookup.SpectralTypeLookupEntry;
import astro.tool.box.main.Application;
import astro.tool.box.main.ImageSeriesPdf;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.panel.GaiaCmdPanel;
import astro.tool.box.panel.ReferencesPanel;
import astro.tool.box.panel.SedUcdPanel;
import astro.tool.box.panel.SedWdPanel;
import astro.tool.box.panel.WiseCcdPanel;
import astro.tool.box.panel.WiseLcPanel;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.DistanceLookupService;
import astro.tool.box.service.DustExtinctionService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.shape.Arrow;
import astro.tool.box.shape.Circle;
import astro.tool.box.shape.Cross;
import astro.tool.box.shape.CrossHair;
import astro.tool.box.shape.Diamond;
import astro.tool.box.shape.Disk;
import astro.tool.box.shape.Drawable;
import astro.tool.box.shape.Square;
import astro.tool.box.shape.Triangle;
import astro.tool.box.shape.XCross;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.CSVParser;
import astro.tool.box.util.Constants;
import astro.tool.box.util.Counter;
import astro.tool.box.util.ExternalResources;
import astro.tool.box.util.FileTypeFilter;
import astro.tool.box.util.GifSequencer;
import astro.tool.box.util.MiscUtils;
import astro.tool.box.util.ServiceHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultCaret;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;

public class ImageViewerTab
implements Tab {
    public static final String TAB_NAME = "Image Viewer";
    public static final WiseBand WISE_BAND = WiseBand.W1W2;
    public static final double OVERLAP_FACTOR = 0.9;
    public static final int NUMBER_OF_WISE_EPOCHS = 11;
    public static final int NUMBER_OF_UNWISE_EPOCHS = 8;
    public static final int WINDOW_SPACING = 25;
    public static final int CATALOG_PANEL_WIDTH = 700;
    public static final int PANEL_HEIGHT = 220;
    public static final int PANEL_WIDTH = 180;
    public static final int ROW_HEIGHT = 25;
    public static final int EPOCH_GAP = 6;
    public static final int SPEED = 200;
    public static final int ZOOM = 500;
    public static final int SIZE = 100;
    public static final int DIFFERENT_SIZE = 100;
    public static final int PROPER_MOTION = 100;
    public static final String OVERLAYS_KEY = "overlays";
    public static final String CHANGE_FOV_TEXT = "Current field of view: %d\" <span style='color:red'>&#9432;</span>";
    public static final double ALLWISE_REFERENCE_EPOCH = 2010.559;
    public static final double CATWISE_ALLWISE_EPOCH_DIFF = 4.846;
    public static final double GAIADR2_ALLWISE_EPOCH_DIFF = 4.941;
    public static final double GAIADR3_ALLWISE_EPOCH_DIFF = 5.441;
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryService catalogQueryService;
    private final SpectralTypeLookupService mainSequenceSpectralTypeLookupService;
    private final SpectralTypeLookupService brownDwarfsSpectralTypeLookupService;
    private final DistanceLookupService distanceLookupService;
    private final DustExtinctionService dustExtinctionService;
    private final List<SpectralTypeLookup> brownDwarfLookupEntries;
    private final Overlays overlays;
    private List<CatalogEntry> simbadEntries;
    private List<CatalogEntry> allWiseEntries;
    private List<CatalogEntry> catWiseEntries;
    private List<CatalogEntry> catWiseTpmEntries;
    private List<CatalogEntry> catWiseRejectEntries;
    private List<CatalogEntry> unWiseEntries;
    private List<CatalogEntry> gaiaEntries;
    private List<CatalogEntry> gaiaTpmEntries;
    private List<CatalogEntry> gaiaDR3Entries;
    private List<CatalogEntry> gaiaDR3TpmEntries;
    private List<CatalogEntry> noirlabEntries;
    private List<CatalogEntry> noirlabTpmEntries;
    private List<CatalogEntry> panStarrsEntries;
    private List<CatalogEntry> sdssEntries;
    private List<CatalogEntry> vhsEntries;
    private List<CatalogEntry> uhsEntries;
    private List<CatalogEntry> uhsTpmEntries;
    private List<CatalogEntry> ukidssEntries;
    private List<CatalogEntry> ukidssTpmEntries;
    private List<CatalogEntry> twoMassEntries;
    private List<CatalogEntry> tessEntries;
    private List<CatalogEntry> desEntries;
    private List<CatalogEntry> gaiaWDEntries;
    private List<CatalogEntry> mocaEntries;
    private List<CatalogEntry> ssoEntries;
    private JPanel imagePanel;
    private JPanel rightPanel;
    private JPanel bywTopRow;
    private JPanel bywBottomRow;
    private JLabel panstarrsLabel;
    private JLabel aladinLiteLabel;
    private JLabel wiseViewLabel;
    private JLabel finderChartLabel;
    private JLabel legacyViewerLabel;
    private JLabel ukidssCutoutsLabel;
    private JLabel vhsCutoutsLabel;
    private JLabel simbadLabel;
    private JLabel vizierLabel;
    private JLabel changeFovLabel;
    private JButton changeFovButton;
    private JButton stopDownloadButton;
    private JRadioButton wiseviewCutouts;
    private JRadioButton unwiseCutouts;
    private JRadioButton desiCutouts;
    private JRadioButton ps1Cutouts;
    private JRadioButton showCatalogsButton;
    private JScrollPane rightScrollPanel;
    private JCheckBox differenceImaging;
    private JCheckBox skipIntermediateEpochs;
    private JCheckBox separateScanDirections;
    private JCheckBox resetContrast;
    private JCheckBox skipBadImages;
    private JCheckBox blurImages;
    private JCheckBox invertColors;
    private JCheckBox borderFirst;
    private JCheckBox staticView;
    private JCheckBox markTarget;
    private JCheckBox showCrosshairs;
    private JCheckBox simbadOverlay;
    private JCheckBox allWiseOverlay;
    private JCheckBox catWiseOverlay;
    private JCheckBox unWiseOverlay;
    private JCheckBox gaiaOverlay;
    private JCheckBox gaiaDR3Overlay;
    private JCheckBox noirlabOverlay;
    private JCheckBox panStarrsOverlay;
    private JCheckBox sdssOverlay;
    private JCheckBox spectrumOverlay;
    private JCheckBox vhsOverlay;
    private JCheckBox uhsOverlay;
    private JCheckBox ukidssOverlay;
    private JCheckBox twoMassOverlay;
    private JCheckBox tessOverlay;
    private JCheckBox desOverlay;
    private JCheckBox gaiaWDOverlay;
    private JCheckBox mocaOverlay;
    private JCheckBox ssoOverlay;
    private JCheckBox ghostOverlay;
    private JCheckBox haloOverlay;
    private JCheckBox latentOverlay;
    private JCheckBox spikeOverlay;
    private JCheckBox gaiaProperMotion;
    private JCheckBox gaiaDR3ProperMotion;
    private JCheckBox noirlabProperMotion;
    private JCheckBox catWiseProperMotion;
    private JCheckBox ukidssProperMotion;
    private JCheckBox uhsProperMotion;
    private JCheckBox showProperMotion;
    private JCheckBox useCustomOverlays;
    private JCheckBox dssImageSeries;
    private JCheckBox twoMassImageSeries;
    private JCheckBox sdssImageSeries;
    private JCheckBox spitzerImageSeries;
    private JCheckBox allwiseImageSeries;
    private JCheckBox ukidssImageSeries;
    private JCheckBox uhsImageSeries;
    private JCheckBox vhsImageSeries;
    private JCheckBox panstarrsImageSeries;
    private JCheckBox legacyImageSeries;
    private JCheckBox staticTimeSeries;
    private JCheckBox animatedTimeSeries;
    private JCheckBox imageSeriesPdf;
    private JCheckBox drawCrosshairs;
    private JComboBox wiseBands;
    private JSlider brightnessSlider;
    private JSlider contrastSlider;
    private JSlider speedSlider;
    private JSlider zoomSlider;
    private JSlider stackSlider;
    private JTextField coordsField;
    private JTextField sizeField;
    private JTextField properMotionField;
    private JTextField differentSizeField;
    private JTextField panstarrsField;
    private JTextField aladinLiteField;
    private JTextField wiseViewField;
    private JTextField finderChartField;
    private JTextArea crosshairCoords;
    private JTextArea downloadLog;
    private JTable collectionTable;
    private JTable currentTable;
    private Timer timer;
    private BufferedImage wiseImage;
    private BufferedImage desiImage;
    private BufferedImage ps1Image;
    private BufferedImage vhsImage;
    private BufferedImage uhsImage;
    private BufferedImage ukidssImage;
    private BufferedImage sdssImage;
    private BufferedImage dssImage;
    private BufferedImage processedDesiImage;
    private BufferedImage processedPs1Image;
    private BufferedImage processedVhsImage;
    private BufferedImage processedUhsImage;
    private BufferedImage processedUkidssImage;
    private BufferedImage processedSdssImage;
    private BufferedImage processedDssImage;
    private Map<String, ImageContainer> imagesW1 = new HashMap<String, ImageContainer>();
    private Map<String, ImageContainer> imagesW2 = new HashMap<String, ImageContainer>();
    private Map<String, ImageContainer> imagesW1All = new HashMap<String, ImageContainer>();
    private Map<String, ImageContainer> imagesW2All = new HashMap<String, ImageContainer>();
    private Map<String, ImageContainer> imagesW1Ends = new HashMap<String, ImageContainer>();
    private Map<String, ImageContainer> imagesW2Ends = new HashMap<String, ImageContainer>();
    private Map<String, CustomOverlay> customOverlays;
    private List<NumberPair> crosshairs = new ArrayList<NumberPair>();
    private List<Fits> band1Images = new ArrayList<Fits>();
    private List<Fits> band2Images = new ArrayList<Fits>();
    private List<FlipbookComponent> flipbook = new ArrayList<FlipbookComponent>();
    private ImageViewerTab imageViewer;
    private Tile tile;
    private WiseBand wiseBand = WISE_BAND;
    private double pixelScale = 2.75;
    private int fieldOfView = 30;
    private int shapeSize = 5;
    private int stackSize = 1;
    private int imageNumber;
    private int imageCount;
    private int windowShift;
    private int quadrantCount;
    private int epochCount;
    private int brightness;
    private int contrast;
    private int minValue;
    private int maxValue;
    private int speed = 200;
    private int zoom = 500;
    private int size = 100;
    private int year_ps1_y_i_g;
    private int year_vhs_k_h_j;
    private int year_uhs_k_j;
    private int year_ukidss_k_h_j;
    private int year_dss_2ir_1r_1b;
    private double targetRa;
    private double targetDec;
    private double crval1;
    private double crval2;
    private double crpix1;
    private double crpix2;
    private int naxis1;
    private int naxis2;
    private int pointerX;
    private int pointerY;
    private int componentIndex;
    private int previousSize;
    private double previousRa;
    private double previousDec;
    private boolean loadImages;
    private boolean stopDownloadProcess;
    private boolean flipbookComplete;
    private boolean imageCutOff;
    private boolean timerStopped;
    private boolean hasException;
    private final boolean nearestBywSubjects;
    private boolean asyncDownloads;
    private boolean legacyImages;
    private boolean panstarrsImages;
    private boolean vhsImages;
    private boolean uhsImages;
    private boolean ukidssImages;
    private boolean sdssImages;
    private boolean dssImages;
    private boolean waitCursor = true;

    public ImageViewerTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        Stream<String> stream;
        InputStream input;
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryService = new CatalogQueryService();
        this.dustExtinctionService = new DustExtinctionService();
        try {
            input = this.getClass().getResourceAsStream("/SpectralTypeLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                List<SpectralTypeLookup> entries = stream.skip(1L).map(line -> new SpectralTypeLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.mainSequenceSpectralTypeLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
        try {
            input = this.getClass().getResourceAsStream("/BrownDwarfLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                this.brownDwarfLookupEntries = stream.skip(1L).map(line -> new BrownDwarfLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.brownDwarfsSpectralTypeLookupService = new SpectralTypeLookupService(this.brownDwarfLookupEntries);
                this.distanceLookupService = new DistanceLookupService(this.brownDwarfLookupEntries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
        this.overlays = new Overlays();
        this.overlays.deserialize(SettingsTab.getUserSetting(OVERLAYS_KEY, this.overlays.serialize()));
        this.nearestBywSubjects = Boolean.parseBoolean(SettingsTab.getUserSetting("nearestBywSubjects", "true"));
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel leftPanel = new JPanel();
            leftPanel.setLayout(new BoxLayout(leftPanel, 1));
            leftPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JTabbedPane controlTabs = new JTabbedPane(1, 1);
            leftPanel.add(controlTabs);
            this.imagePanel = new JPanel();
            this.imagePanel.setLayout(new BoxLayout(this.imagePanel, 1));
            JScrollPane imageScrollPanel = new JScrollPane(this.imagePanel);
            imageScrollPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JSplitPane splitPane = new JSplitPane(1, leftPanel, imageScrollPanel);
            mainPanel.add((Component)splitPane, "Center");
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightScrollPanel = new JScrollPane(this.rightPanel);
            this.rightScrollPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.rightScrollPanel.setPreferredSize(new Dimension(230, this.rightPanel.getHeight()));
            mainPanel.add((Component)this.rightScrollPanel, "East");
            int rows = 39;
            if (this.nearestBywSubjects) {
                rows += 3;
            }
            int controlPanelWidth = 255;
            int controlPanelHeight = 10 + 25 * rows;
            JPanel mainControlPanel = new JPanel(new GridLayout(rows, 1));
            mainControlPanel.setPreferredSize(new Dimension(controlPanelWidth - 20, controlPanelHeight));
            mainControlPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JScrollPane mainScrollPanel = new JScrollPane(mainControlPanel);
            mainScrollPanel.setPreferredSize(new Dimension(controlPanelWidth, controlPanelHeight));
            mainScrollPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            controlTabs.add("Controls", mainScrollPanel);
            mainControlPanel.add(new JLabel("Target coordinates:"));
            this.coordsField = new JTextField();
            mainControlPanel.add(this.coordsField);
            TextPrompt coordsFieldPrompt = new TextPrompt("Enter coordinates and press Enter");
            coordsFieldPrompt.applyTo(this.coordsField);
            this.coordsField.addActionListener(evt -> this.createFlipbook());
            mainControlPanel.add(new JLabel("Field of view (arcsec):"));
            this.sizeField = new JTextField(String.valueOf(this.size));
            mainControlPanel.add(this.sizeField);
            this.sizeField.addActionListener(evt -> this.createFlipbook());
            mainControlPanel.add(new JLabel("Band:"));
            this.wiseBands = new JComboBox<WiseBand>(WiseBand.values());
            mainControlPanel.add(this.wiseBands);
            this.wiseBands.setSelectedItem((Object)this.wiseBand);
            this.wiseBands.addActionListener(evt -> {
                this.wiseBand = (WiseBand)((Object)((Object)this.wiseBands.getSelectedItem()));
                this.loadImages = true;
                this.createFlipbook();
            });
            mainControlPanel.add(new JLabel("Brightness:"));
            this.brightnessSlider = new JSlider(1, 100, 1);
            mainControlPanel.add(this.brightnessSlider);
            this.brightnessSlider.addChangeListener(e -> {
                this.brightness = this.brightnessSlider.getValue();
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                this.createFlipbook();
            });
            mainControlPanel.add(new JLabel("Contrast:"));
            this.contrastSlider = new JSlider(1, 100, 50);
            mainControlPanel.add(this.contrastSlider);
            this.contrastSlider.addChangeListener(e -> {
                this.contrast = this.contrastSlider.getValue();
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                this.createFlipbook();
            });
            JLabel zoomLabel = new JLabel("Zoom: %d".formatted(this.zoom));
            mainControlPanel.add(zoomLabel);
            this.zoomSlider = new JSlider(100, 2000, 500);
            mainControlPanel.add(this.zoomSlider);
            this.zoomSlider.addChangeListener(e -> {
                this.zoom = this.zoomSlider.getValue();
                zoomLabel.setText("Zoom: %d".formatted(this.zoom));
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                this.processImages();
            });
            JLabel speedLabel = new JLabel("Blink interval: %d ms".formatted(this.speed));
            mainControlPanel.add(speedLabel);
            this.speedSlider = new JSlider(0, 2000, 200);
            mainControlPanel.add(this.speedSlider);
            this.speedSlider.addChangeListener(e -> {
                this.speed = this.speedSlider.getValue();
                speedLabel.setText("Blink interval: %d ms".formatted(this.speed));
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                this.timer.setDelay(this.speed);
                this.processImages();
            });
            this.wiseviewCutouts = new JRadioButton(ToolboxHelper.html("WISE cutouts (sep. scan) <span style='color:red'>&#9432;</span>"), true);
            this.wiseviewCutouts.setToolTipText("WISE cutouts are from http://byw.tools/wiseview and have separate scan directions,\nwhich can be activated by ticking the 'Separate scan directions' checkbox.");
            this.wiseviewCutouts.addActionListener(evt -> {
                this.pixelScale = 2.75;
                this.previousSize = 0;
                this.createFlipbook();
            });
            this.unwiseCutouts = new JRadioButton(ToolboxHelper.html("unWISE deep coadds <span style='color:red'>&#9432;</span>"));
            this.unwiseCutouts.setToolTipText("unWISE deep coadds are from https://unwise.me and do not have separate scan directions.\nSeveral epochs are stacked together so that high proper motion objects may look smeared.");
            this.unwiseCutouts.addActionListener(evt -> {
                this.pixelScale = 2.75;
                this.previousSize = 0;
                this.createFlipbook();
            });
            String stackText = "Images per blink: %d";
            JLabel stackLabel = new JLabel(stackText.formatted(this.stackSize));
            mainControlPanel.add(stackLabel);
            this.stackSlider = new JSlider(1, this.getNumberOfWiseEpochs(), 1);
            mainControlPanel.add(this.stackSlider);
            this.stackSlider.addChangeListener(e -> {
                this.stackSize = this.stackSlider.getValue();
                stackLabel.setText(stackText.formatted(this.stackSize));
                JSlider source = (JSlider)e.getSource();
                if (source.getValueIsAdjusting()) {
                    return;
                }
                if (this.skipIntermediateEpochs.isSelected()) {
                    this.skipIntermediateEpochs.setSelected(false);
                    this.loadImages = true;
                }
                this.createFlipbook();
            });
            this.skipIntermediateEpochs = new JCheckBox("Skip intermediate epochs", true);
            mainControlPanel.add(this.skipIntermediateEpochs);
            this.skipIntermediateEpochs.addActionListener(evt -> {
                if (this.skipIntermediateEpochs.isSelected()) {
                    if (this.skipBadImages.isSelected()) {
                        this.skipBadImages.setSelected(false);
                    }
                    this.imagesW1.clear();
                    this.imagesW2.clear();
                    this.imagesW1.putAll(this.imagesW1Ends);
                    this.imagesW2.putAll(this.imagesW2Ends);
                    if (this.stackSlider.getValue() > 1) {
                        ChangeListener actionListener = this.stackSlider.getChangeListeners()[0];
                        this.stackSlider.removeChangeListener(actionListener);
                        this.stackSlider.setValue(1);
                        this.stackSlider.addChangeListener(actionListener);
                        this.stackSize = 1;
                        stackLabel.setText(stackText.formatted(this.stackSize));
                    }
                } else {
                    if (!this.imagesW1All.isEmpty()) {
                        this.imagesW1.putAll(this.imagesW1All);
                    }
                    if (!this.imagesW2All.isEmpty()) {
                        this.imagesW2.putAll(this.imagesW2All);
                    }
                }
                this.loadImages = true;
                this.createFlipbook();
            });
            this.separateScanDirections = new JCheckBox("Separate scan directions");
            mainControlPanel.add(this.separateScanDirections);
            this.separateScanDirections.addActionListener(evt -> this.createFlipbook());
            this.differenceImaging = new JCheckBox("Difference imaging");
            mainControlPanel.add(this.differenceImaging);
            this.differenceImaging.addActionListener(evt -> {
                if (this.differenceImaging.isSelected()) {
                    this.separateScanDirections.setSelected(true);
                    this.blurImages.setSelected(true);
                    this.brightnessSlider.setEnabled(false);
                    this.separateScanDirections.setEnabled(false);
                } else {
                    this.separateScanDirections.setSelected(false);
                    this.blurImages.setSelected(false);
                    this.brightnessSlider.setEnabled(true);
                    this.separateScanDirections.setEnabled(true);
                }
                if (this.resetContrast.isSelected()) {
                    this.resetContrastSlider();
                }
                this.createFlipbook();
            });
            this.resetContrast = new JCheckBox("Auto-reset brightness & contrast", true);
            mainControlPanel.add(this.resetContrast);
            this.resetContrast.addActionListener(evt -> {
                if (this.resetContrast.isSelected()) {
                    this.resetContrastSlider();
                    this.createFlipbook();
                }
            });
            this.skipBadImages = new JCheckBox("Skip poor quality images");
            mainControlPanel.add(this.skipBadImages);
            this.skipBadImages.addActionListener(evt -> {
                if (this.skipBadImages.isSelected() && this.skipIntermediateEpochs.isSelected()) {
                    this.skipIntermediateEpochs.setSelected(false);
                }
                this.previousSize = -1;
                this.createFlipbook();
            });
            JPanel settingsPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(settingsPanel);
            this.blurImages = new JCheckBox("Blur images");
            settingsPanel.add(this.blurImages);
            this.blurImages.addActionListener(evt -> this.processImages());
            this.invertColors = new JCheckBox("Invert colors");
            settingsPanel.add(this.invertColors);
            this.invertColors.addActionListener(evt -> this.processImages());
            settingsPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(settingsPanel);
            this.borderFirst = new JCheckBox("Border 1st ep.");
            settingsPanel.add(this.borderFirst);
            this.staticView = new JCheckBox("Static view");
            settingsPanel.add(this.staticView);
            this.staticView.addActionListener(evt -> {
                if (!this.flipbook.isEmpty()) {
                    if (this.staticView.isSelected()) {
                        this.createStaticBook();
                    } else {
                        this.createFlipbook();
                    }
                }
            });
            settingsPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(settingsPanel);
            this.markTarget = new JCheckBox("Mark target");
            settingsPanel.add(this.markTarget);
            this.showCrosshairs = new JCheckBox(ToolboxHelper.html("Crosshairs <span style='color:red'>&#9432;</span>"));
            settingsPanel.add(this.showCrosshairs);
            this.showCrosshairs.setToolTipText("Click on object to copy coordinates to clipboard (overlays must be disabled)");
            JButton resetDefaultsButton = new JButton("Reset image defaults");
            mainControlPanel.add(resetDefaultsButton);
            resetDefaultsButton.addActionListener(evt -> {
                if (this.differenceImaging.isSelected()) {
                    this.blurImages.setSelected(true);
                } else {
                    this.blurImages.setSelected(false);
                }
                this.resetContrastSlider();
                this.createFlipbook();
            });
            this.stopDownloadButton = new JButton("Stop download process");
            mainControlPanel.add(this.stopDownloadButton);
            this.stopDownloadButton.addActionListener(evt -> {
                this.stopDownloadProcess = true;
                this.enableAll();
            });
            mainControlPanel.add(this.wiseviewCutouts);
            mainControlPanel.add(this.unwiseCutouts);
            this.desiCutouts = new JRadioButton(ToolboxHelper.html("DECaLS cutouts <span style='color:red'>&#9432;</span>"));
            mainControlPanel.add(this.desiCutouts);
            this.desiCutouts.setToolTipText("DECaLS cutouts are from https://www.legacysurvey.org and should be used with caution for motion detection.\nThe imagery might partially be the same for some of the data releases (e.g. DR8 and DR9).");
            this.desiCutouts.addActionListener(evt -> {
                this.pixelScale = 0.25;
                this.previousSize = 0;
                this.createFlipbook();
            });
            this.ps1Cutouts = new JRadioButton(ToolboxHelper.html("PS1 Warp images <span style='color:red'>&#9432;</span>"));
            mainControlPanel.add(this.ps1Cutouts);
            this.ps1Cutouts.setToolTipText("These are cutouts from the Pan-STARRS1 DR2 Warp images. For further details, see https://outerspace.stsci.edu/display/PANSTARRS/PS1+Warp+images");
            this.ps1Cutouts.addActionListener(evt -> {
                this.pixelScale = 0.25;
                this.previousSize = 0;
                this.createFlipbook();
            });
            ButtonGroup cutoutGroup = new ButtonGroup();
            cutoutGroup.add(this.wiseviewCutouts);
            cutoutGroup.add(this.unwiseCutouts);
            cutoutGroup.add(this.desiCutouts);
            cutoutGroup.add(this.ps1Cutouts);
            if (this.nearestBywSubjects) {
                mainControlPanel.add(ToolboxHelper.createHeaderLabel("Nearest BYW subjects"));
                this.bywTopRow = new JPanel(new FlowLayout(0));
                mainControlPanel.add(this.bywTopRow);
                this.bywBottomRow = new JPanel(new FlowLayout(0));
                mainControlPanel.add(this.bywBottomRow);
            }
            mainControlPanel.add(ToolboxHelper.createHeaderLabel("External resources"));
            JPanel resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.panstarrsLabel = new JLabel("Pan-STARRS");
            resourcesPanel.add(this.panstarrsLabel);
            this.panstarrsField = new JTextField();
            resourcesPanel.add(this.panstarrsField);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.aladinLiteLabel = new JLabel("Aladin Lite");
            resourcesPanel.add(this.aladinLiteLabel);
            this.aladinLiteField = new JTextField();
            resourcesPanel.add(this.aladinLiteField);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.wiseViewLabel = new JLabel("WiseView");
            resourcesPanel.add(this.wiseViewLabel);
            this.wiseViewField = new JTextField();
            resourcesPanel.add(this.wiseViewField);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.finderChartLabel = new JLabel("IRSA Finder Chart");
            resourcesPanel.add(this.finderChartLabel);
            this.finderChartField = new JTextField();
            resourcesPanel.add(this.finderChartField);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            resourcesPanel.add(new JLabel());
            this.changeFovButton = new JButton("Change FoV (\")");
            this.changeFovButton.addActionListener(e -> {
                try {
                    int panstarrsFOV = NumericFunctions.toInteger(this.panstarrsField.getText());
                    int aladinLiteFOV = NumericFunctions.toInteger(this.aladinLiteField.getText());
                    int wiseViewFOV = NumericFunctions.toInteger(this.wiseViewField.getText());
                    int finderChartFOV = NumericFunctions.toInteger(this.finderChartField.getText());
                    int defaultFOV = NumericFunctions.toInteger(this.sizeField.getText());
                    panstarrsFOV = panstarrsFOV == 0 ? defaultFOV : panstarrsFOV;
                    aladinLiteFOV = aladinLiteFOV == 0 ? defaultFOV : aladinLiteFOV;
                    wiseViewFOV = wiseViewFOV == 0 ? defaultFOV : wiseViewFOV;
                    finderChartFOV = finderChartFOV == 0 ? defaultFOV : finderChartFOV;
                    ToolboxHelper.createHyperlink(this.panstarrsLabel, ExternalResources.getPanstarrsUrl(this.targetRa, this.targetDec, panstarrsFOV, ImageType.STACK));
                    ToolboxHelper.createHyperlink(this.aladinLiteLabel, ExternalResources.getAladinLiteUrl(this.targetRa, this.targetDec, aladinLiteFOV));
                    ToolboxHelper.createHyperlink(this.wiseViewLabel, ExternalResources.getWiseViewUrl(this.targetRa, this.targetDec, wiseViewFOV, this.skipIntermediateEpochs.isSelected() ? 1 : 0, this.separateScanDirections.isSelected() ? 1 : 0, this.differenceImaging.isSelected() ? 1 : 0));
                    ToolboxHelper.createHyperlink(this.finderChartLabel, ExternalResources.getFinderChartUrl(this.targetRa, this.targetDec, finderChartFOV));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid field of view!");
                }
            });
            resourcesPanel.add(this.changeFovButton);
            this.legacyViewerLabel = new JLabel("Legacy Sky Viewer");
            mainControlPanel.add(this.legacyViewerLabel);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.ukidssCutoutsLabel = new JLabel("UKIDSS cutouts");
            resourcesPanel.add(this.ukidssCutoutsLabel);
            this.vhsCutoutsLabel = new JLabel("VHS cutouts");
            resourcesPanel.add(this.vhsCutoutsLabel);
            resourcesPanel = new JPanel(new GridLayout(1, 2));
            mainControlPanel.add(resourcesPanel);
            this.simbadLabel = new JLabel("SIMBAD");
            resourcesPanel.add(this.simbadLabel);
            this.vizierLabel = new JLabel("VizieR");
            resourcesPanel.add(this.vizierLabel);
            JPanel overlaysControlPanel = new JPanel(new GridLayout(rows, 1));
            overlaysControlPanel.setPreferredSize(new Dimension(controlPanelWidth - 20, controlPanelHeight));
            overlaysControlPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JScrollPane overlaysScrollPanel = new JScrollPane(overlaysControlPanel);
            overlaysScrollPanel.setPreferredSize(new Dimension(controlPanelWidth, 50));
            overlaysScrollPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            controlTabs.add("Overlays", overlaysScrollPanel);
            JLabel catalogOverlaysLabel = ToolboxHelper.createHeaderLabel(ToolboxHelper.html("Catalog overlays <span style='color:red'>&#9432;</span>"));
            overlaysControlPanel.add(catalogOverlaysLabel);
            catalogOverlaysLabel.setToolTipText("Shortcuts: Alt+[underscored letter]");
            JPanel overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.simbadOverlay = new JCheckBox(ToolboxHelper.html("<u>S</u>IMBAD"), this.overlays.isSimbad());
            this.simbadOverlay.setForeground(Color.RED);
            this.simbadOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.simbadOverlay);
            this.allWiseOverlay = new JCheckBox(ToolboxHelper.html("<u>A</u>llWISE"), this.overlays.isAllwise());
            this.allWiseOverlay.setForeground(Color.GREEN.darker());
            this.allWiseOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.allWiseOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.catWiseOverlay = new JCheckBox(ToolboxHelper.html("<u>C</u>atWISE2020"), this.overlays.isCatwise());
            this.catWiseOverlay.setForeground(Color.MAGENTA);
            this.catWiseOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.catWiseOverlay);
            this.unWiseOverlay = new JCheckBox(ToolboxHelper.html("<u>u</u>nWISE"), this.overlays.isUnwise());
            this.unWiseOverlay.setForeground(JColor.MINT.val);
            this.unWiseOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.unWiseOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.gaiaOverlay = new JCheckBox("Gaia DR2", this.overlays.isGaiadr2());
            this.gaiaOverlay.setForeground(Color.CYAN.darker());
            this.gaiaOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.gaiaOverlay);
            this.gaiaDR3Overlay = new JCheckBox(ToolboxHelper.html("<u>G</u>aia DR3"), this.overlays.isGaiadr3());
            this.gaiaDR3Overlay.setForeground(Color.CYAN.darker());
            this.gaiaDR3Overlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.gaiaDR3Overlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.noirlabOverlay = new JCheckBox(ToolboxHelper.html("<u>N</u>SC DR2"), this.overlays.isNoirlab());
            this.noirlabOverlay.setForeground(JColor.NAVY.val);
            this.noirlabOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.noirlabOverlay);
            this.panStarrsOverlay = new JCheckBox(ToolboxHelper.html("<u>P</u>an-STARRS"), this.overlays.isPanstar());
            this.panStarrsOverlay.setForeground(JColor.BROWN.val);
            this.panStarrsOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.panStarrsOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.sdssOverlay = new JCheckBox(ToolboxHelper.html("S<u>D</u>SS DR17"), this.overlays.isSdss());
            this.sdssOverlay.setForeground(JColor.STEEL.val);
            this.sdssOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.sdssOverlay);
            this.spectrumOverlay = new JCheckBox("SDSS Spectra", this.overlays.isSpectra());
            this.spectrumOverlay.setForeground(JColor.OLIVE.val);
            this.spectrumOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.spectrumOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.vhsOverlay = new JCheckBox(ToolboxHelper.html("<u>V</u>HS DR5"), this.overlays.isVhs());
            this.vhsOverlay.setForeground(JColor.PINK.val);
            this.vhsOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.vhsOverlay);
            this.uhsOverlay = new JCheckBox(ToolboxHelper.html("U<u>H</u>S DR3"), this.overlays.isUhs());
            this.uhsOverlay.setForeground(JColor.DARK_YELLOW.val);
            this.uhsOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.uhsOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.ukidssOverlay = new JCheckBox(ToolboxHelper.html("U<u>K</u>IDSS DR11"), this.overlays.isUkidss());
            this.ukidssOverlay.setForeground(JColor.BLOOD.val);
            this.ukidssOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.ukidssOverlay);
            this.twoMassOverlay = new JCheckBox(ToolboxHelper.html("2<u>M</u>ASS"), this.overlays.isTwomass());
            this.twoMassOverlay.setForeground(JColor.ORANGE.val);
            this.twoMassOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.twoMassOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.tessOverlay = new JCheckBox(ToolboxHelper.html("<u>T</u>ESS"), this.overlays.isTess());
            this.tessOverlay.setForeground(JColor.LILAC.val);
            this.tessOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.tessOverlay);
            this.desOverlay = new JCheckBox(ToolboxHelper.html("D<u>E</u>S DR2"), this.overlays.isDes());
            this.desOverlay.setForeground(JColor.SAND.val);
            this.desOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.desOverlay);
            overlayPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(overlayPanel);
            this.gaiaWDOverlay = new JCheckBox(ToolboxHelper.html("Gaia EDR3 <u>W</u>D"), this.overlays.isGaiawd());
            this.gaiaWDOverlay.setForeground(JColor.PURPLE.val);
            this.gaiaWDOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.gaiaWDOverlay);
            this.mocaOverlay = new JCheckBox(ToolboxHelper.html("M<u>O</u>CA DB <span style='color:red'>&#9432;</span>"), this.overlays.isMoca());
            this.mocaOverlay.setForeground(JColor.DARK_ORANGE.val);
            this.mocaOverlay.setToolTipText(ToolboxHelper.html("Montreal Open Clusters and Associations (MOCA) database (https://mocadb.ca/home)<br/>Overlays created from the \"Summary of all objects\" table (https://mocadb.ca/schema/summary_all_objects)"));
            this.mocaOverlay.addActionListener(evt -> this.processImages());
            overlayPanel.add(this.mocaOverlay);
            this.ssoOverlay = new JCheckBox("Solar System Objects", this.overlays.isSso());
            this.ssoOverlay.setForeground(Color.BLUE);
            this.ssoOverlay.addActionListener(evt -> this.processImages());
            overlaysControlPanel.add(this.ssoOverlay);
            this.useCustomOverlays = new JCheckBox("Custom overlays:");
            overlaysControlPanel.add(this.useCustomOverlays);
            this.useCustomOverlays.addActionListener(evt -> {
                if (this.customOverlays.isEmpty()) {
                    ToolboxHelper.showInfoDialog(this.baseFrame, "No custom overlays added yet.");
                    this.useCustomOverlays.setSelected(false);
                } else {
                    GridLayout layout = (GridLayout)overlaysControlPanel.getLayout();
                    int numberOfRows = this.customOverlays.size();
                    int rowsHeight = numberOfRows * 25;
                    if (this.useCustomOverlays.isSelected()) {
                        this.componentIndex = overlaysControlPanel.getComponentZOrder(this.useCustomOverlays) + 1;
                        layout.setRows(layout.getRows() + numberOfRows);
                        overlaysControlPanel.setPreferredSize(new Dimension(overlaysControlPanel.getWidth(), overlaysControlPanel.getHeight() + rowsHeight));
                        this.customOverlays.values().forEach(customOverlay -> {
                            JCheckBox checkBox = new JCheckBox(customOverlay.getName());
                            checkBox.setForeground(customOverlay.getColor());
                            checkBox.addActionListener(e -> this.processImages());
                            customOverlay.setCheckBox(checkBox);
                            overlaysControlPanel.add((Component)checkBox, this.componentIndex++);
                        });
                    } else {
                        this.componentIndex = overlaysControlPanel.getComponentZOrder(this.useCustomOverlays) + numberOfRows;
                        layout.setRows(layout.getRows() - numberOfRows);
                        overlaysControlPanel.setPreferredSize(new Dimension(overlaysControlPanel.getWidth(), overlaysControlPanel.getHeight() - rowsHeight));
                        this.customOverlays.values().forEach(customOverlay -> {
                            overlaysControlPanel.remove(this.componentIndex--);
                            customOverlay.setCatalogEntries(null);
                        });
                        this.processImages();
                    }
                    overlaysControlPanel.updateUI();
                    this.baseFrame.setVisible(true);
                }
            });
            JLabel pmOverlaysLabel = ToolboxHelper.createHeaderLabel(ToolboxHelper.html("Proper motion vectors <span style='color:red'>&#9432;</span>"));
            overlaysControlPanel.add(pmOverlaysLabel);
            pmOverlaysLabel.setToolTipText("Shortcuts: Ctrl+Alt+[underscored letter]");
            JPanel properMotionPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(properMotionPanel);
            this.gaiaProperMotion = new JCheckBox("Gaia DR2", this.overlays.isPmgaiadr2());
            this.gaiaProperMotion.setForeground(Color.CYAN.darker());
            this.gaiaProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.gaiaProperMotion);
            this.gaiaDR3ProperMotion = new JCheckBox(ToolboxHelper.html("<u>G</u>aia DR3"), this.overlays.isPmgaiadr3());
            this.gaiaDR3ProperMotion.setForeground(Color.CYAN.darker());
            this.gaiaDR3ProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.gaiaDR3ProperMotion);
            properMotionPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(properMotionPanel);
            this.noirlabProperMotion = new JCheckBox(ToolboxHelper.html("<u>N</u>SC DR2"), this.overlays.isPmnoirlab());
            this.noirlabProperMotion.setForeground(JColor.NAVY.val);
            this.noirlabProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.noirlabProperMotion);
            this.catWiseProperMotion = new JCheckBox(ToolboxHelper.html("<u>C</u>atWISE2020"), this.overlays.isPmcatwise());
            this.catWiseProperMotion.setForeground(Color.MAGENTA);
            this.catWiseProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.catWiseProperMotion);
            properMotionPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(properMotionPanel);
            this.ukidssProperMotion = new JCheckBox(ToolboxHelper.html("U<u>K</u>IDSS LAS"), this.overlays.isPmukidss());
            this.ukidssProperMotion.setForeground(JColor.BLOOD.val);
            this.ukidssProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.ukidssProperMotion);
            this.uhsProperMotion = new JCheckBox(ToolboxHelper.html("U<u>H</u>S DR3"), this.overlays.isPmuhs());
            this.uhsProperMotion.setForeground(JColor.DARK_YELLOW.val);
            this.uhsProperMotion.addActionListener(evt -> this.processImages());
            properMotionPanel.add(this.uhsProperMotion);
            properMotionPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(properMotionPanel);
            properMotionPanel.add(new JLabel("Total PM (mas/yr) >"));
            this.properMotionField = new JTextField(String.valueOf(100));
            properMotionPanel.add(this.properMotionField);
            this.properMotionField.addActionListener(evt -> {
                this.gaiaTpmEntries = null;
                this.gaiaDR3TpmEntries = null;
                this.catWiseTpmEntries = null;
                this.noirlabTpmEntries = null;
                this.processImages();
            });
            this.showProperMotion = new JCheckBox("Show motion as moving dots");
            overlaysControlPanel.add(this.showProperMotion);
            this.showProperMotion.addActionListener(evt -> this.processImages());
            JLabel artifactsLabel = ToolboxHelper.createHeaderLabel(ToolboxHelper.html("WISE artifacts <span style='color:red'>&#9432;</span>"));
            overlaysControlPanel.add(artifactsLabel);
            artifactsLabel.setToolTipText(ToolboxHelper.html("Small shapes represent affected sources.<br/>Large shapes represent the actual artifacts."));
            JPanel artifactPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(artifactPanel);
            this.ghostOverlay = new JCheckBox("Ghosts", this.overlays.isGhosts());
            this.ghostOverlay.setForeground(Color.MAGENTA.darker());
            this.ghostOverlay.addActionListener(evt -> this.processImages());
            artifactPanel.add(this.ghostOverlay);
            this.haloOverlay = new JCheckBox(ToolboxHelper.html("<span style='background:black'>&nbsp;Halos&nbsp;</span>"), this.overlays.isHalos());
            this.haloOverlay.setForeground(Color.YELLOW);
            this.haloOverlay.addActionListener(evt -> this.processImages());
            artifactPanel.add(this.haloOverlay);
            artifactPanel = new JPanel(new GridLayout(1, 2));
            overlaysControlPanel.add(artifactPanel);
            this.latentOverlay = new JCheckBox("Latents", this.overlays.isLatents());
            this.latentOverlay.setForeground(Color.GREEN.darker());
            this.latentOverlay.addActionListener(evt -> this.processImages());
            artifactPanel.add(this.latentOverlay);
            this.spikeOverlay = new JCheckBox(ToolboxHelper.html("<span style='background:black'>&nbsp;Spikes&nbsp;</span>"), this.overlays.isSpikes());
            this.spikeOverlay.setForeground(Color.ORANGE);
            this.spikeOverlay.addActionListener(evt -> this.processImages());
            artifactPanel.add(this.spikeOverlay);
            JLabel saveOverlaysMessage = ToolboxHelper.createMessageLabel();
            Timer messageTimer = new Timer(3000, e -> saveOverlaysMessage.setText(""));
            JButton saveButton = new JButton(ToolboxHelper.html("Save selected overlays <span style='color:red'>&#9432;</span>"));
            overlaysControlPanel.add(saveButton);
            saveButton.setToolTipText("Custom overlays not included!");
            saveButton.addActionListener(evt -> {
                this.overlays.setSimbad(this.simbadOverlay.isSelected());
                this.overlays.setAllwise(this.allWiseOverlay.isSelected());
                this.overlays.setCatwise(this.catWiseOverlay.isSelected());
                this.overlays.setUnwise(this.unWiseOverlay.isSelected());
                this.overlays.setGaiadr2(this.gaiaOverlay.isSelected());
                this.overlays.setGaiadr3(this.gaiaDR3Overlay.isSelected());
                this.overlays.setNoirlab(this.noirlabOverlay.isSelected());
                this.overlays.setPanstar(this.panStarrsOverlay.isSelected());
                this.overlays.setSdss(this.sdssOverlay.isSelected());
                this.overlays.setSpectra(this.spectrumOverlay.isSelected());
                this.overlays.setVhs(this.vhsOverlay.isSelected());
                this.overlays.setUhs(this.uhsOverlay.isSelected());
                this.overlays.setUkidss(this.ukidssOverlay.isSelected());
                this.overlays.setTwomass(this.twoMassOverlay.isSelected());
                this.overlays.setTess(this.tessOverlay.isSelected());
                this.overlays.setDes(this.desOverlay.isSelected());
                this.overlays.setGaiawd(this.gaiaWDOverlay.isSelected());
                this.overlays.setMoca(this.mocaOverlay.isSelected());
                this.overlays.setSso(this.ssoOverlay.isSelected());
                this.overlays.setPmgaiadr2(this.gaiaProperMotion.isSelected());
                this.overlays.setPmgaiadr3(this.gaiaDR3ProperMotion.isSelected());
                this.overlays.setPmnoirlab(this.noirlabProperMotion.isSelected());
                this.overlays.setPmcatwise(this.catWiseProperMotion.isSelected());
                this.overlays.setPmukidss(this.ukidssProperMotion.isSelected());
                this.overlays.setPmukidss(this.uhsProperMotion.isSelected());
                this.overlays.setGhosts(this.ghostOverlay.isSelected());
                this.overlays.setLatents(this.haloOverlay.isSelected());
                this.overlays.setHalos(this.latentOverlay.isSelected());
                this.overlays.setSpikes(this.spikeOverlay.isSelected());
                try (FileOutputStream output = new FileOutputStream(SettingsTab.PROP_PATH);){
                    SettingsTab.USER_SETTINGS.setProperty(OVERLAYS_KEY, this.overlays.serialize());
                    SettingsTab.USER_SETTINGS.store(output, "User settings");
                    saveOverlaysMessage.setText("Overlays saved!");
                    messageTimer.restart();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            overlaysControlPanel.add(saveOverlaysMessage);
            JPanel mouseControlPanel = new JPanel(new GridLayout(rows, 1));
            mouseControlPanel.setPreferredSize(new Dimension(controlPanelWidth - 20, controlPanelHeight));
            mouseControlPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JScrollPane mouseScrollPanel = new JScrollPane(mouseControlPanel);
            mouseScrollPanel.setPreferredSize(new Dimension(controlPanelWidth, 50));
            mouseScrollPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            controlTabs.add("Mouse", mouseScrollPanel);
            mouseControlPanel.add(ToolboxHelper.createHeaderLabel("Mouse left click w/o overlays"));
            this.showCatalogsButton = new JRadioButton("Show catalog entries for object", true);
            mouseControlPanel.add(this.showCatalogsButton);
            JRadioButton recenterImagesButton = new JRadioButton("Recenter images on object", false);
            mouseControlPanel.add(recenterImagesButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.showCatalogsButton);
            buttonGroup.add(recenterImagesButton);
            mouseControlPanel.add(ToolboxHelper.createHeaderLabel("Mouse wheel click"));
            mouseControlPanel.add(new JLabel("Select images to display:"));
            this.dssImageSeries = new JCheckBox("DSS 1Red, 1Blue, 2Red, 2Blue, 2IR", false);
            mouseControlPanel.add(this.dssImageSeries);
            this.dssImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.twoMassImageSeries = new JCheckBox("2MASS J, H & K bands", false);
            mouseControlPanel.add(this.twoMassImageSeries);
            this.twoMassImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.sdssImageSeries = new JCheckBox("SDSS u, g, r, i & z bands", false);
            mouseControlPanel.add(this.sdssImageSeries);
            this.sdssImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.spitzerImageSeries = new JCheckBox("Spitzer CH1, CH2, CH3, CH4, MIPS24", false);
            mouseControlPanel.add(this.spitzerImageSeries);
            this.spitzerImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.allwiseImageSeries = new JCheckBox("AllWISE W1, W2, W3 & W4 bands", true);
            mouseControlPanel.add(this.allwiseImageSeries);
            this.allwiseImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.ukidssImageSeries = new JCheckBox("UKIDSS Y, J, H & K bands", false);
            mouseControlPanel.add(this.ukidssImageSeries);
            this.ukidssImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.uhsImageSeries = new JCheckBox("UHS J & K bands", false);
            mouseControlPanel.add(this.uhsImageSeries);
            this.uhsImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.vhsImageSeries = new JCheckBox("VHS Y, J, H & K bands", false);
            mouseControlPanel.add(this.vhsImageSeries);
            this.vhsImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.panstarrsImageSeries = new JCheckBox("Pan-STARRS g, r, i, z & y bands", false);
            mouseControlPanel.add(this.panstarrsImageSeries);
            this.panstarrsImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.legacyImageSeries = new JCheckBox("DECaLS g, r & z bands", false);
            mouseControlPanel.add(this.legacyImageSeries);
            this.legacyImageSeries.addActionListener(evt -> this.imageSeriesPdf.setSelected(false));
            this.staticTimeSeries = new JCheckBox("Time series - static", false);
            mouseControlPanel.add(this.staticTimeSeries);
            this.staticTimeSeries.addActionListener(evt -> {
                if (this.staticTimeSeries.isSelected() || this.animatedTimeSeries.isSelected()) {
                    this.dssImageSeries.setSelected(false);
                    this.twoMassImageSeries.setSelected(false);
                    this.sdssImageSeries.setSelected(false);
                    this.spitzerImageSeries.setSelected(false);
                    this.allwiseImageSeries.setSelected(false);
                    this.ukidssImageSeries.setSelected(false);
                    this.uhsImageSeries.setSelected(false);
                    this.vhsImageSeries.setSelected(false);
                    this.panstarrsImageSeries.setSelected(false);
                    this.legacyImageSeries.setSelected(false);
                    this.animatedTimeSeries.setSelected(false);
                }
                this.imageSeriesPdf.setSelected(false);
            });
            this.animatedTimeSeries = new JCheckBox("Time series - animated", false);
            mouseControlPanel.add(this.animatedTimeSeries);
            this.animatedTimeSeries.addActionListener(evt -> {
                if (this.animatedTimeSeries.isSelected()) {
                    this.dssImageSeries.setSelected(true);
                    this.twoMassImageSeries.setSelected(true);
                    this.sdssImageSeries.setSelected(true);
                    this.spitzerImageSeries.setSelected(true);
                    this.allwiseImageSeries.setSelected(true);
                    this.ukidssImageSeries.setSelected(true);
                    this.uhsImageSeries.setSelected(true);
                    this.vhsImageSeries.setSelected(true);
                    this.panstarrsImageSeries.setSelected(true);
                    this.legacyImageSeries.setSelected(true);
                    this.staticTimeSeries.setSelected(false);
                } else {
                    this.dssImageSeries.setSelected(false);
                    this.twoMassImageSeries.setSelected(false);
                    this.sdssImageSeries.setSelected(false);
                    this.spitzerImageSeries.setSelected(false);
                    this.allwiseImageSeries.setSelected(false);
                    this.ukidssImageSeries.setSelected(false);
                    this.uhsImageSeries.setSelected(false);
                    this.vhsImageSeries.setSelected(false);
                    this.panstarrsImageSeries.setSelected(false);
                    this.legacyImageSeries.setSelected(false);
                }
                this.imageSeriesPdf.setSelected(false);
            });
            this.imageSeriesPdf = new JCheckBox(ToolboxHelper.html("Image series PDF <span style='color:red'>&#9432;</span>"), false);
            mouseControlPanel.add(this.imageSeriesPdf);
            this.imageSeriesPdf.setToolTipText(ToolboxHelper.html("The creation of the PDF may take a few minutes.<br/>Do not continue working with AstroToolBox until the PDF is ready!"));
            this.imageSeriesPdf.addActionListener(evt -> {
                if (this.imageSeriesPdf.isSelected()) {
                    this.setImageViewer(this);
                    this.dssImageSeries.setSelected(false);
                    this.twoMassImageSeries.setSelected(false);
                    this.sdssImageSeries.setSelected(false);
                    this.spitzerImageSeries.setSelected(false);
                    this.allwiseImageSeries.setSelected(false);
                    this.ukidssImageSeries.setSelected(false);
                    this.uhsImageSeries.setSelected(false);
                    this.vhsImageSeries.setSelected(false);
                    this.panstarrsImageSeries.setSelected(false);
                    this.legacyImageSeries.setSelected(false);
                    this.staticTimeSeries.setSelected(false);
                    this.animatedTimeSeries.setSelected(false);
                }
            });
            this.changeFovLabel = new JLabel(ToolboxHelper.html(CHANGE_FOV_TEXT.formatted(this.fieldOfView)));
            mouseControlPanel.add(this.changeFovLabel);
            this.changeFovLabel.setToolTipText("Spin wheel on flipbook images to change the size of the field of view.");
            mouseControlPanel.add(ToolboxHelper.createHeaderLabel("Mouse right click"));
            mouseControlPanel.add(new JLabel("Show object in a different field of view"));
            JPanel differentSizePanel = new JPanel(new GridLayout(1, 2));
            mouseControlPanel.add(differentSizePanel);
            differentSizePanel.add(new JLabel("Enter FoV (arcsec):"));
            this.differentSizeField = new JTextField(String.valueOf(100));
            differentSizePanel.add(this.differentSizeField);
            mouseControlPanel.add(new JLabel());
            this.drawCrosshairs = ToolboxHelper.createHeaderBox(ToolboxHelper.html("Draw crosshairs: <span style='color:red'>&#9432;</span>"));
            mouseControlPanel.add(this.drawCrosshairs);
            this.drawCrosshairs.setToolTipText(ToolboxHelper.html("Tick the check box!<br/>Push mouse wheel to draw a crosshair on a specific location.<br/>Spin mouse wheel to change the crosshair's size.<br/>Wheel-click the crosshair's center to delete it.<br/>The crosshair's coordinates appear in the text box below."));
            this.drawCrosshairs.addActionListener(evt -> {
                if (!this.drawCrosshairs.isSelected()) {
                    this.crosshairs.clear();
                    this.crosshairCoords.setText("");
                }
            });
            this.crosshairCoords = new JTextArea();
            mouseControlPanel.add(new JScrollPane(this.crosshairCoords));
            this.crosshairCoords.setBackground(new JLabel().getBackground());
            JPanel playerControlPanel = new JPanel(new GridLayout(rows, 1));
            playerControlPanel.setPreferredSize(new Dimension(controlPanelWidth - 20, controlPanelHeight));
            playerControlPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JScrollPane playerScrollPanel = new JScrollPane(playerControlPanel);
            playerScrollPanel.setPreferredSize(new Dimension(controlPanelWidth, 50));
            playerScrollPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            controlTabs.add("Player", playerScrollPanel);
            playerControlPanel.add(ToolboxHelper.createHeaderLabel("Image player controls", 0));
            playerControlPanel.add(new JLabel());
            JPanel playerControls = new JPanel(new GridLayout(1, 2));
            playerControlPanel.add(playerControls);
            JButton playButton = new JButton("Play");
            playerControls.add(playButton);
            playButton.addActionListener(evt -> {
                this.timer.setRepeats(true);
                this.timer.start();
                this.timerStopped = false;
            });
            JButton stopButton = new JButton("Stop");
            playerControls.add(stopButton);
            stopButton.addActionListener(evt -> {
                this.timer.stop();
                this.timerStopped = true;
            });
            playerControls = new JPanel(new GridLayout(1, 2));
            playerControlPanel.add(playerControls);
            JButton backwardButton = new JButton("Backward");
            playerControls.add(backwardButton);
            backwardButton.addActionListener(evt -> {
                this.timer.stop();
                this.imageNumber -= 2;
                this.timer.setRepeats(false);
                this.timer.start();
            });
            JButton forwardButton = new JButton("Forward");
            playerControls.add(forwardButton);
            forwardButton.addActionListener(evt -> {
                this.timer.stop();
                this.timer.setRepeats(false);
                this.timer.start();
            });
            playerControlPanel.add(new JLabel());
            JButton moveUpButton = new JButton("Move up");
            playerControlPanel.add(moveUpButton);
            moveUpButton.addActionListener(evt -> {
                double newDec = this.targetDec + (double)this.size * this.pixelScale * 0.9 / 3600.0;
                if (newDec > 90.0) {
                    newDec = 90.0 - (newDec - 90.0);
                    double newRa = this.targetRa + 180.0;
                    this.targetRa = newRa > 360.0 ? newRa - 360.0 : newRa;
                    ToolboxHelper.showInfoDialog(this.baseFrame, "You're about to cross the North Celestial Pole." + Constants.LINE_SEP + "If you want to move on in the current direction, use the 'Move down' button next!");
                }
                this.coordsField.setText(NumericFunctions.roundTo7DecNZLZ(this.targetRa) + " " + NumericFunctions.roundTo7DecNZLZ(newDec));
                this.createFlipbook();
            });
            JPanel navigationButtons = new JPanel(new GridLayout(1, 2));
            playerControlPanel.add(navigationButtons);
            JButton moveLeftButton = new JButton("Move left");
            navigationButtons.add(moveLeftButton);
            moveLeftButton.addActionListener(evt -> {
                double distance = (double)this.size * this.pixelScale * 0.9 / 3600.0;
                NumberPair coords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(this.targetRa, this.targetDec), new NumberPair(distance, 0.0));
                double newRa = coords.getX();
                newRa = newRa > 360.0 ? newRa - 360.0 : newRa;
                newRa = newRa > 360.0 ? 0.0 : newRa;
                this.coordsField.setText(NumericFunctions.roundTo7DecNZLZ(newRa) + " " + NumericFunctions.roundTo7DecNZLZ(this.targetDec));
                this.createFlipbook();
            });
            JButton moveRightButton = new JButton("Move right");
            navigationButtons.add(moveRightButton);
            moveRightButton.addActionListener(evt -> {
                double distance = (double)this.size * this.pixelScale * 0.9 / 3600.0;
                NumberPair coords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(this.targetRa, this.targetDec), new NumberPair(-distance, 0.0));
                double newRa = coords.getX();
                newRa = newRa < 0.0 ? newRa + 360.0 : newRa;
                newRa = newRa < 0.0 ? 0.0 : newRa;
                this.coordsField.setText(NumericFunctions.roundTo7DecNZLZ(newRa) + " " + NumericFunctions.roundTo7DecNZLZ(this.targetDec));
                this.createFlipbook();
            });
            JButton moveDownButton = new JButton("Move down");
            playerControlPanel.add(moveDownButton);
            moveDownButton.addActionListener(evt -> {
                double newDec = this.targetDec - (double)this.size * this.pixelScale * 0.9 / 3600.0;
                if (newDec < -90.0) {
                    newDec = -90.0 + (Math.abs(newDec) - 90.0);
                    double newRa = this.targetRa + 180.0;
                    this.targetRa = newRa > 360.0 ? newRa - 360.0 : newRa;
                    ToolboxHelper.showInfoDialog(this.baseFrame, "You're about to cross the South Celestial Pole." + Constants.LINE_SEP + "If you want to move on in the current direction, use the 'Move up' button next!");
                }
                this.coordsField.setText(NumericFunctions.roundTo7DecNZLZ(this.targetRa) + " " + NumericFunctions.roundTo7DecNZLZ(newDec));
                this.createFlipbook();
            });
            playerControlPanel.add(new JLabel());
            JButton rotateButton = new JButton("Rotate by 90\u00b0 clockwise: %d\u00b0".formatted(this.quadrantCount * 90));
            playerControlPanel.add(rotateButton);
            rotateButton.addActionListener(evt -> {
                ++this.quadrantCount;
                if (this.quadrantCount > 3) {
                    this.quadrantCount = 0;
                }
                rotateButton.setText("Rotate by 90\u00b0 clockwise: %d\u00b0".formatted(this.quadrantCount * 90));
                this.processImages();
            });
            playerControlPanel.add(new JLabel());
            JPanel saveControls = new JPanel(new GridLayout(1, 2));
            playerControlPanel.add(saveControls);
            JButton saveAsPngButton = new JButton("Save as PNG");
            saveControls.add(saveAsPngButton);
            saveAsPngButton.addActionListener(evt -> {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileTypeFilter(".png", ".png files"));
                    int returnVal = fileChooser.showSaveDialog(playerControlPanel);
                    if (returnVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        file = new File(file.getPath() + ".png");
                        ImageIO.write((RenderedImage)this.wiseImage, "png", file);
                    }
                }
                catch (HeadlessException | IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            JButton saveAsGifButton = new JButton("Save as GIF");
            saveControls.add(saveAsGifButton);
            saveAsGifButton.addActionListener(evt -> {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileTypeFilter(".gif", ".gif files"));
                    int returnVal = fileChooser.showSaveDialog(playerControlPanel);
                    if (returnVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        file = new File(file.getPath() + ".gif");
                        BufferedImage[] imageSet = new BufferedImage[this.flipbook.size()];
                        for (int i = 0; i < this.flipbook.size(); ++i) {
                            FlipbookComponent component = this.flipbook.get(i);
                            imageSet[i] = this.addCrosshairs(this.processImage(component, i));
                        }
                        if (imageSet.length > 0) {
                            GifSequencer sequencer = new GifSequencer();
                            sequencer.generateFromBI(imageSet, file, this.speed / 10, true);
                        }
                    }
                }
                catch (HeadlessException | IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            this.timer = new Timer(this.speed, e -> {
                try {
                    if (this.flipbook.isEmpty()) {
                        this.enableAll();
                        return;
                    }
                    if (this.imageNumber < 0) {
                        this.imageNumber = this.flipbook.size() - 1;
                    }
                    if (this.imageNumber > this.flipbook.size() - 1) {
                        this.imageNumber = 0;
                    }
                    this.staticView.setSelected(false);
                    FlipbookComponent component = this.flipbook.get(this.imageNumber);
                    BufferedImage image = component.getImage();
                    if (image == null) {
                        return;
                    }
                    this.wiseImage = this.addCrosshairs(image);
                    ImageIcon icon = new ImageIcon(this.wiseImage);
                    String regularLabel = component.getTitle();
                    JLabel regularImage = ToolboxHelper.addTextToImage(new JLabel(icon), regularLabel);
                    if (this.borderFirst.isSelected() && component.isFirstEpoch()) {
                        regularImage.setBorder(BorderFactory.createLineBorder(Color.RED, 2));
                    } else {
                        regularImage.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    }
                    this.imagePanel.removeAll();
                    this.imagePanel.add(regularImage);
                    int width = 50;
                    int height = 50;
                    int imageWidth = this.wiseImage.getWidth();
                    int imageHeight = this.wiseImage.getHeight();
                    if (this.pointerX == 0 && this.pointerY == 0) {
                        NumberPair pixelCoords = this.toPixelCoordinates(this.targetRa, this.targetDec);
                        this.pointerX = (int)pixelCoords.getX();
                        this.pointerY = (int)pixelCoords.getY();
                    }
                    int upperLeftX = this.pointerX - width / 2;
                    int upperLeftY = this.pointerY - height / 2;
                    int upperRightX = upperLeftX + width;
                    int lowerLeftY = upperLeftY + height;
                    upperLeftX = upperLeftX < 0 ? 0 : upperLeftX;
                    int n = upperLeftY = upperLeftY < 0 ? 0 : upperLeftY;
                    if (upperRightX > imageWidth) {
                        upperLeftX -= upperRightX - imageWidth;
                    }
                    if (lowerLeftY > imageHeight) {
                        upperLeftY -= lowerLeftY - imageHeight;
                    }
                    this.rightPanel.removeAll();
                    this.rightPanel.repaint();
                    regularLabel = this.desiCutouts.isSelected() ? "DECaLS" : (this.ps1Cutouts.isSelected() ? "PS1" : "WISE");
                    this.addMagnifiedImage(regularLabel, this.wiseImage, upperLeftX, upperLeftY, width, height);
                    ArrayList<Couple> surveyImages = new ArrayList<Couple>();
                    Component desiLabel = null;
                    if (this.processedDesiImage != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("LS", "DR10"), new NirImage(2017, this.processedDesiImage)));
                    }
                    Component ps1Label = null;
                    if (this.processedPs1Image != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("PS1", this.year_ps1_y_i_g), new NirImage(this.year_ps1_y_i_g, this.processedPs1Image)));
                    }
                    Component vhsLabel = null;
                    if (this.processedVhsImage != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("VHS", this.year_vhs_k_h_j), new NirImage(this.year_vhs_k_h_j, this.processedVhsImage)));
                    }
                    Component uhsLabel = null;
                    if (this.processedUhsImage != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UHS", this.year_uhs_k_j), new NirImage(this.year_uhs_k_j, this.processedUhsImage)));
                    }
                    Component ukidssLabel = null;
                    if (this.processedUkidssImage != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UKIDSS", this.year_ukidss_k_h_j), new NirImage(this.year_ukidss_k_h_j, this.processedUkidssImage)));
                    }
                    if (this.processedSdssImage != null) {
                        surveyImages.add(new Couple<String, NirImage>("SDSS 1998-2009", new NirImage(2000, this.processedSdssImage)));
                    }
                    if (this.processedDssImage != null) {
                        surveyImages.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DSS", this.year_dss_2ir_1r_1b), new NirImage(this.year_dss_2ir_1r_1b, this.processedDssImage)));
                    }
                    surveyImages.sort(Comparator.comparing(c -> 3000 - ((NirImage)c.getB()).getYear()));
                    for (Couple couple : surveyImages) {
                        String surveyLabel = (String)couple.getA();
                        BufferedImage surveyImage = ((NirImage)couple.getB()).getImage();
                        if (!this.imageCutOff) {
                            this.addMagnifiedImage(surveyLabel, surveyImage, upperLeftX, upperLeftY, width, height);
                        }
                        JLabel imageLabel = ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(surveyImage)), surveyLabel);
                        if (surveyLabel.contains("LS")) {
                            desiLabel = imageLabel;
                        } else if (surveyLabel.contains("PS1")) {
                            ps1Label = imageLabel;
                        } else if (surveyLabel.contains("VHS")) {
                            vhsLabel = imageLabel;
                        } else if (surveyLabel.contains("UHS")) {
                            uhsLabel = imageLabel;
                        } else if (surveyLabel.contains("UKIDSS")) {
                            ukidssLabel = imageLabel;
                        }
                        imageLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
                        this.imagePanel.add(imageLabel);
                    }
                    this.baseFrame.repaint();
                    ++this.imageNumber;
                    regularImage.addMouseListener(new MouseListener(){

                        @Override
                        public void mousePressed(MouseEvent evt) {
                            NumberPair pointerCoords;
                            int mouseX = evt.getX();
                            int mouseY = evt.getY();
                            if (ImageViewerTab.this.quadrantCount > 0 && ImageViewerTab.this.quadrantCount < 4) {
                                NumberPair pixelCoords = ImageViewerTab.this.undoRotationOfPixelCoords(mouseX, mouseY);
                                mouseX = (int)pixelCoords.getX();
                                mouseY = (int)pixelCoords.getY();
                                pointerCoords = ImageViewerTab.this.toWorldCoordinates((int)pixelCoords.getX(), (int)pixelCoords.getY());
                            } else {
                                pointerCoords = ImageViewerTab.this.toWorldCoordinates(mouseX, mouseY);
                            }
                            double newRa = pointerCoords.getX();
                            double newDec = pointerCoords.getY();
                            if (SwingUtilities.isRightMouseButton(evt)) {
                                CompletableFuture.supplyAsync(() -> ImageViewerTab.this.openNewImageViewer(newRa, newDec));
                            } else if (SwingUtilities.isMiddleMouseButton(evt)) {
                                if (ImageViewerTab.this.drawCrosshairs.isSelected()) {
                                    double crosshairX = (double)mouseX * 1.0 / (double)ImageViewerTab.this.zoom;
                                    double crosshairY = (double)mouseY * 1.0 / (double)ImageViewerTab.this.zoom;
                                    double radius = 0.01;
                                    boolean removed = false;
                                    ListIterator<NumberPair> iter = ImageViewerTab.this.crosshairs.listIterator();
                                    while (iter.hasNext()) {
                                        NumberPair pixelCoords = iter.next();
                                        if (!(pixelCoords.getX() > crosshairX - radius) || !(pixelCoords.getX() < crosshairX + radius) || !(pixelCoords.getY() > crosshairY - radius) || !(pixelCoords.getY() < crosshairY + radius)) continue;
                                        iter.remove();
                                        removed = true;
                                    }
                                    if (!removed) {
                                        ImageViewerTab.this.crosshairs.add(new NumberPair(crosshairX, crosshairY));
                                    }
                                    StringBuilder sb = new StringBuilder();
                                    for (int i = 0; i < ImageViewerTab.this.crosshairs.size(); ++i) {
                                        NumberPair crosshair = ImageViewerTab.this.crosshairs.get(i);
                                        NumberPair c = ImageViewerTab.this.toWorldCoordinates((int)Math.round(crosshair.getX() * (double)ImageViewerTab.this.zoom), (int)Math.round(crosshair.getY() * (double)ImageViewerTab.this.zoom));
                                        sb.append(i + 1).append(". ");
                                        sb.append(NumericFunctions.roundTo7Dec(c.getX()));
                                        sb.append(" ");
                                        sb.append(NumericFunctions.roundTo7Dec(c.getY()));
                                        sb.append("\n");
                                    }
                                    ImageViewerTab.this.crosshairCoords.setText(sb.toString());
                                } else if (ImageViewerTab.this.imageSeriesPdf.isSelected()) {
                                    CompletableFuture.supplyAsync(() -> new ImageSeriesPdf(newRa, newDec, ImageViewerTab.this.fieldOfView, ImageViewerTab.this.getImageViewer()).create(ImageViewerTab.this.baseFrame));
                                } else if (ImageViewerTab.this.animatedTimeSeries.isSelected()) {
                                    if (ImageViewerTab.this.imageCount == 0) {
                                        ImageViewerTab.this.displayAnimatedTimeSeries(newRa, newDec, ImageViewerTab.this.fieldOfView);
                                    }
                                } else {
                                    CompletableFuture.supplyAsync(() -> {
                                        int numberOfPanels = 0;
                                        if (ImageViewerTab.this.dssImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.twoMassImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.sdssImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.spitzerImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.allwiseImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.ukidssImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.uhsImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.vhsImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.panstarrsImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.legacyImageSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        if (ImageViewerTab.this.staticTimeSeries.isSelected()) {
                                            ++numberOfPanels;
                                        }
                                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                                        int totalPanelHeight = numberOfPanels * 220;
                                        int screenHeight = screenSize.height;
                                        int verticalSpacing = totalPanelHeight > screenHeight ? 220 - (totalPanelHeight - screenHeight) / numberOfPanels : 220;
                                        Counter counter = new Counter(verticalSpacing);
                                        if (ImageViewerTab.this.dssImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayDssImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.twoMassImageSeries.isSelected()) {
                                            ImageViewerTab.this.display2MassImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.sdssImageSeries.isSelected()) {
                                            ImageViewerTab.this.displaySdssImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.spitzerImageSeries.isSelected()) {
                                            ImageViewerTab.this.displaySpitzerImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.allwiseImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayAllwiseImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.ukidssImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayUkidssImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.uhsImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayUhsImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.vhsImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayVhsImages(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.panstarrsImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayPs1Images(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.legacyImageSeries.isSelected()) {
                                            ImageViewerTab.this.displayDesiImages(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        if (ImageViewerTab.this.staticTimeSeries.isSelected()) {
                                            ImageViewerTab.this.displayStaticTimeSeries(newRa, newDec, ImageViewerTab.this.fieldOfView, counter);
                                        }
                                        return null;
                                    });
                                }
                            } else if (SwingUtilities.isLeftMouseButton(evt)) {
                                int count = 0;
                                if (ImageViewerTab.this.simbadOverlay.isSelected() && ImageViewerTab.this.simbadEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.simbadEntries, mouseX, mouseY, Color.RED);
                                    ++count;
                                }
                                if (ImageViewerTab.this.allWiseOverlay.isSelected() && ImageViewerTab.this.allWiseEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.allWiseEntries, mouseX, mouseY, Color.GREEN.darker());
                                    ++count;
                                }
                                if (ImageViewerTab.this.catWiseOverlay.isSelected() && ImageViewerTab.this.catWiseEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.catWiseEntries, mouseX, mouseY, Color.MAGENTA);
                                    ++count;
                                }
                                if (ImageViewerTab.this.unWiseOverlay.isSelected() && ImageViewerTab.this.unWiseEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.unWiseEntries, mouseX, mouseY, JColor.MINT.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.gaiaOverlay.isSelected() && ImageViewerTab.this.gaiaEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.gaiaEntries, mouseX, mouseY, Color.CYAN.darker());
                                    ++count;
                                }
                                if (ImageViewerTab.this.gaiaDR3Overlay.isSelected() && ImageViewerTab.this.gaiaDR3Entries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.gaiaDR3Entries, mouseX, mouseY, Color.CYAN.darker());
                                    ++count;
                                }
                                if (ImageViewerTab.this.noirlabOverlay.isSelected() && ImageViewerTab.this.noirlabEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.noirlabEntries, mouseX, mouseY, JColor.NAVY.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.panStarrsOverlay.isSelected() && ImageViewerTab.this.panStarrsEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.panStarrsEntries, mouseX, mouseY, JColor.BROWN.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.sdssOverlay.isSelected() && ImageViewerTab.this.sdssEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.sdssEntries, mouseX, mouseY, JColor.STEEL.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.spectrumOverlay.isSelected() && ImageViewerTab.this.sdssEntries != null) {
                                    ImageViewerTab.this.showSpectrumInfo(ImageViewerTab.this.sdssEntries, mouseX, mouseY);
                                    ++count;
                                }
                                if (ImageViewerTab.this.vhsOverlay.isSelected() && ImageViewerTab.this.vhsEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.vhsEntries, mouseX, mouseY, JColor.PINK.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.uhsOverlay.isSelected() && ImageViewerTab.this.uhsEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.uhsEntries, mouseX, mouseY, JColor.DARK_YELLOW.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.ukidssOverlay.isSelected() && ImageViewerTab.this.ukidssEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.ukidssEntries, mouseX, mouseY, JColor.BLOOD.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.twoMassOverlay.isSelected() && ImageViewerTab.this.twoMassEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.twoMassEntries, mouseX, mouseY, JColor.ORANGE.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.tessOverlay.isSelected() && ImageViewerTab.this.tessEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.tessEntries, mouseX, mouseY, JColor.LILAC.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.desOverlay.isSelected() && ImageViewerTab.this.desEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.desEntries, mouseX, mouseY, JColor.SAND.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.gaiaWDOverlay.isSelected() && ImageViewerTab.this.gaiaWDEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.gaiaWDEntries, mouseX, mouseY, JColor.PURPLE.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.mocaOverlay.isSelected() && ImageViewerTab.this.mocaEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.mocaEntries, mouseX, mouseY, JColor.DARK_ORANGE.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.ssoOverlay.isSelected() && ImageViewerTab.this.ssoEntries != null) {
                                    ImageViewerTab.this.showCatalogInfo(ImageViewerTab.this.ssoEntries, mouseX, mouseY, Color.BLUE);
                                    ++count;
                                }
                                if (ImageViewerTab.this.useCustomOverlays.isSelected()) {
                                    for (CustomOverlay customOverlay : ImageViewerTab.this.customOverlays.values()) {
                                        if (!customOverlay.getCheckBox().isSelected()) continue;
                                        ImageViewerTab.this.showCatalogInfo(customOverlay.getCatalogEntries(), mouseX, mouseY, customOverlay.getColor());
                                        ++count;
                                    }
                                }
                                if (ImageViewerTab.this.gaiaProperMotion.isSelected() && ImageViewerTab.this.gaiaTpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.gaiaTpmEntries, mouseX, mouseY, Color.CYAN.darker());
                                    ++count;
                                }
                                if (ImageViewerTab.this.gaiaDR3ProperMotion.isSelected() && ImageViewerTab.this.gaiaDR3TpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.gaiaDR3TpmEntries, mouseX, mouseY, Color.CYAN.darker());
                                    ++count;
                                }
                                if (ImageViewerTab.this.noirlabProperMotion.isSelected() && ImageViewerTab.this.noirlabTpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.noirlabTpmEntries, mouseX, mouseY, JColor.NAVY.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.catWiseProperMotion.isSelected() && ImageViewerTab.this.catWiseTpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.catWiseTpmEntries, mouseX, mouseY, Color.MAGENTA);
                                    ++count;
                                }
                                if (ImageViewerTab.this.ukidssProperMotion.isSelected() && ImageViewerTab.this.ukidssTpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.ukidssTpmEntries, mouseX, mouseY, JColor.BLOOD.val);
                                    ++count;
                                }
                                if (ImageViewerTab.this.uhsProperMotion.isSelected() && ImageViewerTab.this.uhsTpmEntries != null) {
                                    ImageViewerTab.this.showPMInfo(ImageViewerTab.this.uhsTpmEntries, mouseX, mouseY, JColor.DARK_YELLOW.val);
                                    ++count;
                                }
                                if (count == 0) {
                                    if (ImageViewerTab.this.showCrosshairs.isSelected()) {
                                        ToolboxHelper.copyCoordsToClipboard(newRa, newDec);
                                    } else if (ImageViewerTab.this.showCatalogsButton.isSelected()) {
                                        CompletableFuture.supplyAsync(() -> ImageViewerTab.this.openNewCatalogSearch(newRa, newDec));
                                    } else {
                                        ImageViewerTab.this.coordsField.setText(NumericFunctions.roundTo7DecNZ(newRa) + " " + NumericFunctions.roundTo7DecNZ(newDec));
                                        ImageViewerTab.this.createFlipbook();
                                    }
                                }
                            }
                        }

                        @Override
                        public void mouseReleased(MouseEvent evt) {
                        }

                        @Override
                        public void mouseEntered(MouseEvent evt) {
                            ImageViewerTab.this.pointerX = evt.getX();
                            ImageViewerTab.this.pointerY = evt.getY();
                        }

                        @Override
                        public void mouseExited(MouseEvent evt) {
                        }

                        @Override
                        public void mouseClicked(MouseEvent evt) {
                        }
                    });
                    regularImage.addMouseWheelListener(evt -> {
                        int notches = evt.getWheelRotation();
                        if (this.markTarget.isSelected() || this.drawCrosshairs.isSelected() || this.showCrosshairs.isSelected()) {
                            if (notches < 0) {
                                ++this.shapeSize;
                            } else if (this.shapeSize > 0) {
                                --this.shapeSize;
                            }
                        } else {
                            if (notches < 0) {
                                ++this.fieldOfView;
                            } else if (this.fieldOfView > 0) {
                                --this.fieldOfView;
                            }
                            this.changeFovLabel.setText(ToolboxHelper.html(CHANGE_FOV_TEXT.formatted(this.fieldOfView)));
                        }
                    });
                    if (desiLabel != null) {
                        desiLabel.addMouseListener(new MouseListener(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                try {
                                    Desktop.getDesktop().browse(new URI(ExternalResources.getLegacySkyViewerUrl(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, "ls-dr10")));
                                }
                                catch (IOException | URISyntaxException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent evt) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent evt) {
                            }

                            @Override
                            public void mouseExited(MouseEvent evt) {
                            }

                            @Override
                            public void mouseClicked(MouseEvent evt) {
                            }
                        });
                    }
                    if (ps1Label != null) {
                        ps1Label.addMouseListener(new MouseListener(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                try {
                                    Desktop.getDesktop().browse(new URI(ExternalResources.getPanstarrsUrl(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, ImageViewerTab.this.fieldOfView, ImageType.STACK_AND_WARP)));
                                }
                                catch (IOException | URISyntaxException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent evt) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent evt) {
                            }

                            @Override
                            public void mouseExited(MouseEvent evt) {
                            }

                            @Override
                            public void mouseClicked(MouseEvent evt) {
                            }
                        });
                    }
                    if (vhsLabel != null) {
                        vhsLabel.addMouseListener(new MouseListener(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                try {
                                    String imageSize = NumericFunctions.roundTo2DecNZ((double)ImageViewerTab.this.size * ImageViewerTab.this.pixelScale / 60.0);
                                    Desktop.getDesktop().browse(new URI("http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack".formatted(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, "all", imageSize, imageSize)));
                                }
                                catch (IOException | URISyntaxException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent evt) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent evt) {
                            }

                            @Override
                            public void mouseExited(MouseEvent evt) {
                            }

                            @Override
                            public void mouseClicked(MouseEvent evt) {
                            }
                        });
                    }
                    if (uhsLabel != null) {
                        uhsLabel.addMouseListener(new MouseListener(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                try {
                                    String imageSize = NumericFunctions.roundTo2DecNZ((double)ImageViewerTab.this.size * ImageViewerTab.this.pixelScale / 60.0);
                                    Desktop.getDesktop().browse(new URI("http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack".formatted(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, "all", imageSize, imageSize)));
                                }
                                catch (IOException | URISyntaxException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent evt) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent evt) {
                            }

                            @Override
                            public void mouseExited(MouseEvent evt) {
                            }

                            @Override
                            public void mouseClicked(MouseEvent evt) {
                            }
                        });
                    }
                    if (ukidssLabel != null) {
                        ukidssLabel.addMouseListener(new MouseListener(){

                            @Override
                            public void mousePressed(MouseEvent evt) {
                                try {
                                    String imageSize = NumericFunctions.roundTo2DecNZ((double)ImageViewerTab.this.size * ImageViewerTab.this.pixelScale / 60.0);
                                    Desktop.getDesktop().browse(new URI("http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack".formatted(ImageViewerTab.this.targetRa, ImageViewerTab.this.targetDec, "all", imageSize, imageSize)));
                                }
                                catch (IOException | URISyntaxException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }

                            @Override
                            public void mouseReleased(MouseEvent evt) {
                            }

                            @Override
                            public void mouseEntered(MouseEvent evt) {
                            }

                            @Override
                            public void mouseExited(MouseEvent evt) {
                            }

                            @Override
                            public void mouseClicked(MouseEvent evt) {
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                    this.hasException = true;
                    this.timer.stop();
                }
            });
            this.tabbedPane.addChangeListener(evt -> {
                int index;
                JTabbedPane sourceTabbedPane = (JTabbedPane)evt.getSource();
                if (sourceTabbedPane.getTitleAt(index = sourceTabbedPane.getSelectedIndex()).equals(TAB_NAME) && !this.flipbook.isEmpty()) {
                    if (!this.staticView.isSelected()) {
                        this.createFlipbook();
                        this.timer.restart();
                    }
                } else {
                    this.timer.stop();
                }
            });
            this.baseFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ImageViewerTab.this.timer.stop();
                    if (ImageViewerTab.this.imageViewer != null) {
                        ImageViewerTab.this.imageViewer.getTimer().restart();
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    if (!ImageViewerTab.this.flipbook.isEmpty()) {
                        ImageViewerTab.this.timer.stop();
                    }
                }

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!(ImageViewerTab.this.flipbook.isEmpty() || ImageViewerTab.this.staticView.isSelected() || ImageViewerTab.this.hasException || ImageViewerTab.this.timerStopped)) {
                        ImageViewerTab.this.timer.restart();
                    }
                }
            });
            AbstractAction keyActionForAltS = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.simbadOverlay.setSelected(!ImageViewerTab.this.simbadOverlay.isSelected());
                    ImageViewerTab.this.simbadOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltA = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.allWiseOverlay.setSelected(!ImageViewerTab.this.allWiseOverlay.isSelected());
                    ImageViewerTab.this.allWiseOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltC = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.catWiseOverlay.setSelected(!ImageViewerTab.this.catWiseOverlay.isSelected());
                    ImageViewerTab.this.catWiseOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltU = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.unWiseOverlay.setSelected(!ImageViewerTab.this.unWiseOverlay.isSelected());
                    ImageViewerTab.this.unWiseOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltG = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.gaiaDR3Overlay.setSelected(!ImageViewerTab.this.gaiaDR3Overlay.isSelected());
                    ImageViewerTab.this.gaiaDR3Overlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltN = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.noirlabOverlay.setSelected(!ImageViewerTab.this.noirlabOverlay.isSelected());
                    ImageViewerTab.this.noirlabOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltP = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.panStarrsOverlay.setSelected(!ImageViewerTab.this.panStarrsOverlay.isSelected());
                    ImageViewerTab.this.panStarrsOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltD = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.sdssOverlay.setSelected(!ImageViewerTab.this.sdssOverlay.isSelected());
                    ImageViewerTab.this.sdssOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltV = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.vhsOverlay.setSelected(!ImageViewerTab.this.vhsOverlay.isSelected());
                    ImageViewerTab.this.vhsOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltH = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.uhsOverlay.setSelected(!ImageViewerTab.this.uhsOverlay.isSelected());
                    ImageViewerTab.this.uhsOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltK = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.ukidssOverlay.setSelected(!ImageViewerTab.this.ukidssOverlay.isSelected());
                    ImageViewerTab.this.ukidssOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltM = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.twoMassOverlay.setSelected(!ImageViewerTab.this.twoMassOverlay.isSelected());
                    ImageViewerTab.this.twoMassOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltT = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.tessOverlay.setSelected(!ImageViewerTab.this.tessOverlay.isSelected());
                    ImageViewerTab.this.tessOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltE = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.desOverlay.setSelected(!ImageViewerTab.this.desOverlay.isSelected());
                    ImageViewerTab.this.desOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltW = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.gaiaWDOverlay.setSelected(!ImageViewerTab.this.gaiaWDOverlay.isSelected());
                    ImageViewerTab.this.gaiaWDOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForAltO = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.mocaOverlay.setSelected(!ImageViewerTab.this.mocaOverlay.isSelected());
                    ImageViewerTab.this.mocaOverlay.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForCtrlAltG = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.gaiaDR3ProperMotion.setSelected(!ImageViewerTab.this.gaiaDR3ProperMotion.isSelected());
                    ImageViewerTab.this.gaiaDR3ProperMotion.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForCtrlAltN = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.noirlabProperMotion.setSelected(!ImageViewerTab.this.noirlabProperMotion.isSelected());
                    ImageViewerTab.this.noirlabProperMotion.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForCtrlAltC = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.catWiseProperMotion.setSelected(!ImageViewerTab.this.catWiseProperMotion.isSelected());
                    ImageViewerTab.this.catWiseProperMotion.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForCtrlAltK = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.ukidssProperMotion.setSelected(!ImageViewerTab.this.ukidssProperMotion.isSelected());
                    ImageViewerTab.this.ukidssProperMotion.getActionListeners()[0].actionPerformed(null);
                }
            };
            AbstractAction keyActionForCtrlAltH = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerTab.this.uhsProperMotion.setSelected(!ImageViewerTab.this.uhsProperMotion.isSelected());
                    ImageViewerTab.this.uhsProperMotion.getActionListeners()[0].actionPerformed(null);
                }
            };
            InputMap iMap = mainPanel.getInputMap(2);
            ActionMap aMap = mainPanel.getActionMap();
            iMap.put(KeyStroke.getKeyStroke(83, 8), "keyActionForAltS");
            aMap.put("keyActionForAltS", keyActionForAltS);
            iMap.put(KeyStroke.getKeyStroke(65, 8), "keyActionForAltA");
            aMap.put("keyActionForAltA", keyActionForAltA);
            iMap.put(KeyStroke.getKeyStroke(67, 8), "keyActionForAltC");
            aMap.put("keyActionForAltC", keyActionForAltC);
            iMap.put(KeyStroke.getKeyStroke(85, 8), "keyActionForAltU");
            aMap.put("keyActionForAltU", keyActionForAltU);
            iMap.put(KeyStroke.getKeyStroke(71, 8), "keyActionForAltG");
            aMap.put("keyActionForAltG", keyActionForAltG);
            iMap.put(KeyStroke.getKeyStroke(78, 8), "keyActionForAltN");
            aMap.put("keyActionForAltN", keyActionForAltN);
            iMap.put(KeyStroke.getKeyStroke(80, 8), "keyActionForAltP");
            aMap.put("keyActionForAltP", keyActionForAltP);
            iMap.put(KeyStroke.getKeyStroke(68, 8), "keyActionForAltD");
            aMap.put("keyActionForAltD", keyActionForAltD);
            iMap.put(KeyStroke.getKeyStroke(86, 8), "keyActionForAltV");
            aMap.put("keyActionForAltV", keyActionForAltV);
            iMap.put(KeyStroke.getKeyStroke(72, 8), "keyActionForAltH");
            aMap.put("keyActionForAltH", keyActionForAltH);
            iMap.put(KeyStroke.getKeyStroke(75, 8), "keyActionForAltK");
            aMap.put("keyActionForAltK", keyActionForAltK);
            iMap.put(KeyStroke.getKeyStroke(77, 8), "keyActionForAltM");
            aMap.put("keyActionForAltM", keyActionForAltM);
            iMap.put(KeyStroke.getKeyStroke(84, 8), "keyActionForAltT");
            aMap.put("keyActionForAltT", keyActionForAltT);
            iMap.put(KeyStroke.getKeyStroke(69, 8), "keyActionForAltE");
            aMap.put("keyActionForAltE", keyActionForAltE);
            iMap.put(KeyStroke.getKeyStroke(87, 8), "keyActionForAltW");
            aMap.put("keyActionForAltW", keyActionForAltW);
            iMap.put(KeyStroke.getKeyStroke(79, 8), "keyActionForAltO");
            aMap.put("keyActionForAltO", keyActionForAltO);
            iMap.put(KeyStroke.getKeyStroke(71, 10), "keyActionForCtrlAltG");
            aMap.put("keyActionForCtrlAltG", keyActionForCtrlAltG);
            iMap.put(KeyStroke.getKeyStroke(78, 10), "keyActionForCtrlAltN");
            aMap.put("keyActionForCtrlAltN", keyActionForCtrlAltN);
            iMap.put(KeyStroke.getKeyStroke(67, 10), "keyActionForCtrlAltC");
            aMap.put("keyActionForCtrlAltC", keyActionForCtrlAltC);
            iMap.put(KeyStroke.getKeyStroke(75, 10), "keyActionForCtrlAltK");
            aMap.put("keyActionForCtrlAltK", keyActionForCtrlAltK);
            iMap.put(KeyStroke.getKeyStroke(72, 10), "keyActionForCtrlAltH");
            aMap.put("keyActionForCtrlAltH", keyActionForCtrlAltH);
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, mainPanel);
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
            this.hasException = true;
        }
    }

    private void addMagnifiedImage(String imageLabel, BufferedImage image, int upperLeftX, int upperLeftY, int width, int height) {
        try {
            BufferedImage magnifiedImage = image.getSubimage(upperLeftX, upperLeftY, width, height);
            magnifiedImage = ToolboxHelper.zoomImage(magnifiedImage, 200);
            JLabel magnifiedLabel = ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(magnifiedImage)), imageLabel);
            magnifiedLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
            this.rightPanel.add(magnifiedLabel);
        }
        catch (RasterFormatException ex) {
            ToolboxHelper.writeErrorLog(ex);
        }
    }

    private void resetContrastSlider() {
        this.brightness = 1;
        ChangeListener changeListener = this.brightnessSlider.getChangeListeners()[0];
        this.brightnessSlider.removeChangeListener(changeListener);
        this.brightnessSlider.setValue(this.brightness);
        this.brightnessSlider.addChangeListener(changeListener);
        this.contrast = 50;
        changeListener = this.contrastSlider.getChangeListeners()[0];
        this.contrastSlider.removeChangeListener(changeListener);
        this.contrastSlider.setValue(this.contrast);
        this.contrastSlider.addChangeListener(changeListener);
    }

    private NumberPair undoRotationOfPixelCoords(int mouseX, int mouseY) {
        double anchorX = this.wiseImage.getWidth() / 2;
        double anchorY = this.wiseImage.getHeight() / 2;
        double angle = (4 - this.quadrantCount) * 90;
        double theta = Math.toRadians(angle);
        Point ptSrc = new Point(mouseX, mouseY);
        Point ptDst = new Point();
        AffineTransform.getRotateInstance(theta, anchorX, anchorY).transform(ptSrc, ptDst);
        mouseX = (int)Math.round(((Point2D)ptDst).getX());
        mouseY = (int)Math.round(((Point2D)ptDst).getY());
        return new NumberPair(mouseX, mouseY);
    }

    private NumberPair toWorldCoordinates(double x, double y) {
        x = this.getUnzoomedValue(x);
        y = this.getUnzoomedValue(y);
        x += 0.5;
        y -= 0.5;
        y = (double)this.naxis2 - y;
        x -= this.crpix1;
        y -= this.crpix2;
        double scale = 3600.0 / this.pixelScale;
        x = Math.toRadians(x) / -scale;
        y = Math.toRadians(y) / scale;
        double ra0 = Math.toRadians(this.crval1);
        double dec0 = Math.toRadians(this.crval2);
        double p = Math.sqrt(x * x + y * y);
        double c = Math.atan(p);
        double ra = ra0 + Math.atan2(x * Math.sin(c), p * Math.cos(dec0) * Math.cos(c) - y * Math.sin(dec0) * Math.sin(c));
        double dec = Math.asin(Math.cos(c) * Math.sin(dec0) + y * Math.sin(c) * Math.cos(dec0) / p);
        ra = Math.toDegrees(ra);
        dec = Math.toDegrees(dec);
        if (ra < 0.0) {
            ra += 360.0;
        }
        return new NumberPair(ra, dec);
    }

    private NumberPair toPixelCoordinates(double ra, double dec) {
        ra = Math.toRadians(ra);
        dec = Math.toRadians(dec);
        double ra0 = Math.toRadians(this.crval1);
        double dec0 = Math.toRadians(this.crval2);
        double cosc = Math.sin(dec0) * Math.sin(dec) + Math.cos(dec0) * Math.cos(dec) * Math.cos(ra - ra0);
        double x = Math.cos(dec) * Math.sin(ra - ra0) / cosc;
        double y = (Math.cos(dec0) * Math.sin(dec) - Math.sin(dec0) * Math.cos(dec) * Math.cos(ra - ra0)) / cosc;
        double scale = 3600.0 / this.pixelScale;
        x = Math.toDegrees(x) * -scale;
        y = Math.toDegrees(y) * scale;
        x += this.crpix1;
        y += this.crpix2;
        y = (double)this.naxis2 - y;
        x -= 0.5;
        y += 0.5;
        x = this.getZoomedValue(x);
        y = this.getZoomedValue(y);
        return new NumberPair(x, y);
    }

    private double getUnzoomedValue(double value) {
        return value * (double)this.size / (double)this.zoom;
    }

    private double getZoomedValue(double value) {
        return value * (double)this.zoom / (double)this.size;
    }

    public void createFlipbook() {
        if (this.asyncDownloads) {
            CompletableFuture.supplyAsync(() -> this.assembleFlipbook());
        } else {
            this.assembleFlipbook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assembleFlipbook() {
        try {
            this.timer.stop();
            this.timerStopped = true;
            this.stopDownloadProcess = false;
            String coords = this.coordsField.getText();
            if (coords.isEmpty()) {
                ToolboxHelper.showErrorDialog(this.baseFrame, "Coordinates must not be empty!");
                boolean bl = false;
                return bl;
            }
            String imageSize = this.sizeField.getText();
            if (imageSize.isEmpty()) {
                ToolboxHelper.showErrorDialog(this.baseFrame, "Field of view must not be empty!");
                boolean bl = false;
                return bl;
            }
            ArrayList<String> errorMessages = new ArrayList<String>();
            try {
                NumberPair coordinates = ToolboxHelper.getCoordinates(coords);
                this.targetRa = coordinates.getX();
                this.targetDec = coordinates.getY();
                if (this.targetRa < 0.0) {
                    errorMessages.add("RA must not be smaller than 0 deg.");
                }
                if (this.targetRa > 360.0) {
                    errorMessages.add("RA must not be greater than 360 deg.");
                }
                if (this.targetDec < -90.0) {
                    errorMessages.add("Dec must not be smaller than -90 deg.");
                }
                if (this.targetDec > 90.0) {
                    errorMessages.add("Dec must not be greater than 90 deg.");
                }
            }
            catch (Exception ex) {
                this.targetRa = 0.0;
                this.targetDec = 0.0;
                errorMessages.add("Invalid coordinates!");
            }
            try {
                this.size = (int)Math.ceil((double)NumericFunctions.toInteger(this.sizeField.getText()) / this.pixelScale);
                if (this.desiCutouts.isSelected() || this.ps1Cutouts.isSelected()) {
                    if (this.size > 1200) {
                        errorMessages.add("Field of view must not be larger than 300 arcsec.");
                    }
                } else if (this.size > 1091) {
                    errorMessages.add("Field of view must not be larger than 3000 arcsec.");
                }
            }
            catch (Exception ex) {
                this.size = 0;
                errorMessages.add("Invalid field of view!");
            }
            if (!errorMessages.isEmpty()) {
                String errorMessage = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                ToolboxHelper.showErrorDialog(this.baseFrame, errorMessage);
                boolean bl = false;
                return bl;
            }
            this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.coordsField.setCursor(Cursor.getPredefinedCursor(3));
            this.sizeField.setCursor(Cursor.getPredefinedCursor(3));
            if (!ToolboxHelper.isSameTarget(this.targetRa, this.targetDec, this.size, this.previousRa, this.previousDec, this.previousSize)) {
                this.skipIntermediateEpochs.setEnabled(false);
                this.separateScanDirections.setEnabled(false);
                this.differenceImaging.setEnabled(false);
                this.wiseviewCutouts.setEnabled(false);
                this.unwiseCutouts.setEnabled(false);
                this.desiCutouts.setEnabled(false);
                this.ps1Cutouts.setEnabled(false);
                int panstarrsFOV = NumericFunctions.toInteger(this.panstarrsField.getText());
                int aladinLiteFOV = NumericFunctions.toInteger(this.aladinLiteField.getText());
                int wiseViewFOV = NumericFunctions.toInteger(this.wiseViewField.getText());
                int finderChartFOV = NumericFunctions.toInteger(this.finderChartField.getText());
                int defaultFOV = NumericFunctions.toInteger(this.sizeField.getText());
                panstarrsFOV = panstarrsFOV == 0 ? defaultFOV : panstarrsFOV;
                aladinLiteFOV = aladinLiteFOV == 0 ? defaultFOV : aladinLiteFOV;
                wiseViewFOV = wiseViewFOV == 0 ? defaultFOV : wiseViewFOV;
                finderChartFOV = finderChartFOV == 0 ? defaultFOV : finderChartFOV;
                ToolboxHelper.createHyperlink(this.panstarrsLabel, ExternalResources.getPanstarrsUrl(this.targetRa, this.targetDec, panstarrsFOV, ImageType.STACK));
                ToolboxHelper.createHyperlink(this.aladinLiteLabel, ExternalResources.getAladinLiteUrl(this.targetRa, this.targetDec, aladinLiteFOV));
                ToolboxHelper.createHyperlink(this.wiseViewLabel, ExternalResources.getWiseViewUrl(this.targetRa, this.targetDec, wiseViewFOV, this.skipIntermediateEpochs.isSelected() ? 1 : 0, this.separateScanDirections.isSelected() ? 1 : 0, this.differenceImaging.isSelected() ? 1 : 0));
                ToolboxHelper.createHyperlink(this.finderChartLabel, ExternalResources.getFinderChartUrl(this.targetRa, this.targetDec, finderChartFOV));
                ToolboxHelper.createHyperlink(this.legacyViewerLabel, ExternalResources.getLegacySkyViewerUrl(this.targetRa, this.targetDec, "unwise-neo6"));
                String fovSize = NumericFunctions.roundTo2DecNZ((float)defaultFOV / 60.0f);
                ToolboxHelper.createHyperlink(this.ukidssCutoutsLabel, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack".formatted(this.targetRa, this.targetDec, "all", fovSize, fovSize));
                ToolboxHelper.createHyperlink(this.vhsCutoutsLabel, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack".formatted(this.targetRa, this.targetDec, "all", fovSize, fovSize));
                ToolboxHelper.createHyperlink(this.simbadLabel, ExternalResources.getSimbadUrl(this.targetRa, this.targetDec, 30.0));
                ToolboxHelper.createHyperlink(this.vizierLabel, ExternalResources.getVizierUrl(this.targetRa, this.targetDec, 30.0, 50, false));
                this.loadImages = true;
                this.flipbookComplete = false;
                this.hasException = false;
                this.imageCutOff = false;
                this.imagesW1.clear();
                this.imagesW2.clear();
                this.imagesW1All.clear();
                this.imagesW2All.clear();
                this.imagesW1Ends.clear();
                this.imagesW2Ends.clear();
                this.crosshairs.clear();
                this.crosshairCoords.setText("");
                this.naxis1 = this.naxis2 = this.size;
                this.pointerY = 0;
                this.pointerX = 0;
                this.windowShift = 0;
                this.year_ps1_y_i_g = 0;
                this.year_vhs_k_h_j = 0;
                this.year_uhs_k_j = 0;
                this.year_ukidss_k_h_j = 0;
                this.year_dss_2ir_1r_1b = 0;
                this.initCatalogEntries();
                if (this.resetContrast.isSelected()) {
                    this.resetContrastSlider();
                }
                this.desiImage = null;
                this.processedDesiImage = null;
                if (this.legacyImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.desiImage = this.fetchDesiImage(this.targetRa, this.targetDec, this.size);
                        this.processedDesiImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.desiImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.ps1Image = null;
                this.processedPs1Image = null;
                if (this.panstarrsImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.ps1Image = this.fetchPs1Image(this.targetRa, this.targetDec, this.size);
                        this.processedPs1Image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ps1Image, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.vhsImage = null;
                this.processedVhsImage = null;
                if (this.vhsImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.vhsImage = this.fetchVhsImage(this.targetRa, this.targetDec, this.size);
                        this.processedVhsImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.vhsImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.uhsImage = null;
                this.processedUhsImage = null;
                if (this.uhsImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.uhsImage = this.fetchUhsImage(this.targetRa, this.targetDec, this.size);
                        this.processedUhsImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.uhsImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.ukidssImage = null;
                this.processedUkidssImage = null;
                if (this.ukidssImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.ukidssImage = this.fetchUkidssImage(this.targetRa, this.targetDec, this.size);
                        this.processedUkidssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ukidssImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.sdssImage = null;
                this.processedSdssImage = null;
                if (this.sdssImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.sdssImage = this.fetchSdssImage(this.targetRa, this.targetDec, this.size);
                        this.processedSdssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.sdssImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                this.dssImage = null;
                this.processedDssImage = null;
                if (this.dssImages) {
                    CompletableFuture.supplyAsync(() -> {
                        this.dssImage = this.fetchDssImage(this.targetRa, this.targetDec, this.size);
                        this.processedDssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.dssImage, this.quadrantCount), this.zoom);
                        return null;
                    });
                }
                if (this.nearestBywSubjects) {
                    this.bywTopRow.removeAll();
                    this.bywBottomRow.removeAll();
                    List<JLabel> subjects = ToolboxHelper.getNearestZooniverseSubjects(this.targetRa, this.targetDec);
                    int numberOfSubjects = subjects.size();
                    if (numberOfSubjects == 0) {
                        this.bywTopRow.add(new JLabel("None"));
                    } else {
                        int i;
                        for (i = 0; i < 4 && i < numberOfSubjects; ++i) {
                            this.bywTopRow.add(subjects.get(i));
                        }
                        for (i = 4; i < 8 && i < numberOfSubjects; ++i) {
                            this.bywBottomRow.add(subjects.get(i));
                        }
                    }
                }
                this.tile = ToolboxHelper.getWiseTiles(this.targetRa, this.targetDec).getFirst();
            }
            this.previousSize = this.size;
            this.previousRa = this.targetRa;
            this.previousDec = this.targetDec;
            this.imageNumber = 0;
            if (this.loadImages) {
                List<Object> epochsW2;
                List<Object> epochsW1;
                this.epochCount = 0;
                this.band1Images.clear();
                this.band2Images.clear();
                this.imagePanel.removeAll();
                this.rightPanel.removeAll();
                if (this.asyncDownloads) {
                    this.downloadLog = new JTextArea();
                    this.downloadLog.setFont(new JLabel().getFont());
                    this.downloadLog.setEditable(false);
                    DefaultCaret caret = (DefaultCaret)this.downloadLog.getCaret();
                    caret.setUpdatePolicy(2);
                    this.imagePanel.add(this.downloadLog);
                    this.baseFrame.repaint();
                }
                this.writeLogEntry("Target: " + this.coordsField.getText() + " FoV: " + this.sizeField.getText() + "\"");
                if (this.unwiseCutouts.isSelected()) {
                    epochsW1 = new ArrayList<Epoch>();
                    epochsW2 = new ArrayList();
                    double mjd = AstrometricFunctions.convertDateTimeToMJD(LocalDate.of(2010, 6, 1).atStartOfDay()).doubleValue();
                    epochsW1.add(new Epoch(1, 0, 0, mjd));
                    epochsW1.add(new Epoch(1, 1, 1, mjd));
                    epochsW2.add(new Epoch(2, 0, 0, mjd));
                    epochsW2.add(new Epoch(2, 1, 1, mjd));
                    int year = 2013;
                    for (int i = 2; i <= 15; ++i) {
                        int forward = i % 2 == 0 ? 0 : 1;
                        mjd = AstrometricFunctions.convertDateTimeToMJD(LocalDate.of(year + i / 2, 6, 1).atStartOfDay()).doubleValue();
                        epochsW1.add(new Epoch(1, i, forward, mjd));
                        epochsW2.add(new Epoch(2, i, forward, mjd));
                    }
                } else {
                    this.tile.getEpochs().stream().forEach(e -> e.setObsDate(AstrometricFunctions.convertMJDToDateTime(BigDecimal.valueOf(e.getMjdmean()))));
                    this.tile.getEpochs().removeIf(e -> e.getObsDate() != null && (e.getObsDate().getYear() == 2013 || e.getObsDate().getYear() == 2024));
                    epochsW1 = this.tile.getEpochs().stream().filter(e -> e.getBand() == 1).collect(Collectors.toList());
                    epochsW2 = this.tile.getEpochs().stream().filter(e -> e.getBand() == 2).collect(Collectors.toList());
                }
                epochsW1.sort(Comparator.comparingInt(Epoch::getEpoch).thenComparingInt(Epoch::getForward));
                epochsW2.sort(Comparator.comparingInt(Epoch::getEpoch).thenComparingInt(Epoch::getForward));
                if (this.skipIntermediateEpochs.isSelected()) {
                    epochsW1 = ImageViewerTab.selectBoundaryEpochs(epochsW1);
                    epochsW2 = ImageViewerTab.selectBoundaryEpochs(epochsW2);
                    epochsW1.sort(Comparator.comparingInt(Epoch::getEpoch).thenComparingInt(Epoch::getForward));
                    epochsW2.sort(Comparator.comparingInt(Epoch::getEpoch).thenComparingInt(Epoch::getForward));
                }
                switch (this.wiseBand) {
                    case W1: {
                        this.downloadRequestedEpochs(null, WiseBand.W1.val, epochsW1, this.imagesW1);
                        break;
                    }
                    case W2: {
                        this.downloadRequestedEpochs(null, WiseBand.W2.val, epochsW2, this.imagesW2);
                        break;
                    }
                    case W1W2: {
                        this.downloadRequestedEpochs(null, WiseBand.W1.val, epochsW1, this.imagesW1);
                        if (this.stopDownloadProcess) break;
                        this.downloadRequestedEpochs(null, WiseBand.W2.val, epochsW2, this.imagesW2);
                    }
                }
                if (this.stopDownloadProcess) {
                    this.writeLogEntry("Download process stopped.");
                    boolean mjd = false;
                    return mjd;
                }
                this.writeLogEntry("Finished.");
                if (this.asyncDownloads) {
                    this.downloadLog.setCaretPosition(0);
                }
                if (this.epochCount < 2) {
                    ToolboxHelper.showInfoDialog(this.baseFrame, "No images found for the given coordinates.");
                    this.hasException = true;
                    boolean mjd = false;
                    return mjd;
                }
            }
            this.loadImages = false;
            List<Fits> band1Scan1Images = new ArrayList<Fits>();
            List<Fits> band1Scan2Images = new ArrayList<Fits>();
            for (Fits fits : this.band1Images) {
                ImageHDU hdu = (ImageHDU)fits.getHDU(0);
                long forward = hdu.getHeader().getLongValue("FORWARD");
                if (forward == 0L) {
                    band1Scan1Images.add(fits);
                    continue;
                }
                band1Scan2Images.add(fits);
            }
            List<Fits> band2Scan1Images = new ArrayList<Fits>();
            List<Fits> band2Scan2Images = new ArrayList<Fits>();
            for (Fits fits : this.band2Images) {
                ImageHDU hdu = (ImageHDU)fits.getHDU(0);
                long forward = hdu.getHeader().getLongValue("FORWARD");
                if (forward == 0L) {
                    band2Scan1Images.add(fits);
                    continue;
                }
                band2Scan2Images.add(fits);
            }
            boolean sep = this.separateScanDirections.isSelected();
            boolean diff = this.differenceImaging.isSelected();
            boolean desi = this.desiCutouts.isSelected();
            boolean ps1 = this.ps1Cutouts.isSelected();
            if (this.wiseviewCutouts.isSelected() || this.unwiseCutouts.isSelected() || this.ps1Cutouts.isSelected()) {
                band1Scan1Images = this.stackImages(band1Scan1Images, this.stackSize);
                band1Scan2Images = this.stackImages(band1Scan2Images, this.stackSize);
                band2Scan1Images = this.stackImages(band2Scan1Images, this.stackSize);
                band2Scan2Images = this.stackImages(band2Scan2Images, this.stackSize);
            }
            ArrayList<Fits> band1GroupedImages = new ArrayList<Fits>();
            ArrayList<Fits> band2GroupedImages = new ArrayList<Fits>();
            if (sep) {
                if (diff) {
                    for (i = 0; i < band1Scan1Images.size() - 1; ++i) {
                        band1GroupedImages.add(this.subtractImages(band1Scan1Images.get(0), band1Scan1Images.get(i + 1)));
                    }
                    for (i = 0; i < band1Scan2Images.size() - 1; ++i) {
                        band1GroupedImages.add(this.subtractImages(band1Scan2Images.get(i + 1), band1Scan2Images.get(0)));
                    }
                    for (i = 0; i < band2Scan1Images.size() - 1; ++i) {
                        band2GroupedImages.add(this.subtractImages(band2Scan1Images.get(0), band2Scan1Images.get(i + 1)));
                    }
                    for (i = 0; i < band2Scan2Images.size() - 1; ++i) {
                        band2GroupedImages.add(this.subtractImages(band2Scan2Images.get(i + 1), band2Scan2Images.get(0)));
                    }
                } else {
                    for (i = 0; i < band1Scan1Images.size(); ++i) {
                        band1GroupedImages.add(band1Scan1Images.get(i));
                    }
                    for (i = 0; i < band1Scan2Images.size(); ++i) {
                        band1GroupedImages.add(band1Scan2Images.get(i));
                    }
                    for (i = 0; i < band2Scan1Images.size(); ++i) {
                        band2GroupedImages.add(band2Scan1Images.get(i));
                    }
                    for (i = 0; i < band2Scan2Images.size(); ++i) {
                        band2GroupedImages.add(band2Scan2Images.get(i));
                    }
                }
            } else {
                for (i = 0; i < band1Scan1Images.size() && i < band1Scan2Images.size(); ++i) {
                    band1GroupedImages.add(this.addImages(band1Scan1Images.get(i), band1Scan2Images.get(i)));
                }
                for (i = 0; i < band2Scan1Images.size() && i < band2Scan2Images.size(); ++i) {
                    band2GroupedImages.add(this.addImages(band2Scan1Images.get(i), band2Scan2Images.get(i)));
                }
            }
            this.flipbook.clear();
            switch (this.wiseBand) {
                case W1: {
                    int i;
                    String band = desi ? "DECaLS r" : (ps1 ? "PS1 r" : "W1");
                    for (i = 0; i < band1GroupedImages.size(); ++i) {
                        Fits fits = (Fits)band1GroupedImages.get(i);
                        this.flipbook.add(new FlipbookComponent(fits, null, band, desi ? this.getDataRelease(fits) : this.getMeanObsDate(fits), this.isFirstEpoch(fits)));
                    }
                    break;
                }
                case W2: {
                    int i;
                    String band = desi ? "DECaLS z" : (ps1 ? "PS1 y" : "W2");
                    for (i = 0; i < band2GroupedImages.size(); ++i) {
                        Fits fits = (Fits)band2GroupedImages.get(i);
                        this.flipbook.add(new FlipbookComponent(null, fits, band, desi ? this.getDataRelease(fits) : this.getMeanObsDate(fits), this.isFirstEpoch(fits)));
                    }
                    break;
                }
                case W1W2: {
                    String band = desi ? "DECaLS r+z" : (ps1 ? "PS1 r+y" : "W1+W2");
                    int size1 = band1GroupedImages.size();
                    int size2 = band2GroupedImages.size();
                    for (int i = 0; i < Math.min(size1, size2); ++i) {
                        Fits fits1 = (Fits)band1GroupedImages.get(i);
                        Fits fits2 = (Fits)band2GroupedImages.get(i);
                        this.flipbook.add(new FlipbookComponent(fits1, fits2, band, desi ? this.getDataRelease(fits1) : this.getMeanObsDate(fits1), this.isFirstEpoch(fits1)));
                    }
                    break;
                }
            }
            int count = this.flipbook.size();
            if (count > 0) {
                NumberPair refVal = this.getRefValues(this.flipbook.get(0));
                this.minValue = (int)refVal.getX();
                this.maxValue = (int)refVal.getY();
            }
            this.flipbookComplete = true;
            this.processImages();
            this.timer.restart();
            this.timerStopped = false;
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
            this.hasException = true;
        }
        finally {
            this.enableAll();
        }
        return true;
    }

    private static List<Epoch> selectBoundaryEpochs(List<Epoch> epochs) {
        ArrayList<Epoch> result = new ArrayList<Epoch>();
        Epoch first0 = null;
        Epoch first1 = null;
        Epoch last0 = null;
        Epoch last1 = null;
        for (Epoch e : epochs) {
            if (e.getForward() == 0) {
                if (first0 == null) {
                    first0 = e;
                }
                last0 = e;
                continue;
            }
            if (e.getForward() != 1) continue;
            if (first1 == null) {
                first1 = e;
            }
            last1 = e;
        }
        if (first0 != null) {
            result.add(first0);
        }
        if (first1 != null) {
            result.add(first1);
        }
        if (last0 != null) {
            result.add(last0);
        }
        if (last1 != null) {
            result.add(last1);
        }
        return result;
    }

    private boolean isFirstEpoch(Fits fits) throws Exception {
        ImageHDU hdu = (ImageHDU)fits.getHDU(0);
        long firstEpoch = hdu.getHeader().getLongValue("FEPOCH");
        return firstEpoch == 1L;
    }

    private List<Fits> stackImages(List<Fits> images, int stackSize) {
        if (stackSize < 2) {
            return images;
        }
        try {
            ArrayList<Fits> list = new ArrayList<Fits>();
            Fits fits = images.get(0);
            int j = 1;
            for (int i = 1; i < images.size(); ++i) {
                if (j < stackSize) {
                    fits = this.addImages(fits, images.get(i));
                    ++j;
                    continue;
                }
                list.add(this.average(fits, j));
                fits = images.get(i);
                j = 1;
            }
            if (j > 1) {
                list.add(this.average(fits, j));
            }
            if (list.isEmpty()) {
                return this.stackImages(images, --stackSize);
            }
            return list;
        }
        catch (Exception ex) {
            return images;
        }
    }

    private void enableAll() {
        this.skipIntermediateEpochs.setEnabled(true);
        if (!this.differenceImaging.isSelected()) {
            this.separateScanDirections.setEnabled(true);
        }
        this.differenceImaging.setEnabled(true);
        this.wiseviewCutouts.setEnabled(true);
        this.unwiseCutouts.setEnabled(true);
        this.desiCutouts.setEnabled(true);
        this.ps1Cutouts.setEnabled(true);
        if (this.waitCursor) {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
            this.coordsField.setCursor(Cursor.getDefaultCursor());
            this.sizeField.setCursor(Cursor.getDefaultCursor());
        }
    }

    private NumberPair getRefValues(FlipbookComponent component) throws Exception {
        Fits fits = component.getFits2();
        if (fits != null) {
            ImageHDU hdu = (ImageHDU)fits.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            float[][] values = (float[][])imageData.getData();
            NumberPair refValues = this.determineRefValues(values);
            double minVal = refValues.getX();
            double maxVal = refValues.getY();
            return new NumberPair(minVal, maxVal);
        }
        fits = component.getFits1();
        if (fits != null) {
            ImageHDU hdu = (ImageHDU)fits.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            float[][] values = (float[][])imageData.getData();
            NumberPair refValues = this.determineRefValues(values);
            double minVal = refValues.getX();
            double maxVal = refValues.getY();
            return new NumberPair(minVal, maxVal);
        }
        return null;
    }

    private void processImages() {
        if (this.desiImage != null) {
            this.processedDesiImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.desiImage, this.quadrantCount), this.zoom);
        }
        if (this.ps1Image != null) {
            this.processedPs1Image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ps1Image, this.quadrantCount), this.zoom);
        }
        if (this.ukidssImage != null) {
            this.processedUkidssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ukidssImage, this.quadrantCount), this.zoom);
        }
        if (this.vhsImage != null) {
            this.processedVhsImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.vhsImage, this.quadrantCount), this.zoom);
        }
        if (this.sdssImage != null) {
            this.processedSdssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.sdssImage, this.quadrantCount), this.zoom);
        }
        if (this.dssImage != null) {
            this.processedDssImage = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.dssImage, this.quadrantCount), this.zoom);
        }
        if (this.flipbook.isEmpty() || !this.flipbookComplete) {
            return;
        }
        this.timer.stop();
        for (int i = 0; i < this.flipbook.size(); ++i) {
            FlipbookComponent component = this.flipbook.get(i);
            component.setImage(this.processImage(component, i));
        }
        this.timer.restart();
    }

    public void initCatalogEntries() {
        this.simbadEntries = null;
        this.allWiseEntries = null;
        this.catWiseEntries = null;
        this.catWiseRejectEntries = null;
        this.catWiseTpmEntries = null;
        this.unWiseEntries = null;
        this.gaiaEntries = null;
        this.gaiaDR3Entries = null;
        this.gaiaTpmEntries = null;
        this.gaiaDR3TpmEntries = null;
        this.noirlabEntries = null;
        this.noirlabTpmEntries = null;
        this.panStarrsEntries = null;
        this.sdssEntries = null;
        this.vhsEntries = null;
        this.uhsEntries = null;
        this.ukidssEntries = null;
        this.ukidssTpmEntries = null;
        this.twoMassEntries = null;
        this.tessEntries = null;
        this.desEntries = null;
        this.gaiaWDEntries = null;
        this.mocaEntries = null;
        this.ssoEntries = null;
        if (this.useCustomOverlays.isSelected()) {
            this.customOverlays.values().forEach(customOverlay -> customOverlay.setCatalogEntries(null));
        }
    }

    private void createStaticBook() {
        JScrollPane pane;
        this.timer.stop();
        JPanel grid = new JPanel(new FlowLayout(0));
        for (int i = 0; i < this.flipbook.size(); ++i) {
            FlipbookComponent component = this.flipbook.get(i);
            BufferedImage image = this.addCrosshairs(this.processImage(component, i));
            JScrollPane scrollPanel = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), component.getTitle()));
            grid.add(scrollPanel);
        }
        if (this.desiImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.desiImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("LS", "DR10")));
            grid.add(pane);
        }
        if (this.ps1Image != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ps1Image, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("PS1", this.year_ps1_y_i_g)));
            grid.add(pane);
        }
        if (this.vhsImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.vhsImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("VHS", this.year_vhs_k_h_j)));
            grid.add(pane);
        }
        if (this.uhsImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.uhsImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("UHS", this.year_uhs_k_j)));
            grid.add(pane);
        }
        if (this.ukidssImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.ukidssImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("UKIDSS", this.year_ukidss_k_h_j)));
            grid.add(pane);
        }
        if (this.sdssImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.sdssImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), "SDSS 1998-2009"));
            grid.add(pane);
        }
        if (this.dssImage != null) {
            BufferedImage image = ToolboxHelper.zoomImage(ToolboxHelper.rotateImage(this.dssImage, this.quadrantCount), this.zoom);
            pane = new JScrollPane(ToolboxHelper.addTextToImage(new JLabel(new ImageIcon(image)), ToolboxHelper.getImageLabel("DSS", this.year_dss_2ir_1r_1b)));
            grid.add(pane);
        }
        this.imagePanel.removeAll();
        this.imagePanel.setBorder(ToolboxHelper.createEmptyBorder(""));
        this.imagePanel.add(grid);
        this.baseFrame.setVisible(true);
    }

    public BufferedImage processImage(FlipbookComponent component, int epoch) {
        BufferedImage image = this.wiseBand.equals((Object)WiseBand.W1W2) ? this.createColorImage(component.getFits1(), component.getFits2()) : this.createImage(component.getFits1() == null ? component.getFits2() : component.getFits1());
        image = ToolboxHelper.zoomImage(image, this.zoom);
        image = ToolboxHelper.flipImage(image);
        this.addOverlaysAndPMVectors(image, epoch);
        return image;
    }

    private BufferedImage addCrosshairs(BufferedImage image) {
        if (this.markTarget.isSelected() || this.drawCrosshairs.isSelected() || this.showCrosshairs.isSelected()) {
            image = ToolboxHelper.copyImage(image);
        }
        if (this.markTarget.isSelected()) {
            NumberPair position = this.toPixelCoordinates(this.targetRa, this.targetDec);
            Circle circle = new Circle(position.getX(), position.getY(), this.shapeSize * this.zoom / 100, Color.RED);
            circle.draw(image.getGraphics());
            circle = new Circle(position.getX(), position.getY(), 1.0, Color.RED);
            circle.draw(image.getGraphics());
        }
        if (this.drawCrosshairs.isSelected()) {
            for (int i = 0; i < this.crosshairs.size(); ++i) {
                NumberPair crosshair = this.crosshairs.get(i);
                String label = String.valueOf(i + 1);
                CrossHair drawable = new CrossHair(crosshair.getX() * (double)this.zoom, crosshair.getY() * (double)this.zoom, this.shapeSize * this.zoom / 100, Color.RED, label);
                drawable.draw(image.getGraphics());
            }
        }
        image = ToolboxHelper.rotateImage(image, this.quadrantCount);
        if (this.showCrosshairs.isSelected()) {
            NumberPair coordinates;
            if (this.quadrantCount > 0 && this.quadrantCount < 4) {
                NumberPair pixelCoords = this.undoRotationOfPixelCoords(this.pointerX, this.pointerY);
                coordinates = this.toWorldCoordinates((int)pixelCoords.getX(), (int)pixelCoords.getY());
            } else {
                coordinates = this.toWorldCoordinates(this.pointerX, this.pointerY);
            }
            String label = NumericFunctions.roundTo3DecNZ(coordinates.getX()) + " " + NumericFunctions.roundTo3DecNZ(coordinates.getY());
            CrossHair drawable = new CrossHair(this.pointerX, this.pointerY, this.shapeSize * this.zoom / 100, Color.RED, label);
            drawable.draw(image.getGraphics());
        }
        return image;
    }

    private void addOverlaysAndPMVectors(BufferedImage image, int epoch) {
        if (this.simbadOverlay.isSelected()) {
            if (this.simbadEntries == null) {
                this.simbadEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.simbadEntries = this.fetchCatalogEntries(new SimbadCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.simbadEntries, Color.RED, Shape.CIRCLE);
            }
        }
        if (this.allWiseOverlay.isSelected()) {
            if (this.allWiseEntries == null) {
                this.allWiseEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.allWiseEntries = this.fetchCatalogEntries(new AllWiseCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.allWiseEntries, Color.GREEN.darker(), Shape.CIRCLE);
            }
        }
        if (this.catWiseOverlay.isSelected()) {
            if (this.catWiseEntries == null) {
                this.catWiseEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.catWiseEntries = this.fetchCatalogEntries(new CatWiseCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.catWiseEntries, Color.MAGENTA, Shape.CIRCLE);
            }
        }
        if (this.unWiseOverlay.isSelected()) {
            if (this.unWiseEntries == null) {
                this.unWiseEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.unWiseEntries = this.fetchCatalogEntries(new UnWiseCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.unWiseEntries, JColor.MINT.val, Shape.CIRCLE);
            }
        }
        if (this.gaiaOverlay.isSelected()) {
            if (this.gaiaEntries == null) {
                this.gaiaEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.gaiaEntries = this.fetchCatalogEntries(new GaiaDR2CatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.gaiaEntries, Color.CYAN.darker(), Shape.CIRCLE);
            }
        }
        if (this.gaiaDR3Overlay.isSelected()) {
            if (this.gaiaDR3Entries == null) {
                this.gaiaDR3Entries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.gaiaDR3Entries = this.fetchCatalogEntries(new GaiaDR3CatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.gaiaDR3Entries, Color.CYAN.darker(), Shape.DIAMOND);
            }
        }
        if (this.noirlabOverlay.isSelected()) {
            if (this.noirlabEntries == null) {
                this.noirlabEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.noirlabEntries = this.fetchCatalogEntries(new NoirlabCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.noirlabEntries, JColor.NAVY.val, Shape.CIRCLE);
            }
        }
        if (this.panStarrsOverlay.isSelected()) {
            if (this.panStarrsEntries == null) {
                this.panStarrsEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.panStarrsEntries = this.fetchCatalogEntries(new PanStarrsCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.panStarrsEntries, JColor.BROWN.val, Shape.CIRCLE);
            }
        }
        if (this.sdssOverlay.isSelected()) {
            if (this.sdssEntries == null) {
                this.sdssEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.sdssEntries = this.fetchCatalogEntries(new SdssCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.sdssEntries, JColor.STEEL.val, Shape.CIRCLE);
            }
        }
        if (this.spectrumOverlay.isSelected()) {
            if (this.sdssEntries == null) {
                this.sdssEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.sdssEntries = this.fetchCatalogEntries(new SdssCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawSpectrumOverlay(image, this.sdssEntries);
            }
        }
        if (this.vhsOverlay.isSelected()) {
            if (this.vhsEntries == null) {
                this.vhsEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.vhsEntries = this.fetchCatalogEntries(new VhsCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.vhsEntries, JColor.PINK.val, Shape.CIRCLE);
            }
        }
        if (this.uhsOverlay.isSelected()) {
            if (this.uhsEntries == null) {
                this.uhsEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.uhsEntries = this.fetchCatalogEntries(new UhsCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.uhsEntries, JColor.DARK_YELLOW.val, Shape.CIRCLE);
            }
        }
        if (this.ukidssOverlay.isSelected()) {
            if (this.ukidssEntries == null) {
                this.ukidssEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.ukidssEntries = this.fetchCatalogEntries(new UkidssCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.ukidssEntries, JColor.BLOOD.val, Shape.CIRCLE);
            }
        }
        if (this.twoMassOverlay.isSelected()) {
            if (this.twoMassEntries == null) {
                this.twoMassEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.twoMassEntries = this.fetchCatalogEntries(new TwoMassCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.twoMassEntries, JColor.ORANGE.val, Shape.CIRCLE);
            }
        }
        if (this.tessOverlay.isSelected()) {
            if (this.tessEntries == null) {
                this.tessEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.tessEntries = this.fetchCatalogEntries(new TessCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.tessEntries, JColor.LILAC.val, Shape.CIRCLE);
            }
        }
        if (this.desOverlay.isSelected()) {
            if (this.desEntries == null) {
                this.desEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.desEntries = this.fetchCatalogEntries(new DesCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.desEntries, JColor.SAND.val, Shape.CIRCLE);
            }
        }
        if (this.gaiaWDOverlay.isSelected()) {
            if (this.gaiaWDEntries == null) {
                this.gaiaWDEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.gaiaWDEntries = this.fetchCatalogEntries(new GaiaWDCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.gaiaWDEntries, JColor.PURPLE.val, Shape.CIRCLE);
            }
        }
        if (this.mocaOverlay.isSelected()) {
            if (this.mocaEntries == null) {
                this.mocaEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.mocaEntries = this.fetchCatalogEntries(new MocaCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.mocaEntries, JColor.DARK_ORANGE.val, Shape.DIAMOND);
            }
        }
        if (this.ssoOverlay.isSelected()) {
            if (this.ssoEntries == null) {
                this.ssoEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.ssoEntries = this.fetchCatalogEntries(new SsoCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawOverlay(image, this.ssoEntries, Color.BLUE, Shape.CIRCLE);
            }
        }
        if (this.useCustomOverlays.isSelected()) {
            this.customOverlays.values().forEach(customOverlay -> {
                JCheckBox checkBox = customOverlay.getCheckBox();
                if (checkBox != null && checkBox.isSelected()) {
                    if (customOverlay.getCatalogEntries() == null) {
                        customOverlay.setCatalogEntries(Collections.emptyList());
                        CompletableFuture.supplyAsync(() -> {
                            this.fetchGenericCatalogEntries((CustomOverlay)customOverlay);
                            this.processImages();
                            return null;
                        });
                    } else {
                        this.drawOverlay(image, customOverlay.getCatalogEntries(), customOverlay.getColor(), customOverlay.getShape());
                    }
                }
            });
        }
        if (this.gaiaProperMotion.isSelected()) {
            if (this.gaiaTpmEntries == null) {
                this.gaiaTpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.gaiaTpmEntries = this.fetchTpmCatalogEntries(new GaiaDR2CatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.gaiaTpmEntries, Color.CYAN.darker(), epoch);
            }
        }
        if (this.gaiaDR3ProperMotion.isSelected()) {
            if (this.gaiaDR3TpmEntries == null) {
                this.gaiaDR3TpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.gaiaDR3TpmEntries = this.fetchTpmCatalogEntries(new GaiaDR3CatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.gaiaDR3TpmEntries, Color.CYAN.darker(), epoch);
            }
        }
        if (this.noirlabProperMotion.isSelected()) {
            if (this.noirlabTpmEntries == null) {
                this.noirlabTpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.noirlabTpmEntries = this.fetchTpmCatalogEntries(new NoirlabCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.noirlabTpmEntries, JColor.NAVY.val, epoch);
            }
        }
        if (this.catWiseProperMotion.isSelected()) {
            if (this.catWiseTpmEntries == null) {
                this.catWiseTpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.catWiseTpmEntries = this.fetchTpmCatalogEntries(new CatWiseCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.catWiseTpmEntries, Color.MAGENTA, epoch);
            }
        }
        if (this.ukidssProperMotion.isSelected()) {
            if (this.ukidssTpmEntries == null) {
                this.ukidssTpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.ukidssTpmEntries = this.fetchTpmCatalogEntries(new UkidssCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.ukidssTpmEntries, JColor.BLOOD.val, epoch);
            }
        }
        if (this.uhsProperMotion.isSelected()) {
            if (this.uhsTpmEntries == null) {
                this.uhsTpmEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.uhsTpmEntries = this.fetchTpmCatalogEntries(new UhsCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawPMVectors(image, this.uhsTpmEntries, JColor.DARK_YELLOW.val, epoch);
            }
        }
        if (this.ghostOverlay.isSelected() || this.haloOverlay.isSelected() || this.latentOverlay.isSelected() || this.spikeOverlay.isSelected()) {
            if (this.catWiseEntries == null) {
                this.catWiseEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.catWiseEntries = this.fetchCatalogEntries(new CatWiseCatalogEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawArtifactOverlay(image, this.catWiseEntries);
            }
            if (this.catWiseRejectEntries == null) {
                this.catWiseRejectEntries = Collections.emptyList();
                CompletableFuture.supplyAsync(() -> {
                    this.catWiseRejectEntries = this.fetchCatalogEntries(new CatWiseRejectEntry());
                    this.processImages();
                    return null;
                });
            } else {
                this.drawArtifactOverlay(image, this.catWiseRejectEntries);
            }
        }
    }

    private void downloadRequestedEpochs(Integer forward, int band, List<Epoch> epochs, Map<String, ImageContainer> images) throws Exception {
        if (epochs == null) {
            this.writeLogEntry("No images found for band " + band + ".");
            return;
        }
        if (this.desiCutouts.isSelected()) {
            this.retrieveDesiImages(band, images);
        } else if (this.ps1Cutouts.isSelected()) {
            this.retrievePs1Images(band, images);
        } else {
            for (Epoch epoch : epochs) {
                ImageHDU hdu;
                Fits fits;
                if (this.stopDownloadProcess) {
                    return;
                }
                int requestedEpoch = epoch.getEpoch();
                String imageKey = band + "_" + requestedEpoch;
                ImageContainer container = images.get(imageKey);
                if (container != null) {
                    this.writeLogEntry("band " + band + " | epoch " + requestedEpoch + " | cached");
                    continue;
                }
                if (this.unwiseCutouts.isSelected() && requestedEpoch % 2 > 0 && (container = images.get(band + "_" + (requestedEpoch - 1))) != null) {
                    fits = new Fits();
                    fits.addHDU(Fits.makeHDU(((Data)container.getImage().getHDU(0).getData()).getData()));
                    Header header = fits.getHDU(0).getHeader();
                    header.addValue("FORWARD", epoch.getForward(), "Scan direction");
                    header.addValue("MJDMEAN", epoch.getMjdmean(), "Mean MJD");
                    images.put(imageKey, new ImageContainer(requestedEpoch, fits, false));
                    this.writeLogEntry("band " + band + " | epoch " + requestedEpoch + " | " + this.formatDate(epoch.getMjdmean()) + " | downloaded");
                    continue;
                }
                try {
                    fits = new Fits(this.getImageData(band, requestedEpoch));
                    hdu = (ImageHDU)fits.getHDU(0);
                    fits.close();
                }
                catch (IOException ex) {
                    this.writeLogEntry("band " + band + " | epoch " + requestedEpoch + " | " + ex.getMessage());
                    break;
                }
                Header header = hdu.getHeader();
                double mjdmean = this.wiseviewCutouts.isSelected() ? this.getMjdmean(header) : epoch.getMjdmean();
                header.addValue("FORWARD", epoch.getForward(), "Scan direction");
                header.addValue("MJDMEAN", mjdmean, "Mean MJD");
                String meanObsDate = this.formatDate(mjdmean);
                if (this.skipBadImages.isSelected()) {
                    ImageData imageData = (ImageData)hdu.getData();
                    float[][] data = (float[][])imageData.getData();
                    double y = data.length;
                    double x = y > 0.0 ? (double)data[0].length : 0.0;
                    int badPixels = 0;
                    int i2 = 0;
                    while ((double)i2 < y) {
                        int j = 0;
                        while ((double)j < x) {
                            if (data[i2][j] == 0.0f) {
                                ++badPixels;
                            }
                            ++j;
                        }
                        ++i2;
                    }
                    if ((double)badPixels > x * y * 0.5) {
                        this.writeLogEntry("band " + band + " | epoch " + requestedEpoch + " | " + meanObsDate + " | skipped (poor quality image)");
                        images.put(imageKey, new ImageContainer(requestedEpoch, fits, true));
                        continue;
                    }
                }
                images.put(imageKey, new ImageContainer(requestedEpoch, fits, false));
                this.writeLogEntry("band " + band + " | epoch " + requestedEpoch + " | " + meanObsDate + " | downloaded");
            }
        }
        if (images.isEmpty()) {
            return;
        }
        if (this.skipIntermediateEpochs.isSelected()) {
            this.imagesW1Ends.clear();
            this.imagesW2Ends.clear();
            this.imagesW1Ends.putAll(this.imagesW1);
            this.imagesW2Ends.putAll(this.imagesW2);
        } else {
            this.imagesW1All.clear();
            this.imagesW2All.clear();
            this.imagesW1All.putAll(this.imagesW1);
            this.imagesW2All.putAll(this.imagesW2);
        }
        List containers = images.values().stream().filter(v -> !v.isSkip()).sorted(Comparator.comparing(ImageContainer::getEpoch)).collect(Collectors.toList());
        if (containers.isEmpty()) {
            return;
        }
        this.extractHeaderInfo(((ImageContainer)containers.get(0)).getImage());
        containers.stream().map(ImageContainer::getImage).forEach(i -> this.addImage(band, (Fits)i));
        this.epochCount = containers.size();
    }

    private double getMjdmean(Header header) throws Exception {
        double mjdmin = header.getDoubleValue("MJDMIN");
        double mjdmax = header.getDoubleValue("MJDMAX");
        return (mjdmin + mjdmax) / 2.0;
    }

    private String formatDate(double mjd) {
        LocalDateTime obsDate = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(Double.toString(mjd)));
        return obsDate.format(Constants.DATE_FORMATTER);
    }

    private String getMeanObsDate(Fits fits) throws Exception {
        ImageHDU hdu = (ImageHDU)fits.getHDU(0);
        Header header = hdu.getHeader();
        double mjdmean = header.getDoubleValue("MJDMEAN");
        return this.formatDate(mjdmean);
    }

    private String getDataRelease(Fits fits) throws Exception {
        ImageHDU hdu = (ImageHDU)fits.getHDU(0);
        Header header = hdu.getHeader();
        return header.getStringValue("SURVEY");
    }

    private void extractHeaderInfo(Fits fits) throws Exception {
        if (fits != null) {
            ImageHDU hdu = (ImageHDU)fits.getHDU(0);
            Header header = hdu.getHeader();
            header.addValue("FEPOCH", 1, "First epoch");
            if (header.getDoubleValue("NAXIS1") != header.getDoubleValue("NAXIS2")) {
                this.imageCutOff = true;
            }
            this.crval1 = header.getDoubleValue("CRVAL1");
            this.crval2 = header.getDoubleValue("CRVAL2");
            this.crpix1 = header.getDoubleValue("CRPIX1");
            this.crpix2 = header.getDoubleValue("CRPIX2");
            this.naxis1 = this.size;
            this.naxis2 = this.size;
        }
    }

    private void writeLogEntry(String log) {
        if (this.asyncDownloads) {
            this.downloadLog.append(log + "\n");
        }
    }

    /*
     * Exception decompiling
     */
    private InputStream getImageData(int band, int epoch) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void retrieveDesiImages(int band, Map<String, ImageContainer> images) throws Exception {
        boolean epochDownloaded = this.downloadDesiCutouts(0, band, images, "decals-dr5");
        if (!epochDownloaded || !this.skipIntermediateEpochs.isSelected()) {
            epochDownloaded = this.downloadDesiCutouts(2, band, images, "decals-dr7");
        }
        if (!epochDownloaded || !this.skipIntermediateEpochs.isSelected()) {
            epochDownloaded = this.downloadDesiCutouts(4, band, images, "ls-dr8");
        }
        if (!epochDownloaded || !this.skipIntermediateEpochs.isSelected()) {
            this.downloadDesiCutouts(6, band, images, "ls-dr9");
        }
        this.downloadDesiCutouts(8, band, images, "ls-dr10");
    }

    private boolean downloadDesiCutouts(int requestedEpoch, int band, Map<String, ImageContainer> images, String survey) throws Exception {
        if (this.stopDownloadProcess) {
            return true;
        }
        String imageKey = band + "_" + requestedEpoch;
        ImageContainer container = images.get(imageKey);
        if (container != null) {
            this.writeLogEntry("band " + band + " | image " + requestedEpoch / 2 + " | cached");
            return true;
        }
        String selectedBand = band == 1 ? "r" : "z";
        String baseUrl = "https://www.legacysurvey.org/viewer/fits-cutout?ra=%f&dec=%f&pixscale=%f&layer=%s&size=%d&bands=%s";
        String imageUrl = baseUrl.formatted(this.targetRa, this.targetDec, 0.25, survey, this.size, selectedBand);
        try {
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            Fits fits = new Fits(connection.getInputStream());
            Header header = fits.getHDU(0).getHeader();
            header.addValue("FORWARD", 0, "Scan direction");
            header.addValue("MJDMEAN", 55256.0, "Mean MJD");
            header.addValue("SURVEY", survey, "Data release");
            this.enhanceImage(fits, 1000);
            fits.close();
            images.put(imageKey, new ImageContainer(requestedEpoch, fits, false));
            this.writeLogEntry("band " + band + " | image " + requestedEpoch / 2 + " | " + survey + " | downloaded");
            ++requestedEpoch;
            Fits fits2 = new Fits();
            fits2.addHDU(Fits.makeHDU(((Data)fits.getHDU(0).getData()).getData()));
            header = fits2.getHDU(0).getHeader();
            header.addValue("FORWARD", 1, "Scan direction");
            header.addValue("MJDMEAN", 55256.0, "Mean MJD");
            header.addValue("SURVEY", survey, "Data release");
            imageKey = band + "_" + requestedEpoch;
            images.put(imageKey, new ImageContainer(requestedEpoch, fits2, false));
            return true;
        }
        catch (IOException | FitsException ex) {
            return false;
        }
    }

    private void retrievePs1Images(int band, Map<String, ImageContainer> images) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        String selectedBand = band == 1 ? "r" : "y";
        try {
            String downloadUrl = "http://ps1images.stsci.edu/cgi-bin/ps1filenames.py?RA=%f&DEC=%f&filters=%s&type=warp&sep=comma".formatted(this.targetRa, this.targetDec, selectedBand);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(downloadUrl), "Pan-STARRS");
            try (Scanner scanner = new Scanner(response);){
                String[] columnNames = scanner.nextLine().split(",");
                int fileName = 0;
                for (int i = 0; i < columnNames.length; ++i) {
                    if (!columnNames[i].equals("filename")) continue;
                    fileName = i;
                }
                while (scanner.hasNextLine()) {
                    String[] columnValues = scanner.nextLine().split(",");
                    fileNames.add(columnValues[fileName]);
                }
            }
        }
        catch (IOException ex) {
            ToolboxHelper.writeErrorLog(ex);
        }
        int i = 0;
        for (String fileName : fileNames) {
            this.downloadPs1Cutouts(i, band, images, fileName);
            i += 2;
        }
    }

    private void downloadPs1Cutouts(int requestedEpoch, int band, Map<String, ImageContainer> images, String fileName) throws Exception {
        if (this.stopDownloadProcess) {
            return;
        }
        String imageKey = band + "_" + requestedEpoch;
        ImageContainer container = images.get(imageKey);
        if (container != null) {
            this.writeLogEntry("band " + band + " | image " + requestedEpoch / 2 + " | cached");
            return;
        }
        String imageUrl = "http://ps1images.stsci.edu/cgi-bin/fitscut.cgi?ra=%f&dec=%f&size=%d&red=%s&format=fits".formatted(this.targetRa, this.targetDec, this.size, fileName);
        try {
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            Fits fits = new Fits(connection.getInputStream());
            Header header = fits.getHDU(0).getHeader();
            double mjdmean = header.getDoubleValue("MJD-OBS");
            String meanObsDate = this.formatDate(mjdmean);
            ImageHDU hdu = (ImageHDU)fits.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            float[][] data = (float[][])imageData.getData();
            double y = data.length;
            double x = y > 0.0 ? (double)data[0].length : 0.0;
            int badPixels = 0;
            int i = 0;
            while ((double)i < y) {
                int j = 0;
                while ((double)j < x) {
                    float value = data[i][j];
                    if (this.isBadPixel(value)) {
                        ++badPixels;
                    }
                    ++j;
                }
                ++i;
            }
            double rate = this.skipBadImages.isSelected() ? 0.1 : 0.5;
            if ((double)badPixels > x * y * rate) {
                String reason = this.skipBadImages.isSelected() ? "(poor quality image)" : "(mostly blank image)";
                this.writeLogEntry("band " + band + " | epoch " + requestedEpoch / 2 + " | " + meanObsDate + " | skipped " + reason);
                images.put(imageKey, new ImageContainer(requestedEpoch, fits, true));
                return;
            }
            header.addValue("FORWARD", 0, "Scan direction");
            header.addValue("MJDMEAN", mjdmean, "Mean MJD");
            fits.close();
            images.put(imageKey, new ImageContainer(requestedEpoch, fits, false));
            this.writeLogEntry("band " + band + " | image " + requestedEpoch / 2 + " | " + meanObsDate + " | downloaded");
            ++requestedEpoch;
            Fits fits2 = new Fits();
            fits2.addHDU(Fits.makeHDU(((Data)fits.getHDU(0).getData()).getData()));
            header = fits2.getHDU(0).getHeader();
            header.addValue("FORWARD", 1, "Scan direction");
            header.addValue("MJDMEAN", mjdmean, "Mean MJD");
            imageKey = band + "_" + requestedEpoch;
            images.put(imageKey, new ImageContainer(requestedEpoch, fits2, false));
        }
        catch (IOException | FitsException exception) {
            // empty catch block
        }
    }

    private boolean isBadPixel(float value) {
        return value == 0.0f || Float.toString(value).equals("NaN");
    }

    private BufferedImage createImage(Fits fits) {
        try {
            ImageHDU hdu = (ImageHDU)fits.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            float[][] values = (float[][])imageData.getData();
            if (this.blurImages.isSelected()) {
                values = this.blur(values);
            }
            BufferedImage image = new BufferedImage(this.naxis1, this.naxis2, 1);
            Graphics2D graphics = image.createGraphics();
            for (int i = 0; i < this.naxis2; ++i) {
                for (int j = 0; j < this.naxis1; ++j) {
                    try {
                        float value = this.processPixel(values[i][j]);
                        graphics.setColor(new Color(value, value, value));
                        graphics.fillRect(j, i, 1, 1);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            return image;
        }
        catch (IOException | IndexOutOfBoundsException | FitsException ex) {
            throw new RuntimeException(ex);
        }
    }

    private BufferedImage createColorImage(Fits fits1, Fits fits2) {
        try {
            ImageHDU hdu = (ImageHDU)fits1.getHDU(0);
            ImageData imageData = (ImageData)hdu.getData();
            float[][] valuesW1 = (float[][])imageData.getData();
            hdu = (ImageHDU)fits2.getHDU(0);
            imageData = (ImageData)hdu.getData();
            float[][] valuesW2 = (float[][])imageData.getData();
            if (this.blurImages.isSelected()) {
                valuesW1 = this.blur(valuesW1);
                valuesW2 = this.blur(valuesW2);
            }
            BufferedImage image = new BufferedImage(this.naxis1, this.naxis2, 1);
            Graphics2D graphics = image.createGraphics();
            for (int i = 0; i < this.naxis2; ++i) {
                for (int j = 0; j < this.naxis1; ++j) {
                    try {
                        float red = this.processPixel(valuesW1[i][j]);
                        float blue = this.processPixel(valuesW2[i][j]);
                        float green = (red + blue) / 2.0f;
                        Color color = this.invertColors.isSelected() ? new Color(blue, green, red) : new Color(red, green, blue);
                        graphics.setColor(color);
                        graphics.fillRect(j, i, 1, 1);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            return image;
        }
        catch (IOException | IndexOutOfBoundsException | FitsException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Fits addImages(Fits fits1, Fits fits2) throws Exception {
        ImageHDU hdu = (ImageHDU)fits1.getHDU(0);
        Header header = hdu.getHeader();
        String survey = header.getStringValue("SURVEY");
        double mjdmean1 = header.getDoubleValue("MJDMEAN");
        long firstEpoch1 = header.getLongValue("FEPOCH");
        ImageData imageData = (ImageData)hdu.getData();
        float[][] values1 = (float[][])imageData.getData();
        hdu = (ImageHDU)fits2.getHDU(0);
        header = hdu.getHeader();
        double mjdmean2 = header.getDoubleValue("MJDMEAN");
        long firstEpoch2 = header.getLongValue("FEPOCH");
        imageData = (ImageData)hdu.getData();
        float[][] values2 = (float[][])imageData.getData();
        float[][] addedValues = new float[this.naxis2][this.naxis1];
        for (int i = 0; i < this.naxis2; ++i) {
            for (int j = 0; j < this.naxis1; ++j) {
                try {
                    float value1 = values1[i][j];
                    float value2 = values2[i][j];
                    value1 = this.isBadPixel(value1) ? value2 : value1;
                    value2 = this.isBadPixel(value2) ? value1 : value2;
                    addedValues[i][j] = value1 + value2;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        Fits fits = new Fits();
        fits.addHDU(Fits.makeHDU(addedValues));
        hdu = (ImageHDU)fits.getHDU(0);
        header = hdu.getHeader();
        double mjdmean = (mjdmean1 + mjdmean2) / 2.0;
        header.addValue("MJDMEAN", mjdmean, "Mean MJD");
        header.addValue("SURVEY", survey, "Data release");
        header.addValue("FEPOCH", firstEpoch1 > 0L || firstEpoch2 > 0L ? 1 : 0, "First epoch");
        return fits;
    }

    private Fits subtractImages(Fits fits1, Fits fits2) throws Exception {
        ImageHDU hdu = (ImageHDU)fits1.getHDU(0);
        Header header = hdu.getHeader();
        String survey = header.getStringValue("SURVEY");
        double mjdmean1 = header.getDoubleValue("MJDMEAN");
        long firstEpoch1 = header.getLongValue("FEPOCH");
        ImageData imageData = (ImageData)hdu.getData();
        float[][] values1 = (float[][])imageData.getData();
        hdu = (ImageHDU)fits2.getHDU(0);
        header = hdu.getHeader();
        double mjdmean2 = header.getDoubleValue("MJDMEAN");
        long firstEpoch2 = header.getLongValue("FEPOCH");
        imageData = (ImageData)hdu.getData();
        float[][] values2 = (float[][])imageData.getData();
        float[][] subtractedValues = new float[this.naxis2][this.naxis1];
        for (int i = 0; i < this.naxis2; ++i) {
            for (int j = 0; j < this.naxis1; ++j) {
                try {
                    subtractedValues[i][j] = values1[i][j] - values2[i][j];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        Fits fits = new Fits();
        fits.addHDU(Fits.makeHDU(subtractedValues));
        hdu = (ImageHDU)fits.getHDU(0);
        header = hdu.getHeader();
        double mjdmean = (mjdmean1 + mjdmean2) / 2.0;
        header.addValue("MJDMEAN", mjdmean, "Mean MJD");
        header.addValue("SURVEY", survey, "Data release");
        header.addValue("FEPOCH", firstEpoch1 > 0L || firstEpoch2 > 0L ? 1 : 0, "First epoch");
        return fits;
    }

    private Fits average(Fits fits, int numberOfImages) throws Exception {
        ImageHDU hdu = (ImageHDU)fits.getHDU(0);
        Header header = hdu.getHeader();
        String survey = header.getStringValue("SURVEY");
        double mjdmean = header.getDoubleValue("MJDMEAN");
        long firstEpoch = header.getLongValue("FEPOCH");
        ImageData imageData = (ImageData)hdu.getData();
        float[][] values = (float[][])imageData.getData();
        float[][] averagedValues = new float[this.naxis2][this.naxis1];
        for (int i = 0; i < this.naxis2; ++i) {
            for (int j = 0; j < this.naxis1; ++j) {
                try {
                    averagedValues[i][j] = values[i][j] / (float)numberOfImages;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        fits = new Fits();
        fits.addHDU(Fits.makeHDU(averagedValues));
        hdu = (ImageHDU)fits.getHDU(0);
        header = hdu.getHeader();
        header.addValue("MJDMEAN", mjdmean, "Mean MJD");
        header.addValue("SURVEY", survey, "Data release");
        header.addValue("FEPOCH", firstEpoch, "First epoch");
        return fits;
    }

    private void enhanceImage(Fits fits, int enhanceFactor) throws Exception {
        ImageHDU imageHDU = (ImageHDU)fits.getHDU(0);
        ImageData imageData = (ImageData)imageHDU.getData();
        float[][] values = (float[][])imageData.getData();
        for (int i = 0; i < this.naxis2; ++i) {
            for (int j = 0; j < this.naxis1; ++j) {
                try {
                    values[i][j] = values[i][j] * (float)enhanceFactor;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    private float[][] blur(float[][] values) {
        float[][] blurredValues = new float[this.naxis2][this.naxis1];
        for (int i = 0; i < this.naxis2; ++i) {
            for (int j = 0; j < this.naxis1; ++j) {
                int sum = 0;
                int c = 0;
                for (int k = Math.max(0, i - 1); k <= Math.min(i + 1, this.naxis2 - 1); ++k) {
                    for (int u = Math.max(0, j - 1); u <= Math.min(j + 1, this.naxis1 - 1); ++u) {
                        sum = (int)((float)sum + values[k][u]);
                        ++c;
                    }
                }
                blurredValues[i][j] = sum / c;
            }
        }
        return blurredValues;
    }

    private void addImage(int band, Fits fits) {
        if (band == 1) {
            this.band1Images.add(fits);
        }
        if (band == 2) {
            this.band2Images.add(fits);
        }
    }

    private float processPixel(float value) {
        value = this.normalize(value, this.minValue, this.maxValue);
        return this.invertColors.isSelected() ? value : 1.0f - value;
    }

    private float normalize(float value, float minVal, float maxVal) {
        value = Math.max(value, minVal);
        value = Math.min(value, maxVal);
        float lowerBound = 0.0f;
        float upperBound = 1.0f;
        return (value - minVal) * ((upperBound - lowerBound) / (maxVal - minVal)) + lowerBound;
    }

    private NumberPair determineRefValues(float[][] values) {
        double upperBound;
        double lowerBound;
        ArrayList<Double> imageData = new ArrayList<Double>();
        float[][] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] row;
            for (float value : row = fArray[i]) {
                if (value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY || value == Float.NaN) continue;
                imageData.add(Double.valueOf(value));
            }
        }
        imageData.sort(Comparator.naturalOrder());
        if (this.differenceImaging.isSelected()) {
            limits = ImageViewerTab.determineLimits(imageData, (float)this.contrast / 10.0f, 100.0f - (float)this.contrast / 10.0f);
            lowerBound = limits.getX();
            upperBound = limits.getY();
        } else {
            limits = ImageViewerTab.determineLimits(imageData, this.brightness, 1.0);
            lowerBound = limits.getX();
            limits = ImageViewerTab.determineLimits(imageData, 1.0, 1.0);
            double min = limits.getX();
            double max = limits.getY();
            double dev = max - min;
            double med = StatisticFunctions.determineMedian(imageData);
            upperBound = med + (double)((float)(100 - this.contrast) / 10.0f) * dev;
        }
        return new NumberPair(lowerBound, upperBound);
    }

    public static NumberPair determineLimits(List<Double> values, double lowPercentile, double highPercentile) {
        int size = values.size();
        int half = size / 2;
        int min = (int)((double)half * lowPercentile / 100.0);
        int max = (int)((double)half * (100.0 - highPercentile) / 100.0);
        return new NumberPair(values.get(min), values.get(size - 1 - max));
    }

    private boolean openNewCatalogSearch(double targetRa, double targetDec) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.timer.stop();
        Application application = new Application();
        application.setDefaultCloseOperation(2);
        application.init();
        JTabbedPane pane = application.getTabbedPane();
        int tabIndex = pane.indexOfTab("Catalog Search");
        if (tabIndex < 0) {
            ToolboxHelper.showErrorDialog(this.baseFrame, "The Catalog Search tab has been removed. You can add it again from the Settings tab.");
            return false;
        }
        pane.setSelectedIndex(tabIndex);
        Point point = this.baseFrame.getLocation();
        application.getBaseFrame().setLocation((int)point.getX() + 25, (int)point.getY() + 25);
        CatalogQueryTab catalogQueryTab = application.getCatalogQueryTab();
        catalogQueryTab.getCoordsField().setText(NumericFunctions.roundTo7DecNZ(targetRa) + " " + NumericFunctions.roundTo7DecNZ(targetDec));
        catalogQueryTab.getRadiusField().setText("10");
        catalogQueryTab.getSearchButton().getActionListeners()[0].actionPerformed(null);
        this.baseFrame.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private boolean openNewImageViewer(double targetRa, double targetDec) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.timer.stop();
        Application application = new Application();
        application.setDefaultCloseOperation(2);
        application.init();
        JTabbedPane pane = application.getTabbedPane();
        int tabIndex = pane.indexOfTab(TAB_NAME);
        if (tabIndex < 0) {
            ToolboxHelper.showErrorDialog(this.baseFrame, "The Image Viewer tab has been removed. You can add it again from the Settings tab.");
            return false;
        }
        pane.setSelectedIndex(tabIndex);
        Point point = this.baseFrame.getLocation();
        application.getBaseFrame().setLocation((int)point.getX() + 25, (int)point.getY() + 25);
        ImageViewerTab imageViewerTab = application.getImageViewerTab();
        imageViewerTab.getCoordsField().setText(NumericFunctions.roundTo7DecNZ(targetRa) + " " + NumericFunctions.roundTo7DecNZ(targetDec));
        imageViewerTab.getSizeField().setText(this.differentSizeField.getText());
        if (this.unwiseCutouts.isSelected()) {
            imageViewerTab.setPixelScale(2.75);
            imageViewerTab.getWiseCoadds().setSelected(true);
        }
        if (this.desiCutouts.isSelected()) {
            imageViewerTab.setPixelScale(0.25);
            imageViewerTab.getDesiCutouts().setSelected(true);
        }
        if (this.ps1Cutouts.isSelected()) {
            imageViewerTab.setPixelScale(0.25);
            imageViewerTab.getPs1Cutouts().setSelected(true);
        }
        imageViewerTab.getWiseBands().setSelectedItem((Object)this.wiseBand);
        imageViewerTab.setQuadrantCount(this.quadrantCount);
        imageViewerTab.getZoomSlider().setValue(500);
        imageViewerTab.setZoom(500);
        imageViewerTab.setImageViewer(this);
        this.baseFrame.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private BufferedImage fetchDesiImage(double targetRa, double targetDec, double size) {
        try {
            BufferedImage image;
            int imageSize = (int)Math.round(size * this.pixelScale * 4.0);
            if (imageSize > 3000) {
                return null;
            }
            String imageUrl = "https://www.legacysurvey.org/viewer/jpeg-cutout?ra=%f&dec=%f&pixscale=%f&size=%d&bands=%s&layer=%s".formatted(targetRa, targetDec, 0.25, imageSize, "griz", "ls-dr10");
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), ToolboxHelper.BUFFER_SIZE);){
                image = ImageIO.read(stream);
            }
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? image : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private BufferedImage fetchPs1Image(double targetRa, double targetDec, double size) {
        try {
            BufferedImage image;
            ArrayList<String> fileNames = new ArrayList<String>();
            String imageUrl = "http://ps1images.stsci.edu/cgi-bin/ps1filenames.py?RA=%f&DEC=%f&filters=giy&sep=comma".formatted(targetRa, targetDec);
            String response = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(imageUrl), "Pan-STARRS");
            try (Scanner scanner = new Scanner(response);){
                String[] columnNames = scanner.nextLine().split(",");
                int fileName = 0;
                for (int i = 0; i < columnNames.length; ++i) {
                    if (!columnNames[i].equals("filename")) continue;
                    fileName = i;
                    break;
                }
                while (scanner.hasNextLine()) {
                    String[] columnValues = scanner.nextLine().split(",");
                    fileNames.add(columnValues[fileName]);
                }
            }
            imageUrl = "http://ps1images.stsci.edu/cgi-bin/fitscut.cgi?red=%s&green=%s&blue=%s&ra=%f&dec=%f&size=%d&output_size=%d&autoscale=99.8".formatted(fileNames.get(2), fileNames.get(1), fileNames.get(0), targetRa, targetDec, (int)Math.round(size * this.pixelScale * 4.0), 1024);
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), ToolboxHelper.BUFFER_SIZE);){
                image = ImageIO.read(stream);
            }
            Map<String, Double> years = ToolboxHelper.getPs1Epochs(targetRa, targetDec);
            int year_g = years.get("g").intValue();
            int year_i = years.get("i").intValue();
            int year_y = years.get("y").intValue();
            this.year_ps1_y_i_g = ToolboxHelper.getMeanEpoch(year_y, year_i, year_g);
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? image : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private BufferedImage fetchVhsImage(double targetRa, double targetDec, double size) {
        try {
            if (targetDec > 5.0) {
                return null;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size * this.pixelScale, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS");
            NirImage nirImage = nirImages.get("K-H-J");
            if (nirImage == null) {
                nirImage = nirImages.get("K-J");
            }
            if (nirImage == null) {
                return null;
            }
            this.year_vhs_k_h_j = nirImage.getYear();
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? nirImage.getImage() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private BufferedImage fetchUhsImage(double targetRa, double targetDec, double size) {
        try {
            if (targetDec < -5.0) {
                return null;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size * this.pixelScale, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS");
            NirImage nirImage = nirImages.get("K-H-J");
            if (nirImage == null) {
                nirImage = nirImages.get("K-J");
            }
            if (nirImage == null) {
                return null;
            }
            this.year_uhs_k_j = nirImage.getYear();
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? nirImage.getImage() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private BufferedImage fetchUkidssImage(double targetRa, double targetDec, double size) {
        try {
            if (targetDec < -5.0) {
                return null;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size * this.pixelScale, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS");
            NirImage nirImage = nirImages.get("K-H-J");
            if (nirImage == null) {
                nirImage = nirImages.get("K-J");
            }
            if (nirImage == null) {
                return null;
            }
            this.year_ukidss_k_h_j = nirImage.getYear();
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? nirImage.getImage() : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private BufferedImage fetchSdssImage(double targetRa, double targetDec, double size) {
        try {
            BufferedImage image;
            int resolution = 1024;
            String imageUrl = "https://skyserver.sdss.org/dr17/SkyserverWS/ImgCutout/getjpeg?ra=%f&dec=%f&width=%d&height=%d&scale=%f".formatted(targetRa, targetDec, resolution, resolution, size * this.pixelScale / (double)resolution);
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(imageUrl);
            try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), ToolboxHelper.BUFFER_SIZE);){
                image = ImageIO.read(stream);
            }
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? image : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private BufferedImage fetchDssImage(double targetRa, double targetDec, double size) {
        try {
            int year_2ir;
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, (int)Math.round(size * this.pixelScale), "dss", "file_type=colorimage");
            this.year_dss_2ir_1r_1b = year_2ir = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir");
            return ToolboxHelper.isSameTarget(targetRa, targetDec, size, this.targetRa, this.targetDec, this.size) ? image : null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayDssImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            int year_2ir;
            int year_1b = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss1_blue");
            int year_1r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss1_red");
            int year_2b = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_blue");
            int year_2r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_red");
            int year_2ir_1r_1b = year_2ir = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir");
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss1_blue&type=jpgurl");
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS1 B", year_1b)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss1_red&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS1 R", year_1r)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_blue&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS2 B", year_2b)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_red&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS2 R", year_2r)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS IR", year_2ir)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "file_type=colorimage")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DSS IR-R-B", year_2ir_1r_1b)));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("DSS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void display2MassImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            int year_j = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=j");
            int year_h = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=h");
            int year_k = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=k");
            int year_k_h_j = ToolboxHelper.getMeanEpoch(year_k, year_h, year_j);
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=j&type=jpgurl");
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS J", year_j)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=h&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS H", year_h)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=k&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS K", year_k)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "file_type=colorimage")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("2MASS K-H-J", year_k_h_j)));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("2MASS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySdssImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            int year_u = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=u");
            int year_g = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=g");
            int year_r = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=r");
            int year_i = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=i");
            int year_z = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=z");
            int year_z_g_u = ToolboxHelper.getMeanEpoch(year_z, year_g, year_u);
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=u&type=jpgurl");
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS u", year_u)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=g&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS g", year_g)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=r&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS r", year_r)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=i&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS i", year_i)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=z&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS z", year_z)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "file_type=colorimage")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("SDSS z-g-u", year_z_g_u)));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("SDSS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySpitzerImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            int year_ch1 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC1");
            int year_ch2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC2");
            int year_ch3 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC3");
            int year_ch4 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4");
            int year_mips24 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:MIPS24");
            int year_ch3_ch2_ch1 = ToolboxHelper.getMeanEpoch(year_ch3, year_ch2, year_ch1);
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC1&type=jpgurl");
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC1", year_ch1)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC2&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC2", year_ch2)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC3&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC3", year_ch3)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC4", year_ch4)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:MIPS24&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("MIPS24", year_mips24)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "file_type=colorimage")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("IRAC3-2-1", year_ch3_ch2_ch1)));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("Spitzer (SEIP) - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayAllwiseImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            int year_w1 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=1");
            int year_w2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=2");
            int year_w3 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=3");
            int year_w4 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=4");
            int year_w4_w2_w1 = ToolboxHelper.getMeanEpoch(year_w4, year_w2, year_w1);
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=1&type=jpgurl");
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W1", year_w1)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=2&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W2", year_w2)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=3&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W3", year_w3)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=4&type=jpgurl")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W4", year_w4)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "file_type=colorimage")) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("WISE W4-W2-W1", year_w4_w2_w1)));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("AllWISE - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayUkidssImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (targetDec < -5.0) {
                return;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS");
            if (nirImages.isEmpty()) {
                return;
            }
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            nirImages.entrySet().forEach(entry -> {
                String band = (String)entry.getKey();
                NirImage nirImage = (NirImage)entry.getValue();
                BufferedImage image = nirImage.getImage();
                int year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("UKIDSS " + band, year)));
            });
            int componentCount = bandPanel.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("UKIDSS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayUhsImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (targetDec < -5.0) {
                return;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS");
            if (nirImages.isEmpty()) {
                return;
            }
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            nirImages.entrySet().forEach(entry -> {
                String band = (String)entry.getKey();
                NirImage nirImage = (NirImage)entry.getValue();
                BufferedImage image = nirImage.getImage();
                int year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("UHS " + band, year)));
            });
            int componentCount = bandPanel.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("UHS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayVhsImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (targetDec > 5.0) {
                return;
            }
            Map<String, NirImage> nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS");
            if (nirImages.isEmpty()) {
                return;
            }
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            nirImages.entrySet().forEach(entry -> {
                String band = (String)entry.getKey();
                NirImage nirImage = (NirImage)entry.getValue();
                BufferedImage image = nirImage.getImage();
                int year = nirImage.getYear();
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("VHS " + band, year)));
            });
            int componentCount = bandPanel.getComponentCount();
            if (componentCount == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("VHS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPs1Images(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Map<String, String> imageInfos = ToolboxHelper.getPs1FileNames(targetRa, targetDec);
            if (imageInfos.isEmpty()) {
                return;
            }
            Map<String, Double> years = ToolboxHelper.getPs1Epochs(targetRa, targetDec);
            int year_g = years.get("g").intValue();
            int year_r = years.get("r").intValue();
            int year_i = years.get("i").intValue();
            int year_z = years.get("z").intValue();
            int year_y = years.get("y").intValue();
            int year_y_i_g = ToolboxHelper.getMeanEpoch(year_y, year_i, year_g);
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("g")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 g", year_g)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("r")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 r", year_r)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("i")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 i", year_i)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("z")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 z", year_z)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("y")), targetRa, targetDec, size, true), ToolboxHelper.getImageLabel("PS1 y", year_y)));
            bandPanel.add(this.buildImagePanel(ToolboxHelper.retrievePs1Image("red=%s&green=%s&blue=%s".formatted(imageInfos.get("y"), imageInfos.get("i"), imageInfos.get("g")), targetRa, targetDec, size, false), ToolboxHelper.getImageLabel("PS1 y-i-g", year_y_i_g)));
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("Pan-STARRS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(1080, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayDesiImages(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            BufferedImage image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "g", true);
            if (image != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS g", "DR10")));
            }
            if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "r", true)) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS r", "DR10")));
            }
            if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "z", true)) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS z", "DR10")));
            }
            if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "griz", false)) != null) {
                bandPanel.add(this.buildImagePanel(image, ToolboxHelper.getImageLabel("DECaLS", "DR10")));
            }
            if ((componentCount = bandPanel.getComponentCount()) == 0) {
                return;
            }
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("DECaLS - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (HeadlessException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayStaticTimeSeries(double targetRa, double targetDec, int size, Counter counter) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            Map<String, String> imageInfos;
            Map<String, NirImage> nirImages;
            Map<String, NirImage> nirImages2;
            int year;
            String band;
            Map<String, NirImage> nirImages3;
            NirImage nirImage;
            int year2;
            JPanel bandPanel = new JPanel(new GridLayout(1, 0));
            ArrayList<Couple> timeSeries = new ArrayList<Couple>();
            BufferedImage image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir&type=jpgurl");
            if (image != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DSS IR", year2), new NirImage(year2, image)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=k&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=k");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("2MASS K", year2), new NirImage(year2, image)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=z&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=z");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("SDSS z", year2), new NirImage(year2, image)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("IRAC4", year2), new NirImage(2003, image)));
            }
            if ((image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=2&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=2");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("WISE W2", year2), new NirImage(2010, image)));
            }
            if (targetDec > -5.0 && (nirImage = (nirImages3 = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UKIDSS " + band, year), new NirImage(year, image)));
            }
            if (targetDec > -5.0 && (nirImage = (nirImages2 = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UHS " + band, year), new NirImage(year, image)));
            }
            if (targetDec < 5.0 && (nirImage = (nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("VHS " + band, year), new NirImage(year, image)));
            }
            if (!(imageInfos = ToolboxHelper.getPs1FileNames(targetRa, targetDec)).isEmpty()) {
                int year3 = ToolboxHelper.getPs1Epoch(targetRa, targetDec, "z");
                image = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("z")), targetRa, targetDec, size, true);
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("PS1 z", year3), new NirImage(year3, image)));
            }
            if ((image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "z", true)) != null) {
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DECaLS z", "DR10"), new NirImage(2017, image)));
            }
            if ((componentCount = timeSeries.size()) == 0) {
                return;
            }
            timeSeries.sort(Comparator.comparing(c -> ((NirImage)c.getB()).getYear()));
            timeSeries.forEach(couple -> bandPanel.add(this.buildImagePanel(((NirImage)couple.getB()).getImage(), (String)couple.getA())));
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("Time series - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(bandPanel);
            imageFrame.setSize(componentCount * 180, 220);
            imageFrame.setLocation(0, counter.value());
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            imageFrame.setVisible(true);
            counter.add();
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayAnimatedTimeSeries(double targetRa, double targetDec, int size) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int componentCount;
            Map<String, String> imageInfos;
            Map<String, NirImage> nirImages;
            Map<String, NirImage> nirImages2;
            int year;
            String band;
            Map<String, NirImage> nirImages3;
            NirImage nirImage;
            int year2;
            BufferedImage image;
            ArrayList<Couple> timeSeries = new ArrayList<Couple>();
            if (this.dssImageSeries.isSelected() && (image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "dss", "dss_bands=poss2ukstu_ir");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DSS IR", year2), new NirImage(year2, image)));
            }
            if (this.twoMassImageSeries.isSelected() && (image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "2mass", "twomass_bands=k&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "2mass", "twomass_bands=k");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("2MASS K", year2), new NirImage(year2, image)));
            }
            if (this.sdssImageSeries.isSelected() && (image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "sdss", "sdss_bands=z&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "sdss", "sdss_bands=z");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("SDSS z", year2), new NirImage(year2, image)));
            }
            if (this.spitzerImageSeries.isSelected() && (image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "seip", "seip_bands=spitzer.seip_science:IRAC4");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("IRAC4", year2), new NirImage(2003, image)));
            }
            if (this.allwiseImageSeries.isSelected() && (image = ToolboxHelper.retrieveImage(targetRa, targetDec, size, "wise", "wise_bands=2&type=jpgurl")) != null) {
                year2 = ToolboxHelper.getEpoch(targetRa, targetDec, size, "wise", "wise_bands=2");
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("WISE W2", year2), new NirImage(2010, image)));
            }
            if (this.ukidssImageSeries.isSelected() && targetDec > -5.0 && (nirImage = (nirImages3 = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UKIDSSDR11PLUS&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UKIDSS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UKIDSS " + band, year), new NirImage(year, image)));
            }
            if (this.uhsImageSeries.isSelected() && targetDec > -5.0 && (nirImage = (nirImages2 = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://wsa.roe.ac.uk:8080/wsa/GetImage?database=UHSDR3&programmeID=all&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=stack", "UHS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("UHS " + band, year), new NirImage(year, image)));
            }
            if (this.vhsImageSeries.isSelected() && targetDec < 5.0 && (nirImage = (nirImages = ToolboxHelper.retrieveNearInfraredImages(targetRa, targetDec, size, "http://vsa.roe.ac.uk:8080/vdfs/GetImage?database=VHSDR6&programmeID=110&ra=%f&dec=%f&sys=J&filterID=%s&xsize=%s&ysize=%s&obsType=object&frameType=tilestack", "VHS")).get(band = "K")) != null && (image = nirImage.getImage()) != null) {
                year = nirImage.getYear();
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("VHS " + band, year), new NirImage(year, image)));
            }
            if (this.panstarrsImageSeries.isSelected() && !(imageInfos = ToolboxHelper.getPs1FileNames(targetRa, targetDec)).isEmpty()) {
                int year3 = ToolboxHelper.getPs1Epoch(targetRa, targetDec, "z");
                image = ToolboxHelper.retrievePs1Image("red=%s".formatted(imageInfos.get("z")), targetRa, targetDec, size, true);
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("PS1 z", year3), new NirImage(year3, image)));
            }
            if (this.legacyImageSeries.isSelected() && (image = ToolboxHelper.retrieveDesiImage(targetRa, targetDec, size, "z", true)) != null) {
                timeSeries.add(new Couple<String, NirImage>(ToolboxHelper.getImageLabel("DECaLS z", "DR10"), new NirImage(2017, image)));
            }
            if ((componentCount = timeSeries.size()) == 0) {
                return;
            }
            timeSeries.sort(Comparator.comparing(c -> ((NirImage)c.getB()).getYear()));
            JPanel container = new JPanel();
            JPanel displayPanel = new JPanel();
            container.add(displayPanel);
            JButton saveAsGifButton = new JButton("Save as GIF");
            container.add(saveAsGifButton);
            saveAsGifButton.addActionListener(evt -> {
                try {
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileFilter(new FileTypeFilter(".gif", ".gif files"));
                    int returnVal = fileChooser.showSaveDialog(container);
                    if (returnVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        file = new File(file.getPath() + ".gif");
                        BufferedImage[] imageSet = new BufferedImage[timeSeries.size()];
                        int i = 0;
                        for (Couple nirImage : timeSeries) {
                            BufferedImage imageBuffer = ((NirImage)nirImage.getB()).getImage();
                            imageSet[i++] = ToolboxHelper.drawCenterShape(imageBuffer);
                        }
                        if (imageSet.length > 0) {
                            GifSequencer sequencer = new GifSequencer();
                            sequencer.generateFromBI(imageSet, file, this.speed / 10, true);
                        }
                    }
                }
                catch (HeadlessException | IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            JFrame imageFrame = new JFrame();
            imageFrame.setIconImage(ToolboxHelper.getToolBoxImage());
            imageFrame.setTitle("Time series - Target: " + NumericFunctions.roundTo2DecNZ(targetRa) + " " + NumericFunctions.roundTo2DecNZ(targetDec) + " FoV: " + size + "\"");
            imageFrame.add(container);
            imageFrame.setSize(200, 270);
            imageFrame.setAlwaysOnTop(false);
            imageFrame.setResizable(false);
            final Timer seriesTimer = new Timer(this.speed, e -> {
                if (this.imageCount > componentCount - 1) {
                    this.imageCount = 0;
                }
                displayPanel.removeAll();
                Couple nirImage = (Couple)timeSeries.get(this.imageCount);
                displayPanel.add(this.buildImagePanel(((NirImage)nirImage.getB()).getImage(), (String)nirImage.getA()));
                imageFrame.setVisible(true);
                ++this.imageCount;
            });
            imageFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    seriesTimer.stop();
                    ImageViewerTab.this.imageCount = 0;
                }
            });
            seriesTimer.start();
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private JPanel buildImagePanel(BufferedImage image, String imageLabel) {
        JLabel label = ToolboxHelper.addTextToImage(image, imageLabel);
        JPanel panel = new JPanel();
        panel.add(label);
        return panel;
    }

    private List<CatalogEntry> fetchCatalogEntries(CatalogEntry catalogQuery) {
        try {
            this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
            catalogQuery.setRa(this.targetRa);
            catalogQuery.setDec(this.targetDec);
            catalogQuery.setSearchRadius(this.getFovDiagonal() / 2.0);
            ArrayList<CatalogEntry> resultEntries = new ArrayList<CatalogEntry>();
            List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
            catalogEntries.forEach(catalogEntry -> {
                catalogEntry.setTargetRa(this.targetRa);
                catalogEntry.setTargetDec(this.targetDec);
                catalogEntry.loadCatalogElements();
                resultEntries.add((CatalogEntry)catalogEntry);
            });
            ArrayList<CatalogEntry> arrayList = resultEntries;
            return arrayList;
        }
        catch (IOException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private List<CatalogEntry> fetchTpmCatalogEntries(ProperMotionQuery catalogQuery) {
        try {
            this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.properMotionField.setCursor(Cursor.getPredefinedCursor(3));
            catalogQuery.setRa(this.targetRa);
            catalogQuery.setDec(this.targetDec);
            catalogQuery.setSearchRadius(this.getFovDiagonal() / 2.0);
            catalogQuery.setTpm(NumericFunctions.toDouble(this.properMotionField.getText()));
            ArrayList<CatalogEntry> resultEntries = new ArrayList<CatalogEntry>();
            List<CatalogEntry> catalogEntries = this.catalogQueryService.getCatalogEntriesByCoordsAndTpm(catalogQuery);
            catalogEntries.forEach(catalogEntry -> {
                catalogEntry.setTargetRa(this.targetRa);
                catalogEntry.setTargetDec(this.targetDec);
                catalogEntry.loadCatalogElements();
                resultEntries.add((CatalogEntry)catalogEntry);
            });
            ArrayList<CatalogEntry> arrayList = resultEntries;
            return arrayList;
        }
        catch (IOException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
            this.properMotionField.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchGenericCatalogEntries(CustomOverlay customOverlay) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<CatalogEntry> catalogEntries = new ArrayList<CatalogEntry>();
        String results = null;
        Object queryUrl = null;
        boolean isCatalogSearch = false;
        if (!customOverlay.getTableName().isEmpty()) {
            isCatalogSearch = true;
            queryUrl = ServiceHelper.createVizieRUrl(this.targetRa, this.targetDec, this.getFovDiagonal() / 2.0 / 3600.0, customOverlay.getTableName(), customOverlay.getRaColName(), customOverlay.getDecColName());
        }
        if (!customOverlay.getTapUrl().isEmpty()) {
            isCatalogSearch = true;
            String adqlQuery = customOverlay.getAdqlQuery().replace(":ra:", NumericFunctions.roundTo7DecNZ(this.targetRa)).replace(":dec:", NumericFunctions.roundTo7DecNZ(this.targetDec)).replace(":radius:", NumericFunctions.roundTo7DecNZ(this.getFovDiagonal() / 2.0 / 3600.0));
            queryUrl = customOverlay.getTapUrl() + "/sync?request=doQuery&lang=ADQL&format=csv&query=" + MiscUtils.encodeQuery(adqlQuery);
        }
        if (isCatalogSearch) {
            try {
                results = ServiceHelper.readResponse(ServiceHelper.establishHttpConnection(queryUrl), customOverlay.getName());
                if (results.isEmpty()) {
                    this.baseFrame.setCursor(Cursor.getDefaultCursor());
                    return null;
                }
            }
            catch (IOException ex) {
                ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                this.baseFrame.setCursor(Cursor.getDefaultCursor());
                return null;
            }
        }
        try (Scanner scanner = results == null ? new Scanner(customOverlay.getFile()) : new Scanner(results);){
            int decColumnIndex;
            String[] columnNames = CSVParser.parseLine(scanner.nextLine());
            StringBuilder errors = new StringBuilder();
            int numberOfColumns = columnNames.length;
            int lastColumnIndex = numberOfColumns - 1;
            int raColumnIndex = customOverlay.getRaColumnIndex();
            if (raColumnIndex == 0 && !customOverlay.getRaColName().isEmpty()) {
                raColumnIndex = Arrays.asList(columnNames).indexOf(customOverlay.getRaColName());
            }
            if ((decColumnIndex = customOverlay.getDecColumnIndex()) == 0 && !customOverlay.getDecColName().isEmpty()) {
                decColumnIndex = Arrays.asList(columnNames).indexOf(customOverlay.getDecColName());
            }
            if (raColumnIndex > lastColumnIndex) {
                errors.append("RA position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (decColumnIndex > lastColumnIndex) {
                errors.append("Dec position must not be greater than ").append(lastColumnIndex).append(".").append(Constants.LINE_SEP);
            }
            if (errors.length() > 0) {
                ToolboxHelper.showErrorDialog(this.baseFrame, errors.toString());
                Object var13_17 = null;
                return var13_17;
            }
            while (scanner.hasNextLine()) {
                String[] columnValues = CSVParser.parseLine(scanner.nextLine());
                GenericCatalogEntry catalogEntry = new GenericCatalogEntry(columnNames, columnValues);
                catalogEntry.setRa(NumericFunctions.toDouble(columnValues[raColumnIndex]));
                catalogEntry.setDec(NumericFunctions.toDouble(columnValues[decColumnIndex]));
                double catalogRa = catalogEntry.getRa();
                double catalogDec = catalogEntry.getDec();
                double radius = this.getFovDiagonal() / 2.0;
                double distance = AstrometricFunctions.calculateAngularDistance(new NumberPair(this.targetRa, this.targetDec), new NumberPair(catalogRa, catalogDec), 3600.0);
                if (!(distance <= radius)) continue;
                catalogEntry.setTargetRa(this.targetRa);
                catalogEntry.setTargetDec(this.targetDec);
                catalogEntry.setCatalogName(customOverlay.getName());
                catalogEntry.loadCatalogElements();
                catalogEntries.add(catalogEntry);
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            customOverlay.setCatalogEntries(catalogEntries);
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
        return null;
    }

    private void drawSpectrumOverlay(BufferedImage image, List<CatalogEntry> catalogEntries) {
        Graphics graphics = image.getGraphics();
        catalogEntries.forEach(catalogEntry -> {
            NumberPair position = this.toPixelCoordinates(catalogEntry.getRa(), catalogEntry.getDec());
            catalogEntry.setPixelRa(position.getX());
            catalogEntry.setPixelDec(position.getY());
            SdssCatalogEntry sdssCatalogEntry = (SdssCatalogEntry)catalogEntry;
            if (!sdssCatalogEntry.getSpecObjID().equals(new BigInteger("0"))) {
                Circle toDraw = new Circle(position.getX(), position.getY(), this.getOverlaySize(), JColor.OLIVE.val);
                toDraw.draw(graphics);
            }
        });
    }

    private void showSpectrumInfo(List<CatalogEntry> catalogEntries, int x, int y) {
        catalogEntries.forEach(catalogEntry -> {
            double radius = this.getOverlaySize() / 2.0;
            SdssCatalogEntry sdssCatalogEntry = (SdssCatalogEntry)catalogEntry;
            if (!sdssCatalogEntry.getSpecObjID().equals(new BigInteger("0")) && catalogEntry.getPixelRa() > (double)x - radius && catalogEntry.getPixelRa() < (double)x + radius && catalogEntry.getPixelDec() > (double)y - radius && catalogEntry.getPixelDec() < (double)y + radius) {
                this.displaySdssSpectrum((CatalogEntry)catalogEntry);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displaySdssSpectrum(CatalogEntry catalogEntry) {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            BufferedImage spectrum;
            SdssCatalogEntry SDSSCatalogEntry = (SdssCatalogEntry)catalogEntry;
            String spectrumUrl = "https://skyserver.sdss.org/dr17/en/get/specById.ashx?ID=" + String.valueOf(SDSSCatalogEntry.getSpecObjID());
            HttpURLConnection connection = ServiceHelper.establishHttpConnection(spectrumUrl);
            try (BufferedInputStream stream = new BufferedInputStream(connection.getInputStream(), ToolboxHelper.BUFFER_SIZE);){
                spectrum = ImageIO.read(stream);
            }
            if (spectrum != null) {
                JFrame spectrumFrame = new JFrame();
                spectrumFrame.setIconImage(ToolboxHelper.getToolBoxImage());
                spectrumFrame.setTitle("SDSS spectrum for object: " + NumericFunctions.roundTo2DecNZ(catalogEntry.getRa()) + " " + NumericFunctions.roundTo2DecNZ(catalogEntry.getDec()));
                spectrumFrame.add(new JLabel(new ImageIcon(spectrum)));
                spectrumFrame.setSize(1200, 900);
                spectrumFrame.setAlwaysOnTop(false);
                spectrumFrame.setResizable(false);
                spectrumFrame.setVisible(true);
            }
        }
        catch (HeadlessException | IOException | SecurityException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
        finally {
            this.baseFrame.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void drawOverlay(BufferedImage image, List<CatalogEntry> catalogEntries, Color color, Shape shape) {
        Graphics graphics = image.getGraphics();
        catalogEntries.forEach(catalogEntry -> {
            NumberPair position = this.toPixelCoordinates(catalogEntry.getRa(), catalogEntry.getDec());
            catalogEntry.setPixelRa(position.getX());
            catalogEntry.setPixelDec(position.getY());
            Drawable toDraw = switch (shape) {
                case Shape.CIRCLE -> new Circle(position.getX(), position.getY(), this.getOverlaySize(), color);
                case Shape.CROSS -> new Cross(position.getX(), position.getY(), this.getOverlaySize(), color);
                case Shape.XCROSS -> new XCross(position.getX(), position.getY(), this.getOverlaySize(), color);
                case Shape.SQUARE -> new Square(position.getX(), position.getY(), this.getOverlaySize(), color);
                case Shape.TRIANGLE -> new Triangle(position.getX(), position.getY(), this.getOverlaySize(), color);
                case Shape.DIAMOND -> new Diamond(position.getX(), position.getY(), this.getOverlaySize(), color);
                default -> new Circle(position.getX(), position.getY(), this.getOverlaySize(), color);
            };
            toDraw.draw(graphics);
        });
    }

    private void drawArtifactOverlay(BufferedImage image, List<CatalogEntry> catalogEntries) {
        Graphics graphics = image.getGraphics();
        catalogEntries.forEach(catalogEntry -> {
            Drawable toDraw;
            NumberPair position = this.toPixelCoordinates(catalogEntry.getRa(), catalogEntry.getDec());
            catalogEntry.setPixelRa(position.getX());
            catalogEntry.setPixelDec(position.getY());
            Artifact artifact = (Artifact)((Object)catalogEntry);
            String ab_flags = artifact.getAb_flags();
            String cc_flags = artifact.getCc_flags();
            if (cc_flags.isEmpty()) {
                cc_flags = "0000";
            }
            switch (this.wiseBand) {
                case W1: {
                    ab_flags = ab_flags.substring(0, 1);
                    cc_flags = cc_flags.substring(0, 1);
                    break;
                }
                case W2: {
                    ab_flags = ab_flags.substring(1, 2);
                    cc_flags = cc_flags.substring(1, 2);
                    break;
                }
                default: {
                    ab_flags = ab_flags.substring(0, 2);
                    cc_flags = cc_flags.substring(0, 2);
                }
            }
            String flags = ab_flags + cc_flags;
            if (this.ghostOverlay.isSelected()) {
                if (flags.contains("o")) {
                    toDraw = new Diamond(position.getX(), position.getY(), this.getOverlaySize() / 2.0, Color.MAGENTA.darker());
                    toDraw.draw(graphics);
                }
                if (flags.contains("O")) {
                    toDraw = new Diamond(position.getX(), position.getY(), this.getOverlaySize(), Color.MAGENTA.darker());
                    toDraw.draw(graphics);
                }
            }
            if (this.haloOverlay.isSelected()) {
                if (flags.contains("h")) {
                    toDraw = new Square(position.getX(), position.getY(), this.getOverlaySize() / 2.0, Color.YELLOW);
                    toDraw.draw(graphics);
                }
                if (flags.contains("H")) {
                    toDraw = new Square(position.getX(), position.getY(), this.getOverlaySize(), Color.YELLOW);
                    toDraw.draw(graphics);
                }
            }
            if (this.latentOverlay.isSelected()) {
                if (flags.contains("p")) {
                    toDraw = new XCross(position.getX(), position.getY(), this.getOverlaySize() / 2.0, Color.GREEN.darker());
                    toDraw.draw(graphics);
                }
                if (flags.contains("P")) {
                    toDraw = new XCross(position.getX(), position.getY(), this.getOverlaySize(), Color.GREEN.darker());
                    toDraw.draw(graphics);
                }
            }
            if (this.spikeOverlay.isSelected()) {
                if (flags.contains("d")) {
                    toDraw = new Circle(position.getX(), position.getY(), this.getOverlaySize() / 2.0, Color.ORANGE);
                    toDraw.draw(graphics);
                }
                if (flags.contains("D")) {
                    toDraw = new Circle(position.getX(), position.getY(), this.getOverlaySize(), Color.ORANGE);
                    toDraw.draw(graphics);
                }
            }
        });
    }

    private void drawPMVectors(BufferedImage image, List<CatalogEntry> catalogEntries, Color color, double flipbookIndex) {
        Graphics graphics = image.getGraphics();
        for (CatalogEntry catalogEntry : catalogEntries) {
            ProperMotionQuery entry;
            NumberPair position = this.toPixelCoordinates(catalogEntry.getRa(), catalogEntry.getDec());
            catalogEntry.setPixelRa(position.getX());
            catalogEntry.setPixelDec(position.getY());
            double ra = catalogEntry.getRa();
            double dec = catalogEntry.getDec();
            double pmRa = catalogEntry.getPmra();
            double pmDec = catalogEntry.getPmdec();
            double numberOfYears = 0.0;
            if (catalogEntry instanceof GaiaDR2CatalogEntry) {
                numberOfYears = 4.941;
            }
            if (catalogEntry instanceof GaiaDR3CatalogEntry) {
                numberOfYears = 5.441;
            }
            if (catalogEntry instanceof NoirlabCatalogEntry) {
                entry = (NoirlabCatalogEntry)catalogEntry;
                numberOfYears = ((NoirlabCatalogEntry)entry).getMeanEpoch() - 2010.559;
            }
            if (catalogEntry instanceof CatWiseCatalogEntry) {
                entry = (CatWiseCatalogEntry)catalogEntry;
                ra = ((CatWiseCatalogEntry)entry).getRa_pm();
                dec = ((CatWiseCatalogEntry)entry).getDec_pm();
                numberOfYears = 4.846;
            }
            if (catalogEntry instanceof UkidssCatalogEntry) {
                entry = (UkidssCatalogEntry)catalogEntry;
                numberOfYears = ((UkidssCatalogEntry)entry).getMeanEpoch() - 2010.559;
            }
            if (this.showProperMotion.isSelected()) {
                double flipbookSize = this.flipbook.size() - 1;
                if (this.separateScanDirections.isSelected() && !this.skipIntermediateEpochs.isSelected() && flipbookIndex > (flipbookSize /= 2.0)) {
                    flipbookIndex -= flipbookSize;
                }
                double totalEpochs = flipbookIndex / flipbookSize * (double)this.getNumberOfWiseEpochs() * 2.0;
                NumberPair newPosition = this.getNewPosition(ra, dec, pmRa, pmDec, numberOfYears, totalEpochs);
                NumberPair pixelCoords = this.toPixelCoordinates(newPosition.getX(), newPosition.getY());
                Disk disk = new Disk(pixelCoords.getX(), pixelCoords.getY(), this.getOverlaySize(2), color);
                disk.draw(image.getGraphics());
                continue;
            }
            NumberPair fromCoords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(ra, dec), new NumberPair(-numberOfYears * pmRa / 3600000.0, -numberOfYears * pmDec / 3600000.0));
            double fromRa = fromCoords.getX();
            double fromDec = fromCoords.getY();
            NumberPair fromPoint = this.toPixelCoordinates(fromRa, fromDec);
            double fromX = fromPoint.getX();
            double fromY = fromPoint.getY();
            numberOfYears = this.getNumberOfWiseEpochs() + 2;
            NumberPair toCoords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(fromRa, fromDec), new NumberPair(numberOfYears * pmRa / 3600000.0, numberOfYears * pmDec / 3600000.0));
            double toRa = toCoords.getX();
            double toDec = toCoords.getY();
            NumberPair toPoint = this.toPixelCoordinates(toRa, toDec);
            double toX = toPoint.getX();
            double toY = toPoint.getY();
            Arrow arrow = new Arrow(fromX, fromY, toX, toY, this.getOverlaySize(), color);
            arrow.draw(graphics);
        }
    }

    private NumberPair getNewPosition(double ra, double dec, double pmRa, double pmDec, double numberOfYears, double totalEpochs) {
        NumberPair fromCoords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(ra, dec), new NumberPair(-numberOfYears * pmRa / 3600000.0, -numberOfYears * pmDec / 3600000.0));
        double fromRa = fromCoords.getX();
        double fromDec = fromCoords.getY();
        NumberPair toCoords = AstrometricFunctions.calculatePositionFromProperMotion(new NumberPair(fromRa, fromDec), new NumberPair(totalEpochs * (pmRa / 2.0) / 3600000.0, totalEpochs * (pmDec / 2.0) / 3600000.0));
        double toRa = toCoords.getX();
        double toDec = toCoords.getY();
        return new NumberPair(toRa, toDec);
    }

    private void showPMInfo(List<CatalogEntry> catalogEntries, int x, int y, Color color) {
        catalogEntries.forEach(catalogEntry -> {
            double radius = this.getOverlaySize() / 2.0;
            if (catalogEntry.getPixelRa() > (double)x - radius && catalogEntry.getPixelRa() < (double)x + radius && catalogEntry.getPixelDec() > (double)y - radius && catalogEntry.getPixelDec() < (double)y + radius) {
                this.displayCatalogPanel((CatalogEntry)catalogEntry, color, true);
            }
        });
    }

    private void showCatalogInfo(List<CatalogEntry> catalogEntries, int x, int y, Color color) {
        catalogEntries.forEach(catalogEntry -> {
            double radius = this.getOverlaySize() / 2.0;
            if (catalogEntry.getPixelRa() > (double)x - radius && catalogEntry.getPixelRa() < (double)x + radius && catalogEntry.getPixelDec() > (double)y - radius && catalogEntry.getPixelDec() < (double)y + radius) {
                this.displayCatalogPanel((CatalogEntry)catalogEntry, color, true);
            }
        });
    }

    private void displayCatalogPanel(CatalogEntry catalogEntry, Color color, boolean addExtinctionCheckbox) {
        boolean simpleLayout = catalogEntry instanceof GenericCatalogEntry || catalogEntry instanceof SsoCatalogEntry;
        List<CatalogElement> catalogElements = catalogEntry.getCatalogElements();
        int elements = catalogElements.size();
        int rows = elements / 2;
        int remainder = elements % 2;
        int maxRows = simpleLayout ? (rows > 30 ? rows : 30) : (rows > 20 ? (rows += remainder) : 20);
        JPanel detailPanel = new JPanel(new GridLayout(0, 4));
        detailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), catalogEntry.getCatalogName() + " entry (Computed values are shown in green; (*) Further info: mouse pointer)", 1, 2));
        catalogElements.forEach(element -> {
            ToolboxHelper.addLabelToPanel(element, detailPanel);
            ToolboxHelper.addFieldToPanel(element, detailPanel);
        });
        if (remainder == 1) {
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
        }
        for (int i = 0; i < maxRows - rows; ++i) {
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
            ToolboxHelper.addEmptyCatalogElement(detailPanel);
        }
        JScrollPane scrollPanel = new JScrollPane(detailPanel);
        scrollPanel.setBorder(BorderFactory.createEmptyBorder());
        scrollPanel.setMinimumSize(new Dimension(700, 350));
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(new LineBorder(color, 3));
        container.add(simpleLayout ? detailPanel : scrollPanel);
        if (!simpleLayout) {
            List<LookupResult> brownDwarfsResults;
            JPanel messagePanel;
            List<LookupResult> mainSequenceResults = this.mainSequenceSpectralTypeLookupService.lookup(catalogEntry.getColors(true));
            if (!mainSequenceResults.isEmpty()) {
                Object entry;
                container.add(this.createMainSequenceSpectralTypePanel(mainSequenceResults, catalogEntry, color));
                if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN(((AllWiseCatalogEntry)(entry = (AllWiseCatalogEntry)catalogEntry)).getW1_W2(), ((AllWiseCatalogEntry)entry).getW2_W3())) {
                    messagePanel = new JPanel(new FlowLayout(0));
                    messagePanel.add(ToolboxHelper.createLabel("Possible AGN!", JColor.RED));
                    container.add(messagePanel);
                }
                if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry.getBP_RP())) {
                    messagePanel = new JPanel(new FlowLayout(0));
                    messagePanel.add(ToolboxHelper.createLabel("Possible white dwarf!", JColor.RED));
                    container.add(messagePanel);
                }
            }
            if (!(brownDwarfsResults = this.brownDwarfsSpectralTypeLookupService.lookup(catalogEntry.getColors(true))).isEmpty()) {
                container.add(this.createBrownDwarfsSpectralTypePanel(brownDwarfsResults, catalogEntry, color));
            }
            if (mainSequenceResults.isEmpty() && brownDwarfsResults.isEmpty()) {
                container.add(this.createMainSequenceSpectralTypePanel(mainSequenceResults, catalogEntry, color));
                messagePanel = new JPanel(new FlowLayout(0));
                messagePanel.add(ToolboxHelper.createLabel("No colors available / No match", JColor.RED));
                container.add(messagePanel);
            }
            JPanel toolsPanel = new JPanel();
            toolsPanel.setLayout(new BoxLayout(toolsPanel, 1));
            container.add(toolsPanel);
            JPanel collectPanel = new JPanel(new FlowLayout(0));
            toolsPanel.add(collectPanel);
            collectPanel.add(new JLabel("Object type:"));
            JComboBox<String> objectTypes = new JComboBox<String>(ObjectType.labels());
            collectPanel.add(objectTypes);
            JButton collectButton = new JButton("Add to collection");
            collectPanel.add(collectButton);
            Timer collectTimer = new Timer(3000, e -> collectButton.setText("Add to collection"));
            collectButton.addActionListener(evt -> {
                String selectedObjectType = (String)objectTypes.getSelectedItem();
                ToolboxHelper.collectObject(selectedObjectType, catalogEntry, this.baseFrame, this.brownDwarfsSpectralTypeLookupService, this.collectionTable);
                collectButton.setText("Added!");
                collectTimer.restart();
            });
            if (catalogEntry instanceof SimbadCatalogEntry) {
                JButton referencesButton = new JButton("Literature Ref.");
                collectPanel.add(referencesButton);
                referencesButton.addActionListener(evt -> {
                    JFrame referencesFrame = new JFrame();
                    referencesFrame.setDefaultCloseOperation(2);
                    referencesFrame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    referencesFrame.setIconImage(ToolboxHelper.getToolBoxImage());
                    referencesFrame.setTitle("Measurements and references for " + catalogEntry.getSourceId() + " (" + NumericFunctions.roundTo7DecNZ(catalogEntry.getRa()) + " " + NumericFunctions.roundTo7DecNZ(catalogEntry.getDec()) + ")");
                    referencesFrame.add(new JScrollPane(new ReferencesPanel(catalogEntry, referencesFrame)));
                    referencesFrame.setSize(ToolboxHelper.BASE_FRAME_WIDTH, ToolboxHelper.BASE_FRAME_HEIGHT);
                    referencesFrame.setLocation(0, 0);
                    referencesFrame.setAlwaysOnTop(false);
                    referencesFrame.setResizable(true);
                    referencesFrame.setVisible(true);
                });
            }
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            toolsPanel.add(buttonPanel);
            JButton copyCoordsButton = new JButton("Copy coords");
            buttonPanel.add(copyCoordsButton);
            Timer copyCoordsTimer = new Timer(3000, e -> copyCoordsButton.setText("Copy coords"));
            copyCoordsButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectCoordinates(catalogEntry));
                copyCoordsButton.setText("Copied to clipboard!");
                copyCoordsTimer.restart();
            });
            JButton copyInfoButton = new JButton("Copy summary");
            buttonPanel.add(copyInfoButton);
            Timer copyInfoTimer = new Timer(3000, e -> copyInfoButton.setText("Copy summary"));
            copyInfoButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectSummary(catalogEntry));
                copyInfoButton.setText("Copied to clipboard!");
                copyInfoTimer.restart();
            });
            JButton copyAllButton = new JButton("Copy all");
            buttonPanel.add(copyAllButton);
            Timer copyAllTimer = new Timer(3000, e -> copyAllButton.setText("Copy all"));
            copyAllButton.addActionListener(evt -> {
                ToolboxHelper.copyToClipboard(ToolboxHelper.copyObjectInfo(catalogEntry, mainSequenceResults, brownDwarfsResults, this.distanceLookupService));
                copyAllButton.setText("Copied to clipboard!");
                copyAllTimer.restart();
            });
            JButton fillFormButton = new JButton("TYGO form");
            buttonPanel.add(fillFormButton);
            fillFormButton.addActionListener(evt -> ToolboxHelper.fillTygoForm(catalogEntry, this.catalogQueryService, this.baseFrame));
            JButton createSedButton = new JButton("Ultracool Dwarf SED");
            buttonPanel.add(createSedButton);
            createSedButton.addActionListener(evt -> {
                createSedButton.setCursor(Cursor.getPredefinedCursor(3));
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                frame.setIconImage(ToolboxHelper.getToolBoxImage());
                frame.setTitle("Ultracool Dwarf SED");
                frame.add(new SedUcdPanel(this.brownDwarfLookupEntries, this.catalogQueryService, catalogEntry, this.baseFrame));
                frame.setSize(1050, 900);
                frame.setLocation(0, 0);
                frame.setAlwaysOnTop(false);
                frame.setResizable(true);
                frame.setVisible(true);
                createSedButton.setCursor(Cursor.getDefaultCursor());
            });
            JButton createWdSedButton = new JButton("White Dwarf SED");
            buttonPanel.add(createWdSedButton);
            createWdSedButton.addActionListener(evt -> {
                createWdSedButton.setCursor(Cursor.getPredefinedCursor(3));
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                frame.setIconImage(ToolboxHelper.getToolBoxImage());
                frame.setTitle("White Dwarf SED");
                frame.add(new SedWdPanel(this.catalogQueryService, catalogEntry, this.baseFrame));
                frame.setSize(1050, 900);
                frame.setLocation(0, 0);
                frame.setAlwaysOnTop(false);
                frame.setResizable(true);
                frame.setVisible(true);
                createWdSedButton.setCursor(Cursor.getDefaultCursor());
            });
            JButton createCcdButton = new JButton("WISE CCD");
            collectPanel.add(createCcdButton);
            createCcdButton.addActionListener(evt -> {
                try {
                    createCcdButton.setCursor(Cursor.getPredefinedCursor(3));
                    JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    frame.setIconImage(ToolboxHelper.getToolBoxImage());
                    frame.setTitle("WISE CCD");
                    frame.add(new WiseCcdPanel(this.catalogQueryService, catalogEntry, this.baseFrame));
                    frame.setSize(1000, 900);
                    frame.setLocation(0, 0);
                    frame.setAlwaysOnTop(false);
                    frame.setResizable(true);
                    frame.setVisible(true);
                }
                catch (HeadlessException | SecurityException ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                }
                finally {
                    createCcdButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            JButton createLcButton = new JButton("WISE Light Curves");
            collectPanel.add(createLcButton);
            createLcButton.addActionListener(evt -> {
                try {
                    createLcButton.setCursor(Cursor.getPredefinedCursor(3));
                    JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(2);
                    frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                    frame.setIconImage(ToolboxHelper.getToolBoxImage());
                    frame.setTitle("WISE Light Curves");
                    frame.add(new WiseLcPanel(catalogEntry, this.baseFrame));
                    frame.setSize(1000, 900);
                    frame.setLocation(0, 0);
                    frame.setAlwaysOnTop(false);
                    frame.setResizable(true);
                    frame.setVisible(true);
                }
                catch (HeadlessException | SecurityException ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                }
                finally {
                    createLcButton.setCursor(Cursor.getDefaultCursor());
                }
            });
            if (catalogEntry instanceof GaiaCmd) {
                GaiaCmd cmd = (GaiaCmd)catalogEntry;
                JButton createCmdButton = new JButton("Gaia CMD");
                collectPanel.add(createCmdButton);
                createCmdButton.addActionListener(evt -> {
                    try {
                        createCmdButton.setCursor(Cursor.getPredefinedCursor(3));
                        JFrame frame = new JFrame();
                        frame.setDefaultCloseOperation(2);
                        frame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
                        frame.setIconImage(ToolboxHelper.getToolBoxImage());
                        frame.setTitle("Gaia CMD");
                        frame.add(new GaiaCmdPanel(cmd));
                        frame.setSize(1000, 900);
                        frame.setLocation(0, 0);
                        frame.setAlwaysOnTop(false);
                        frame.setResizable(true);
                        frame.setVisible(true);
                    }
                    catch (HeadlessException | SecurityException ex) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                    }
                    finally {
                        createCmdButton.setCursor(Cursor.getDefaultCursor());
                    }
                });
            }
            if (addExtinctionCheckbox && catalogEntry instanceof Extinction) {
                Extinction selectedEntry = (Extinction)catalogEntry.copy();
                JPanel extinctionPanel = new JPanel(new FlowLayout(0));
                toolsPanel.add(extinctionPanel);
                JCheckBox dustExtinction = new JCheckBox("Apply extinction correction for bands u, g, r, i, z, J, H, K, W1 & W2 (Schlafly & Finkbeiner, 2011)");
                extinctionPanel.add(dustExtinction);
                dustExtinction.addActionListener(evt -> {
                    if (dustExtinction.isSelected()) {
                        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            Map<String, Double> extinctionsByBand = this.dustExtinctionService.getExtinctionsByBand(selectedEntry.getRa(), selectedEntry.getDec(), 2.0);
                            try {
                                selectedEntry.applyExtinctionCorrection(extinctionsByBand);
                                selectedEntry.loadCatalogElements();
                                this.displayCatalogPanel(selectedEntry, color, false);
                            }
                            catch (ExtinctionException ex) {
                                extinctionPanel.add(ToolboxHelper.createLabel("No extinction values for " + selectedEntry.getCatalogName() + " bands.", JColor.RED));
                            }
                        }
                        catch (Exception ex) {
                            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                        }
                        finally {
                            this.baseFrame.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }
        }
        JFrame detailsFrame = new JFrame();
        detailsFrame.setDefaultCloseOperation(2);
        detailsFrame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
        detailsFrame.setIconImage(ToolboxHelper.getToolBoxImage());
        detailsFrame.setTitle("Object details");
        detailsFrame.add(simpleLayout ? new JScrollPane(container) : container);
        detailsFrame.setSize(700, 700);
        detailsFrame.setLocation(this.windowShift, this.windowShift);
        detailsFrame.setAlwaysOnTop(false);
        detailsFrame.setResizable(true);
        detailsFrame.setVisible(true);
        this.windowShift += 10;
    }

    private JScrollPane createMainSequenceSpectralTypePanel(List<LookupResult> results, CatalogEntry catalogEntry, Color color) {
        ArrayList<String[]> spectralTypes = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedColor = entry.getColorKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getColorValue());
            String spectralType = entry.getSpt() + "," + matchedColor + "," + NumericFunctions.roundTo3Dec(entry.getNearest()) + "," + NumericFunctions.roundTo3DecLZ(entry.getGap()) + "," + entry.getTeff() + "," + NumericFunctions.roundTo3Dec(entry.getRsun()) + "," + NumericFunctions.roundTo3Dec(entry.getMsun());
            spectralTypes.add(spectralType.split(",", -1));
        });
        String titles = "spt,matched color,nearest color,offset,teff,radius (Rsun),mass (Msun)";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable spectralTypeTable = new JTable((Object[][])spectralTypes.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(spectralTypeTable, spectralTypes);
        spectralTypeTable.setAutoCreateRowSorter(true);
        spectralTypeTable.setAutoResizeMode(0);
        TableColumnModel columnModel = spectralTypeTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(75);
        columnModel.getColumn(3).setPreferredWidth(50);
        columnModel.getColumn(4).setPreferredWidth(50);
        columnModel.getColumn(5).setPreferredWidth(75);
        columnModel.getColumn(6).setPreferredWidth(75);
        spectralTypeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != spectralTypeTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = spectralTypeTable;
                String spt = (String)spectralTypeTable.getValueAt(spectralTypeTable.getSelectedRow(), 0);
                List<DistanceLookupResult> distanceResults = this.distanceLookupService.lookup(spt, catalogEntry.getBands());
                this.createDistanceEstimatesPanel(distanceResults, spt, color);
            }
        });
        JScrollPane spectralTypePanel = new JScrollPane(spectralTypeTable);
        spectralTypePanel.setToolTipText("Clicking on a table row displays photometric distance estimates for the specified spectral type.");
        spectralTypePanel.setMinimumSize(new Dimension(700, 75));
        spectralTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolboxHelper.html("Main sequence spectral type estimates <span style='color:red'>&#9432;</span>"), 1, 2));
        return spectralTypePanel;
    }

    private JScrollPane createBrownDwarfsSpectralTypePanel(List<LookupResult> results, CatalogEntry catalogEntry, Color color) {
        ArrayList<String[]> spectralTypes = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedColor = entry.getColorKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getColorValue());
            String spectralType = entry.getSpt() + "," + matchedColor + "," + NumericFunctions.roundTo3Dec(entry.getNearest()) + "," + NumericFunctions.roundTo3DecLZ(entry.getGap());
            spectralTypes.add(spectralType.split(",", -1));
        });
        String titles = "spt,matched color,nearest color,offset";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable spectralTypeTable = new JTable((Object[][])spectralTypes.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(spectralTypeTable, spectralTypes);
        spectralTypeTable.setAutoCreateRowSorter(true);
        spectralTypeTable.setAutoResizeMode(0);
        TableColumnModel columnModel = spectralTypeTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(1).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(75);
        columnModel.getColumn(3).setPreferredWidth(50);
        spectralTypeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                if (this.currentTable != null && this.currentTable != spectralTypeTable) {
                    try {
                        this.currentTable.clearSelection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.currentTable = spectralTypeTable;
                String spt = (String)spectralTypeTable.getValueAt(spectralTypeTable.getSelectedRow(), 0);
                List<DistanceLookupResult> distanceResults = this.distanceLookupService.lookup(spt, catalogEntry.getBands());
                this.createDistanceEstimatesPanel(distanceResults, spt, color);
            }
        });
        JScrollPane spectralTypePanel = new JScrollPane(spectralTypeTable);
        spectralTypePanel.setToolTipText("Clicking on a table row displays photometric distance estimates for the specified spectral type.");
        spectralTypePanel.setMinimumSize(new Dimension(700, 75));
        spectralTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolboxHelper.html("M, L & T dwarfs spectral type estimates <span style='color:red'>&#9432;</span>"), 1, 2));
        return spectralTypePanel;
    }

    private void createDistanceEstimatesPanel(List<DistanceLookupResult> results, String spt, Color color) {
        ArrayList<String[]> distances = new ArrayList<String[]>();
        results.forEach(entry -> {
            String matchedBand = entry.getBandKey().val + "=" + NumericFunctions.roundTo3DecNZ(entry.getBandValue());
            Object distance = NumericFunctions.roundTo3Dec(entry.getDistance());
            if (entry.getDistanceError() > 0.0) {
                distance = (String)distance + "\u00b1" + NumericFunctions.roundTo3Dec(entry.getDistanceError());
            }
            String resutValues = (String)distance + "," + matchedBand;
            distances.add(resutValues.split(",", -1));
        });
        String titles = "distance (pc),matched bands";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        JTable distanceTable = new JTable((Object[][])distances.toArray((T[])rows), columns);
        ToolboxHelper.alignResultColumns(distanceTable, distances);
        distanceTable.setAutoCreateRowSorter(true);
        distanceTable.setAutoResizeMode(0);
        TableColumnModel columnModel = distanceTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(100);
        columnModel.getColumn(1).setPreferredWidth(100);
        JScrollPane distancePanel = new JScrollPane(distanceTable);
        distancePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Spectral type: " + spt, 1, 2));
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.setBorder(new LineBorder(color, 3));
        container.add(distancePanel);
        JFrame detailsFrame = new JFrame();
        detailsFrame.setDefaultCloseOperation(2);
        detailsFrame.addWindowListener(ToolboxHelper.getChildWindowAdapter(this.baseFrame));
        detailsFrame.setIconImage(ToolboxHelper.getToolBoxImage());
        detailsFrame.setTitle("Photometric distance estimates");
        detailsFrame.add(container);
        detailsFrame.setSize(500, 300);
        detailsFrame.setLocation(this.windowShift, this.windowShift);
        detailsFrame.setAlwaysOnTop(true);
        detailsFrame.setResizable(true);
        detailsFrame.setVisible(true);
        this.windowShift += 10;
    }

    private double getFovDiagonal() {
        return (double)this.size * this.pixelScale * Math.sqrt(2.0);
    }

    private double getOverlaySize() {
        return this.getOverlaySize(1);
    }

    private double getOverlaySize(int scale) {
        double factor = this.desiCutouts.isSelected() || this.ps1Cutouts.isSelected() ? 0.25 : 0.15;
        double overlaySize = (double)scale * factor * (double)this.zoom * Math.sqrt(this.size) / (double)this.size;
        return Math.max(5.0, Math.min(overlaySize, 15.0));
    }

    private int getNumberOfWiseEpochs() {
        return this.wiseviewCutouts.isSelected() ? 11 : 8;
    }

    public JCheckBox getBlurImages() {
        return this.blurImages;
    }

    public JCheckBox getUseCustomOverlays() {
        return this.useCustomOverlays;
    }

    public JComboBox getWiseBands() {
        return this.wiseBands;
    }

    public JTextField getCoordsField() {
        return this.coordsField;
    }

    public JTextField getSizeField() {
        return this.sizeField;
    }

    public JSlider getSpeedSlider() {
        return this.speedSlider;
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public JButton getStopDownloadButton() {
        return this.stopDownloadButton;
    }

    public JTextField getDifferentSizeField() {
        return this.differentSizeField;
    }

    public JTextField getProperMotionField() {
        return this.properMotionField;
    }

    public JRadioButton getWiseCoadds() {
        return this.unwiseCutouts;
    }

    public JRadioButton getDesiCutouts() {
        return this.desiCutouts;
    }

    public JRadioButton getPs1Cutouts() {
        return this.ps1Cutouts;
    }

    public JCheckBox getSkipIntermediateEpochs() {
        return this.skipIntermediateEpochs;
    }

    public JCheckBox getSimbadOverlay() {
        return this.simbadOverlay;
    }

    public JCheckBox getAllWiseOverlay() {
        return this.allWiseOverlay;
    }

    public JCheckBox getCatWiseOverlay() {
        return this.catWiseOverlay;
    }

    public JCheckBox getUnWiseOverlay() {
        return this.unWiseOverlay;
    }

    public JCheckBox getGaiaOverlay() {
        return this.gaiaOverlay;
    }

    public JCheckBox getGaiaDR3Overlay() {
        return this.gaiaDR3Overlay;
    }

    public JCheckBox getNoirlabOverlay() {
        return this.noirlabOverlay;
    }

    public JCheckBox getPanStarrsOverlay() {
        return this.panStarrsOverlay;
    }

    public JCheckBox getSdssOverlay() {
        return this.sdssOverlay;
    }

    public JCheckBox getVhsOverlay() {
        return this.vhsOverlay;
    }

    public JCheckBox getUhsOverlay() {
        return this.uhsOverlay;
    }

    public JCheckBox getUkidssOverlay() {
        return this.ukidssOverlay;
    }

    public JCheckBox getTwoMassOverlay() {
        return this.twoMassOverlay;
    }

    public JCheckBox getTessOverlay() {
        return this.tessOverlay;
    }

    public JCheckBox getDesOverlay() {
        return this.desOverlay;
    }

    public JCheckBox getGaiaWDOverlay() {
        return this.gaiaWDOverlay;
    }

    public JCheckBox getMocaOverlay() {
        return this.mocaOverlay;
    }

    public JTextField getPanstarrsField() {
        return this.panstarrsField;
    }

    public JTextField getAladinLiteField() {
        return this.aladinLiteField;
    }

    public JTextField getWiseViewField() {
        return this.wiseViewField;
    }

    public JTextField getFinderChartField() {
        return this.finderChartField;
    }

    public JButton getChangeFovButton() {
        return this.changeFovButton;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public List<FlipbookComponent> getFlipbook() {
        return this.flipbook;
    }

    public ImageViewerTab getImageViewer() {
        return this.imageViewer;
    }

    public void setImageViewer(ImageViewerTab imageViewer) {
        this.imageViewer = imageViewer;
    }

    public void setCustomOverlays(Map<String, CustomOverlay> customOverlays) {
        this.customOverlays = customOverlays;
    }

    public void setCollectionTable(JTable collectionTable) {
        this.collectionTable = collectionTable;
    }

    public void setQuadrantCount(int quadrantCount) {
        this.quadrantCount = quadrantCount;
    }

    public void setWiseBand(WiseBand wiseBand) {
        this.wiseBand = wiseBand;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setPixelScale(double pixelScale) {
        this.pixelScale = pixelScale;
    }

    public void setAsyncDownloads(boolean asyncDownloads) {
        this.asyncDownloads = asyncDownloads;
    }

    public void setPanstarrsImages(boolean panstarrsImages) {
        this.panstarrsImages = panstarrsImages;
    }

    public void setVhsImages(boolean vhsImages) {
        this.vhsImages = vhsImages;
    }

    public void setUhsImages(boolean uhsImages) {
        this.uhsImages = uhsImages;
    }

    public void setUkidssImages(boolean ukidssImages) {
        this.ukidssImages = ukidssImages;
    }

    public void setLegacyImages(boolean legacyImages) {
        this.legacyImages = legacyImages;
    }

    public void setSdssImages(boolean sdssImages) {
        this.sdssImages = sdssImages;
    }

    public void setDssImages(boolean dssImages) {
        this.dssImages = dssImages;
    }

    public void setWaitCursor(boolean waitCursor) {
        this.waitCursor = waitCursor;
    }
}

