/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.component.FixedTable;
import astro.tool.box.enumeration.LookupTable;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.Tab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public class LookupTab
implements Tab {
    public static final String TAB_NAME = "Photometric Relations";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private JPanel centerPanel;
    private JTable resultTable;

    public LookupTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new GridLayout(1, 1));
            mainPanel.add((Component)topPanel, "First");
            JPanel filePanel = new JPanel(new FlowLayout(0));
            topPanel.add(filePanel);
            filePanel.add(new JLabel("Relations table:"));
            JComboBox<LookupTable> lookupTables = new JComboBox<LookupTable>(LookupTable.values());
            filePanel.add(lookupTables);
            lookupTables.addActionListener(evt -> {
                String fileName = null;
                String tableName = null;
                switch ((LookupTable)((Object)((Object)lookupTables.getSelectedItem()))) {
                    case MAIN_SEQUENCE: {
                        fileName = "/SpectralTypeLookupTable.csv";
                        tableName = "Main sequence stars - A Modern Mean Dwarf Stellar Color & Effective Temperature Sequence (Eric Mamajek, version %s)".formatted("2022.04.16");
                        break;
                    }
                    case MLT_DWARFS: {
                        fileName = "/BrownDwarfLookupTable.csv";
                        tableName = "M, L & T dwarfs - Skrzypek et al. (2015), Skrzypek et al. (2016), Deacon et al. (2016), Best et al. (2018), Carnero Rosell et al. (2019) and Kiman et al. (2019)";
                        break;
                    }
                    case WHITE_DWARFS: {
                        fileName = "/WhiteDwarfLookupTable.csv";
                        tableName = "White dwarfs - Evolutionary cooling sequences from http://www.astro.umontreal.ca/~bergeron/CoolingModels (B\u00e9dard et al., 2020)";
                    }
                }
                this.removeAndRecreateCenterPanel(mainPanel);
                InputStream input = this.getClass().getResourceAsStream(fileName);
                this.readFileContents(input, tableName);
                this.baseFrame.setVisible(true);
            });
            lookupTables.setSelectedItem((Object)LookupTable.MAIN_SEQUENCE);
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, mainPanel);
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void readFileContents(InputStream input, String tableName) {
        try (Scanner scanner = new Scanner(input);){
            String[] columnNames = scanner.nextLine().split(",");
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",", -1);
                rows.add(columnValues);
            }
            this.displayQueryResults(columnNames, rows, tableName);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void displayQueryResults(String[] columnNames, List<String[]> rows, String tableName) {
        Object[][] data = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])rows.toArray((T[])data), columnNames);
        this.resultTable = new JTable(defaultTableModel);
        this.alignResultColumns(this.resultTable, rows);
        this.resultTable.setAutoCreateRowSorter(true);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setRowSorter(this.createResultTableSorter(defaultTableModel, rows));
        ToolboxHelper.resizeColumnWidth(this.resultTable);
        JScrollPane resultScrollPanel = new JScrollPane(this.resultTable);
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), tableName, 1, 2));
        FixedTable fixedTable = new FixedTable(1, resultScrollPanel);
        resultScrollPanel.getRowHeader().addChangeListener(fixedTable);
        this.centerPanel.add(resultScrollPanel);
    }

    private void alignResultColumns(JTable table, List<String[]> rows) {
        DefaultTableCellRenderer leftRenderer = new DefaultTableCellRenderer();
        leftRenderer.setHorizontalAlignment(2);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        rows.forEach(row -> {
            for (int i = 0; i < ((String[])row).length; ++i) {
                String columnValue = row[i];
                if (columnValue.isEmpty()) continue;
                DefaultTableCellRenderer cellRenderer = NumericFunctions.isInteger(columnValue) || NumericFunctions.isNumeric(columnValue) ? rightRenderer : leftRenderer;
                table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            }
        });
    }

    private TableRowSorter createResultTableSorter(DefaultTableModel defaultTableModel, List<String[]> rows) {
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(defaultTableModel);
        rows.forEach(row -> {
            for (int i = 0; i < ((String[])row).length; ++i) {
                sorter.setSortable(i, false);
            }
        });
        return sorter;
    }

    private void removeAndRecreateCenterPanel(JPanel mainPanel) {
        if (this.centerPanel != null) {
            mainPanel.remove(this.centerPanel);
        }
        this.centerPanel = new JPanel(new GridLayout(1, 1));
        mainPanel.add(this.centerPanel);
    }
}

