/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ObjectCollectionTab
implements Tab {
    public static final String TAB_NAME = "Object Collection";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryTab catalogQueryTab;
    private final ImageViewerTab imageViewerTab;
    private final TableRowSorter<TableModel> objectCollectionSorter;
    private JPanel centerPanel;
    private JTable resultTable;
    private JTextField searchField;
    private JCheckBox copyCoords;
    private int selectedRow;
    private File file;

    public ObjectCollectionTab(JFrame baseFrame, JTabbedPane tabbedPane, CatalogQueryTab catalogQueryTab, ImageViewerTab imageViewerTab) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryTab = catalogQueryTab;
        this.imageViewerTab = imageViewerTab;
        this.objectCollectionSorter = new TableRowSorter();
        this.objectCollectionSorter.setSortsOnUpdates(true);
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel topPanel = new JPanel(new FlowLayout(0));
            mainPanel.add((Component)topPanel, "First");
            JPanel bottomPanel = new JPanel(new FlowLayout(0));
            mainPanel.add((Component)bottomPanel, "Last");
            topPanel.add(new JLabel("Columns to add:"));
            JTextField addColumnsField = new JTextField(15);
            topPanel.add(addColumnsField);
            JLabel topPanelMessage = ToolboxHelper.createMessageLabel();
            JLabel bottomPanelMessage = ToolboxHelper.createMessageLabel();
            Timer timer = new Timer(3000, e -> {
                topPanelMessage.setText("");
                bottomPanelMessage.setText("");
            });
            JButton reloadButton = new JButton("Reload file");
            topPanel.add(reloadButton);
            reloadButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Object collection does not exist yet!");
                    return;
                }
                String confirmMessage = "Any unsaved changes will be lost!" + Constants.LINE_SEP + "Do you really want to reload file " + this.file.getName() + "?";
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, confirmMessage)) {
                    return;
                }
                this.removeAndRecreateCenterPanel(mainPanel);
                this.readFileContents(addColumnsField.getText());
                addColumnsField.setText("");
                topPanelMessage.setText("File reloaded!");
                timer.restart();
                this.baseFrame.setVisible(true);
            });
            JButton saveButton = new JButton("Save file");
            topPanel.add(saveButton);
            saveButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Object collection does not exist yet!");
                    return;
                }
                boolean hasFileBeenSaved = this.saveFile();
                if (hasFileBeenSaved) {
                    topPanelMessage.setText("File saved!");
                    timer.restart();
                }
            });
            topPanel.add(topPanelMessage);
            JButton addButton = new JButton("Add row");
            bottomPanel.add(addButton);
            addButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Object collection does not exist yet!");
                    return;
                }
                this.searchField.setText("");
                DefaultTableModel tableModel = (DefaultTableModel)this.resultTable.getModel();
                tableModel.addRow((Object[])null);
                bottomPanelMessage.setText("Row added!");
                timer.restart();
            });
            JButton deleteButton = new JButton("Delete selected row");
            bottomPanel.add(deleteButton);
            deleteButton.addActionListener(evt -> {
                if (this.file == null) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Object collection does not exist yet!");
                    return;
                }
                if (this.resultTable.getSelectedRow() == -1) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "No row selected yet!");
                    return;
                }
                int selected = this.resultTable.getSelectedRow();
                String confirmMessage = "Do you really want to delete row # " + String.valueOf(this.resultTable.getValueAt(selected, 0));
                if (!ToolboxHelper.showConfirmDialog(this.baseFrame, confirmMessage)) {
                    return;
                }
                DefaultTableModel tableModel = (DefaultTableModel)this.resultTable.getModel();
                int rowToDelete = this.resultTable.convertRowIndexToModel(selected);
                tableModel.removeRow(rowToDelete);
                boolean hasFileBeenSaved = this.saveFile();
                if (hasFileBeenSaved) {
                    bottomPanelMessage.setText("Row deleted!");
                    timer.restart();
                }
            });
            bottomPanel.add(bottomPanelMessage);
            bottomPanel.add(new JLabel("Search:"));
            this.searchField = new JTextField(30);
            bottomPanel.add(this.searchField);
            this.searchField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ObjectCollectionTab.this.objectCollectionSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(ObjectCollectionTab.this.searchField.getText()));
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ObjectCollectionTab.this.objectCollectionSorter.setRowFilter(ToolboxHelper.getCustomRowFilter(ObjectCollectionTab.this.searchField.getText()));
                }
            });
            this.copyCoords = new JCheckBox("Copy selected coordinates to the Image Viewer or Catalog Search tab");
            bottomPanel.add(this.copyCoords);
            this.tabbedPane.addChangeListener(evt -> {
                int index;
                JTabbedPane sourceTabbedPane = (JTabbedPane)evt.getSource();
                if (sourceTabbedPane.getTitleAt(index = sourceTabbedPane.getSelectedIndex()).equals(TAB_NAME)) {
                    if (this.file == null) {
                        String objectCollectionPath = SettingsTab.getUserSetting("objectCollectionPath");
                        if (objectCollectionPath == null || objectCollectionPath.isEmpty()) {
                            return;
                        }
                        File objectCollectionFile = new File(objectCollectionPath);
                        if (!objectCollectionFile.exists()) {
                            return;
                        }
                        this.file = objectCollectionFile;
                    } else {
                        this.saveFile();
                    }
                    this.removeAndRecreateCenterPanel(mainPanel);
                    this.readFileContents(addColumnsField.getText());
                    this.baseFrame.setVisible(true);
                }
            });
            this.baseFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ObjectCollectionTab.this.saveFile();
                }
            });
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(mainPanel));
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private boolean saveFile() {
        if (this.file != null) {
            boolean bl;
            int i;
            StringBuilder fileContent = new StringBuilder();
            TableModel model = this.resultTable.getModel();
            int columnCount = model.getColumnCount();
            for (i = 1; i < columnCount; ++i) {
                String columnName = model.getColumnName(i);
                this.appendCellValue(fileContent, i, columnCount, columnName);
            }
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int y = 1; y < columnCount; ++y) {
                    String cellValue = (String)model.getValueAt(i, y);
                    this.appendCellValue(fileContent, y, columnCount, cellValue);
                }
            }
            FileWriter writer = new FileWriter(this.file);
            try {
                writer.write(fileContent.toString());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            }
            writer.close();
            return bl;
        }
        return false;
    }

    private void appendCellValue(StringBuilder fileContent, int columnIndex, int columnCount, String cellValue) {
        if (cellValue != null) {
            fileContent.append(cellValue);
        }
        if (columnIndex < columnCount - 1) {
            fileContent.append(",");
        } else {
            fileContent.append(Constants.LINE_SEP);
        }
    }

    private void readFileContents(String columnsToAdd) {
        try (Scanner scanner = new Scanner(this.file);){
            String[] columnNames = scanner.nextLine().split(",");
            String[] newNames = columnsToAdd.split(",");
            int columnCount = newNames.length;
            if (columnCount == 1 && newNames[0].isEmpty()) {
                columnCount = 0;
            }
            Object valuesToAppend = "";
            for (int i = 1; i < columnCount; ++i) {
                valuesToAppend = (String)valuesToAppend + ",";
            }
            String[] newValues = ((String)valuesToAppend).split(",", -1);
            int rowNumber = 0;
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (scanner.hasNextLine()) {
                String[] columnValues = scanner.nextLine().split(",", -1);
                String[] values = ToolboxHelper.concatArrays(new String[]{String.valueOf(++rowNumber)}, columnValues);
                if (columnCount > 0) {
                    values = ToolboxHelper.concatArrays(values, newValues);
                }
                rows.add(values);
            }
            String[] names = ToolboxHelper.concatArrays(new String[]{"row#"}, columnNames);
            if (columnCount > 0) {
                names = ToolboxHelper.concatArrays(names, newNames);
            }
            this.displayQueryResults(names, rows);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void displayQueryResults(String[] columnNames, List<String[]> rows) {
        Object[][] data = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])rows.toArray((T[])data), columnNames);
        this.resultTable = new JTable(defaultTableModel);
        List<RowSorter.SortKey> sortKeys = this.objectCollectionSorter.getSortKeys();
        ToolboxHelper.alignResultColumns(this.resultTable, rows);
        ToolboxHelper.addComparatorsToTableSorter(this.objectCollectionSorter, defaultTableModel, rows);
        this.resultTable.setAutoCreateRowSorter(true);
        this.resultTable.setAutoResizeMode(0);
        this.resultTable.setRowSorter(this.objectCollectionSorter);
        this.resultTable.setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(e -> {
            int rowIndex = this.resultTable.getSelectedRow();
            if (rowIndex < 0) {
                return;
            }
            this.selectedRow = rowIndex;
            if (this.copyCoords.isSelected() && !e.getValueIsAdjusting() && this.selectedRow > -1 && this.selectedRow < this.resultTable.getRowCount()) {
                String ra = (String)this.resultTable.getValueAt(this.selectedRow, 4);
                String dec = (String)this.resultTable.getValueAt(this.selectedRow, 5);
                String coords = ra + " " + dec;
                this.imageViewerTab.getCoordsField().setText(coords);
                this.catalogQueryTab.getCoordsField().setText(coords);
                this.catalogQueryTab.getSearchLabel().setText("");
                this.catalogQueryTab.removeAndRecreateCenterPanel();
                this.catalogQueryTab.removeAndRecreateBottomPanel();
            }
        });
        ToolboxHelper.resizeColumnWidth(this.resultTable);
        this.objectCollectionSorter.setSortKeys(sortKeys);
        if (this.selectedRow >= 0) {
            try {
                this.resultTable.setRowSelectionInterval(this.selectedRow, this.selectedRow);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.imageViewerTab.setCollectionTable(this.resultTable);
        this.catalogQueryTab.setCollectionTable(this.resultTable);
        JScrollPane resultScrollPanel = new JScrollPane(this.resultTable);
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.file.getName(), 1, 2));
        this.centerPanel.add(resultScrollPanel);
        Rectangle rectangle = this.resultTable.getCellRect(this.selectedRow, 0, true);
        this.resultTable.scrollRectToVisible(rectangle);
    }

    private void removeAndRecreateCenterPanel(JPanel mainPanel) {
        if (this.centerPanel != null) {
            mainPanel.remove(this.centerPanel);
        }
        this.centerPanel = new JPanel(new GridLayout(1, 1));
        mainPanel.add(this.centerPanel);
    }
}

