/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.AllWiseCatalogEntry;
import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.catalog.SimbadCatalogEntry;
import astro.tool.box.catalog.WhiteDwarf;
import astro.tool.box.container.ClassificationResult;
import astro.tool.box.container.ClassifierData;
import astro.tool.box.container.NumberPair;
import astro.tool.box.container.SpectralType;
import astro.tool.box.enumeration.JColor;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.lookup.BrownDwarfLookupEntry;
import astro.tool.box.lookup.LookupResult;
import astro.tool.box.lookup.SpectralTypeLookup;
import astro.tool.box.lookup.SpectralTypeLookupEntry;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.service.CatalogQueryService;
import astro.tool.box.service.SpectralTypeLookupService;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.SettingsTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Comparators;
import astro.tool.box.util.Constants;
import astro.tool.box.util.MiscUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class PhotometricClassifierTab
implements Tab {
    public static final String TAB_NAME = "Photometric Classifier";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryTab catalogQueryTab;
    private final ImageViewerTab imageViewerTab;
    private final Map<String, CatalogEntry> catalogInstances;
    private final CatalogQueryService catalogQueryService;
    private final SpectralTypeLookupService mainSequenceLookupService;
    private final SpectralTypeLookupService brownDwarfsLookupService;
    private JPanel mainPanel;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JButton searchButton;
    private JTextField coordsField;
    private JTextField radiusField;
    private JTable mainSequenceResultTable;
    private JTable brownDwarfsResultTable;
    private double targetRa;
    private double targetDec;
    private double searchRadius;
    private double prevTargetRa;
    private double prevTargetDec;
    private double prevSearchRadius;
    private Set<String> matchedColors;
    private Map<String, Integer> sptOccurrencesMainSequence;
    private Map<String, Integer> sptOccurrencesBrownDwarfs;
    private Map<String, Integer> sptOccurrencesSimbad;
    private List<CatalogEntry> catalogEntries;
    private List<ClassifierData> classifierListMainSequence;
    private List<ClassifierData> classifierListBrownDwarfs;

    public PhotometricClassifierTab(JFrame baseFrame, JTabbedPane tabbedPane, CatalogQueryTab catalogQueryTab, ImageViewerTab imageViewerTab) {
        List<SpectralTypeLookup> entries;
        Stream<String> stream;
        InputStream input;
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryTab = catalogQueryTab;
        this.imageViewerTab = imageViewerTab;
        this.catalogInstances = ToolboxHelper.getCatalogInstances();
        this.catalogInstances.remove("Gaia DR2");
        this.catalogInstances.remove("Gaia EDR3 WD");
        this.catalogInstances.remove("TESS Input Catalog");
        this.catalogQueryService = new CatalogQueryService();
        try {
            input = this.getClass().getResourceAsStream("/SpectralTypeLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                entries = stream.skip(1L).map(line -> new SpectralTypeLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.mainSequenceLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
        try {
            input = this.getClass().getResourceAsStream("/BrownDwarfLookupTable.csv");
            try {
                stream = new BufferedReader(new InputStreamReader(input)).lines();
                entries = stream.skip(1L).map(line -> new BrownDwarfLookupEntry(line.split(",", -1))).collect(Collectors.toList());
                this.brownDwarfsLookupService = new SpectralTypeLookupService(entries);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            ToolboxHelper.showExceptionDialog(baseFrame, e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(boolean visible) {
        try {
            this.mainPanel = new JPanel(new BorderLayout());
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(this.mainPanel));
            }
            this.topPanel = new JPanel(new FlowLayout(0));
            this.mainPanel.add((Component)this.topPanel, "First");
            this.centerPanel = new JPanel(new GridLayout(2, 1));
            this.mainPanel.add((Component)this.centerPanel, "Center");
            this.bottomPanel = new JPanel(new FlowLayout(0));
            this.mainPanel.add((Component)this.bottomPanel, "Last");
            JLabel coordsLabel = new JLabel("Coordinates:");
            this.topPanel.add(coordsLabel);
            this.coordsField = new JTextField(25);
            this.topPanel.add(this.coordsField);
            JLabel radiusLabel = new JLabel("Search radius (arcsec):");
            this.topPanel.add(radiusLabel);
            this.radiusField = new JTextField(5);
            this.topPanel.add(this.radiusField);
            this.radiusField.setText("5");
            this.searchButton = new JButton("Classify");
            this.topPanel.add(this.searchButton);
            this.searchButton.addActionListener(e -> {
                try {
                    this.bottomPanel.removeAll();
                    this.baseFrame.setVisible(true);
                    String coords = this.coordsField.getText();
                    if (coords.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Coordinates must not be empty!");
                        return;
                    }
                    String radius = this.radiusField.getText();
                    if (radius.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Search radius must not be empty!");
                        return;
                    }
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    try {
                        NumberPair coordinates = ToolboxHelper.getCoordinates(coords);
                        this.targetRa = coordinates.getX();
                        this.targetDec = coordinates.getY();
                        if (this.targetRa < 0.0) {
                            errorMessages.add("RA must not be smaller than 0 deg.");
                        }
                        if (this.targetRa > 360.0) {
                            errorMessages.add("RA must not be greater than 360 deg.");
                        }
                        if (this.targetDec < -90.0) {
                            errorMessages.add("Dec must not be smaller than -90 deg.");
                        }
                        if (this.targetDec > 90.0) {
                            errorMessages.add("Dec must not be greater than 90 deg.");
                        }
                    }
                    catch (Exception ex) {
                        this.targetRa = 0.0;
                        this.targetDec = 0.0;
                        errorMessages.add("Invalid coordinates!");
                    }
                    try {
                        this.searchRadius = Double.parseDouble(radius);
                        if (this.searchRadius < 0.0) {
                            errorMessages.add("Radius must not be smaller than 0.");
                        }
                        if (this.searchRadius > 100.0) {
                            errorMessages.add("Radius must not be larger than 100 arcsec.");
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.searchRadius = 0.0;
                        errorMessages.add("Invalid radius!");
                    }
                    if (!errorMessages.isEmpty()) {
                        String message = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                        ToolboxHelper.showErrorDialog(this.baseFrame, message);
                    } else {
                        if (!ToolboxHelper.isSameTarget(this.targetRa, this.targetDec, this.searchRadius, this.prevTargetRa, this.prevTargetDec, this.prevSearchRadius)) {
                            this.centerPanel.removeAll();
                            this.baseFrame.setVisible(true);
                        }
                        CompletableFuture.supplyAsync(() -> {
                            try {
                                this.setWaitCursor();
                                this.matchedColors = new HashSet<String>();
                                this.sptOccurrencesMainSequence = new HashMap<String, Integer>();
                                this.sptOccurrencesBrownDwarfs = new HashMap<String, Integer>();
                                this.sptOccurrencesSimbad = new HashMap<String, Integer>();
                                this.classifierListMainSequence = new ArrayList<ClassifierData>();
                                this.classifierListBrownDwarfs = new ArrayList<ClassifierData>();
                                if (ToolboxHelper.isSameTarget(this.targetRa, this.targetDec, this.searchRadius, this.prevTargetRa, this.prevTargetDec, this.prevSearchRadius)) {
                                    this.performSpectralTypeLookup(this.mainSequenceLookupService, this.catalogEntries, this.sptOccurrencesMainSequence, this.classifierListMainSequence, this.mainSequenceResultTable);
                                    this.performSpectralTypeLookup(this.brownDwarfsLookupService, this.catalogEntries, this.sptOccurrencesBrownDwarfs, this.classifierListBrownDwarfs, this.brownDwarfsResultTable);
                                } else {
                                    this.catalogEntries = new ArrayList<CatalogEntry>();
                                    List<String> selectedCatalogs = SettingsTab.getSelectedCatalogs(this.catalogInstances);
                                    for (CatalogEntry catalogEntry : this.catalogInstances.values()) {
                                        if (!selectedCatalogs.contains(catalogEntry.getCatalogName())) continue;
                                        catalogEntry.setRa(this.targetRa);
                                        catalogEntry.setDec(this.targetDec);
                                        catalogEntry.setSearchRadius(this.searchRadius);
                                        List<CatalogEntry> results = this.performQuery(catalogEntry);
                                        if (results == null) continue;
                                        this.catalogEntries.addAll(results);
                                    }
                                    this.prevTargetRa = this.targetRa;
                                    this.prevTargetDec = this.targetDec;
                                    this.prevSearchRadius = this.searchRadius;
                                    List<ClassificationResult> classificationResults = this.performSpectralTypeLookup(this.mainSequenceLookupService, this.catalogEntries, this.sptOccurrencesMainSequence, this.classifierListMainSequence, null);
                                    this.mainSequenceResultTable = this.displayQueryResults(classificationResults, "Main sequence spectral type estimates", JColor.DARK_GREEN.val);
                                    classificationResults = this.performSpectralTypeLookup(this.brownDwarfsLookupService, this.catalogEntries, this.sptOccurrencesBrownDwarfs, this.classifierListBrownDwarfs, null);
                                    this.brownDwarfsResultTable = this.displayQueryResults(classificationResults, "M, L & T dwarfs spectral type estimates", JColor.BROWN.val);
                                }
                                this.displayClassification(this.sptOccurrencesMainSequence, "Photometric classification: Main sequence", JColor.DARK_GREEN.val);
                                this.displayClassification(this.sptOccurrencesBrownDwarfs, "Photometric classification: M, L & T dwarfs", JColor.BROWN.val);
                                this.displayClassifierData(this.classifierListMainSequence, "Colors used for classification: Main sequence", JColor.DARK_GREEN.val);
                                this.displayClassifierData(this.classifierListBrownDwarfs, "Colors used for classification: M, L & T dwarfs", JColor.BROWN.val);
                                if (!this.sptOccurrencesSimbad.isEmpty()) {
                                    this.displayClassification(this.sptOccurrencesSimbad, "SIMBAD object type", Color.RED);
                                }
                                this.baseFrame.setVisible(true);
                            }
                            catch (Exception ex) {
                                ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                            }
                            finally {
                                this.setDefaultCursor();
                            }
                            return null;
                        });
                    }
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            this.coordsField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.radiusField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void setWaitCursor() {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.coordsField.setCursor(Cursor.getPredefinedCursor(3));
        this.radiusField.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.baseFrame.setCursor(Cursor.getDefaultCursor());
        this.coordsField.setCursor(Cursor.getPredefinedCursor(2));
        this.radiusField.setCursor(Cursor.getPredefinedCursor(2));
    }

    private List<CatalogEntry> performQuery(CatalogEntry catalogQuery) throws IOException {
        List<CatalogEntry> entries = this.catalogQueryService.getCatalogEntriesByCoords(catalogQuery);
        entries.forEach(catalogEntry -> {
            catalogEntry.setTargetRa(catalogQuery.getRa());
            catalogEntry.setTargetDec(catalogQuery.getDec());
        });
        if (!entries.isEmpty()) {
            entries.sort(Comparator.comparingDouble(CatalogEntry::getTargetDistance));
            return entries;
        }
        return null;
    }

    private List<ClassificationResult> performSpectralTypeLookup(SpectralTypeLookupService spectralTypeLookupService, List<CatalogEntry> catalogEntries, Map<String, Integer> sptOccurrences, List<ClassifierData> classifierList, JTable resultTable) throws Exception {
        ArrayList<ClassificationResult> classificationResults = new ArrayList<ClassificationResult>();
        for (CatalogEntry catalogEntry : catalogEntries) {
            String spectralType;
            Object entry2;
            String catalogName = catalogEntry.getCatalogName();
            String sourceId = catalogEntry.getSourceId();
            List<LookupResult> results = spectralTypeLookupService.lookup(catalogEntry.getColors(true));
            ArrayList<String> spectralTypes = new ArrayList<String>();
            results.forEach(entry -> {
                String colorKey = entry.getColorKey().val;
                String colorValue = NumericFunctions.roundTo3Dec(entry.getColorValue());
                String nearest = NumericFunctions.roundTo3Dec(entry.getNearest());
                String matchedColor = colorKey + "=" + colorValue;
                Object spectralType = entry.getSpt();
                this.addOccurrence(new ClassifierData(catalogName, colorKey, colorValue, (String)spectralType, nearest, sourceId), sptOccurrences, classifierList, resultTable);
                spectralType = (String)spectralType + ": " + matchedColor + "; ";
                spectralTypes.add((String)spectralType);
            });
            if (catalogEntry instanceof SimbadCatalogEntry) {
                SimbadCatalogEntry simbadEntry = (SimbadCatalogEntry)catalogEntry;
                StringBuilder simbadType = new StringBuilder();
                simbadType.append(simbadEntry.getObjectType());
                String spectralType2 = simbadEntry.getSpectralType();
                if (!spectralType2.isEmpty()) {
                    simbadType.append(": ").append(spectralType2);
                }
                this.sptOccurrencesSimbad.put(simbadType.toString(), 1);
                simbadType.append("; ");
                spectralTypes.add(0, simbadType.toString());
            }
            if (catalogEntry instanceof AllWiseCatalogEntry && PhotometricFunctions.isAPossibleAGN(((AllWiseCatalogEntry)(entry2 = (AllWiseCatalogEntry)catalogEntry)).getW1_W2(), ((AllWiseCatalogEntry)entry2).getW2_W3())) {
                spectralType = "Possible AGN!";
                this.addOccurrence(new ClassifierData(catalogName, spectralType, sourceId), sptOccurrences, classifierList, resultTable);
                spectralTypes.add(spectralType);
            }
            if (catalogEntry instanceof WhiteDwarf && PhotometricFunctions.isAPossibleWD((entry2 = (WhiteDwarf)((Object)catalogEntry)).getAbsoluteGmag(), entry2.getBP_RP())) {
                spectralType = "Possible white dwarf!";
                this.addOccurrence(new ClassifierData(catalogName, spectralType, sourceId), sptOccurrences, classifierList, resultTable);
                spectralTypes.add(spectralType);
            }
            ClassificationResult classificationResult = new ClassificationResult.Builder().setCatalogName(catalogEntry.getCatalogName()).setTargetRa(this.targetRa).setTargetDec(this.targetDec).setTargetDistance(catalogEntry.getTargetDistance()).setRa(catalogEntry.getRa()).setDec(catalogEntry.getDec()).setSourceId(catalogEntry.getSourceId() + " ").setPlx(catalogEntry.getPlx()).setPmra(catalogEntry.getPmra()).setPmdec(catalogEntry.getPmdec()).setMagnitudes(catalogEntry.getMagnitudes()).setSpectralTypes(spectralTypes).build();
            classificationResults.add(classificationResult);
        }
        return classificationResults;
    }

    private JTable displayQueryResults(List<ClassificationResult> classificationResults, String title, Color borderColor) {
        ArrayList resultRows = new ArrayList();
        classificationResults.forEach(entry -> resultRows.add(MiscUtils.addToArray(new Boolean[]{Boolean.FALSE}, entry.getColumnValues())));
        ClassificationResult result = classificationResults.get(0);
        Object[] columns = MiscUtils.addToArray(new String[]{"Remove from classification"}, result.getColumnTitles());
        Object[][] array = new Object[][]{};
        final Object[][] rows = (Object[][])resultRows.toArray((T[])array);
        DefaultTableModel defaultTableModel = new DefaultTableModel(rows, columns);
        JTable resultTable = new JTable(defaultTableModel){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return rows[0][columnIndex].getClass();
            }
        };
        resultTable.setAutoCreateRowSorter(true);
        resultTable.setAutoResizeMode(0);
        resultTable.setSelectionMode(0);
        resultTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                String sourceId = (String)resultTable.getValueAt(resultTable.getSelectedRow(), 7);
                ClassificationResult selected = classificationResults.stream().filter(entry -> entry.getSourceId().equals(sourceId)).findFirst().get();
                if (selected != null) {
                    String coords = NumericFunctions.roundTo7DecNZLZ(selected.getRa()) + " " + NumericFunctions.roundTo7DecNZLZ(selected.getDec());
                    this.imageViewerTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getCoordsField().setText(coords);
                    this.catalogQueryTab.getRadiusField().setText(NumericFunctions.roundTo2DecNZ(this.searchRadius));
                    this.catalogQueryTab.getSearchLabel().setText("");
                    this.catalogQueryTab.removeAndRecreateCenterPanel();
                    this.catalogQueryTab.removeAndRecreateBottomPanel();
                }
            }
        });
        ToolboxHelper.resizeColumnWidth(resultTable, 300);
        TableColumnModel columnModel = resultTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(150);
        DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
        rightRenderer.setHorizontalAlignment(4);
        columnModel.getColumn(4).setCellRenderer(rightRenderer);
        columnModel.getColumn(8).setCellRenderer(rightRenderer);
        columnModel.getColumn(9).setCellRenderer(rightRenderer);
        columnModel.getColumn(10).setCellRenderer(rightRenderer);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(defaultTableModel);
        sorter.setComparator(4, Comparators.getDoubleComparator());
        sorter.setComparator(8, Comparators.getDoubleComparator());
        sorter.setComparator(9, Comparators.getDoubleComparator());
        sorter.setComparator(10, Comparators.getDoubleComparator());
        JScrollPane resultScrollPanel = new JScrollPane(resultTable);
        resultScrollPanel.setPreferredSize(new Dimension(resultScrollPanel.getWidth(), resultScrollPanel.getHeight()));
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(borderColor, 2), title, 1, 2));
        this.centerPanel.add(resultScrollPanel);
        return resultTable;
    }

    private void displayClassification(Map<String, Integer> sptOccurrences, String title, Color borderColor) {
        ArrayList<SpectralType> spectralTypes = new ArrayList<SpectralType>();
        sptOccurrences.entrySet().forEach(entry -> {
            Double sptNum = MiscUtils.SPECTRAL_TYPES.get(entry.getKey());
            spectralTypes.add(new SpectralType((String)entry.getKey(), (Integer)entry.getValue(), sptNum == null ? -1.0 : sptNum));
        });
        spectralTypes.sort(Comparator.comparing(SpectralType::getOccurrences, Comparator.reverseOrder()).thenComparing(SpectralType::getSptNum));
        ArrayList<String[]> occurrences = new ArrayList<String[]>();
        spectralTypes.forEach(spectralType -> occurrences.add(new String[]{spectralType.getOccurrences().toString(), spectralType.getSpt()}));
        String titles = "occurrences,spectral type";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])occurrences.toArray((T[])rows), columns);
        JTable resultTable = new JTable(defaultTableModel);
        ToolboxHelper.alignResultColumns(resultTable, occurrences);
        resultTable.setAutoCreateRowSorter(true);
        resultTable.setAutoResizeMode(0);
        resultTable.setRowSorter(ToolboxHelper.createResultTableSorter(defaultTableModel, occurrences));
        TableColumnModel columnModel = resultTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(75);
        columnModel.getColumn(1).setPreferredWidth(195);
        JScrollPane resultScrollPanel = occurrences.isEmpty() ? new JScrollPane(ToolboxHelper.createLabel("No colors available / No match", JColor.RED)) : new JScrollPane(resultTable);
        resultScrollPanel.setPreferredSize(new Dimension(300, 300));
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(borderColor, 2), title, 1, 2));
        this.bottomPanel.add(resultScrollPanel);
    }

    private void displayClassifierData(List<ClassifierData> classifierList, String title, Color borderColor) {
        classifierList.forEach(entry -> {
            Double sptNum = MiscUtils.SPECTRAL_TYPES.get(entry.getSpectralType());
            entry.setSptNum(sptNum == null ? -1.0 : sptNum);
        });
        classifierList.sort(Comparator.comparing(ClassifierData::getCatalog, Comparator.naturalOrder()).thenComparing(ClassifierData::getSptNum));
        ArrayList<String[]> occurrences = new ArrayList<String[]>();
        classifierList.forEach(classifierData -> occurrences.add(new String[]{classifierData.getCatalog(), classifierData.getSpectralType(), classifierData.getColorKey(), classifierData.getColorValue(), classifierData.getReferenceColor(), classifierData.getSourceId()}));
        String titles = "catalog,spectral type,color,value,reference value,source id";
        Object[] columns = titles.split(",", -1);
        Object[][] rows = new Object[][]{};
        DefaultTableModel defaultTableModel = new DefaultTableModel((Object[][])occurrences.toArray((T[])rows), columns);
        JTable resultTable = new JTable(defaultTableModel);
        ToolboxHelper.alignResultColumns(resultTable, occurrences);
        resultTable.setAutoCreateRowSorter(true);
        resultTable.setAutoResizeMode(0);
        resultTable.setRowSorter(ToolboxHelper.createResultTableSorter(defaultTableModel, occurrences));
        TableColumnModel columnModel = resultTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(120);
        columnModel.getColumn(2).setPreferredWidth(80);
        columnModel.getColumn(4).setPreferredWidth(100);
        columnModel.getColumn(5).setPreferredWidth(150);
        JScrollPane resultScrollPanel = occurrences.isEmpty() ? new JScrollPane(ToolboxHelper.createLabel("No data available", JColor.RED)) : new JScrollPane(resultTable);
        resultScrollPanel.setPreferredSize(new Dimension(400, 300));
        resultScrollPanel.setBorder(BorderFactory.createTitledBorder(new LineBorder(borderColor, 2), title, 1, 2));
        this.bottomPanel.add(resultScrollPanel);
    }

    private void addOccurrence(ClassifierData classifierData, Map<String, Integer> sptOccurrences, List<ClassifierData> classifierList, JTable resultTable) {
        if (resultTable != null) {
            for (int i = 0; i < resultTable.getRowCount(); ++i) {
                String sourceId = (String)resultTable.getValueAt(i, 7);
                Boolean remove = (Boolean)resultTable.getValueAt(i, 0);
                if (!classifierData.getSourceId().equals(sourceId.trim()) || !remove.booleanValue()) continue;
                return;
            }
        }
        String matchedColor = classifierData.getColorKey() + classifierData.getColorValue() + classifierData.getSpectralType();
        String spectralType = classifierData.getSpectralType();
        if (this.matchedColors.contains(matchedColor)) {
            return;
        }
        Integer occurrences = sptOccurrences.get(spectralType);
        sptOccurrences.put(spectralType, occurrences == null ? 1 : occurrences + 1);
        this.matchedColors.add(matchedColor);
        classifierList.add(classifierData);
    }
}

