/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.catalog.CatalogEntry;
import astro.tool.box.enumeration.LookAndFeel;
import astro.tool.box.enumeration.TabCode;
import astro.tool.box.enumeration.TapProvider;
import astro.tool.box.enumeration.WiseBand;
import astro.tool.box.main.Application;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.panel.DualListBox;
import astro.tool.box.tab.BatchQueryTab;
import astro.tool.box.tab.CatalogQueryTab;
import astro.tool.box.tab.ImageViewerTab;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.intellijthemes.FlatNordIJTheme;
import com.formdev.flatlaf.intellijthemes.materialthemeuilite.FlatMoonlightIJTheme;
import com.formdev.flatlaf.intellijthemes.materialthemeuilite.FlatNightOwlIJTheme;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SettingsTab
implements Tab {
    public static final String TAB_NAME = "Settings";
    public static final String COMMENTS = "User settings";
    public static final String RESTART_LABEL = "Restarts after pushing 'Apply settings'";
    public static final String PROP_FILE_NAME = "/AstroToolBox.properties";
    public static final String PROP_PATH = ToolboxHelper.USER_HOME + "/AstroToolBox.properties";
    public static final Properties USER_SETTINGS = new Properties();
    public static String DEFAULT_TAP_PROVIDER = TapProvider.VIZIER.name();
    public static String DEFAULT_LOOK_AND_FEEL = LookAndFeel.Flat_Light.name();
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private final CatalogQueryTab catalogQueryTab;
    private final ImageViewerTab imageViewerTab;
    private final BatchQueryTab batchQueryTab;
    public static final String LOOK_AND_FEEL = "lookAndFeel";
    public static final String TAP_PROVIDER = "tapProvider";
    public static final String PROXY_ADDRESS = "proxyAddress";
    public static final String PROXY_PORT = "proxyPort";
    public static final String USE_PROXY = "useProxy";
    public static final String USE_SIMBAD_MIRROR = "useSimbadMirror";
    public static final String PHOTOMETRIC_ERRORS = "photometricErrors";
    public static final String CUTOUT_SERVICE = "cutoutService";
    public static final String OBJECT_COLLECTION_PATH = "objectCollectionPath";
    private LookAndFeel lookAndFeel;
    private TapProvider tapProvider;
    private String proxyAddress;
    private int proxyPort;
    private boolean useProxy;
    private boolean useSimbadMirror;
    private boolean photometricErrors;
    private String cutoutService;
    private String objectCollectionPath;
    private static final String COPY_COORDS_TO_CLIPBOARD = "copyCoordsToClipboard";
    private static final String SEARCH_RADIUS = "searchRadius";
    private static final String USER_NAME = "userName";
    private static final String USER_EMAIL = "userEmail";
    public static final String PANSTARRS_FOV = "panstarrsFOV";
    public static final String ALADIN_LITE_FOV = "aladinLiteFOV";
    public static final String WISE_VIEW_FOV = "wiseViewFOV";
    public static final String FINDER_CHART_FOV = "finderChartFOV";
    private boolean copyCoordsToClipboard;
    private int searchRadius;
    private int panstarrsFOV;
    private int aladinLiteFOV;
    private int wiseViewFOV;
    private int finderChartFOV;
    private static final String WISE_BAND = "wiseBand";
    private static final String SIZE = "imageSize";
    private static final String SPEED = "speed";
    private static final String ZOOM = "zoom";
    private static final String DIFFERENT_SIZE = "differentSize";
    private static final String PROPER_MOTION = "properMotion";
    public static final String NEAREST_BYW_SUBJECTS = "nearestBywSubjects";
    private static final String ASYNC_DOWNLOADS = "asyncDownloads";
    private static final String LEGACY_IMAGES = "legacyImages";
    private static final String PANSTARRS_IMAGES = "panstarrsImages";
    private static final String VHS_IMAGES = "vhsImages";
    private static final String UHS_IMAGES = "uhsImages";
    private static final String UKIDSS_IMAGES = "ukidssImages";
    private static final String SDSS_IMAGES = "sdssImages";
    private static final String DSS_IMAGES = "dssImages";
    private WiseBand wiseBand;
    private int size;
    private int speed;
    private int zoom;
    private int differentSize;
    private int properMotion;
    private boolean nearestBywSubjects;
    private boolean asyncDownloads;
    private boolean legacyImages;
    private boolean panstarrsImages;
    private boolean vhsImages;
    private boolean uhsImages;
    private boolean ukidssImages;
    private boolean sdssImages;
    private boolean dssImages;
    private static final String CATALOGS = "catalogs";
    private List<String> selectedCatalogs;
    private JPanel catalogPanel;
    public static final String SOURCE_TABS = "sourceTabs";
    public static final String DEST_TABS = "destTabs";
    private ActionListener actionListener;
    private JComboBox wiseBandsBox;

    public SettingsTab(JFrame baseFrame, JTabbedPane tabbedPane, CatalogQueryTab catalogQueryTab, ImageViewerTab imageViewerTab, BatchQueryTab batchQueryTab) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
        this.catalogQueryTab = catalogQueryTab;
        this.imageViewerTab = imageViewerTab;
        this.batchQueryTab = batchQueryTab;
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel settingsPanel = new JPanel(new BorderLayout());
            JPanel containerPanel = new JPanel(new FlowLayout(0));
            settingsPanel.add((Component)containerPanel, "First");
            int panelHeight = 360;
            int gridRows = 12;
            JPanel globalSettings = new JPanel(new GridLayout(gridRows, 2));
            globalSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Global Settings", 1, 2));
            globalSettings.setPreferredSize(new Dimension(475, panelHeight));
            containerPanel.add(globalSettings);
            this.lookAndFeel = LookAndFeel.valueOf(USER_SETTINGS.getProperty(LOOK_AND_FEEL, DEFAULT_LOOK_AND_FEEL));
            this.tapProvider = TapProvider.valueOf(USER_SETTINGS.getProperty(TAP_PROVIDER, DEFAULT_TAP_PROVIDER));
            this.proxyAddress = USER_SETTINGS.getProperty(PROXY_ADDRESS, "");
            String port = USER_SETTINGS.getProperty(PROXY_PORT, "0");
            this.proxyPort = port.isEmpty() ? 0 : Integer.parseInt(port);
            this.useProxy = Boolean.parseBoolean(USER_SETTINGS.getProperty(USE_PROXY, "false"));
            this.useSimbadMirror = Boolean.parseBoolean(USER_SETTINGS.getProperty(USE_SIMBAD_MIRROR, "false"));
            this.photometricErrors = Boolean.parseBoolean(USER_SETTINGS.getProperty(PHOTOMETRIC_ERRORS, "false"));
            this.cutoutService = USER_SETTINGS.getProperty(CUTOUT_SERVICE);
            this.objectCollectionPath = USER_SETTINGS.getProperty(OBJECT_COLLECTION_PATH, "");
            globalSettings.add(new JLabel("Look & Feel: ", 4));
            JComboBox<LookAndFeel> themes = new JComboBox<LookAndFeel>(LookAndFeel.values());
            themes.setSelectedItem((Object)this.lookAndFeel);
            globalSettings.add(themes);
            globalSettings.add(new JLabel("TAP provider for AllWISE, CatWISE, ", 4));
            globalSettings.add(new JLabel());
            globalSettings.add(new JLabel("2MASS, Gaia, DES and VHS: ", 4));
            JPanel radioPanel = new JPanel(new GridLayout(1, 2));
            globalSettings.add(radioPanel);
            boolean isVizierTap = this.tapProvider.equals((Object)TapProvider.VIZIER);
            boolean isNoaoTap = this.tapProvider.equals((Object)TapProvider.NOIRLAB);
            if (!isVizierTap && !isNoaoTap) {
                isNoaoTap = true;
            }
            JRadioButton vizierButton = new JRadioButton("VizieR", isVizierTap);
            radioPanel.add(vizierButton);
            JRadioButton noirlabButton = new JRadioButton("Other", isNoaoTap);
            radioPanel.add(noirlabButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(vizierButton);
            buttonGroup.add(noirlabButton);
            globalSettings.add(new JLabel("Proxy host name: ", 4));
            JTextField proxyAddressField = new JTextField(this.proxyAddress);
            globalSettings.add(proxyAddressField);
            globalSettings.add(new JLabel("Proxy port: ", 4));
            JTextField proxyPortField = new JTextField(String.valueOf(this.proxyPort));
            globalSettings.add(proxyPortField);
            globalSettings.add(new JLabel("Use proxy: ", 4));
            JCheckBox useProxyCheckBox = new JCheckBox();
            useProxyCheckBox.setSelected(this.useProxy);
            globalSettings.add(useProxyCheckBox);
            globalSettings.add(new JLabel("Use SIMBAD mirror: ", 4));
            JCheckBox useSimbadMirrorCheckBox = new JCheckBox();
            useSimbadMirrorCheckBox.setSelected(this.useSimbadMirror);
            globalSettings.add(useSimbadMirrorCheckBox);
            globalSettings.add(new JLabel("Consider phot. errors in SpT estimates: ", 4));
            JCheckBox photometricErrorsBox = new JCheckBox(ToolboxHelper.html("<span color='red'>Restarts after pushing 'Apply settings'</span>"));
            photometricErrorsBox.setSelected(this.photometricErrors);
            globalSettings.add(photometricErrorsBox);
            globalSettings.add(new JLabel("WiseView cutout service URL: ", 4));
            JTextField cutoutServiceField = new JTextField(this.cutoutService);
            globalSettings.add(cutoutServiceField);
            globalSettings.add(new JLabel("File location of object collection (*): ", 4));
            JTextField collectionPathField = new JTextField(this.objectCollectionPath);
            globalSettings.add(collectionPathField);
            globalSettings.add(new JLabel("(*) The file will be created by the tool. ", 4));
            globalSettings.add(new JLabel("Example: C:/Folder/MyCollection.csv", 2));
            JPanel catalogQuerySettings = new JPanel(new GridLayout(gridRows, 2));
            catalogQuerySettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Miscellaneous settings", 1, 2));
            catalogQuerySettings.setPreferredSize(new Dimension(350, panelHeight));
            containerPanel.add(catalogQuerySettings);
            this.copyCoordsToClipboard = Boolean.parseBoolean(USER_SETTINGS.getProperty(COPY_COORDS_TO_CLIPBOARD, "true"));
            this.searchRadius = Integer.parseInt(USER_SETTINGS.getProperty(SEARCH_RADIUS, "10"));
            this.panstarrsFOV = Integer.parseInt(USER_SETTINGS.getProperty(PANSTARRS_FOV, "30"));
            this.aladinLiteFOV = Integer.parseInt(USER_SETTINGS.getProperty(ALADIN_LITE_FOV, "300"));
            this.wiseViewFOV = Integer.parseInt(USER_SETTINGS.getProperty(WISE_VIEW_FOV, "100"));
            this.finderChartFOV = Integer.parseInt(USER_SETTINGS.getProperty(FINDER_CHART_FOV, "100"));
            String userName = USER_SETTINGS.getProperty(USER_NAME, "");
            String userEmail = USER_SETTINGS.getProperty(USER_EMAIL, "");
            this.catalogQueryTab.getRadiusField().setText(String.valueOf(this.searchRadius));
            this.catalogQueryTab.setCopyCoordsToClipboard(this.copyCoordsToClipboard);
            this.imageViewerTab.getPanstarrsField().setText(String.valueOf(this.panstarrsFOV));
            this.imageViewerTab.getAladinLiteField().setText(String.valueOf(this.aladinLiteFOV));
            this.imageViewerTab.getWiseViewField().setText(String.valueOf(this.wiseViewFOV));
            this.imageViewerTab.getFinderChartField().setText(String.valueOf(this.finderChartFOV));
            catalogQuerySettings.add(new JLabel("Copy coordinates to clipboard: ", 4));
            JCheckBox clipboardCheckBox = new JCheckBox();
            clipboardCheckBox.setSelected(this.copyCoordsToClipboard);
            catalogQuerySettings.add(clipboardCheckBox);
            catalogQuerySettings.add(new JLabel("Catalog search radius: ", 4));
            JTextField searchRadiusField = new JTextField(String.valueOf(this.searchRadius));
            catalogQuerySettings.add(searchRadiusField);
            catalogQuerySettings.add(new JLabel("PanSTARRS FoV: ", 4));
            JTextField panstarrsFovField = new JTextField(String.valueOf(this.panstarrsFOV));
            catalogQuerySettings.add(panstarrsFovField);
            catalogQuerySettings.add(new JLabel("Aladin Lite FoV: ", 4));
            JTextField aladinLiteFovField = new JTextField(String.valueOf(this.aladinLiteFOV));
            catalogQuerySettings.add(aladinLiteFovField);
            catalogQuerySettings.add(new JLabel("WiseView FoV: ", 4));
            JTextField wiseViewFovField = new JTextField(String.valueOf(this.wiseViewFOV));
            catalogQuerySettings.add(wiseViewFovField);
            catalogQuerySettings.add(new JLabel("IRSA Finder Chart FoV: ", 4));
            JTextField finderChartFovField = new JTextField(String.valueOf(this.finderChartFOV));
            catalogQuerySettings.add(finderChartFovField);
            catalogQuerySettings.add(new JLabel("Your name (*): ", 4));
            JTextField userNameField = new JTextField(userName);
            catalogQuerySettings.add(userNameField);
            catalogQuerySettings.add(new JLabel("Your email (*): ", 4));
            JTextField userEmailField = new JTextField(userEmail);
            catalogQuerySettings.add(userEmailField);
            catalogQuerySettings.add(new JLabel("(*) Required only for automatic", 4));
            catalogQuerySettings.add(new JLabel(" BYW-TYGO form filling", 2));
            JPanel imageViewerSettings = new JPanel(new GridLayout(gridRows, 2));
            imageViewerSettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Image Viewer Settings", 1, 2));
            imageViewerSettings.setPreferredSize(new Dimension(475, panelHeight));
            containerPanel.add(imageViewerSettings);
            this.wiseBand = WiseBand.valueOf(USER_SETTINGS.getProperty(WISE_BAND, ImageViewerTab.WISE_BAND.name()));
            this.size = Integer.parseInt(USER_SETTINGS.getProperty(SIZE, String.valueOf(100)));
            this.speed = Integer.parseInt(USER_SETTINGS.getProperty(SPEED, String.valueOf(200)));
            this.zoom = Integer.parseInt(USER_SETTINGS.getProperty(ZOOM, String.valueOf(500)));
            this.differentSize = Integer.parseInt(USER_SETTINGS.getProperty(DIFFERENT_SIZE, String.valueOf(100)));
            this.properMotion = Integer.parseInt(USER_SETTINGS.getProperty(PROPER_MOTION, String.valueOf(100)));
            this.nearestBywSubjects = Boolean.parseBoolean(USER_SETTINGS.getProperty(NEAREST_BYW_SUBJECTS, "true"));
            this.asyncDownloads = Boolean.parseBoolean(USER_SETTINGS.getProperty(ASYNC_DOWNLOADS, "true"));
            this.legacyImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(LEGACY_IMAGES, "true"));
            this.panstarrsImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(PANSTARRS_IMAGES, "true"));
            this.vhsImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(VHS_IMAGES, "true"));
            this.uhsImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(UHS_IMAGES, "true"));
            this.ukidssImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(UKIDSS_IMAGES, "true"));
            this.sdssImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(SDSS_IMAGES, "true"));
            this.dssImages = Boolean.parseBoolean(USER_SETTINGS.getProperty(DSS_IMAGES, "true"));
            this.wiseBandsBox = this.imageViewerTab.getWiseBands();
            this.actionListener = this.wiseBandsBox.getActionListeners()[0];
            this.wiseBandsBox.removeActionListener(this.actionListener);
            this.wiseBandsBox.setSelectedItem((Object)this.wiseBand);
            this.wiseBandsBox.addActionListener(this.actionListener);
            this.imageViewerTab.getSizeField().setText(String.valueOf(this.size));
            this.imageViewerTab.getSpeedSlider().setValue(this.speed);
            this.imageViewerTab.getZoomSlider().setValue(this.zoom);
            this.imageViewerTab.getDifferentSizeField().setText(String.valueOf(this.differentSize));
            this.imageViewerTab.getProperMotionField().setText(String.valueOf(this.properMotion));
            this.imageViewerTab.setWiseBand(this.wiseBand);
            this.imageViewerTab.setSize(this.size);
            this.imageViewerTab.setSpeed(this.speed);
            this.imageViewerTab.setZoom(this.zoom);
            this.imageViewerTab.setAsyncDownloads(this.asyncDownloads);
            this.enableStopDownloadButton();
            this.imageViewerTab.setLegacyImages(this.legacyImages);
            this.imageViewerTab.setPanstarrsImages(this.panstarrsImages);
            this.imageViewerTab.setVhsImages(this.vhsImages);
            this.imageViewerTab.setUhsImages(this.uhsImages);
            this.imageViewerTab.setUkidssImages(this.ukidssImages);
            this.imageViewerTab.setSdssImages(this.sdssImages);
            this.imageViewerTab.setDssImages(this.dssImages);
            imageViewerSettings.add(new JLabel("Bands: ", 4));
            JComboBox<WiseBand> wiseBands = new JComboBox<WiseBand>(WiseBand.values());
            wiseBands.setSelectedItem((Object)this.wiseBand);
            imageViewerSettings.add(wiseBands);
            imageViewerSettings.add(new JLabel("Field of view (arcsec): ", 4));
            JTextField sizeField = new JTextField(String.valueOf(this.size));
            imageViewerSettings.add(sizeField);
            imageViewerSettings.add(new JLabel("Speed (ms): ", 4));
            JTextField speedField = new JTextField(String.valueOf(this.speed));
            imageViewerSettings.add(speedField);
            imageViewerSettings.add(new JLabel("Zoom: ", 4));
            JTextField zoomField = new JTextField(String.valueOf(this.zoom));
            imageViewerSettings.add(zoomField);
            imageViewerSettings.add(new JLabel("Different field of view (arcsec): ", 4));
            JTextField differentSizeField = new JTextField(String.valueOf(this.differentSize));
            imageViewerSettings.add(differentSizeField);
            imageViewerSettings.add(new JLabel("Total proper motion (mas/yr): ", 4));
            JTextField properMotionField = new JTextField(String.valueOf(this.properMotion));
            imageViewerSettings.add(properMotionField);
            imageViewerSettings.add(new JLabel("Show nearest BYW subjects: ", 4));
            JCheckBox nearestBywSubjectsCheckBox = new JCheckBox(ToolboxHelper.html("<span color='red'>Restarts after pushing 'Apply settings'</span>"));
            nearestBywSubjectsCheckBox.setSelected(this.nearestBywSubjects);
            imageViewerSettings.add(nearestBywSubjectsCheckBox);
            imageViewerSettings.add(new JLabel("Async download of WISE images: ", 4));
            JCheckBox asynchDownloadsCheckBox = new JCheckBox();
            asynchDownloadsCheckBox.setSelected(this.asyncDownloads);
            imageViewerSettings.add(asynchDownloadsCheckBox);
            imageViewerSettings.add(new JLabel("Download color images: ", 4));
            JPanel downloadPanel = new JPanel(new GridLayout(1, 2));
            imageViewerSettings.add(downloadPanel);
            JCheckBox legacyImagesCheckBox = new JCheckBox("DECaLS", this.legacyImages);
            downloadPanel.add(legacyImagesCheckBox);
            JCheckBox panstarrsImagesCheckBox = new JCheckBox("Pan-STARRS", this.panstarrsImages);
            downloadPanel.add(panstarrsImagesCheckBox);
            imageViewerSettings.add(new JLabel());
            downloadPanel = new JPanel(new GridLayout(1, 2));
            imageViewerSettings.add(downloadPanel);
            JCheckBox vhsImagesCheckBox = new JCheckBox("VHS", this.vhsImages);
            downloadPanel.add(vhsImagesCheckBox);
            JCheckBox uhsImagesCheckBox = new JCheckBox("UHS", this.uhsImages);
            downloadPanel.add(uhsImagesCheckBox);
            imageViewerSettings.add(new JLabel());
            downloadPanel = new JPanel(new GridLayout(1, 2));
            imageViewerSettings.add(downloadPanel);
            JCheckBox ukidssImagesCheckBox = new JCheckBox("UKIDSS", this.ukidssImages);
            downloadPanel.add(ukidssImagesCheckBox);
            JCheckBox sdssImagesCheckBox = new JCheckBox("SDSS", this.sdssImages);
            downloadPanel.add(sdssImagesCheckBox);
            imageViewerSettings.add(new JLabel());
            downloadPanel = new JPanel(new GridLayout(1, 2));
            imageViewerSettings.add(downloadPanel);
            JCheckBox dssImagesCheckBox = new JCheckBox("DSS", this.dssImages);
            downloadPanel.add(dssImagesCheckBox);
            JPanel centerLayout = new JPanel(new GridLayout(2, 1));
            settingsPanel.add((Component)centerLayout, "Center");
            containerPanel = new JPanel(new FlowLayout(0));
            centerLayout.add(containerPanel);
            String sourceTabs = USER_SETTINGS.getProperty(SOURCE_TABS, "");
            String destTabs = USER_SETTINGS.getProperty(DEST_TABS, TabCode.getTabCodes());
            DualListBox dualListBox = new DualListBox(450, 225);
            dualListBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ToolboxHelper.html("Rearrange tabs (<span color='red'>Restarts after pushing 'Apply settings'</span>)"), 1, 2));
            dualListBox.setAllElements(TabCode.getTabLabels());
            dualListBox.addSourceElements(TabCode.convertTabCodeToLabel(sourceTabs));
            dualListBox.addDestinationElements(TabCode.convertTabCodeToLabel(destTabs));
            containerPanel.add(dualListBox);
            this.catalogPanel = new JPanel(new GridLayout(7, 3));
            this.catalogPanel.setPreferredSize(new Dimension(450, 249));
            this.catalogPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select catalogs", 1, 2));
            containerPanel.add(this.catalogPanel);
            Map<String, CatalogEntry> catalogInstances = ToolboxHelper.getCatalogInstances();
            this.selectedCatalogs = SettingsTab.getSelectedCatalogs(catalogInstances);
            this.setCheckBoxValue(this.catalogQueryTab.getTopPanel(), this.selectedCatalogs);
            this.setCheckBoxValue(this.batchQueryTab.getBottomRow(), this.selectedCatalogs);
            for (String catalogKey : catalogInstances.keySet()) {
                JCheckBox checkbox = new JCheckBox(catalogKey);
                checkbox.setSelected(this.selectedCatalogs.contains(catalogKey));
                this.catalogPanel.add(checkbox);
            }
            JPanel buttonPanel = new JPanel(new FlowLayout(0));
            centerLayout.add(buttonPanel);
            JLabel message = ToolboxHelper.createMessageLabel();
            Timer timer = new Timer(3000, e -> message.setText(""));
            JButton applyButton = new JButton("Apply settings");
            buttonPanel.add(applyButton);
            applyButton.addActionListener(evt -> {
                boolean requiresRestart = false;
                try {
                    this.lookAndFeel = (LookAndFeel)((Object)((Object)themes.getSelectedItem()));
                    this.tapProvider = noirlabButton.isSelected() ? TapProvider.IRSA : TapProvider.VIZIER;
                    this.proxyAddress = proxyAddressField.getText();
                    String text = proxyPortField.getText();
                    this.proxyPort = text.isEmpty() ? 0 : Integer.parseInt(text);
                    this.useProxy = useProxyCheckBox.isSelected();
                    if (this.useProxy) {
                        ArrayList<String> errorMessages = new ArrayList<String>();
                        if (this.proxyAddress.isEmpty()) {
                            errorMessages.add("You must specify a proxy host name.");
                        }
                        if (this.proxyPort == 0) {
                            errorMessages.add("You must specify a proxy port.");
                        }
                        if (!errorMessages.isEmpty()) {
                            String errorMessage = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                            ToolboxHelper.showErrorDialog(this.baseFrame, errorMessage);
                            return;
                        }
                    }
                    this.useSimbadMirror = useSimbadMirrorCheckBox.isSelected();
                    if (this.photometricErrors != photometricErrorsBox.isSelected()) {
                        requiresRestart = true;
                    }
                    this.photometricErrors = photometricErrorsBox.isSelected();
                    this.copyCoordsToClipboard = clipboardCheckBox.isSelected();
                    this.searchRadius = Integer.parseInt(searchRadiusField.getText());
                    this.panstarrsFOV = Integer.parseInt(panstarrsFovField.getText());
                    this.aladinLiteFOV = Integer.parseInt(aladinLiteFovField.getText());
                    this.wiseViewFOV = Integer.parseInt(wiseViewFovField.getText());
                    this.finderChartFOV = Integer.parseInt(finderChartFovField.getText());
                    this.wiseBand = (WiseBand)((Object)((Object)wiseBands.getSelectedItem()));
                    this.size = Integer.parseInt(sizeField.getText());
                    this.speed = Integer.parseInt(speedField.getText());
                    this.zoom = Integer.parseInt(zoomField.getText());
                    this.differentSize = Integer.parseInt(differentSizeField.getText());
                    this.properMotion = Integer.parseInt(properMotionField.getText());
                    if (this.nearestBywSubjects != nearestBywSubjectsCheckBox.isSelected()) {
                        requiresRestart = true;
                    }
                    this.nearestBywSubjects = nearestBywSubjectsCheckBox.isSelected();
                    this.asyncDownloads = asynchDownloadsCheckBox.isSelected();
                    this.legacyImages = legacyImagesCheckBox.isSelected();
                    this.panstarrsImages = panstarrsImagesCheckBox.isSelected();
                    this.vhsImages = vhsImagesCheckBox.isSelected();
                    this.uhsImages = uhsImagesCheckBox.isSelected();
                    this.ukidssImages = ukidssImagesCheckBox.isSelected();
                    this.sdssImages = sdssImagesCheckBox.isSelected();
                    this.dssImages = dssImagesCheckBox.isSelected();
                }
                catch (NumberFormatException ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input: " + ex.getMessage());
                    return;
                }
                SettingsTab.setLookAndFeel(this.lookAndFeel);
                SwingUtilities.updateComponentTreeUI(this.baseFrame);
                USER_SETTINGS.setProperty(LOOK_AND_FEEL, this.lookAndFeel.name());
                USER_SETTINGS.setProperty(TAP_PROVIDER, this.tapProvider.name());
                USER_SETTINGS.setProperty(PROXY_ADDRESS, proxyAddressField.getText());
                USER_SETTINGS.setProperty(PROXY_PORT, proxyPortField.getText());
                USER_SETTINGS.setProperty(USE_PROXY, String.valueOf(this.useProxy));
                USER_SETTINGS.setProperty(USE_SIMBAD_MIRROR, String.valueOf(this.useSimbadMirror));
                USER_SETTINGS.setProperty(PHOTOMETRIC_ERRORS, String.valueOf(this.photometricErrors));
                USER_SETTINGS.setProperty(CUTOUT_SERVICE, cutoutServiceField.getText());
                USER_SETTINGS.setProperty(OBJECT_COLLECTION_PATH, collectionPathField.getText());
                this.catalogQueryTab.getRadiusField().setText(String.valueOf(this.searchRadius));
                this.catalogQueryTab.setCopyCoordsToClipboard(this.copyCoordsToClipboard);
                this.imageViewerTab.getPanstarrsField().setText(String.valueOf(this.panstarrsFOV));
                this.imageViewerTab.getAladinLiteField().setText(String.valueOf(this.aladinLiteFOV));
                this.imageViewerTab.getWiseViewField().setText(String.valueOf(this.wiseViewFOV));
                this.imageViewerTab.getFinderChartField().setText(String.valueOf(this.finderChartFOV));
                this.imageViewerTab.getChangeFovButton().getActionListeners()[0].actionPerformed(null);
                USER_SETTINGS.setProperty(COPY_COORDS_TO_CLIPBOARD, String.valueOf(this.copyCoordsToClipboard));
                USER_SETTINGS.setProperty(SEARCH_RADIUS, searchRadiusField.getText());
                USER_SETTINGS.setProperty(PANSTARRS_FOV, panstarrsFovField.getText());
                USER_SETTINGS.setProperty(ALADIN_LITE_FOV, aladinLiteFovField.getText());
                USER_SETTINGS.setProperty(WISE_VIEW_FOV, wiseViewFovField.getText());
                USER_SETTINGS.setProperty(FINDER_CHART_FOV, finderChartFovField.getText());
                USER_SETTINGS.setProperty(USER_NAME, userNameField.getText());
                USER_SETTINGS.setProperty(USER_EMAIL, userEmailField.getText());
                this.imageViewerTab.initCatalogEntries();
                this.imageViewerTab.getTimer().stop();
                this.wiseBandsBox = this.imageViewerTab.getWiseBands();
                this.actionListener = this.wiseBandsBox.getActionListeners()[0];
                this.wiseBandsBox.removeActionListener(this.actionListener);
                this.wiseBandsBox.setSelectedItem((Object)this.wiseBand);
                this.wiseBandsBox.addActionListener(this.actionListener);
                this.imageViewerTab.getSizeField().setText(String.valueOf(this.size));
                this.imageViewerTab.getSpeedSlider().setValue(this.speed);
                this.imageViewerTab.getZoomSlider().setValue(this.zoom);
                this.imageViewerTab.getDifferentSizeField().setText(String.valueOf(this.differentSize));
                this.imageViewerTab.getProperMotionField().setText(String.valueOf(this.properMotion));
                this.imageViewerTab.setWiseBand(this.wiseBand);
                this.imageViewerTab.setSize(this.size);
                this.imageViewerTab.setSpeed(this.speed);
                this.imageViewerTab.setZoom(this.zoom);
                this.imageViewerTab.setAsyncDownloads(this.asyncDownloads);
                this.enableStopDownloadButton();
                this.imageViewerTab.setLegacyImages(this.legacyImages);
                this.imageViewerTab.setPanstarrsImages(this.panstarrsImages);
                this.imageViewerTab.setVhsImages(this.vhsImages);
                this.imageViewerTab.setUhsImages(this.uhsImages);
                this.imageViewerTab.setUkidssImages(this.ukidssImages);
                this.imageViewerTab.setSdssImages(this.sdssImages);
                this.imageViewerTab.setDssImages(this.dssImages);
                USER_SETTINGS.setProperty(WISE_BAND, this.wiseBand.name());
                USER_SETTINGS.setProperty(SIZE, sizeField.getText());
                USER_SETTINGS.setProperty(SPEED, speedField.getText());
                USER_SETTINGS.setProperty(ZOOM, zoomField.getText());
                USER_SETTINGS.setProperty(DIFFERENT_SIZE, differentSizeField.getText());
                USER_SETTINGS.setProperty(PROPER_MOTION, properMotionField.getText());
                USER_SETTINGS.setProperty(NEAREST_BYW_SUBJECTS, String.valueOf(this.nearestBywSubjects));
                USER_SETTINGS.setProperty(ASYNC_DOWNLOADS, String.valueOf(this.asyncDownloads));
                USER_SETTINGS.setProperty(LEGACY_IMAGES, String.valueOf(this.legacyImages));
                USER_SETTINGS.setProperty(PANSTARRS_IMAGES, String.valueOf(this.panstarrsImages));
                USER_SETTINGS.setProperty(VHS_IMAGES, String.valueOf(this.vhsImages));
                USER_SETTINGS.setProperty(UHS_IMAGES, String.valueOf(this.uhsImages));
                USER_SETTINGS.setProperty(UKIDSS_IMAGES, String.valueOf(this.ukidssImages));
                USER_SETTINGS.setProperty(SDSS_IMAGES, String.valueOf(this.sdssImages));
                USER_SETTINGS.setProperty(DSS_IMAGES, String.valueOf(this.dssImages));
                this.selectedCatalogs = new ArrayList<String>();
                for (Component component : this.catalogPanel.getComponents()) {
                    JCheckBox catalogBox;
                    if (!(component instanceof JCheckBox) || !(catalogBox = (JCheckBox)component).isSelected()) continue;
                    this.selectedCatalogs.add(catalogBox.getText());
                }
                this.setCheckBoxValue(this.catalogQueryTab.getTopPanel(), this.selectedCatalogs);
                this.setCheckBoxValue(this.batchQueryTab.getBottomRow(), this.selectedCatalogs);
                String catalogs = this.selectedCatalogs.stream().collect(Collectors.joining(","));
                USER_SETTINGS.setProperty(CATALOGS, catalogs);
                String sourceElements = TabCode.convertTabLabelToCode(dualListBox.getSourceElements());
                String destElements = TabCode.convertTabLabelToCode(dualListBox.getDestinationElements());
                if (!destTabs.equals(destElements)) {
                    requiresRestart = true;
                }
                USER_SETTINGS.setProperty(SOURCE_TABS, sourceElements);
                USER_SETTINGS.setProperty(DEST_TABS, destElements);
                SettingsTab.saveSettings();
                message.setText("Settings applied!");
                timer.restart();
                if (requiresRestart) {
                    this.restartApplication();
                }
            });
            buttonPanel.add(message);
            this.tabbedPane.addTab(TAB_NAME, new JScrollPane(settingsPanel));
        }
        catch (NumberFormatException ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void enableStopDownloadButton() {
        if (this.asyncDownloads) {
            this.imageViewerTab.getStopDownloadButton().setEnabled(true);
        } else {
            this.imageViewerTab.getStopDownloadButton().setEnabled(false);
        }
    }

    private void setCheckBoxValue(JPanel panel, List<String> catalogList) {
        for (Component component : panel.getComponents()) {
            if (!(component instanceof JCheckBox)) continue;
            JCheckBox catalogBox = (JCheckBox)component;
            catalogBox.setSelected(catalogList.contains(catalogBox.getText()));
        }
    }

    public static void setLookAndFeel(LookAndFeel lookAndFeel) {
        boolean isFlatLaf = false;
        try {
            switch (lookAndFeel) {
                case OS: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                case Flat_Light: {
                    UIManager.setLookAndFeel(new FlatLightLaf());
                    isFlatLaf = true;
                    break;
                }
                case Flat_Dark: {
                    UIManager.setLookAndFeel(new FlatDarkLaf());
                    isFlatLaf = true;
                    break;
                }
                case Flat_Darcula: {
                    UIManager.setLookAndFeel(new FlatDarculaLaf());
                    isFlatLaf = true;
                    break;
                }
                case Flat_IntelliJ: {
                    UIManager.setLookAndFeel(new FlatIntelliJLaf());
                    isFlatLaf = true;
                    break;
                }
                case Flat_Mac_Light: {
                    UIManager.setLookAndFeel(new FlatMacLightLaf());
                    isFlatLaf = true;
                    break;
                }
                case Flat_Mac_Dark: {
                    UIManager.setLookAndFeel(new FlatMacDarkLaf());
                    isFlatLaf = true;
                    break;
                }
                case Nord: {
                    UIManager.setLookAndFeel(new FlatNordIJTheme());
                    isFlatLaf = true;
                    break;
                }
                case NightOwl: {
                    UIManager.setLookAndFeel(new FlatNightOwlIJTheme());
                    isFlatLaf = true;
                    break;
                }
                case Moonlight: {
                    UIManager.setLookAndFeel(new FlatMoonlightIJTheme());
                    isFlatLaf = true;
                }
            }
            if (isFlatLaf) {
                UIManager.put("Button.arc", 0);
                UIManager.put("CheckBox.arc", 0);
                UIManager.put("Component.arc", 0);
                UIManager.put("ProgressBar.arc", 0);
                UIManager.put("TextComponent.arc", 0);
                UIManager.put("Component.arrowType", "triangle");
                UIManager.put("ScrollBar.showButtons", true);
                UIManager.put("ScrollBar.width", 15);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
    }

    public static LookAndFeel getLookAndFeel() {
        return LookAndFeel.valueOf(SettingsTab.getUserSetting(LOOK_AND_FEEL, DEFAULT_LOOK_AND_FEEL));
    }

    public static void loadUserSettings() {
        try (FileInputStream input = new FileInputStream(PROP_PATH);){
            USER_SETTINGS.load(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setUserSetting(String key, String value) {
        USER_SETTINGS.setProperty(key, value);
    }

    public static String getUserSetting(String key) {
        return USER_SETTINGS.getProperty(key);
    }

    public static String getUserSetting(String key, String defaultValue) {
        String property = USER_SETTINGS.getProperty(key);
        return property == null || property.isEmpty() ? defaultValue : property;
    }

    public static List<String> getSelectedCatalogs(Map<String, CatalogEntry> catalogInstances) {
        String defaultCatalogs = catalogInstances.keySet().stream().collect(Collectors.joining(","));
        String catalogs = USER_SETTINGS.getProperty(CATALOGS, defaultCatalogs);
        return Arrays.asList(catalogs.split(","));
    }

    public static void saveSettings() {
        try (FileOutputStream output = new FileOutputStream(PROP_PATH);){
            USER_SETTINGS.store(output, COMMENTS);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void restartApplication() {
        Application application = new Application();
        application.setDefaultCloseOperation(2);
        application.init();
        this.baseFrame.setVisible(false);
    }
}

