/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.Tab;
import astro.tool.box.tool.AbsoluteMagnitudeTool;
import astro.tool.box.tool.AngularDistanceTool;
import astro.tool.box.tool.CoordsConverterTool;
import astro.tool.box.tool.DateConverterTool;
import astro.tool.box.tool.LinearDistanceTool;
import astro.tool.box.tool.ParallacticDistanceTool;
import astro.tool.box.tool.PhotometricDistanceTool;
import astro.tool.box.tool.ProperMotionsTool;
import astro.tool.box.tool.TangentialVelocityTool;
import astro.tool.box.tool.TotalProperMotionTool;
import astro.tool.box.tool.TotalVelocityTool;
import astro.tool.box.tool.UnitConverterTool;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ToolTab
implements Tab {
    public static final String TAB_NAME = "Calculators & Converters";
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;

    public ToolTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void init(boolean visible) {
        try {
            JPanel toolPanel = new JPanel(new GridLayout(4, 3));
            AngularDistanceTool angularDistanceTool = new AngularDistanceTool(this.baseFrame, toolPanel);
            angularDistanceTool.init();
            LinearDistanceTool linearDistanceTool = new LinearDistanceTool(this.baseFrame, toolPanel);
            linearDistanceTool.init();
            ParallacticDistanceTool parallacticDistanceTool = new ParallacticDistanceTool(this.baseFrame, toolPanel);
            parallacticDistanceTool.init();
            PhotometricDistanceTool photometricDistanceTool = new PhotometricDistanceTool(this.baseFrame, toolPanel);
            photometricDistanceTool.init();
            AbsoluteMagnitudeTool absoluteMagnitudeTool = new AbsoluteMagnitudeTool(this.baseFrame, toolPanel);
            absoluteMagnitudeTool.init();
            ProperMotionsTool properMotionsTool = new ProperMotionsTool(this.baseFrame, toolPanel);
            properMotionsTool.init();
            TotalProperMotionTool totalProperMotionTool = new TotalProperMotionTool(this.baseFrame, toolPanel);
            totalProperMotionTool.init();
            TangentialVelocityTool tangentialVelocityTool = new TangentialVelocityTool(this.baseFrame, toolPanel);
            tangentialVelocityTool.init();
            TotalVelocityTool totalVelocityTool = new TotalVelocityTool(this.baseFrame, toolPanel);
            totalVelocityTool.init();
            UnitConverterTool unitConverterTool = new UnitConverterTool(this.baseFrame, toolPanel);
            unitConverterTool.init();
            CoordsConverterTool coordsConverterTool = new CoordsConverterTool(this.baseFrame, toolPanel);
            coordsConverterTool.init();
            DateConverterTool dateConverterTool = new DateConverterTool(this.baseFrame, toolPanel);
            dateConverterTool.init();
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, new JScrollPane(toolPanel));
            }
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

