/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tab;

import astro.tool.box.container.NumberPair;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.Tab;
import astro.tool.box.util.Constants;
import astro.tool.box.util.ExternalResources;
import astro.tool.box.util.ServiceHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;

public class VizierCatalogsTab
implements Tab {
    public static final String TAB_NAME = "VizieR Catalogs";
    private static final Font MONO_FONT = new Font("Monospaced", 0, 12);
    private final JFrame baseFrame;
    private final JTabbedPane tabbedPane;
    private JPanel mainPanel;
    private JPanel firstRow;
    private JPanel secondRow;
    private JPanel centerPanel;
    private JButton searchButton;
    private JButton findButton;
    private JTextField coordsField;
    private JTextField radiusField;
    private JTextField rowsField;
    private JTextField findField;
    private JTextArea catalogArea;
    private double targetRa;
    private double targetDec;
    private double searchRadius;
    private int numberOfRows;
    private boolean allColumns;
    private double prevTargetRa;
    private double prevTargetDec;
    private double prevSearchRadius;
    private int prevNumberOfRows;
    private boolean prevAllColumns;
    private int position;
    private int matchesFound;
    private boolean firstTable = true;
    private boolean titleAdded = false;

    public VizierCatalogsTab(JFrame baseFrame, JTabbedPane tabbedPane) {
        this.baseFrame = baseFrame;
        this.tabbedPane = tabbedPane;
    }

    @Override
    public void init(boolean visible) {
        try {
            this.mainPanel = new JPanel(new BorderLayout());
            if (visible) {
                this.tabbedPane.addTab(TAB_NAME, this.mainPanel);
            }
            JPanel layout = new JPanel(new GridLayout(2, 1));
            this.mainPanel.add((Component)layout, "First");
            this.firstRow = new JPanel(new FlowLayout(0));
            layout.add(this.firstRow);
            this.secondRow = new JPanel(new FlowLayout(0));
            layout.add(this.secondRow);
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
            this.mainPanel.add((Component)this.centerPanel, "Center");
            this.catalogArea = new JTextArea();
            this.catalogArea.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.catalogArea.setFont(MONO_FONT);
            this.catalogArea.setEditable(true);
            DefaultCaret caret = (DefaultCaret)this.catalogArea.getCaret();
            caret.setUpdatePolicy(2);
            JScrollPane scrollPanel = new JScrollPane(this.catalogArea);
            scrollPanel.setBorder(ToolboxHelper.createEtchedBorder("Search results"));
            this.centerPanel.add(scrollPanel);
            JLabel coordsLabel = new JLabel("Coordinates:");
            this.firstRow.add(coordsLabel);
            this.coordsField = new JTextField(25);
            this.firstRow.add(this.coordsField);
            JLabel radiusLabel = new JLabel("Search radius (arcsec):");
            this.firstRow.add(radiusLabel);
            this.radiusField = new JTextField(5);
            this.firstRow.add(this.radiusField);
            this.radiusField.setText("5");
            JLabel rowsLabel = new JLabel("Number of rows per table:");
            this.firstRow.add(rowsLabel);
            this.rowsField = new JTextField(5);
            this.firstRow.add(this.rowsField);
            this.rowsField.setText("50");
            JCheckBox allColumnsCheckBox = new JCheckBox("Include all columns");
            JPanel vizierLinkPanel = new JPanel(new FlowLayout(0));
            this.searchButton = new JButton("Search");
            this.firstRow.add(this.searchButton);
            this.searchButton.addActionListener(e -> {
                try {
                    this.baseFrame.setVisible(true);
                    String coords = this.coordsField.getText();
                    if (coords.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Coordinates must not be empty!");
                        return;
                    }
                    String radius = this.radiusField.getText();
                    if (radius.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Search radius must not be empty!");
                        return;
                    }
                    String rows = this.rowsField.getText();
                    if (rows.isEmpty()) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, "Number of rows must not be empty!");
                        return;
                    }
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    try {
                        NumberPair coordinates = ToolboxHelper.getCoordinates(coords);
                        this.targetRa = coordinates.getX();
                        this.targetDec = coordinates.getY();
                        if (this.targetRa < 0.0) {
                            errorMessages.add("RA must not be smaller than 0 deg.");
                        }
                        if (this.targetRa > 360.0) {
                            errorMessages.add("RA must not be greater than 360 deg.");
                        }
                        if (this.targetDec < -90.0) {
                            errorMessages.add("Dec must not be smaller than -90 deg.");
                        }
                        if (this.targetDec > 90.0) {
                            errorMessages.add("Dec must not be greater than 90 deg.");
                        }
                    }
                    catch (Exception ex) {
                        this.targetRa = 0.0;
                        this.targetDec = 0.0;
                        errorMessages.add("Invalid coordinates!");
                    }
                    try {
                        this.searchRadius = Double.parseDouble(radius);
                        if (this.searchRadius > 300.0) {
                            errorMessages.add("Radius must not be larger than 300 arcsec.");
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.searchRadius = 0.0;
                        errorMessages.add("Invalid radius!");
                    }
                    try {
                        this.numberOfRows = Integer.parseInt(rows);
                        if (this.numberOfRows > 500) {
                            errorMessages.add("Number of rows must not be greater than 500.");
                        } else if (this.numberOfRows < 1) {
                            errorMessages.add("Number of rows must not be less than 1.");
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.numberOfRows = 0;
                        errorMessages.add("Invalid number of rows!");
                    }
                    this.allColumns = allColumnsCheckBox.isSelected();
                    if (this.targetRa == this.prevTargetRa && this.targetDec == this.prevTargetDec && this.searchRadius == this.prevSearchRadius && this.numberOfRows == this.prevNumberOfRows && this.allColumns == this.prevAllColumns) {
                        return;
                    }
                    this.position = 0;
                    this.matchesFound = 0;
                    this.firstTable = true;
                    this.titleAdded = false;
                    this.catalogArea.setText(null);
                    this.prevTargetRa = this.targetRa;
                    this.prevTargetDec = this.targetDec;
                    this.prevSearchRadius = this.searchRadius;
                    this.prevNumberOfRows = this.numberOfRows;
                    this.prevAllColumns = this.allColumns;
                    vizierLinkPanel.removeAll();
                    if (!errorMessages.isEmpty()) {
                        String message = String.join((CharSequence)Constants.LINE_SEP, errorMessages);
                        ToolboxHelper.showErrorDialog(this.baseFrame, message);
                    } else {
                        CompletableFuture.supplyAsync(() -> {
                            try {
                                this.setWaitCursor();
                                String outAll = allColumnsCheckBox.isSelected() ? "&-out.all" : "";
                                String url = "http://vizier.u-strasbg.fr/viz-bin/asu-txt?-c=%s%s&-c.rs=%f&-out.max=%d&-sort=_r&-out.meta=hu&-oc.form=d&-out.add=_r&-out.form=mini%s";
                                url = url.formatted(Double.toString(this.targetRa), NumericFunctions.addPlusSign(this.targetDec), this.searchRadius, this.numberOfRows, outAll);
                                HttpURLConnection connection = ServiceHelper.establishHttpConnection(url);
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                                    reader.lines().forEach(line -> {
                                        if ((line = line.replaceAll("\\s+$", "")).startsWith("#RESOURCE")) {
                                            this.titleAdded = false;
                                        }
                                        if (line.startsWith("#Title:") && !this.titleAdded) {
                                            this.titleAdded = true;
                                            if (this.firstTable) {
                                                this.firstTable = false;
                                            } else {
                                                this.catalogArea.append("\n\n");
                                            }
                                            String title = line.replace("#Title: ", "");
                                            String headerDeco = this.createHeaderDeco(title);
                                            this.catalogArea.append(headerDeco + "\n");
                                            this.catalogArea.append("===== " + title + " =====\n");
                                            this.catalogArea.append(headerDeco + "\n");
                                        } else if (!line.startsWith("#") && !line.isEmpty()) {
                                            this.catalogArea.append(line + "\n");
                                        }
                                    });
                                }
                                this.catalogArea.append("\n");
                                this.catalogArea.append("##### END #####");
                                JLabel vizierLink = ToolboxHelper.createHyperlink("Open in web browser", ExternalResources.getVizierUrl(this.targetRa, this.targetDec, this.searchRadius, this.numberOfRows, allColumnsCheckBox.isSelected()));
                                vizierLinkPanel.add(vizierLink);
                                this.baseFrame.setVisible(true);
                            }
                            catch (IOException ex) {
                                ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                            }
                            finally {
                                this.setDefaultCursor();
                            }
                            return null;
                        });
                    }
                }
                catch (Exception ex) {
                    ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
                }
            });
            this.firstRow.add(allColumnsCheckBox);
            JLabel findLabel = new JLabel("Find in search results:");
            this.secondRow.add(findLabel);
            this.findField = new JTextField(10);
            this.secondRow.add(this.findField);
            this.findButton = new JButton("Find");
            this.secondRow.add(this.findButton);
            this.findButton.addActionListener(e -> {
                String stringToFind = this.findField.getText().toLowerCase();
                if (stringToFind != null && stringToFind.length() > 0) {
                    Document document = this.catalogArea.getDocument();
                    int findLength = stringToFind.length();
                    try {
                        boolean found = false;
                        if (this.position + findLength > document.getLength()) {
                            this.position = 0;
                        }
                        while (this.position + findLength <= document.getLength()) {
                            String match = document.getText(this.position, findLength).toLowerCase();
                            if (match.equals(stringToFind)) {
                                found = true;
                                break;
                            }
                            ++this.position;
                        }
                        if (found) {
                            ++this.matchesFound;
                            this.catalogArea.requestFocusInWindow();
                            Rectangle2D viewShape = this.catalogArea.modelToView2D(this.position + findLength);
                            Rectangle viewRect = viewShape.getBounds();
                            this.catalogArea.scrollRectToVisible(viewRect);
                            this.catalogArea.setCaretPosition(this.position + findLength);
                            this.catalogArea.moveCaretPosition(this.position);
                            this.position += findLength;
                        } else {
                            String message;
                            if (this.matchesFound == 0) {
                                message = "No match found for";
                            } else {
                                message = "No more matches found for";
                                this.matchesFound = 0;
                            }
                            ToolboxHelper.showInfoDialog(this.baseFrame, message + " '" + stringToFind + "'");
                            this.position = 0;
                        }
                    }
                    catch (BadLocationException ex) {
                        ToolboxHelper.showErrorDialog(this.baseFrame, ex.getMessage());
                    }
                }
            });
            this.secondRow.add(vizierLinkPanel);
            this.coordsField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.radiusField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.rowsField.addActionListener(evt -> this.searchButton.getActionListeners()[0].actionPerformed(evt));
            this.findField.addActionListener(evt -> ToolboxHelper.showWarnDialog(this.baseFrame, "Use the Find button, please!"));
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }

    private void setWaitCursor() {
        this.baseFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.coordsField.setCursor(Cursor.getPredefinedCursor(3));
        this.radiusField.setCursor(Cursor.getPredefinedCursor(3));
        this.findField.setCursor(Cursor.getPredefinedCursor(3));
        this.catalogArea.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setDefaultCursor() {
        this.baseFrame.setCursor(Cursor.getDefaultCursor());
        this.coordsField.setCursor(Cursor.getPredefinedCursor(2));
        this.radiusField.setCursor(Cursor.getPredefinedCursor(2));
        this.findField.setCursor(Cursor.getPredefinedCursor(2));
        this.catalogArea.setCursor(Cursor.getPredefinedCursor(2));
    }

    private String createHeaderDeco(String title) {
        int lengthOfTitle = title.length();
        Object headerDeco = "";
        for (int i = 0; i < lengthOfTitle + 12; ++i) {
            headerDeco = (String)headerDeco + "=";
        }
        return headerDeco;
    }
}

