/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AbsoluteMagnitudeTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public AbsoluteMagnitudeTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(5, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Absolute magnitude calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 150));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Apparent magnitude: ", 4));
            JTextField apparentMagField = new JTextField();
            mainPanel.add(apparentMagField);
            mainPanel.add(new JLabel("Parallax (mas): ", 4));
            JTextField parallaxField = new JTextField();
            mainPanel.add(parallaxField);
            mainPanel.add(new JLabel("or Distance (pc): ", 4));
            JTextField distanceField = new JTextField();
            mainPanel.add(distanceField);
            mainPanel.add(new JLabel("Absolute magnitude: ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double parallax = NumericFunctions.toDouble(parallaxField.getText());
                    double distance = NumericFunctions.toDouble(distanceField.getText());
                    double absoluteMagnitude = distance == 0.0 ? PhotometricFunctions.calculateAbsoluteMagnitudeFromParallax(NumericFunctions.toDouble(apparentMagField.getText()), parallax) : PhotometricFunctions.calculateAbsoluteMagnitudeFromDistance(NumericFunctions.toDouble(apparentMagField.getText()), distance);
                    resultField.setText(NumericFunctions.roundTo3DecNZ(absoluteMagnitude));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

