/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.enumeration.Unit;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AngularDistanceTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public AngularDistanceTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(5, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Angular distance calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 150));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Coordinates object 1 (deg): ", 4));
            JTextField fromCoordsField = new JTextField();
            mainPanel.add(fromCoordsField);
            mainPanel.add(new JLabel("Coordinates object 2 (deg): ", 4));
            JTextField toCoordsField = new JTextField();
            mainPanel.add(toCoordsField);
            mainPanel.add(new JLabel("Angular distance unit: ", 4));
            JComboBox<Unit> resultUnits = new JComboBox<Unit>(new Unit[]{Unit.ARCSEC, Unit.MAS});
            mainPanel.add(resultUnits);
            mainPanel.add(new JLabel("Angular distance: ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    Unit resultUnit = (Unit)((Object)((Object)resultUnits.getSelectedItem()));
                    double conversionFactor = resultUnit.equals((Object)Unit.ARCSEC) ? 3600.0 : 3600000.0;
                    double angularDistance = AstrometricFunctions.calculateAngularDistance(ToolboxHelper.getCoordinates(fromCoordsField.getText()), ToolboxHelper.getCoordinates(toCoordsField.getText()), conversionFactor);
                    String result = resultUnit.equals((Object)Unit.ARCSEC) ? NumericFunctions.roundTo6DecNZ(angularDistance) : NumericFunctions.roundTo3DecNZ(angularDistance);
                    resultField.setText(result);
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

