/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.container.NumberPair;
import astro.tool.box.container.StringPair;
import astro.tool.box.enumeration.CoordsSystem;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CoordsConverterTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public CoordsConverterTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(5, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Coordinates converter", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 150));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Coordinates to convert: ", 4));
            JTextField coordsToConvert = new JTextField();
            mainPanel.add(coordsToConvert);
            mainPanel.add(new JLabel("Convert from: ", 4));
            JComboBox<CoordsSystem> systemsToConvertFrom = new JComboBox<CoordsSystem>(new CoordsSystem[]{CoordsSystem.DECIMAL, CoordsSystem.SEXAGESIMAL});
            mainPanel.add(systemsToConvertFrom);
            mainPanel.add(new JLabel("To: ", 4));
            JComboBox<CoordsSystem> systemsToConvertTo = new JComboBox<CoordsSystem>(new CoordsSystem[]{CoordsSystem.DECIMAL, CoordsSystem.SEXAGESIMAL});
            systemsToConvertTo.setSelectedItem((Object)CoordsSystem.SEXAGESIMAL);
            mainPanel.add(systemsToConvertTo);
            systemsToConvertFrom.addActionListener(evt -> {
                CoordsSystem coordsSystem = (CoordsSystem)((Object)((Object)systemsToConvertFrom.getSelectedItem()));
                if (coordsSystem.equals((Object)CoordsSystem.DECIMAL)) {
                    systemsToConvertTo.setSelectedItem((Object)CoordsSystem.SEXAGESIMAL);
                } else {
                    systemsToConvertTo.setSelectedItem((Object)CoordsSystem.DECIMAL);
                }
            });
            systemsToConvertTo.addActionListener(evt -> {
                CoordsSystem coordsSystem = (CoordsSystem)((Object)((Object)systemsToConvertTo.getSelectedItem()));
                if (coordsSystem.equals((Object)CoordsSystem.DECIMAL)) {
                    systemsToConvertFrom.setSelectedItem((Object)CoordsSystem.SEXAGESIMAL);
                } else {
                    systemsToConvertFrom.setSelectedItem((Object)CoordsSystem.DECIMAL);
                }
            });
            mainPanel.add(new JLabel("Converted coordinates: ", 4));
            JTextField convertedCoords = new JTextField();
            convertedCoords.setEditable(false);
            mainPanel.add(convertedCoords);
            mainPanel.add(new JLabel());
            JButton convertButton = new JButton("Convert");
            convertButton.addActionListener(e -> {
                try {
                    String converted;
                    CoordsSystem coordsSystem = (CoordsSystem)((Object)((Object)systemsToConvertTo.getSelectedItem()));
                    NumberPair coordinates = ToolboxHelper.getCoordinates(coordsToConvert.getText());
                    if (coordsSystem.equals((Object)CoordsSystem.DECIMAL)) {
                        converted = coordinates.getX() + " " + coordinates.getY();
                    } else {
                        StringPair strings = AstrometricFunctions.convertToSexagesimalCoords(coordinates.getX(), coordinates.getY());
                        converted = strings.getS1() + " " + strings.getS2();
                    }
                    convertedCoords.setText(converted);
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(convertButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

