/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.enumeration.DateSystem;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.util.Constants;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateConverterTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public DateConverterTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(7, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Date converter", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 200));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Date to convert: ", 4));
            JTextField dateToConvert = new JTextField();
            mainPanel.add(dateToConvert);
            mainPanel.add(new JLabel("Calendar date format: ", 4));
            mainPanel.add(new JLabel("yyyy-MM-dd HH:mm:ss"));
            mainPanel.add(new JLabel("", 4));
            mainPanel.add(new JLabel("Time is not required."));
            mainPanel.add(new JLabel("Convert from: ", 4));
            JComboBox<DateSystem> systemsToConvertFrom = new JComboBox<DateSystem>(new DateSystem[]{DateSystem.CALENDAR_DATE, DateSystem.MODIFIED_JULIAN_DATE});
            mainPanel.add(systemsToConvertFrom);
            mainPanel.add(new JLabel("To: ", 4));
            JComboBox<DateSystem> systemsToConvertTo = new JComboBox<DateSystem>(new DateSystem[]{DateSystem.CALENDAR_DATE, DateSystem.MODIFIED_JULIAN_DATE});
            systemsToConvertTo.setSelectedItem((Object)DateSystem.MODIFIED_JULIAN_DATE);
            mainPanel.add(systemsToConvertTo);
            systemsToConvertFrom.addActionListener(evt -> {
                DateSystem dateSystem = (DateSystem)((Object)((Object)systemsToConvertFrom.getSelectedItem()));
                if (dateSystem.equals((Object)DateSystem.CALENDAR_DATE)) {
                    systemsToConvertTo.setSelectedItem((Object)DateSystem.MODIFIED_JULIAN_DATE);
                } else {
                    systemsToConvertTo.setSelectedItem((Object)DateSystem.CALENDAR_DATE);
                }
            });
            systemsToConvertTo.addActionListener(evt -> {
                DateSystem dateSystem = (DateSystem)((Object)((Object)systemsToConvertTo.getSelectedItem()));
                if (dateSystem.equals((Object)DateSystem.CALENDAR_DATE)) {
                    systemsToConvertFrom.setSelectedItem((Object)DateSystem.MODIFIED_JULIAN_DATE);
                } else {
                    systemsToConvertFrom.setSelectedItem((Object)DateSystem.CALENDAR_DATE);
                }
            });
            mainPanel.add(new JLabel("Converted date: ", 4));
            JTextField convertedDate = new JTextField();
            convertedDate.setEditable(false);
            mainPanel.add(convertedDate);
            mainPanel.add(new JLabel());
            JButton convertButton = new JButton("Convert");
            convertButton.addActionListener(e -> {
                try {
                    String converted;
                    DateSystem dateSystem = (DateSystem)((Object)((Object)systemsToConvertTo.getSelectedItem()));
                    String input = dateToConvert.getText().trim();
                    if (dateSystem.equals((Object)DateSystem.CALENDAR_DATE)) {
                        converted = AstrometricFunctions.convertMJDToDateTime(new BigDecimal(input)).format(Constants.DATE_TIME_FORMATTER);
                    } else {
                        LocalDateTime dateTime;
                        try {
                            dateTime = LocalDateTime.parse(input, Constants.DATE_TIME_FORMATTER);
                        }
                        catch (DateTimeParseException ex) {
                            dateTime = LocalDateTime.parse(input + " 00:00:00", Constants.DATE_TIME_FORMATTER);
                        }
                        converted = AstrometricFunctions.convertDateTimeToMJD(dateTime).toString();
                    }
                    convertedDate.setText(converted);
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(convertButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

