/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LinearDistanceTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public LinearDistanceTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(6, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Linear distance calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 175));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Coordinates object 1 (deg): ", 4));
            JTextField fromCoordsField = new JTextField();
            mainPanel.add(fromCoordsField);
            mainPanel.add(new JLabel("Coordinates object 2 (deg): ", 4));
            JTextField toCoordsField = new JTextField();
            mainPanel.add(toCoordsField);
            mainPanel.add(new JLabel("Parallax object 1 (mas): ", 4));
            JTextField fromParallaxField = new JTextField();
            mainPanel.add(fromParallaxField);
            mainPanel.add(new JLabel("Parallax object 2 (mas): ", 4));
            JTextField toParallaxField = new JTextField();
            mainPanel.add(toParallaxField);
            mainPanel.add(new JLabel("Linear distance (pc): ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double linearDistance = AstrometricFunctions.calculateLinearDistance(ToolboxHelper.getCoordinates(fromCoordsField.getText()), ToolboxHelper.getCoordinates(toCoordsField.getText()), NumericFunctions.toDouble(fromParallaxField.getText()), NumericFunctions.toDouble(toParallaxField.getText()));
                    resultField.setText(NumericFunctions.roundTo6DecNZ(linearDistance));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

