/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParallacticDistanceTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public ParallacticDistanceTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(3, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Parallactic distance calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 100));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Parallax (mas): ", 4));
            JTextField parallaxField = new JTextField();
            mainPanel.add(parallaxField);
            mainPanel.add(new JLabel("Distance (pc): ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double distance = AstrometricFunctions.calculateParallacticDistance(NumericFunctions.toDouble(parallaxField.getText()));
                    resultField.setText(NumericFunctions.roundTo3DecNZ(distance));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

