/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.NumericFunctions;
import astro.tool.box.function.PhotometricFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PhotometricDistanceTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public PhotometricDistanceTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(4, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Photometric distance calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 125));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Apparent magnitude: ", 4));
            JTextField apparentMagnitudeField = new JTextField();
            mainPanel.add(apparentMagnitudeField);
            mainPanel.add(new JLabel("Absolute magnitude: ", 4));
            JTextField absoluteMagnitudeField = new JTextField();
            mainPanel.add(absoluteMagnitudeField);
            mainPanel.add(new JLabel("Distance (pc): ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double absoluteMagnitude;
                    double apparentMagnitude;
                    double apparentMagnitudeError = 0.0;
                    double absoluteMagnitudeError = 0.0;
                    if (apparentMagnitudeField.getText().contains(" ")) {
                        String[] apparentMagnitudeData = apparentMagnitudeField.getText().split(" ");
                        apparentMagnitude = NumericFunctions.toDouble(apparentMagnitudeData[0]);
                        apparentMagnitudeError = NumericFunctions.toDouble(apparentMagnitudeData[1]);
                    } else {
                        apparentMagnitude = NumericFunctions.toDouble(apparentMagnitudeField.getText());
                    }
                    if (absoluteMagnitudeField.getText().contains(" ")) {
                        String[] absoluteMagnitudeData = absoluteMagnitudeField.getText().split(" ");
                        absoluteMagnitude = NumericFunctions.toDouble(absoluteMagnitudeData[0]);
                        absoluteMagnitudeError = NumericFunctions.toDouble(absoluteMagnitudeData[1]);
                    } else {
                        absoluteMagnitude = NumericFunctions.toDouble(absoluteMagnitudeField.getText());
                    }
                    double distance = PhotometricFunctions.calculatePhotometricDistance(apparentMagnitude, absoluteMagnitude);
                    double distanceError = PhotometricFunctions.calculatePhotometricDistanceError(apparentMagnitude, apparentMagnitudeError, absoluteMagnitude, absoluteMagnitudeError);
                    Object result = NumericFunctions.roundTo3DecNZ(distance);
                    if (distanceError != 0.0) {
                        result = (String)result + "\u00b1" + NumericFunctions.roundTo3DecNZ(distanceError);
                    }
                    resultField.setText((String)result);
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

