/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.container.NumberPair;
import astro.tool.box.enumeration.Unit;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProperMotionsTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public ProperMotionsTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(7, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Proper motions calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 200));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Coordinates epoch 1 (deg): ", 4));
            JTextField fromCoordsField = new JTextField();
            mainPanel.add(fromCoordsField);
            mainPanel.add(new JLabel("Coordinates epoch 2 (deg): ", 4));
            JTextField toCoordsField = new JTextField();
            mainPanel.add(toCoordsField);
            mainPanel.add(new JLabel("Elapsed time unit: ", 4));
            JComboBox<Unit> timeUnits = new JComboBox<Unit>(new Unit[]{Unit.YEAR, Unit.DAY});
            mainPanel.add(timeUnits);
            mainPanel.add(new JLabel("Elapsed time: ", 4));
            JTextField elapsedTimeField = new JTextField();
            mainPanel.add(elapsedTimeField);
            mainPanel.add(new JLabel("Proper motions unit: ", 4));
            JComboBox<Unit> resultUnits = new JComboBox<Unit>(new Unit[]{Unit.ARCSEC, Unit.MAS});
            mainPanel.add(resultUnits);
            mainPanel.add(new JLabel("Proper motions (pmra, pmdec): ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    String pmdec;
                    String pmra;
                    double elapsedTime = NumericFunctions.toDouble(elapsedTimeField.getText());
                    Unit timeUnit = (Unit)((Object)((Object)timeUnits.getSelectedItem()));
                    int fromDays = 0;
                    int toDays = timeUnit.equals((Object)Unit.YEAR) ? NumericFunctions.fromDoubleToInteger(elapsedTime * 365.0) : NumericFunctions.fromDoubleToInteger(elapsedTime);
                    Unit resultUnit = (Unit)((Object)((Object)resultUnits.getSelectedItem()));
                    double conversionFactor = resultUnit.equals((Object)Unit.ARCSEC) ? 3600.0 : 3600000.0;
                    NumberPair properMotions = AstrometricFunctions.calculateProperMotions(ToolboxHelper.getCoordinates(fromCoordsField.getText()), ToolboxHelper.getCoordinates(toCoordsField.getText()), fromDays, toDays, conversionFactor);
                    if (resultUnit.equals((Object)Unit.ARCSEC)) {
                        pmra = NumericFunctions.roundTo6DecNZ(properMotions.getX());
                        pmdec = NumericFunctions.roundTo6DecNZ(properMotions.getY());
                    } else {
                        pmra = NumericFunctions.roundTo3DecNZ(properMotions.getX());
                        pmdec = NumericFunctions.roundTo3DecNZ(properMotions.getY());
                    }
                    resultField.setText(pmra + ", " + pmdec);
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

