/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TangentialVelocityTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public TangentialVelocityTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(6, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Tangential velocity calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 175));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Proper motion in RA (mas/yr): ", 4));
            JTextField pmraField = new JTextField();
            mainPanel.add(pmraField);
            mainPanel.add(new JLabel("Proper motion in dec (mas/yr): ", 4));
            JTextField pmdecField = new JTextField();
            mainPanel.add(pmdecField);
            mainPanel.add(new JLabel("Parallax (mas): ", 4));
            JTextField parallaxField = new JTextField();
            mainPanel.add(parallaxField);
            mainPanel.add(new JLabel("or Distance (pc): ", 4));
            JTextField distanceField = new JTextField();
            mainPanel.add(distanceField);
            mainPanel.add(new JLabel("Tangential velocity (km/s): ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double parallax = NumericFunctions.toDouble(parallaxField.getText());
                    double distance = NumericFunctions.toDouble(distanceField.getText());
                    double tangentialVelocity = distance == 0.0 ? AstrometricFunctions.calculateTangentialVelocityFromParallax(NumericFunctions.toDouble(pmraField.getText()), NumericFunctions.toDouble(pmdecField.getText()), parallax) : AstrometricFunctions.calculateTangentialVelocityFromDistance(NumericFunctions.toDouble(pmraField.getText()), NumericFunctions.toDouble(pmdecField.getText()), distance);
                    resultField.setText(NumericFunctions.roundTo3DecNZ(tangentialVelocity));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

