/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TotalProperMotionTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public TotalProperMotionTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(4, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Total proper motion calculator", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 125));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Proper motion in RA: ", 4));
            JTextField pmraField = new JTextField();
            mainPanel.add(pmraField);
            mainPanel.add(new JLabel("Proper motion in dec: ", 4));
            JTextField pmdecField = new JTextField();
            mainPanel.add(pmdecField);
            mainPanel.add(new JLabel("Total proper motion: ", 4));
            JTextField resultField = new JTextField();
            resultField.setEditable(false);
            mainPanel.add(resultField);
            mainPanel.add(new JLabel());
            JButton calculateButton = new JButton("Calculate");
            calculateButton.addActionListener(e -> {
                try {
                    double totalProperMotion = AstrometricFunctions.calculateTotalProperMotion(NumericFunctions.toDouble(pmraField.getText()), NumericFunctions.toDouble(pmdecField.getText()));
                    resultField.setText(NumericFunctions.roundTo3DecNZ(totalProperMotion));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(calculateButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

