/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.tool;

import astro.tool.box.enumeration.Unit;
import astro.tool.box.function.AstrometricFunctions;
import astro.tool.box.function.NumericFunctions;
import astro.tool.box.main.ToolboxHelper;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class UnitConverterTool {
    private final JFrame baseFrame;
    private final JPanel toolPanel;

    public UnitConverterTool(JFrame baseFrame, JPanel toolPanel) {
        this.baseFrame = baseFrame;
        this.toolPanel = toolPanel;
    }

    public void init() {
        try {
            JPanel mainPanel = new JPanel(new GridLayout(5, 2));
            mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Unit converter", 1, 2));
            mainPanel.setPreferredSize(new Dimension(375, 150));
            JPanel containerPanel = new JPanel();
            containerPanel.add(mainPanel);
            this.toolPanel.add(containerPanel);
            mainPanel.add(new JLabel("Value to convert: ", 4));
            JTextField valueToConvert = new JTextField();
            mainPanel.add(valueToConvert);
            mainPanel.add(new JLabel("Convert from: ", 4));
            JComboBox<Unit> unitsToConvertFrom = new JComboBox<Unit>(new Unit[]{Unit.DEGREE, Unit.ARCSEC, Unit.MAS});
            mainPanel.add(unitsToConvertFrom);
            mainPanel.add(new JLabel("To: ", 4));
            JComboBox<Unit> unitsToConvertTo = new JComboBox<Unit>(new Unit[]{Unit.DEGREE, Unit.ARCSEC, Unit.MAS});
            unitsToConvertTo.setSelectedItem((Object)Unit.MAS);
            mainPanel.add(unitsToConvertTo);
            mainPanel.add(new JLabel("Converted value: ", 4));
            JTextField convertedValue = new JTextField();
            convertedValue.setEditable(false);
            mainPanel.add(convertedValue);
            mainPanel.add(new JLabel());
            JButton convertButton = new JButton("Convert");
            convertButton.addActionListener(e -> {
                try {
                    double converted = AstrometricFunctions.convertToUnit(NumericFunctions.toDouble(valueToConvert.getText()), (Unit)((Object)((Object)unitsToConvertFrom.getSelectedItem())), (Unit)((Object)((Object)unitsToConvertTo.getSelectedItem())));
                    convertedValue.setText(NumericFunctions.roundTo9DecNZ(converted));
                }
                catch (Exception ex) {
                    ToolboxHelper.showErrorDialog(this.baseFrame, "Invalid input!");
                }
            });
            mainPanel.add(convertButton);
        }
        catch (Exception ex) {
            ToolboxHelper.showExceptionDialog(this.baseFrame, ex);
        }
    }
}

