/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CSVParser {
    private static final char DEFAULT_SEPARATOR = ",".charAt(0);
    private static final char DEFAULT_QUOTE = '\"';

    public static String[] parseLine(String cvsLine) {
        return CSVParser.parseLine(cvsLine, DEFAULT_SEPARATOR, '\"');
    }

    public static String[] parseLine(String cvsLine, char separators) {
        return CSVParser.parseLine(cvsLine, separators, '\"');
    }

    public static String[] parseLine(String cvsLine, char separators, char customQuote) {
        char[] chars;
        List<Object> result = new ArrayList<String>();
        if (cvsLine == null || cvsLine.isEmpty()) {
            return new String[0];
        }
        if (customQuote == ' ') {
            customQuote = (char)34;
        }
        if (separators == ' ') {
            separators = DEFAULT_SEPARATOR;
        }
        StringBuilder curVal = new StringBuilder();
        boolean inQuotes = false;
        boolean startCollectChar = false;
        boolean doubleQuotesInColumn = false;
        for (char ch : chars = cvsLine.toCharArray()) {
            if (inQuotes) {
                startCollectChar = true;
                if (ch == customQuote) {
                    inQuotes = false;
                    doubleQuotesInColumn = false;
                    continue;
                }
                if (ch == '\"') {
                    if (doubleQuotesInColumn) continue;
                    curVal.append(ch);
                    doubleQuotesInColumn = true;
                    continue;
                }
                curVal.append(ch);
                continue;
            }
            if (ch == customQuote) {
                inQuotes = true;
                if (!startCollectChar) continue;
                curVal.append('\"');
                continue;
            }
            if (ch == separators) {
                result.add(curVal.toString());
                curVal = new StringBuilder();
                startCollectChar = false;
                continue;
            }
            curVal.append(ch);
        }
        result.add(curVal.toString());
        result = result.stream().map(String::trim).collect(Collectors.toList());
        return result.toArray(new String[result.size()]);
    }
}

