/*
 * Decompiled with CFR 0.152.
 */
package astro.tool.box.util;

import astro.tool.box.enumeration.TapProvider;
import astro.tool.box.main.ToolboxHelper;
import astro.tool.box.tab.SettingsTab;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class MiscUtils {
    public static final Map<String, Double> SPECTRAL_TYPES;

    private static void add(String spt, int i, int j) {
        SPECTRAL_TYPES.put(spt + i, (double)j + 0.0);
        SPECTRAL_TYPES.put(spt + i + ".5", (double)j + 0.5);
    }

    public static boolean isVizierTAP() {
        return TapProvider.VIZIER.equals((Object)MiscUtils.getTapProvider());
    }

    private static TapProvider getTapProvider() {
        return TapProvider.valueOf(SettingsTab.getUserSetting("tapProvider", SettingsTab.DEFAULT_TAP_PROVIDER));
    }

    public static void addRow(StringBuilder query, String row) {
        query.append(row).append("\n");
    }

    public static String encodeQuery(String query) {
        try {
            return URLEncoder.encode(MiscUtils.omitQueryComments(query), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ToolboxHelper.writeErrorLog(ex);
            return query;
        }
    }

    public static String omitQueryComments(String query) {
        String[] lines = query.split("\n");
        ArrayList<String> results = new ArrayList<String>();
        for (String line : lines) {
            if (line.startsWith("--")) continue;
            results.add(line.trim());
        }
        return String.join((CharSequence)" ", results).replaceAll(";", "");
    }

    public static String removeFirstAndLastCharacter(String str) {
        return str.substring(1, str.length() - 1);
    }

    public static void replaceNanValuesByZero(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (!"NaN".equals(value) && !"Infinity".equals(value) && !"-Infinity".equals(value)) continue;
            values[i] = "0";
        }
    }

    public static Object[] addToArray(Object[] arr, Object ... elements) {
        Object[] tempArr = new Object[arr.length + elements.length];
        System.arraycopy(arr, 0, tempArr, 0, arr.length);
        System.arraycopy(elements, 0, tempArr, arr.length, elements.length);
        return tempArr;
    }

    static {
        String[] spts;
        SPECTRAL_TYPES = new LinkedHashMap<String, Double>();
        int j = 0;
        for (String spt : spts = new String[]{"O", "B", "A", "F", "G", "K", "M", "L", "T", "Y"}) {
            for (int i = 0; i < 10; ++i) {
                MiscUtils.add(spt, i, j++);
            }
        }
    }
}

