/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import nom.tam.fits.AbstractTableData;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ByteFormatter;
import nom.tam.util.ByteParser;
import nom.tam.util.Cursor;
import nom.tam.util.FormatException;

public class AsciiTable
extends AbstractTableData {
    private static final int MAX_INTEGER_LENGTH = 10;
    private static final int FLOAT_MAX_LENGTH = 16;
    private static final int LONG_MAX_LENGTH = 20;
    private static final int INT_MAX_LENGTH = 10;
    private static final int DOUBLE_MAX_LENGTH = 24;
    private static boolean isI10PreferInt = true;
    private int nRows;
    private int nFields;
    private int rowLen;
    private String[] nulls;
    private Class<?>[] types;
    private int[] offsets;
    private int[] lengths;
    private byte[] buffer;
    private boolean[] isNull;
    private String[] names;
    private Object[] data;
    private ByteParser bp;
    private ArrayDataInput currInput;

    public AsciiTable() {
        this.data = new Object[0];
        this.buffer = null;
        this.nFields = 0;
        this.nRows = 0;
        this.rowLen = 0;
        this.types = new Class[0];
        this.lengths = new int[0];
        this.offsets = new int[0];
        this.nulls = new String[0];
        this.names = new String[0];
    }

    public AsciiTable(Header hdr) throws FitsException {
        this(hdr, isI10PreferInt);
    }

    public AsciiTable(Header hdr, boolean preferInt) throws FitsException {
        String ext = hdr.getStringValue(Standard.XTENSION, "IMAGE");
        if (!ext.equalsIgnoreCase("TABLE")) {
            throw new FitsException("Not an ASCII table header (XTENSION = " + hdr.getStringValue(Standard.XTENSION) + ")");
        }
        this.nRows = hdr.getIntValue(Standard.NAXIS2);
        this.nFields = hdr.getIntValue(Standard.TFIELDS);
        this.rowLen = hdr.getIntValue(Standard.NAXIS1);
        this.types = new Class[this.nFields];
        this.offsets = new int[this.nFields];
        this.lengths = new int[this.nFields];
        this.nulls = new String[this.nFields];
        this.names = new String[this.nFields];
        for (int i = 0; i < this.nFields; ++i) {
            this.names[i] = hdr.getStringValue(Standard.TTYPEn.n(i + 1), TableHDU.getDefaultColumnName(i));
            this.offsets[i] = hdr.getIntValue(Standard.TBCOLn.n(i + 1)) - 1;
            String s = hdr.getStringValue(Standard.TFORMn.n(i + 1));
            if (this.offsets[i] < 0 || s == null) {
                throw new FitsException("Invalid Specification for column:" + (i + 1));
            }
            s = s.trim();
            char c = s.charAt(0);
            if ((s = s.substring(1)).indexOf(46) > 0) {
                s = s.substring(0, s.indexOf(46));
            }
            this.lengths[i] = Integer.parseInt(s);
            switch (c) {
                case 'A': {
                    this.types[i] = String.class;
                    break;
                }
                case 'I': {
                    if (this.lengths[i] == 10) {
                        this.types[i] = this.guessI10Type(i, hdr, preferInt);
                        break;
                    }
                    this.types[i] = this.lengths[i] > 10 ? Long.TYPE : Integer.TYPE;
                    break;
                }
                case 'E': 
                case 'F': {
                    this.types[i] = Float.TYPE;
                    break;
                }
                case 'D': {
                    this.types[i] = Double.TYPE;
                    break;
                }
                default: {
                    throw new FitsException("could not parse column type of ascii table");
                }
            }
            this.nulls[i] = hdr.getStringValue(Standard.TNULLn.n(i + 1));
            if (this.nulls[i] == null) continue;
            this.nulls[i] = this.nulls[i].trim();
        }
    }

    public static AsciiTable fromColumnMajor(Object[] columns) throws FitsException {
        AsciiTable t = new AsciiTable();
        for (int i = 0; i < columns.length; ++i) {
            try {
                t.addColumn(columns[i]);
                continue;
            }
            catch (Exception e) {
                throw new FitsException("col[" + i + "]: " + e.getMessage(), e);
            }
        }
        return t;
    }

    void setColumnName(int col, String value) throws IllegalArgumentException, IndexOutOfBoundsException, HeaderCardException {
        HeaderCard.validateChars(value);
        this.names[col] = value;
    }

    private boolean requiresLong(Header h, IFitsHeader key, Long dft) {
        long l = h.getLongValue(key, (long)dft);
        if (l == dft) {
            return false;
        }
        return l < Integer.MIN_VALUE || l > Integer.MAX_VALUE;
    }

    private Class<?> guessI10Type(int col, Header h, boolean preferInt) {
        if (this.requiresLong(h, Standard.TLMINn.n(++col), Long.MAX_VALUE) || this.requiresLong(h, Standard.TLMAXn.n(col), Long.MIN_VALUE) || this.requiresLong(h, Standard.TDMINn.n(col), Long.MAX_VALUE) || this.requiresLong(h, Standard.TDMAXn.n(col), Long.MIN_VALUE)) {
            return Long.TYPE;
        }
        if ((h.containsKey(Standard.TLMINn.n(col)) || h.containsKey(Standard.TDMINn.n(col))) && (h.containsKey(Standard.TLMAXn.n(col)) || h.containsKey(Standard.TDMAXn.n(col)))) {
            return Integer.TYPE;
        }
        return preferInt ? Integer.TYPE : Long.TYPE;
    }

    public final Class<?> getColumnType(int col) {
        return this.types[col];
    }

    int addColInfo(int col, Cursor<String, HeaderCard> iter) {
        String tform = null;
        if (this.types[col] == String.class) {
            tform = "A" + this.lengths[col];
        } else if (this.types[col] == Integer.TYPE || this.types[col] == Long.TYPE) {
            tform = "I" + this.lengths[col];
        } else if (this.types[col] == Float.TYPE) {
            tform = "E" + this.lengths[col] + ".0";
        } else if (this.types[col] == Double.TYPE) {
            tform = "D" + this.lengths[col] + ".0";
        }
        Standard.context(AsciiTable.class);
        if (this.names[col] != null) {
            iter.add(HeaderCard.create(Standard.TTYPEn.n(col + 1), this.names[col]));
        }
        iter.add(HeaderCard.create(Standard.TFORMn.n(col + 1), tform));
        iter.add(HeaderCard.create(Standard.TBCOLn.n(col + 1), this.offsets[col] + 1));
        Standard.context(null);
        return this.lengths[col];
    }

    @Override
    public int addColumn(Object newCol) throws FitsException, IllegalArgumentException {
        if (newCol == null) {
            throw new FitsException("data is null");
        }
        if (!newCol.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + newCol.getClass().getName());
        }
        int maxLen = 1;
        if (newCol instanceof String[]) {
            String[] sa;
            for (String element : sa = (String[])newCol) {
                if (element == null || element.length() <= maxLen) continue;
                maxLen = element.length();
            }
        } else if (newCol instanceof double[]) {
            maxLen = 24;
        } else if (newCol instanceof int[]) {
            maxLen = 10;
        } else if (newCol instanceof long[]) {
            maxLen = 20;
        } else if (newCol instanceof float[]) {
            maxLen = 16;
        } else {
            throw new FitsException("No AsciiTable support for elements of " + newCol.getClass().getComponentType().getName());
        }
        this.addColumn(newCol, maxLen);
        this.buffer = null;
        return this.nFields;
    }

    public int addColumn(Object newCol, int width) throws FitsException, IllegalArgumentException {
        Class<?> type;
        if (width < 1) {
            throw new IllegalArgumentException("Illegal ASCII column width: " + width);
        }
        if (!newCol.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array: " + newCol.getClass().getName());
        }
        if (this.nFields > 0 && Array.getLength(newCol) != this.nRows) {
            throw new FitsException("Mismatched number of rows: expected " + this.nRows + ", got " + Array.getLength(newCol) + "rows.");
        }
        if (this.nFields == 0) {
            this.nRows = Array.getLength(newCol);
        }
        if ((type = ArrayFuncs.getBaseClass(newCol)) != Integer.TYPE && type != Long.TYPE && type != Float.TYPE && type != Double.TYPE && type != String.class) {
            throw new FitsException("No AsciiTable support for elements of " + type.getName());
        }
        this.data = Arrays.copyOf(this.data, this.nFields + 1);
        this.offsets = Arrays.copyOf(this.offsets, this.nFields + 1);
        this.lengths = Arrays.copyOf(this.lengths, this.nFields + 1);
        this.types = Arrays.copyOf(this.types, this.nFields + 1);
        this.nulls = Arrays.copyOf(this.nulls, this.nFields + 1);
        this.names = Arrays.copyOf(this.names, this.nFields + 1);
        this.data[this.nFields] = newCol;
        this.offsets[this.nFields] = this.rowLen + 1;
        this.lengths[this.nFields] = width;
        this.types[this.nFields] = ArrayFuncs.getBaseClass(newCol);
        this.names[this.nFields] = TableHDU.getDefaultColumnName(this.nFields);
        this.rowLen += width + 1;
        if (this.isNull != null) {
            boolean[] newIsNull = new boolean[this.nRows * (this.nFields + 1)];
            int add = 0;
            for (int i = 0; i < this.isNull.length; ++i) {
                if (i % this.nFields == 0) {
                    ++add;
                }
                if (!this.isNull[i]) continue;
                newIsNull[i + add] = true;
            }
            this.isNull = newIsNull;
        }
        ++this.nFields;
        this.buffer = null;
        return this.nFields;
    }

    @Override
    public int addRow(Object[] newRow) throws FitsException {
        try {
            if (this.nFields == 0) {
                for (Object element : newRow) {
                    this.addColumn(element);
                }
            } else {
                for (int i = 0; i < this.nFields; ++i) {
                    Object o = ArrayFuncs.newInstance(this.types[i], this.nRows + 1);
                    System.arraycopy(this.data[i], 0, o, 0, this.nRows);
                    System.arraycopy(newRow[i], 0, o, this.nRows, 1);
                    this.data[i] = o;
                }
                ++this.nRows;
            }
            this.buffer = null;
            return this.nRows;
        }
        catch (Exception e) {
            throw new FitsException("Error adding row:" + e.getMessage(), e);
        }
    }

    @Override
    public void deleteColumns(int start, int len) throws FitsException {
        this.ensureData();
        Object[] newData = new Object[this.nFields - len];
        int[] newOffsets = new int[this.nFields - len];
        int[] newLengths = new int[this.nFields - len];
        Class[] newTypes = new Class[this.nFields - len];
        String[] newNulls = new String[this.nFields - len];
        System.arraycopy(this.data, 0, newData, 0, start);
        System.arraycopy(this.lengths, 0, newLengths, 0, start);
        System.arraycopy(this.types, 0, newTypes, 0, start);
        System.arraycopy(this.nulls, 0, newNulls, 0, start);
        System.arraycopy(this.data, start + len, newData, start, this.nFields - start - len);
        System.arraycopy(this.lengths, start + len, newLengths, start, this.nFields - start - len);
        System.arraycopy(this.types, start + len, newTypes, start, this.nFields - start - len);
        System.arraycopy(this.nulls, start + len, newNulls, start, this.nFields - start - len);
        for (int i = start; i < start + len; ++i) {
            this.rowLen -= this.lengths[i] + 1;
        }
        this.data = newData;
        this.offsets = newOffsets;
        this.lengths = newLengths;
        this.types = newTypes;
        this.nulls = newNulls;
        if (this.isNull != null) {
            boolean found = false;
            boolean[] newIsNull = new boolean[this.nRows * (this.nFields - len)];
            for (int i = 0; i < this.nRows; ++i) {
                int col;
                int oldOff = this.nFields * i;
                int newOff = (this.nFields - len) * i;
                for (col = 0; col < start; ++col) {
                    newIsNull[newOff + col] = this.isNull[oldOff + col];
                    found = found || this.isNull[oldOff + col];
                }
                for (col = start + len; col < this.nFields; ++col) {
                    newIsNull[newOff + col - len] = this.isNull[oldOff + col];
                    found = found || this.isNull[oldOff + col];
                }
            }
            this.isNull = (boolean[])(found ? newIsNull : null);
        }
        this.buffer = null;
        this.nFields -= len;
    }

    @Override
    public void deleteRows(int start, int len) throws FitsException {
        if (this.nRows == 0 || start < 0 || start >= this.nRows || len <= 0) {
            return;
        }
        if (start + len > this.nRows) {
            len = this.nRows - start;
        }
        this.ensureData();
        for (int i = 0; i < this.nFields; ++i) {
            try {
                Object o = ArrayFuncs.newInstance(this.types[i], this.nRows - len);
                System.arraycopy(this.data[i], 0, o, 0, start);
                System.arraycopy(this.data[i], start + len, o, start, this.nRows - len - start);
                this.data[i] = o;
                continue;
            }
            catch (Exception e) {
                throw new FitsException("Error deleting row: " + e.getMessage(), e);
            }
        }
        this.nRows -= len;
    }

    @Override
    protected void loadData(ArrayDataInput in) throws IOException, FitsException {
        this.currInput = in;
        if (this.buffer == null) {
            this.getBuffer((long)this.nRows * (long)this.rowLen, 0L);
        }
        this.data = new Object[this.nFields];
        for (int i = 0; i < this.nFields; ++i) {
            this.data[i] = ArrayFuncs.newInstance(this.types[i], this.nRows);
        }
        this.bp.setOffset(0);
        for (int i = 0; i < this.nRows; ++i) {
            int rowOffset = this.rowLen * i;
            for (int j = 0; j < this.nFields; ++j) {
                try {
                    if (this.extractElement(rowOffset + this.offsets[j], this.lengths[j], this.data, j, i, this.nulls[j])) continue;
                    if (this.isNull == null) {
                        this.isNull = new boolean[this.nRows * this.nFields];
                    }
                    this.isNull[j + i * this.nFields] = true;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new FitsException("not enough data: " + e, e);
                }
            }
        }
    }

    @Override
    public void read(ArrayDataInput in) throws FitsException {
        this.currInput = in;
        super.read(in);
    }

    private boolean extractElement(int offset, int length, Object[] array, int col, int row, String nullFld) throws FitsException {
        block9: {
            this.bp.setOffset(offset);
            if (nullFld != null) {
                String s = this.bp.getString(length);
                if (s.trim().equals(nullFld)) {
                    return false;
                }
                this.bp.skip(-length);
            }
            try {
                if (array[col] instanceof String[]) {
                    ((String[])array[col])[row] = this.bp.getString(length);
                    break block9;
                }
                if (array[col] instanceof int[]) {
                    ((int[])array[col])[row] = this.bp.getInt(length);
                    break block9;
                }
                if (array[col] instanceof float[]) {
                    ((float[])array[col])[row] = this.bp.getFloat(length);
                    break block9;
                }
                if (array[col] instanceof double[]) {
                    ((double[])array[col])[row] = this.bp.getDouble(length);
                    break block9;
                }
                if (array[col] instanceof long[]) {
                    ((long[])array[col])[row] = this.bp.getLong(length);
                    break block9;
                }
                throw new FitsException("Invalid type for ASCII table conversion:" + array[col]);
            }
            catch (FormatException e) {
                throw new FitsException("Error parsing data at row,col:" + row + "," + col + "  ", e);
            }
        }
        return true;
    }

    @Override
    protected void fillHeader(Header h) {
        h.deleteKey(Standard.SIMPLE);
        h.deleteKey(Standard.EXTEND);
        Standard.context(AsciiTable.class);
        Cursor<String, HeaderCard> c = h.iterator();
        c.add(HeaderCard.create((IFitsHeader)Standard.XTENSION, "TABLE"));
        c.add(HeaderCard.create((IFitsHeader)Standard.BITPIX, Bitpix.BYTE.getHeaderValue()));
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, 2));
        c.add(HeaderCard.create(Standard.NAXIS1, this.rowLen));
        c.add(HeaderCard.create(Standard.NAXIS2, this.nRows));
        c.add(HeaderCard.create((IFitsHeader)Standard.PCOUNT, 0));
        c.add(HeaderCard.create((IFitsHeader)Standard.GCOUNT, 1));
        c.add(HeaderCard.create((IFitsHeader)Standard.TFIELDS, this.nFields));
        for (int i = 0; i < this.nFields; ++i) {
            this.addColInfo(i, c);
        }
        Standard.context(null);
    }

    private void getBuffer(long size, long offset) throws IOException, FitsException {
        if (this.currInput == null) {
            throw new IOException("No stream open to read");
        }
        if (size > Integer.MAX_VALUE) {
            throw new FitsException("Cannot read ASCII table > 2 GB");
        }
        this.buffer = new byte[(int)size];
        if (offset != 0L) {
            FitsUtil.reposition(this.currInput, offset);
        }
        this.currInput.readFully(this.buffer);
        this.bp = new ByteParser(this.buffer);
    }

    @Override
    public Object getColumn(int col) throws FitsException {
        this.ensureData();
        return this.data[col];
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    protected Object[] getCurrentData() {
        return this.data;
    }

    public Object[] getData() throws FitsException {
        return (Object[])super.getData();
    }

    @Override
    public Object getElement(int row, int col) throws FitsException {
        if (this.data != null) {
            return this.singleElement(row, col);
        }
        return this.parseSingleElement(row, col);
    }

    @Override
    public int getNCols() {
        return this.nFields;
    }

    @Override
    public int getNRows() {
        return this.nRows;
    }

    @Override
    public Object[] getRow(int row) throws FitsException {
        if (this.data != null) {
            return this.singleRow(row);
        }
        return this.parseSingleRow(row);
    }

    public int getRowLen() {
        return this.rowLen;
    }

    @Override
    protected long getTrueSize() {
        return (long)this.nRows * (long)this.rowLen;
    }

    public boolean isNull(int row, int col) {
        if (this.isNull != null) {
            return this.isNull[row * this.nFields + col];
        }
        return false;
    }

    private Object parseSingleElement(int row, int col) throws FitsException {
        Object[] res = new Object[1];
        try {
            this.getBuffer(this.lengths[col], this.getFileOffset() + (long)row * (long)this.rowLen + (long)this.offsets[col]);
        }
        catch (IOException e) {
            this.buffer = null;
            throw new FitsException("Unable to read element", e);
        }
        res[0] = ArrayFuncs.newInstance(this.types[col], 1);
        boolean success = this.extractElement(0, this.lengths[col], res, 0, 0, this.nulls[col]);
        this.buffer = null;
        return success ? res[0] : null;
    }

    private Object[] parseSingleRow(int row) throws FitsException {
        Object[] res = new Object[this.nFields];
        try {
            this.getBuffer(this.rowLen, this.getFileOffset() + (long)row * (long)this.rowLen);
        }
        catch (IOException e) {
            throw new FitsException("Unable to read row", e);
        }
        for (int i = 0; i < this.nFields; ++i) {
            res[i] = ArrayFuncs.newInstance(this.types[i], 1);
            if (this.extractElement(this.offsets[i], this.lengths[i], res, i, 0, this.nulls[i])) continue;
            res[i] = null;
        }
        this.buffer = null;
        return res;
    }

    @Override
    public void setColumn(int col, Object newData) throws FitsException {
        this.ensureData();
        if (col < 0 || col >= this.nFields || newData.getClass() != this.data[col].getClass() || Array.getLength(newData) != Array.getLength(this.data[col])) {
            throw new FitsException("Invalid column/column mismatch:" + col);
        }
        this.data[col] = newData;
        this.buffer = null;
    }

    @Override
    public void setElement(int row, int col, Object newData) throws FitsException {
        this.ensureData();
        try {
            System.arraycopy(newData, 0, this.data[col], row, 1);
        }
        catch (Exception e) {
            throw new FitsException("Incompatible element:" + row + "," + col, e);
        }
        this.setNull(row, col, false);
        this.buffer = null;
    }

    public void setNull(int row, int col, boolean flag) {
        if (flag) {
            if (this.isNull == null) {
                this.isNull = new boolean[this.nRows * this.nFields];
            }
            this.isNull[col + row * this.nFields] = true;
        } else if (this.isNull != null) {
            this.isNull[col + row * this.nFields] = false;
        }
        this.buffer = null;
    }

    void setNullString(int col, String newNull) {
        if (col >= 0 && col < this.nulls.length) {
            this.nulls[col] = newNull;
        }
    }

    @Override
    public void setRow(int row, Object[] newData) throws FitsException {
        if (row < 0 || row > this.nRows) {
            throw new FitsException("Invalid row in setRow");
        }
        this.ensureData();
        for (int i = 0; i < this.nFields; ++i) {
            try {
                System.arraycopy(newData[i], 0, this.data[i], row, 1);
            }
            catch (Exception e) {
                throw new FitsException("Unable to modify row: incompatible data:" + row, e);
            }
            this.setNull(row, i, false);
        }
        this.buffer = null;
    }

    private Object singleElement(int row, int col) {
        Object res = null;
        if (this.isNull == null || !this.isNull[row * this.nFields + col]) {
            res = ArrayFuncs.newInstance(this.types[col], 1);
            System.arraycopy(this.data[col], row, res, 0, 1);
        }
        return res;
    }

    private Object[] singleRow(int row) {
        Object[] res = new Object[this.nFields];
        for (int i = 0; i < this.nFields; ++i) {
            if (this.isNull != null && this.isNull[row * this.nFields + i]) continue;
            res[i] = ArrayFuncs.newInstance(this.types[i], 1);
            System.arraycopy(this.data[i], row, res[i], 0, 1);
        }
        return res;
    }

    @Override
    public void updateAfterDelete(int oldNCol, Header hdr) throws FitsException {
        int i;
        int offset = 0;
        for (i = 0; i < this.nFields; ++i) {
            this.offsets[i] = offset;
            hdr.addValue(Standard.TBCOLn.n(i + 1), offset + 1);
            offset += this.lengths[i] + 1;
        }
        for (i = this.nFields; i < oldNCol; ++i) {
            hdr.deleteKey(Standard.TBCOLn.n(i + 1));
        }
        hdr.addValue(Standard.NAXIS1, this.rowLen);
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        if (str != this.currInput) {
            this.ensureData();
        }
        if (this.data == null) {
            throw new FitsException("Attempt to write undefined ASCII Table");
        }
        if ((long)this.nRows * (long)this.rowLen > Integer.MAX_VALUE) {
            throw new FitsException("Cannot write ASCII table > 2 GB");
        }
        this.buffer = new byte[this.nRows * this.rowLen];
        this.bp = new ByteParser(this.buffer);
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = 32;
        }
        ByteFormatter bf = new ByteFormatter();
        for (int i = 0; i < this.nRows; ++i) {
            for (int j = 0; j < this.nFields; ++j) {
                int offset = i * this.rowLen + this.offsets[j];
                int len = this.lengths[j];
                if (this.isNull != null && this.isNull[i * this.nFields + j]) {
                    if (this.nulls[j] == null) {
                        throw new FitsException("No null value set when needed");
                    }
                    bf.format(this.nulls[j], this.buffer, offset, len);
                    continue;
                }
                if (this.types[j] == String.class) {
                    String[] s = (String[])this.data[j];
                    bf.format(s[i], this.buffer, offset, len);
                    continue;
                }
                if (this.types[j] == Integer.TYPE) {
                    int[] ia = (int[])this.data[j];
                    bf.format(ia[i], this.buffer, offset, len);
                    continue;
                }
                if (this.types[j] == Float.TYPE) {
                    float[] fa = (float[])this.data[j];
                    bf.format(fa[i], this.buffer, offset, len);
                    continue;
                }
                if (this.types[j] == Double.TYPE) {
                    double[] da = (double[])this.data[j];
                    bf.format(da[i], this.buffer, offset, len);
                    continue;
                }
                if (this.types[j] != Long.TYPE) continue;
                long[] la = (long[])this.data[j];
                bf.format(la[i], this.buffer, offset, len);
            }
        }
        try {
            str.write(this.buffer);
            FitsUtil.pad(str, this.buffer.length, (byte)32);
        }
        catch (IOException e) {
            throw new FitsException("Error writing ASCII Table data", e);
        }
    }

    public AsciiTableHDU toHDU() {
        Header h = new Header();
        this.fillHeader(h);
        return new AsciiTableHDU(h, this);
    }

    public static void setI10PreferInt(boolean value) {
        isI10PreferInt = value;
    }

    public static boolean isI10PreferInt() {
        return isI10PreferInt;
    }
}

