/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;

public class AsciiTableHDU
extends TableHDU<AsciiTable> {
    private static final IFitsHeader[] KEY_STEMS = new IFitsHeader[]{Standard.TFORMn, Standard.TZEROn, Standard.TNULLn, Standard.TTYPEn, Standard.TUNITn};

    public AsciiTableHDU(Header h, AsciiTable d) {
        super(h, d);
    }

    @Override
    protected final String getCanonicalXtension() {
        return "TABLE";
    }

    @Deprecated
    public static AsciiTable encapsulate(Object o) throws FitsException {
        return AsciiTable.fromColumnMajor((Object[])o);
    }

    @Deprecated
    public static boolean isData(Object o) {
        if (o instanceof Object[]) {
            for (Object element : (Object[])o) {
                if (element instanceof String[] || element instanceof int[] || element instanceof long[] || element instanceof float[] || element instanceof double[]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isHeader(Header header) {
        String xtension = header.getStringValue(Standard.XTENSION);
        xtension = xtension == null ? "" : xtension.trim();
        return "TABLE".equals(xtension);
    }

    @Deprecated
    public static AsciiTable manufactureData(Header hdr) throws FitsException {
        return new AsciiTable(hdr);
    }

    @Deprecated
    public static Header manufactureHeader(Data d) throws FitsException {
        Header hdr = new Header();
        d.fillHeader(hdr);
        hdr.iterator();
        return hdr;
    }

    @Override
    public void setColumnName(int index, String name, String comment) throws IndexOutOfBoundsException, HeaderCardException {
        super.setColumnName(index, name, comment);
        ((AsciiTable)this.myData).setColumnName(index, name);
    }

    @Override
    public int addColumn(Object newCol) throws FitsException {
        Standard.context(AsciiTable.class);
        ((AsciiTable)this.myData).addColumn(newCol);
        Cursor<String, HeaderCard> iter = this.myHeader.positionAfterIndex(Standard.TBCOLn, ((AsciiTable)this.myData).getNCols());
        int rowlen = ((AsciiTable)this.myData).addColInfo(this.getNCols() - 1, iter);
        int oldRowlen = this.myHeader.getIntValue(Standard.NAXIS1);
        this.myHeader.setNaxis(1, rowlen + oldRowlen);
        super.addColumn(newCol);
        Standard.context(null);
        return this.getNCols();
    }

    @Override
    protected IFitsHeader[] columnKeyStems() {
        return KEY_STEMS;
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("ASCII Table:");
        stream.println("  Header:");
        stream.println("    Number of fields:" + this.myHeader.getIntValue(Standard.TFIELDS));
        stream.println("    Number of rows:  " + this.myHeader.getIntValue(Standard.NAXIS2));
        stream.println("    Length of row:   " + this.myHeader.getIntValue(Standard.NAXIS1));
        stream.println("  Data:");
        Object[] data = (Object[])this.getKernel();
        for (int i = 0; i < this.getNCols(); ++i) {
            stream.println("      " + i + ":" + ArrayFuncs.arrayDescription(data[i]));
        }
    }

    public boolean isNull(int row, int col) {
        return ((AsciiTable)this.myData).isNull(row, col);
    }

    public void setNull(int row, int col, boolean flag) {
        String nullStr;
        if (flag && (nullStr = this.myHeader.getStringValue(Standard.TNULLn.n(col + 1))) == null) {
            this.setNullString(col, "NULL");
        }
        ((AsciiTable)this.myData).setNull(row, col, flag);
    }

    public void setNullString(int col, String newNull) throws IllegalArgumentException {
        this.myHeader.positionAfterIndex(Standard.TBCOLn, col + 1);
        HeaderCard card = HeaderCard.create(Standard.TNULLn.n(col + 1), newNull);
        this.myHeader.deleteKey(card.getKey());
        this.myHeader.addLine(card);
        ((AsciiTable)this.myData).setNullString(col, newNull);
    }
}

