/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsIntegrityException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.NullDataHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.fits.utilities.FitsCheckSum;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.FitsOutput;
import nom.tam.util.LoggerHelper;
import nom.tam.util.RandomAccess;

public abstract class BasicHDU<DataClass extends Data>
implements FitsElement {
    private static final int MAX_NAXIS_ALLOWED = 999;
    private static final Logger LOG = LoggerHelper.getLogger(BasicHDU.class);
    @Deprecated
    public static final int BITPIX_BYTE = 8;
    @Deprecated
    public static final int BITPIX_SHORT = 16;
    @Deprecated
    public static final int BITPIX_INT = 32;
    @Deprecated
    public static final int BITPIX_LONG = 64;
    @Deprecated
    public static final int BITPIX_FLOAT = -32;
    @Deprecated
    public static final int BITPIX_DOUBLE = -64;
    protected Header myHeader = null;
    protected DataClass myData = null;

    protected BasicHDU(Header myHeader, DataClass myData) {
        this.setHeader(myHeader);
        this.myData = myData;
    }

    private void setHeader(Header header) {
        this.myHeader = header;
        if (header != null) {
            this.myHeader.assignTo(this);
        }
    }

    @Deprecated
    public static NullDataHDU getDummyHDU() {
        return new NullDataHDU();
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public static boolean isData(Object o) {
        return false;
    }

    public void addValue(IFitsHeader key, boolean val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, double val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, int val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, String val) throws HeaderCardException {
        this.myHeader.addValue(key.key(), val, key.comment());
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, int val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.myHeader.addValue(key, val, comment);
    }

    final boolean canBePrimary() {
        return "IMAGE".equals(this.getCanonicalXtension());
    }

    public String getAuthor() {
        return this.myHeader.getStringValue(Standard.AUTHOR);
    }

    public int[] getAxes() throws FitsException {
        int nAxis = this.myHeader.getIntValue(Standard.NAXIS, 0);
        if (nAxis < 0) {
            throw new FitsException("Negative NAXIS value " + nAxis);
        }
        if (nAxis > 999) {
            throw new FitsException("NAXIS value " + nAxis + " too large");
        }
        if (nAxis == 0) {
            return null;
        }
        int[] axes = new int[nAxis];
        for (int i = 1; i <= nAxis; ++i) {
            axes[nAxis - i] = this.myHeader.getIntValue(Standard.NAXISn.n(i), 0);
        }
        return axes;
    }

    public Bitpix getBitpix() throws FitsException {
        return Bitpix.fromHeader(this.myHeader);
    }

    public final int getBitPix() throws FitsException {
        return this.getBitpix().getHeaderValue();
    }

    public String getBUnit() {
        return this.myHeader.getStringValue(Standard.BUNIT);
    }

    public long getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey(Standard.BLANK.key())) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getLongValue(Standard.BLANK);
    }

    @Deprecated
    public double getBScale() {
        return this.myHeader.getDoubleValue(Standard.BSCALE, 1.0);
    }

    @Deprecated
    public double getBZero() {
        return this.myHeader.getDoubleValue(Standard.BZERO, 0.0);
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue(Standard.DATE)).toDate();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to convert string to FITS date", e);
            return null;
        }
    }

    public DataClass getData() {
        return this.myData;
    }

    @Deprecated
    public double getEpoch() {
        return this.myHeader.getDoubleValue(Standard.EPOCH, -1.0);
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue(Standard.EQUINOX, -1.0);
    }

    @Override
    public long getFileOffset() {
        return this.myHeader.getFileOffset();
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue(Standard.GCOUNT, 1);
    }

    public long getStoredChecksum() throws FitsException {
        return FitsCheckSum.getStoredChecksum(this.myHeader);
    }

    public long getStoredDatasum() throws FitsException {
        return FitsCheckSum.getStoredDatasum(this.myHeader);
    }

    public void setChecksum() throws FitsException {
        FitsCheckSum.setChecksum(this);
    }

    public boolean verifyIntegrity() throws FitsException, IOException {
        long fsum;
        boolean result = this.verifyDataIntegrity();
        if (this.myHeader.getCard(Checksum.CHECKSUM) == null) {
            return result;
        }
        long l = fsum = this.myHeader.getStreamChecksum() < 0L ? FitsCheckSum.checksum(this.myHeader.getRandomAccessInput(), this.getFileOffset(), this.getSize()) : FitsCheckSum.sumOf(this.myHeader.getStreamChecksum(), ((Data)this.myData).getStreamChecksum());
        if (fsum != 0xFFFFFFFFL) {
            throw new FitsIntegrityException("checksum", fsum, 0xFFFFFFFFL);
        }
        return true;
    }

    public boolean verifyDataIntegrity() throws FitsException, IOException {
        long fsum;
        if (this.getHeader().getCard(Checksum.DATASUM) == null) {
            return false;
        }
        DataClass d = this.getData();
        RandomAccess rin = ((Data)this.myData).getRandomAccessInput();
        long l = fsum = rin != null ? FitsCheckSum.checksum(rin, ((Data)d).getFileOffset(), ((Data)d).getSize()) : ((Data)d).getStreamChecksum();
        if (fsum != this.getStoredDatasum()) {
            throw new FitsIntegrityException("datasum", fsum, this.getStoredDatasum());
        }
        return true;
    }

    public long calcChecksum() throws FitsException {
        return FitsCheckSum.checksum(this);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    public HeaderCardBuilder card(IFitsHeader key) {
        return this.myHeader.card(key);
    }

    public String getInstrument() {
        return this.myHeader.getStringValue(Standard.INSTRUME);
    }

    public final Object getKernel() {
        try {
            return ((Data)this.myData).getKernel();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to get kernel data", e);
            return null;
        }
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue(Standard.DATAMAX);
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue(Standard.DATAMIN);
    }

    public String getObject() {
        return this.myHeader.getStringValue(Standard.OBJECT);
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue(Standard.DATE_OBS)).toDate();
        }
        catch (FitsException e) {
            LOG.log(Level.SEVERE, "Unable to convert string to FITS observation date", e);
            return null;
        }
    }

    public String getObserver() {
        return this.myHeader.getStringValue(Standard.OBSERVER);
    }

    public String getOrigin() {
        return this.myHeader.getStringValue(Standard.ORIGIN);
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue(Standard.PCOUNT, 0);
    }

    public String getReference() {
        return this.myHeader.getStringValue(Standard.REFERENC);
    }

    @Override
    public long getSize() {
        long size = 0L;
        if (this.myHeader != null) {
            size += this.myHeader.getSize();
        }
        if (this.myData != null) {
            size += ((Data)this.myData).getSize();
        }
        return size;
    }

    public String getTelescope() {
        return this.myHeader.getStringValue(Standard.TELESCOP);
    }

    public String getTrimmedString(String keyword) {
        String s = this.myHeader.getStringValue(keyword);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    public String getTrimmedString(IFitsHeader keyword) {
        return this.getTrimmedString(keyword.key());
    }

    public abstract void info(PrintStream var1) throws FitsException;

    @Override
    public void read(ArrayDataInput stream) throws FitsException, IOException {
        this.setHeader(Header.readHeader(stream));
        this.myData = FitsFactory.dataFactory(this.myHeader);
        ((Data)this.myData).read(stream);
    }

    @Override
    public boolean reset() {
        return this.myHeader.reset();
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite HDU");
        }
        this.myHeader.rewrite();
        if (!((Data)this.myData).isDeferred()) {
            ((Data)this.myData).rewrite();
        }
    }

    @Override
    public boolean rewriteable() {
        return this.myHeader.rewriteable() && ((Data)this.myData).rewriteable();
    }

    void setPrimaryHDU(boolean value) throws FitsException {
        if (value && !this.canBePrimary()) {
            throw new FitsException("Invalid attempt to make HDU of type:" + this.getClass().getName() + " primary.");
        }
        Header.KeywordCheck mode = this.myHeader.getKeywordChecking();
        this.myHeader.setKeywordChecking(Header.KeywordCheck.DATA_TYPE);
        this.myHeader.setRequiredKeys(value ? null : this.getCanonicalXtension());
        this.myHeader.setKeywordChecking(mode);
    }

    protected String getCanonicalXtension() {
        LOG.warning(this.getClass().getName() + " should override getCanonicalXtension() method as appropriate.");
        return "UNKNOWN";
    }

    @Override
    public void write(ArrayDataOutput stream) throws FitsException {
        if (this.myHeader == null) {
            this.setHeader(new Header());
        }
        if (stream instanceof FitsOutput) {
            boolean isFirst = ((FitsOutput)stream).isAtStart();
            this.setPrimaryHDU(this.canBePrimary() && isFirst);
        }
        this.myHeader.write(stream);
        if (this.myData != null) {
            ((Data)this.myData).write(stream);
        }
        try {
            stream.flush();
        }
        catch (IOException e) {
            throw new FitsException("Error flushing at end of HDU", e);
        }
    }
}

