/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import nom.tam.fits.AbstractTableData;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsHeap;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.ComplexValue;
import nom.tam.util.Cursor;
import nom.tam.util.FitsEncoder;
import nom.tam.util.Quantizer;
import nom.tam.util.RandomAccess;
import nom.tam.util.ReadWriteAccess;
import nom.tam.util.TableException;
import nom.tam.util.type.ElementType;

public class BinaryTable
extends AbstractTableData
implements Cloneable {
    private static final char POINTER_NONE = '\u0000';
    private static final char POINTER_INT = 'P';
    private static final char POINTER_LONG = 'Q';
    private static final int[] SINGLETON_SHAPE = new int[0];
    private static final String SUBSTRING_MARKER = ":SSTR";
    private static final Logger LOG = Logger.getLogger(BinaryTable.class.getName());
    private FitsHeap heap;
    private long heapAddress;
    private int heapReserve;
    private int heapFileSize;
    private List<ColumnDesc> columns;
    private int nRow;
    private int rowLen;
    private ColumnTable<?> table;
    private FitsEncoder encoder;

    public BinaryTable() {
        this.table = new ColumnTable();
        this.columns = new ArrayList<ColumnDesc>();
        this.heap = new FitsHeap(0);
        this.nRow = 0;
        this.rowLen = 0;
    }

    public BinaryTable(ColumnTable<?> tab) throws FitsException {
        this();
        this.table = new ColumnTable();
        this.nRow = tab.getNRows();
        this.columns = new ArrayList<ColumnDesc>();
        for (int i = 0; i < tab.getNCols(); ++i) {
            int[] nArray;
            int n = tab.getElementSize(i);
            Class<?> clazz = tab.getElementClass(i);
            if (n > 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = n;
            } else {
                nArray = SINGLETON_SHAPE;
            }
            ColumnDesc c = new ColumnDesc(clazz, nArray);
            this.addFlattenedColumn(tab.getColumn(i), this.nRow, c, true);
        }
    }

    public BinaryTable(Header header) throws FitsException {
        long heapOffsetL;
        long paramSizeL;
        String ext = header.getStringValue(Standard.XTENSION, "IMAGE");
        if (!ext.equalsIgnoreCase("BINTABLE") && !ext.equalsIgnoreCase("A3DTABLE")) {
            throw new FitsException("Not a binary table header (XTENSION = " + header.getStringValue(Standard.XTENSION) + ")");
        }
        this.nRow = header.getIntValue(Standard.NAXIS2);
        long tableSize = (long)this.nRow * header.getLongValue(Standard.NAXIS1);
        long heapSizeL = tableSize + (paramSizeL = header.getLongValue(Standard.PCOUNT)) - (heapOffsetL = header.getLongValue(Standard.THEAP, tableSize));
        if (heapSizeL < 0L) {
            throw new FitsException("Inconsistent THEAP and PCOUNT");
        }
        if (heapSizeL > Integer.MAX_VALUE) {
            throw new FitsException("Heap size > 2 GB");
        }
        if (heapSizeL == 0L) {
            this.heapAddress = 0L;
        }
        this.heapAddress = (int)heapOffsetL;
        this.heapFileSize = (int)heapSizeL;
        int nCol = header.getIntValue(Standard.TFIELDS);
        this.rowLen = 0;
        this.columns = new ArrayList<ColumnDesc>();
        for (int col = 0; col < nCol; ++col) {
            this.rowLen += this.processCol(header, col, this.rowLen);
        }
        HeaderCard card = header.getCard(Standard.NAXIS1);
        card.setValue(this.rowLen);
    }

    public BinaryTable(Object[][] rowColTable) throws FitsException {
        this();
        for (Object[] row : rowColTable) {
            this.addRow(row);
        }
    }

    public static BinaryTable fromRowMajor(Object[][] table) throws FitsException {
        BinaryTable tab = new BinaryTable();
        for (Object[] row : table) {
            tab.addRow(row);
        }
        return tab;
    }

    public BinaryTable(Object[] columns) throws FitsException {
        this();
        for (Object element : columns) {
            this.addColumn(element);
        }
    }

    public static BinaryTable fromColumnMajor(Object[] columns) throws FitsException {
        BinaryTable t = new BinaryTable();
        for (Object element : columns) {
            t.addColumn(element);
        }
        return t;
    }

    protected BinaryTable clone() {
        try {
            return (BinaryTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BinaryTable copy() throws FitsException {
        BinaryTable copy = this.clone();
        if (this.table != null) {
            copy.table = this.table.copy();
        }
        if (this.heap != null) {
            BinaryTable binaryTable = copy;
            synchronized (binaryTable) {
                copy.heap = this.heap.copy();
            }
        }
        copy.columns = new ArrayList<ColumnDesc>();
        for (ColumnDesc c : this.columns) {
            c = c.clone();
            copy.columns.add(c);
        }
        return copy;
    }

    protected synchronized void discardVLAs() {
        for (int col = 0; col < this.columns.size(); ++col) {
            ColumnDesc c = this.columns.get(col);
            if (!c.isVariableSize()) continue;
            for (int row = 0; row < this.nRow; ++row) {
                this.table.setElement(row, col, c.hasLongPointers() ? new long[2] : (long[])new int[2]);
            }
        }
        this.heap = new FitsHeap(0);
    }

    final int getRowBytes() {
        return this.rowLen;
    }

    public static void createColumnDataFor(BinaryTable table) throws FitsException {
        table.createTable(table.nRow);
    }

    public static int[] parseTDims(String tdims) {
        StringTokenizer st;
        int dim;
        if (tdims == null) {
            return null;
        }
        int start = tdims.indexOf(40);
        if (start < 0) {
            return null;
        }
        int end = tdims.indexOf(41, start);
        if (end < 0) {
            end = tdims.length();
        }
        if ((dim = (st = new StringTokenizer(tdims.substring(start + 1, end), ",")).countTokens()) > 0) {
            int[] dims = new int[dim];
            int i = dim;
            while (--i >= 0) {
                dims[i] = Integer.parseInt(st.nextToken().trim());
            }
            return dims;
        }
        return null;
    }

    public int addComplexColumn(Object o, Class<?> decimalType) throws FitsException {
        int col = this.columns.size();
        int eSize = this.addColumn(ArrayFuncs.complexToDecimals(o, decimalType));
        ColumnDesc c = this.columns.get(col);
        c.isComplex = true;
        c.setLegacyShape(c.fitsShape);
        return eSize;
    }

    public int addStringColumn(String[] o) throws FitsException {
        this.checkRowCount(o);
        ColumnDesc c = new ColumnDesc(String.class);
        int min = FitsUtil.minStringLength(o);
        int max = FitsUtil.maxStringLength(o);
        if (max - min > 2 * ElementType.forClass(c.pointerClass()).size()) {
            c = ColumnDesc.createForVariableSize(String.class);
            return this.addVariableSizeColumn(o, c);
        }
        c = ColumnDesc.createForStrings(max);
        return this.addFlattenedColumn((Object)o, o.length, c, false);
    }

    public int addBitsColumn(Object o) throws FitsException {
        if (ArrayFuncs.getBaseClass(o) != Boolean.TYPE) {
            throw new IllegalArgumentException("Not an array of booleans: " + o.getClass());
        }
        return this.addColumn(o, false);
    }

    public int addColumn(ColumnDesc descriptor) throws IllegalStateException {
        if (this.nRow != 0) {
            throw new IllegalStateException("Cannot add empty columns to table already containing data rows");
        }
        descriptor.offset = this.rowLen;
        this.rowLen += descriptor.rowLen();
        if (descriptor.name() == null) {
            descriptor.name(TableHDU.getDefaultColumnName(this.columns.size()));
        }
        this.columns.add(descriptor);
        return this.columns.size();
    }

    private static Object entryToColumnArray(Object o) throws FitsException {
        int[] dim;
        if ((o = BinaryTable.boxedToArray(o)).getClass().isArray() && (dim = ArrayFuncs.getDimensions(o)).length == 1 && dim[0] == 1) {
            return o;
        }
        Object[] array = (Object[])Array.newInstance(o.getClass(), 1);
        array[0] = o;
        return array;
    }

    @Override
    public int addColumn(Object o) throws FitsException {
        return this.addColumn(o, true);
    }

    private int checkRowCount(Object o) throws FitsException {
        if (!o.getClass().isArray()) {
            throw new TableException("Not an array: " + o.getClass().getName());
        }
        int rows = Array.getLength(o);
        if (this.columns.size() != 0 && rows != this.nRow) {
            throw new TableException("Mismatched number of rows: " + rows + ", expected " + this.nRow);
        }
        return rows;
    }

    private int addColumn(Object o, boolean compat) throws FitsException {
        o = BinaryTable.boxedToArray(o);
        int rows = this.checkRowCount(o);
        ColumnDesc c = new ColumnDesc(ArrayFuncs.getBaseClass(o));
        if (ArrayFuncs.getBaseClass(o) == ComplexValue.class) {
            o = ArrayFuncs.complexToDecimals(o, Double.TYPE);
            c.isComplex = true;
        }
        try {
            int[] dim = ArrayFuncs.checkRegularArray(o, c.isNullAllowed());
            if (c.isString()) {
                c.setStringLength(FitsUtil.maxStringLength(o));
            }
            if (c.isComplex) {
                dim = Arrays.copyOf(dim, dim.length - 1);
                o = ArrayFuncs.flatten(o);
            }
            if (dim.length <= 1) {
                c.setSingleton();
            } else {
                int[] shape = new int[dim.length - 1];
                System.arraycopy(dim, 1, shape, 0, shape.length);
                c.setLegacyShape(shape);
                o = ArrayFuncs.flatten(o);
            }
        }
        catch (IllegalArgumentException e) {
            c.setVariableSize(false);
            return this.addVariableSizeColumn(o, c);
        }
        return this.addFlattenedColumn(o, rows, c, compat);
    }

    public int addVariableSizeColumn(Object o) throws FitsException {
        Class<?> base = ArrayFuncs.getBaseClass(o);
        ColumnDesc c = ColumnDesc.createForVariableSize(base);
        return this.addVariableSizeColumn(o, c);
    }

    private int addDirectColumn(Object o, int rows, ColumnDesc c) throws FitsException {
        c.offset = this.rowLen;
        this.rowLen += c.rowLen();
        this.ensureData();
        c.name(TableHDU.getDefaultColumnName(this.columns.size()));
        this.table.addColumn(o, c.getTableBaseCount());
        this.columns.add(c);
        if (this.nRow == 0) {
            this.nRow = rows;
        }
        return this.columns.size();
    }

    private int addVariableSizeColumn(Object o, ColumnDesc c) throws FitsException {
        this.checkRowCount(o);
        Object[] array = (Object[])o;
        o = Array.newInstance(c.pointerClass(), array.length * 2);
        for (int i = 0; i < array.length; ++i) {
            boolean multi;
            boolean bl = multi = c.isComplex() ? array[i] instanceof Object[][] : array[i] instanceof Object[];
            if (multi) {
                int[] dim;
                boolean canBeComplex = false;
                if ((c.getFitsBase() == Float.TYPE || c.getFitsBase() == Double.TYPE) && (dim = ArrayFuncs.getDimensions(array[i]))[dim.length - 1] == 2) {
                    canBeComplex = true;
                }
                if (!canBeComplex && !c.warnedFlatten) {
                    LOG.warning("Table entries of " + array[i].getClass() + " will be stored as 1D arrays in variable-length columns. Array shape(s) and intermittent null subarrays (if any) will be lost.");
                    c.warnedFlatten = true;
                }
            }
            Object p = this.putOnHeap(c, array[i], null);
            System.arraycopy(p, 0, o, 2 * i, 2);
        }
        return this.addDirectColumn(o, array.length, c);
    }

    public int addFlattenedColumn(Object o, int ... dims) throws FitsException {
        ColumnDesc c = new ColumnDesc(ArrayFuncs.getBaseClass(o));
        try {
            ArrayFuncs.checkRegularArray(o, c.isNullAllowed());
        }
        catch (IllegalArgumentException e) {
            throw new FitsException("Irregular array: " + o.getClass() + ": " + e.getMessage(), e);
        }
        if (c.isString()) {
            c.setStringLength(FitsUtil.maxStringLength(o));
        }
        int n = 1;
        c.setLegacyShape(dims);
        for (int dim : dims) {
            n *= dim;
        }
        int rows = Array.getLength(o) / n;
        return this.addFlattenedColumn(o, rows, c, true);
    }

    private void checkFlattenedColumnSize(ColumnDesc c, Object o) throws FitsException {
        if (c.getTableBaseCount() == 0) {
            LOG.warning("Elements of column + " + this.columns.size() + " have zero storage size.");
        } else if (this.columns.size() > 0) {
            int l = Array.getLength(o);
            if (this.nRow > 0 && l != this.nRow * c.getTableBaseCount()) {
                throw new TableException("Mismatched element count " + l + ", expected " + this.nRow * c.getTableBaseCount());
            }
        }
    }

    private int addFlattenedColumn(Object o, int rows, ColumnDesc c, boolean compat) throws FitsException {
        if (compat) {
            c.isBits = false;
        }
        if (c.isBits) {
            boolean[] bits = (boolean[])o;
            o = FitsUtil.bitsToBytes(bits, bits.length / rows);
        } else {
            o = this.javaToFits1D(c, o);
        }
        this.checkFlattenedColumnSize(c, o);
        return this.addDirectColumn(o, rows, c);
    }

    @Override
    public int addRow(Object[] o) throws FitsException {
        this.ensureData();
        if (this.columns.isEmpty()) {
            for (Object element : o) {
                if (element == null) {
                    throw new TableException("Prototype row may not contain null");
                }
                this.addColumn(BinaryTable.entryToColumnArray(element));
            }
        } else {
            if (o.length != this.columns.size()) {
                throw new TableException("Mismatched row size: " + o.length + ", expected " + this.columns.size());
            }
            Object[] flatRow = new Object[this.getNCols()];
            for (int i = 0; i < flatRow.length; ++i) {
                ColumnDesc c = this.columns.get(i);
                flatRow[i] = c.isVariableSize() ? this.putOnHeap(c, o[i], null) : this.javaToFits1D(c, ArrayFuncs.flatten(o[i]));
            }
            this.table.addRow(flatRow);
            ++this.nRow;
        }
        return this.nRow;
    }

    @Override
    public void deleteColumns(int start, int len) throws FitsException {
        this.ensureData();
        this.table.deleteColumns(start, len);
        ArrayList<ColumnDesc> remain = new ArrayList<ColumnDesc>(this.columns.size() - len);
        this.rowLen = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i >= start && i < start + len) continue;
            ColumnDesc c = this.columns.get(i);
            c.offset = this.rowLen;
            this.rowLen += c.rowLen();
            remain.add(c);
        }
        this.columns = remain;
    }

    @Override
    public void deleteRows(int row, int len) throws FitsException {
        this.ensureData();
        this.table.deleteRows(row, len);
        this.nRow -= len;
    }

    public Class<?>[] getBases() {
        return this.table.getBases();
    }

    @Override
    public Object getColumn(int col) throws FitsException {
        ColumnDesc c = this.columns.get(col);
        if (!c.isVariableSize() && c.fitsDimension() == 0 && !c.isComplex()) {
            return this.getFlattenedColumn(col);
        }
        this.ensureData();
        Object[] data = null;
        for (int i = 0; i < this.nRow; ++i) {
            Object e = this.getElement(i, col);
            if (data == null) {
                data = (Object[])Array.newInstance(e.getClass(), this.nRow);
            }
            data[i] = e;
        }
        return data;
    }

    public int indexOf(String name) {
        for (int col = 0; col < this.columns.size(); ++col) {
            if (!name.equals(this.getDescriptor(col).name())) continue;
            return col;
        }
        return -1;
    }

    @Override
    protected ColumnTable<?> getCurrentData() {
        return this.table;
    }

    @Override
    public ColumnTable<?> getData() throws FitsException {
        return (ColumnTable)super.getData();
    }

    public int[][] getDimens() {
        int[][] dimens = new int[this.columns.size()][];
        for (int i = 0; i < dimens.length; ++i) {
            dimens[i] = this.columns.get(i).getDimens();
        }
        return dimens;
    }

    public Object[] getFlatColumns() throws FitsException {
        this.ensureData();
        return this.table.getColumns();
    }

    public Object getFlattenedColumn(int col) throws FitsException {
        if (!this.validColumn(col)) {
            throw new TableException("Invalid column index " + col + " in table of " + this.getNCols() + " columns");
        }
        ColumnDesc c = this.columns.get(col);
        if (c.isVariableSize()) {
            throw new TableException("Cannot flatten variable-sized column data");
        }
        this.ensureData();
        if (c.isBits()) {
            boolean[] bits = new boolean[this.nRow * c.fitsCount];
            for (int i = 0; i < this.nRow; ++i) {
                boolean[] seg = (boolean[])this.fitsToJava1D(c, this.table.getElement(i, col), c.fitsCount, false);
                System.arraycopy(seg, 0, bits, i * c.fitsCount, c.fitsCount);
            }
            return bits;
        }
        return this.fitsToJava1D(c, this.table.getColumn(col), 0, false);
    }

    public void reserveRowSpace(int rows) {
        this.heapAddress = rows > 0 ? this.getRegularTableSize() + (long)rows * (long)this.getRowBytes() : 0L;
    }

    public void reserveHeapSpace(int bytes) {
        this.heapReserve = Math.max(0, bytes);
    }

    final long getHeapAddress() {
        long tableSize = this.getRegularTableSize();
        return this.heapAddress > tableSize ? this.heapAddress : tableSize;
    }

    final long getHeapOffset() {
        return this.getHeapAddress() - this.getRegularTableSize();
    }

    private int getHeapSize() {
        if (this.heap != null && this.heap.size() + this.heapReserve > this.heapFileSize) {
            return this.heap.size() + this.heapReserve;
        }
        return this.heapFileSize;
    }

    synchronized long getParameterSize() {
        return this.getHeapOffset() + (long)this.getHeapSize();
    }

    public Object[] getModelRow() {
        Object[] modelRow = new Object[this.columns.size()];
        for (int i = 0; i < modelRow.length; ++i) {
            ColumnDesc c = this.columns.get(i);
            modelRow[i] = c.fitsDimension() < 2 ? Array.newInstance(c.getTableBase(), c.getTableBaseCount()) : Array.newInstance(c.getTableBase(), c.fitsShape);
        }
        return modelRow;
    }

    @Override
    public int getNCols() {
        return this.columns.size();
    }

    @Override
    public int getNRows() {
        return this.nRow;
    }

    private synchronized void readTableElement(Object o, ColumnDesc c, int row) throws IOException, FitsException {
        RandomAccess in = this.getRandomAccessInput();
        in.position(this.getFileOffset() + (long)row * (long)this.rowLen + (long)c.offset);
        if (c.isLogical()) {
            in.readArrayFully(o);
        } else {
            in.readImage(o);
        }
    }

    public Object getRawElement(int row, int col) throws FitsException {
        if (!this.validRow(row) || !this.validColumn(col)) {
            throw new TableException("No such element (" + row + "," + col + ")");
        }
        if (this.table == null) {
            try {
                ColumnDesc c = this.columns.get(col);
                Object e = c.newInstance(1);
                this.readTableElement(e, c, row);
                return e;
            }
            catch (IOException e) {
                throw new FitsException("Error reading from input: " + e.getMessage(), e);
            }
        }
        this.ensureData();
        return this.table.getElement(row, col);
    }

    @Override
    public Object getElement(int row, int col) throws FitsException {
        return this.getElement(row, col, false);
    }

    private Object getElement(int row, int col, boolean isEnhanced) throws FitsException {
        if (!this.validRow(row) || !this.validColumn(col)) {
            throw new TableException("No such element (" + row + "," + col + ")");
        }
        ColumnDesc c = this.columns.get(col);
        Object o = this.getRawElement(row, col);
        if (c.isVariableSize()) {
            return this.getFromHeap(c, o, isEnhanced);
        }
        o = this.fitsToJava1D(c, o, c.isBits() ? c.fitsCount : 0, isEnhanced);
        if (c.legacyShape.length > 1) {
            return ArrayFuncs.curl(o, c.legacyShape);
        }
        return o;
    }

    public Object getArrayElement(int row, int col) {
        return this.getElement(row, col, true);
    }

    public Object getArrayElementAs(int row, int col, Class<?> asType) throws IllegalArgumentException {
        ColumnDesc c = this.getDescriptor(col);
        Object e = this.getElement(row, col, true);
        return asType.isAssignableFrom(c.getFitsBase()) ? e : ArrayFuncs.convertArray(e, asType, c.getQuantizer());
    }

    public Object get(int row, int col) throws FitsException {
        ColumnDesc c = this.columns.get(col);
        Object e = this.getElement(row, col, true);
        return c.isSingleton() && e.getClass().isArray() ? Array.get(e, 0) : e;
    }

    public final Number getNumber(int row, int col) throws FitsException, ClassCastException, NumberFormatException {
        Object o = this.get(row, col);
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException e) {
                return Double.parseDouble((String)o);
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return (Number)o;
    }

    public final double getDouble(int row, int col) throws FitsException, ClassCastException {
        Quantizer q;
        Number n = this.getNumber(row, col);
        if (!(n instanceof Float) && !(n instanceof Double) && (q = this.getDescriptor(col).getQuantizer()) != null) {
            return q.toDouble(n.longValue());
        }
        return n == null ? Double.NaN : n.doubleValue();
    }

    public final long getLong(int row, int col) throws FitsException, ClassCastException, IllegalStateException {
        Quantizer q;
        Number n = this.getNumber(row, col);
        if ((n instanceof Float || n instanceof Double) && (q = this.getDescriptor(col).getQuantizer()) != null) {
            return q.toLong(n.doubleValue());
        }
        if (Double.isNaN(n.doubleValue())) {
            throw new IllegalStateException("Cannot convert NaN to long without Quantizer");
        }
        return n.longValue();
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null has specific meaning here")
    public final Boolean getLogical(int row, int col) throws FitsException, ClassCastException {
        Object o = this.get(row, col);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (Double.isNaN(n.doubleValue())) {
                return null;
            }
            return n.longValue() != 0L;
        }
        if (o instanceof Character) {
            char c = ((Character)o).charValue();
            if (c == 'T' || c == 't' || c == '1') {
                return true;
            }
            if (c == 'F' || c == 'f' || c == '0') {
                return false;
            }
            return null;
        }
        if (o instanceof String) {
            return FitsUtil.parseLogical((String)o);
        }
        return (Boolean)o;
    }

    public final String getString(int row, int col) throws FitsException, ClassCastException {
        ColumnDesc c = this.columns.get(col);
        Object value = this.get(row, col);
        if (value == null) {
            return "null";
        }
        if (!value.getClass().isArray()) {
            return value.toString();
        }
        if (c.fitsDimension() > 1) {
            throw new ClassCastException("Cannot convert multi-dimensional array element to String");
        }
        if (value instanceof char[]) {
            return String.valueOf((char[])value).trim();
        }
        if (value instanceof byte[]) {
            return AsciiFuncs.asciiString((byte[])value).trim();
        }
        throw new ClassCastException("Cannot convert " + value.getClass().getName() + " to String.");
    }

    @Override
    public Object[] getRow(int row) throws FitsException {
        if (!this.validRow(row)) {
            throw new TableException("Invalid row index " + row + " in table of " + this.getNRows() + " rows");
        }
        Object[] data = new Object[this.columns.size()];
        for (int col = 0; col < data.length; ++col) {
            data[col] = this.getElement(row, col);
        }
        return data;
    }

    public int[] getSizes() {
        int[] sizes = new int[this.columns.size()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.columns.get(i).getTableBaseCount();
        }
        return sizes;
    }

    private long getRegularTableSize() {
        return (long)this.nRow * (long)this.rowLen;
    }

    @Override
    protected long getTrueSize() {
        return this.getRegularTableSize() + this.getParameterSize();
    }

    public char[] getTypes() {
        char[] types = new char[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            types[i] = ElementType.forClass(this.columns.get(i).getTableBase()).type();
        }
        return types;
    }

    @Override
    public void setColumn(int col, Object o) throws FitsException {
        ColumnDesc c = this.columns.get(col);
        if (c.isVariableSize()) {
            Object[] array = (Object[])o;
            for (int i = 0; i < this.nRow; ++i) {
                Object p = this.putOnHeap(c, ArrayFuncs.flatten(array[i]), this.getRawElement(i, col));
                this.setTableElement(i, col, p);
            }
        } else {
            this.setFlattenedColumn(col, o);
        }
    }

    private void writeTableElement(int row, int col, Object array) throws IOException {
        ColumnDesc c = this.columns.get(col);
        this.getRandomAccessInput().position(this.getFileOffset() + (long)row * (long)this.rowLen + (long)c.offset);
        this.encoder.writeArray(array);
    }

    private void setTableElement(int row, int col, Object o) throws FitsException {
        if (this.table == null) {
            try {
                this.writeTableElement(row, col, o);
            }
            catch (IOException e) {
                throw new FitsException(e.getMessage(), e);
            }
        } else {
            this.ensureData();
            this.table.setElement(row, col, o);
        }
    }

    @Override
    public void setElement(int row, int col, Object o) throws FitsException {
        ColumnDesc c = this.columns.get(col);
        o = c.isVariableSize() ? this.putOnHeap(c, o, this.getRawElement(row, col)) : this.javaToFits1D(c, ArrayFuncs.flatten(o));
        this.setTableElement(row, col, o);
    }

    public void set(int row, int col, Object o) throws FitsException, IllegalArgumentException {
        ColumnDesc c = this.columns.get(col);
        if (o == null) {
            if (!c.isSingleton()) {
                throw new TableException("No null values allowed for column of " + c.getLegacyBase() + " arrays.");
            }
            if (c.isString()) {
                this.setElement(row, col, "");
            } else {
                this.setLogical(row, col, null);
            }
        } else if (o.getClass().isArray()) {
            Class<?> eType = ArrayFuncs.getBaseClass(o);
            if (!c.getFitsBase().isAssignableFrom(eType) && c.isNumeric()) {
                o = ArrayFuncs.convertArray(o, c.getFitsBase(), c.getQuantizer());
            }
            this.setElement(row, col, o);
        } else if (o instanceof String) {
            this.setString(row, col, (String)o);
        } else {
            if (!c.isSingleton()) {
                throw new TableException("Cannot set scalar values in non-scalar columns");
            }
            if (c.isString()) {
                this.setElement(row, col, o.toString());
            } else if (o instanceof Boolean) {
                this.setLogical(row, col, (Boolean)o);
            } else if (o instanceof Character) {
                this.setCharacter(row, col, (Character)o);
            } else if (o instanceof Number) {
                this.setNumber(row, col, (Number)o);
            } else if (o instanceof ComplexValue) {
                this.setElement(row, col, o);
            } else {
                throw new IllegalArgumentException("Unsupported scalar type: " + o.getClass());
            }
        }
    }

    private void setNumber(int row, int col, Number value) throws FitsException, ClassCastException {
        ColumnDesc c = this.columns.get(col);
        if (c.isLogical()) {
            Boolean b = null;
            if (!Double.isNaN(value.doubleValue())) {
                b = value.longValue() != 0L;
            }
            this.setTableElement(row, col, new byte[]{FitsEncoder.byteForBoolean(b)});
            return;
        }
        Class<?> base = c.getLegacyBase();
        Quantizer q = c.getQuantizer();
        if (q != null) {
            boolean decimalValue;
            boolean decimalBase = base == Float.TYPE || base == Double.TYPE;
            boolean bl = decimalValue = value instanceof Float || value instanceof Double || value instanceof BigInteger || value instanceof BigDecimal;
            if (decimalValue && !decimalBase) {
                value = q.toLong(value.doubleValue());
            } else if (!decimalValue && decimalBase) {
                value = q.toDouble(value.longValue());
            }
        }
        Object[] wrapped = null;
        if (base == Byte.TYPE) {
            wrapped = new byte[]{value.byteValue()};
        } else if (base == Short.TYPE) {
            wrapped = new short[]{value.shortValue()};
        } else if (base == Integer.TYPE) {
            wrapped = new int[]{value.intValue()};
        } else if (base == Long.TYPE) {
            wrapped = new long[]{value.longValue()};
        } else if (base == Float.TYPE) {
            wrapped = new float[]{value.floatValue()};
        } else if (base == Double.TYPE) {
            wrapped = new double[]{value.doubleValue()};
        } else {
            throw new ClassCastException("Cannot set number value for column of type " + base);
        }
        this.setTableElement(row, col, wrapped);
    }

    private void setLogical(int row, int col, Boolean value) throws FitsException, ClassCastException {
        ColumnDesc c = this.columns.get(col);
        if (c.isLogical()) {
            this.setTableElement(row, col, new byte[]{FitsEncoder.byteForBoolean(value)});
        } else if (c.getLegacyBase() == Character.TYPE) {
            this.setTableElement(row, col, new char[]{value == null ? (char)'\u0000' : (value != false ? (char)'T' : 'F')});
        } else {
            this.setNumber(row, col, value == null ? Double.NaN : (double)(value != false ? 1 : 0));
        }
    }

    private void setCharacter(int row, int col, Character value) throws FitsException, ClassCastException {
        ColumnDesc c = this.columns.get(col);
        if (c.isLogical()) {
            this.setLogical(row, col, FitsUtil.parseLogical(value.toString()));
        } else if (c.fitsBase == Character.TYPE) {
            this.setTableElement(row, col, new char[]{value.charValue()});
        } else if (c.fitsBase == Byte.TYPE) {
            this.setTableElement(row, col, new byte[]{(byte)(value.charValue() & 0xFF)});
        } else {
            throw new ClassCastException("Cannot convert char value to " + c.fitsBase.getName());
        }
    }

    private void setString(int row, int col, String value) throws FitsException, ClassCastException, IllegalArgumentException, NumberFormatException {
        ColumnDesc c = this.columns.get(col);
        if (c.isLogical()) {
            this.setLogical(row, col, FitsUtil.parseLogical(value));
        } else if (value.length() == 1) {
            this.setCharacter(row, col, Character.valueOf(value.charAt(0)));
        } else {
            if (c.fitsDimension() > 1) {
                throw new ClassCastException("Cannot convert String to multi-dimensional array");
            }
            if (c.fitsDimension() == 1) {
                int len;
                if (c.fitsBase != Character.TYPE && c.fitsBase != Byte.TYPE) {
                    throw new ClassCastException("Cannot cast String to " + c.fitsBase.getName());
                }
                int n = len = c.isVariableSize() ? value.length() : c.fitsCount;
                if (value.length() > len) {
                    throw new IllegalArgumentException("String size " + value.length() + " exceeds entry size of " + len);
                }
                if (c.fitsBase == Character.TYPE) {
                    this.setTableElement(row, col, Arrays.copyOf(value.toCharArray(), len));
                } else {
                    this.setTableElement(row, col, FitsUtil.stringToByteArray(value, len));
                }
            } else {
                try {
                    this.setNumber(row, col, Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    this.setNumber(row, col, Double.parseDouble(value));
                }
            }
        }
    }

    public void setFlattenedColumn(int col, Object data) throws FitsException {
        this.ensureData();
        Object oldCol = this.table.getColumn(col);
        if (data.getClass() != oldCol.getClass() || Array.getLength(data) != Array.getLength(oldCol)) {
            throw new TableException("Replacement column mismatch at column:" + col);
        }
        this.table.setColumn(col, this.javaToFits1D(this.columns.get(col), data));
    }

    @Override
    public void setRow(int row, Object[] data) throws FitsException {
        this.ensureData();
        if (data.length != this.getNCols()) {
            throw new TableException("Mismatched number of columns: " + data.length + ", expected " + this.getNCols());
        }
        for (int col = 0; col < data.length; ++col) {
            this.set(row, col, data[col]);
        }
    }

    @Override
    public void updateAfterDelete(int oldNcol, Header hdr) throws FitsException {
        hdr.addValue(Standard.NAXIS1, this.rowLen);
        int l = 0;
        for (ColumnDesc d : this.columns) {
            d.offset = l;
            l += d.rowLen();
        }
    }

    @Override
    public void write(ArrayDataOutput os) throws FitsException {
        try {
            if (this.isDeferred() && os == this.getRandomAccessInput()) {
                ((RandomAccess)((Object)os)).skipAllBytes(this.getRegularTableSize());
            } else {
                this.ensureData();
                if (this.getRegularTableSize() > 0L) {
                    this.table.write(os);
                }
            }
            if (this.getParameterSize() > 0L) {
                byte[] b;
                for (long rem = this.getHeapOffset(); rem > 0L; rem -= (long)b.length) {
                    b = new byte[(int)Math.min(this.getHeapOffset(), 65536L)];
                    os.write(b);
                }
                this.getHeap().write(os);
                if (this.heapReserve > 0) {
                    byte[] b2 = new byte[this.heapReserve];
                    os.write(b2);
                }
            }
            FitsUtil.pad(os, this.getTrueSize(), (byte)0);
        }
        catch (IOException e) {
            throw new FitsException("Unable to write table:" + e, e);
        }
    }

    private long getPointerOffset(Object p) {
        return p instanceof long[] ? ((long[])p)[1] : (long)((int[])p)[1];
    }

    private long getPointerCount(Object p) {
        return p instanceof long[] ? ((long[])p)[0] : (long)((int[])p)[0];
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="not propagated or used locally")
    private Object putOnHeap(ColumnDesc c, Object o, Object oldPointer) throws FitsException {
        return this.putOnHeap(this.getHeap(), c, o, oldPointer);
    }

    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="not propagated or used locally")
    private Object putOnHeap(FitsHeap h, ColumnDesc c, Object o, Object oldPointer) throws FitsException {
        Object[] objectArray;
        o = ArrayFuncs.flatten(o);
        int off = h.size();
        int len = c.isComplex() || c.isString() ? -1 : Array.getLength(o);
        o = this.javaToFits1D(c, o);
        if (len < 0) {
            len = Array.getLength(o);
            if (c.isComplex() && o.getClass().getComponentType().isPrimitive()) {
                len >>>= 1;
            }
        }
        if (oldPointer != null && (long)len <= this.getPointerCount(oldPointer)) {
            off = (int)this.getPointerOffset(oldPointer);
        }
        h.putData(o, off);
        if (c.hasLongPointers()) {
            long[] lArray = new long[2];
            lArray[0] = len;
            objectArray = lArray;
            lArray[1] = off;
        } else {
            int[] nArray = new int[2];
            nArray[0] = len;
            objectArray = nArray;
            nArray[1] = off;
        }
        return objectArray;
    }

    protected Object getFromHeap(ColumnDesc c, Object p, boolean isEnhanced) throws FitsException {
        long len = this.getPointerCount(p);
        long off = this.getPointerOffset(p);
        if (off > Integer.MAX_VALUE || len > Integer.MAX_VALUE) {
            throw new FitsException("Data located beyond 32-bit accessible heap limit: off=" + off + ", len=" + len);
        }
        Object e = null;
        e = c.isComplex() ? Array.newInstance(c.getFitsBase(), (int)len, 2) : Array.newInstance(c.getFitsBase(), c.getFitsBaseCount((int)len));
        this.readHeap(off, e);
        return this.fitsToJava1D(c, e, (int)len, isEnhanced);
    }

    private Object javaToFits1D(ColumnDesc c, Object o) throws FitsException {
        if (c.isBits()) {
            return FitsUtil.bitsToBytes((boolean[])o);
        }
        if (c.isLogical()) {
            return FitsUtil.booleansToBytes(o);
        }
        if (c.isComplex() && (o instanceof ComplexValue || o instanceof ComplexValue[])) {
            return ArrayFuncs.complexToDecimals(o, c.fitsBase);
        }
        if (c.isString()) {
            if (o == null) {
                if (c.isVariableSize()) {
                    return new byte[0];
                }
                return Array.newInstance(Byte.TYPE, c.fitsShape);
            }
            if (o instanceof String) {
                int l = c.getStringLength();
                if (l < 0) {
                    l = ((String)o).length();
                }
                return FitsUtil.stringToByteArray((String)o, l);
            }
            if (c.isVariableSize() && c.delimiter != 0) {
                for (String s : (String[])o) {
                    c.setStringLength(Math.max(c.stringLength, s == null ? 1 : s.length() + 1));
                }
                return FitsUtil.stringsToDelimitedBytes((String[])o, c.getStringLength(), c.delimiter);
            }
            return FitsUtil.stringsToByteArray((String[])o, c.getStringLength(), (byte)32);
        }
        return BinaryTable.boxedToArray(o);
    }

    private Object fitsToJava1D(ColumnDesc c, Object o, int bits, boolean isEnhanced) {
        if (c.isBits()) {
            return FitsUtil.bytesToBits((byte[])o, bits);
        }
        if (c.isLogical()) {
            return isEnhanced ? FitsUtil.bytesToBooleanObjects(o) : (Object)FitsUtil.byteToBoolean((byte[])o);
        }
        if (c.isComplex() && isEnhanced) {
            return ArrayFuncs.decimalsToComplex(o);
        }
        if (c.isString()) {
            byte[] bytes = (byte[])o;
            int len = c.getStringLength();
            if (c.isVariableSize() && c.delimiter != 0) {
                return FitsUtil.delimitedBytesToStrings(bytes, c.getStringLength(), c.delimiter);
            }
            if (c.isSingleton()) {
                return FitsUtil.extractString(bytes, new ParsePosition(0), bytes.length, (byte)0);
            }
            String[] s = new String[bytes.length / len];
            for (int i = 0; i < s.length; ++i) {
                s[i] = FitsUtil.extractString(bytes, new ParsePosition(i * len), len, (byte)0);
            }
            return s;
        }
        return o;
    }

    protected void createTable(int rows) throws FitsException {
        int nfields = this.columns.size();
        Object[] data = new Object[nfields];
        int[] sizes = new int[nfields];
        for (int i = 0; i < nfields; ++i) {
            ColumnDesc c = this.columns.get(i);
            sizes[i] = c.getTableBaseCount();
            data[i] = c.newInstance(rows);
        }
        this.table = this.createColumnTable(data, sizes);
        this.nRow = rows;
    }

    private static Object boxedToArray(Object o) throws FitsException {
        if (o.getClass().isArray()) {
            return o;
        }
        if (o instanceof Number) {
            if (o instanceof Byte) {
                return new byte[]{(Byte)o};
            }
            if (o instanceof Short) {
                return new short[]{(Short)o};
            }
            if (o instanceof Integer) {
                return new int[]{(Integer)o};
            }
            if (o instanceof Long) {
                return new long[]{(Long)o};
            }
            if (o instanceof Float) {
                return new float[]{((Float)o).floatValue()};
            }
            if (o instanceof Double) {
                return new double[]{(Double)o};
            }
            throw new FitsException("Unsupported Number type: " + o.getClass());
        }
        if (o instanceof Boolean) {
            return new Boolean[]{(Boolean)o};
        }
        if (o instanceof Character) {
            return new char[]{((Character)o).charValue()};
        }
        return o;
    }

    private void setInput(ArrayDataInput in) {
        this.encoder = in instanceof ReadWriteAccess ? new FitsEncoder((ReadWriteAccess)((Object)in)) : null;
    }

    @Override
    public void read(ArrayDataInput in) throws FitsException {
        this.setInput(in);
        super.read(in);
    }

    @Override
    protected void loadData(ArrayDataInput in) throws IOException, FitsException {
        this.setInput(in);
        this.createTable(this.nRow);
        this.readTrueData(in);
    }

    public static ColumnDesc getDescriptor(Header header, int col) throws FitsException {
        String tform = header.getStringValue(Standard.TFORMn.n(col + 1));
        if (tform == null) {
            throw new FitsException("Missing TFORM" + (col + 1));
        }
        int count = 1;
        char type = '\u0000';
        ParsePosition pos = new ParsePosition(0);
        try {
            count = AsciiFuncs.parseInteger(tform, pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            type = Character.toUpperCase(AsciiFuncs.extractChar(tform, pos));
        }
        catch (Exception e) {
            throw new FitsException("Missing data type in TFORM: [" + tform + "]");
        }
        ColumnDesc c = new ColumnDesc();
        if (header.containsKey(Standard.TTYPEn.n(col + 1))) {
            c.name(header.getStringValue(Standard.TTYPEn.n(col + 1)));
        }
        if (type == 'P' || type == 'Q') {
            c.setVariableSize(type == 'Q');
            try {
                type = Character.toUpperCase(AsciiFuncs.extractChar(tform, pos));
            }
            catch (Exception e) {
                throw new FitsException("Missing variable-length data type in TFORM: [" + tform + "]");
            }
        }
        if (type == 'C' || type == 'M') {
            c.isComplex = true;
        } else if (type == 'X') {
            c.isBits = true;
        }
        if (!c.setFitsType(type)) {
            throw new FitsException("Invalid type '" + type + "' in column:" + col);
        }
        if (!c.isVariableSize()) {
            int[] dims = BinaryTable.parseTDims(header.getStringValue(Standard.TDIMn.n(col + 1)));
            if (dims == null) {
                int[] nArray;
                if (count == 1 && type != 'A') {
                    nArray = SINGLETON_SHAPE;
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = count;
                }
                c.setFitsShape(nArray);
                c.stringLength = -1;
            } else {
                c.setFitsShape(dims);
            }
        }
        if (c.isString()) {
            c.parseSubstringConvention(tform, pos, c.getStringLength() < 0);
        }
        c.fitsCount = count;
        c.quant = Quantizer.fromTableHeader(header, col);
        if (c.quant.isDefault()) {
            c.quant = null;
        }
        return c;
    }

    private int processCol(Header header, int col, int offset) throws FitsException {
        ColumnDesc c = BinaryTable.getDescriptor(header, col);
        c.offset = offset;
        this.columns.add(c);
        return c.rowLen();
    }

    protected void addByteVaryingColumn() {
        this.addColumn(ColumnDesc.createForVariableSize(Byte.TYPE));
    }

    protected ColumnTable<?> createColumnTable(Object[] arrCol, int[] sizes) throws TableException {
        return new ColumnTable(arrCol, sizes);
    }

    private synchronized FitsHeap getHeap() throws FitsException {
        if (this.heap == null) {
            this.readHeap(this.getRandomAccessInput());
        }
        return this.heap;
    }

    protected void readHeap(long offset, Object array) throws FitsException {
        this.getHeap().getData((int)offset, array);
    }

    protected synchronized void readHeap(ArrayDataInput input) throws FitsException {
        if (input instanceof RandomAccess) {
            FitsUtil.reposition(input, this.getFileOffset() + this.getHeapAddress());
        }
        this.heap = new FitsHeap(this.heapFileSize);
        if (input != null) {
            this.heap.read(input);
        }
    }

    protected synchronized void readTrueData(ArrayDataInput i) throws FitsException {
        try {
            this.table.read(i);
            i.skipAllBytes(this.getHeapOffset());
            if (this.heap == null) {
                this.readHeap(i);
            }
        }
        catch (IOException e) {
            throw new FitsException("Error reading binary table data:" + e, e);
        }
    }

    protected boolean validColumn(int j) {
        return j >= 0 && j < this.getNCols();
    }

    protected boolean validRow(int i) {
        return this.getNRows() > 0 && i >= 0 && i < this.getNRows();
    }

    @Override
    public void fillHeader(Header h) throws FitsException {
        this.fillHeader(h, true);
    }

    void fillHeader(Header h, boolean updateColumns) throws FitsException {
        h.deleteKey(Standard.SIMPLE);
        h.deleteKey(Standard.EXTEND);
        Standard.context(BinaryTable.class);
        Cursor<String, HeaderCard> c = h.iterator();
        c.add(HeaderCard.create((IFitsHeader)Standard.XTENSION, "BINTABLE"));
        c.add(HeaderCard.create((IFitsHeader)Standard.BITPIX, Bitpix.BYTE.getHeaderValue()));
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, 2));
        c.add(HeaderCard.create(Standard.NAXIS1, this.rowLen));
        c.add(HeaderCard.create(Standard.NAXIS2, this.nRow));
        if (h.getLongValue(Standard.PCOUNT, -1L) < this.getParameterSize()) {
            c.add(HeaderCard.create((IFitsHeader)Standard.PCOUNT, this.getParameterSize()));
        }
        c.add(HeaderCard.create((IFitsHeader)Standard.GCOUNT, 1));
        c.add(HeaderCard.create((IFitsHeader)Standard.TFIELDS, this.columns.size()));
        if (this.getHeapOffset() == 0L) {
            h.deleteKey(Standard.THEAP);
        } else {
            c.add(HeaderCard.create((IFitsHeader)Standard.THEAP, this.getHeapAddress()));
        }
        if (updateColumns) {
            for (int i = 0; i < this.columns.size(); ++i) {
                c.setKey(Standard.TFORMn.n(i + 1).key());
                this.fillForColumn(h, c, i);
            }
        }
        Standard.context(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillForColumn(Header header, Cursor<String, HeaderCard> hc, int col) throws FitsException {
        ColumnDesc c = this.columns.get(col);
        try {
            Standard.context(BinaryTable.class);
            if (c.name() != null) {
                hc.add(HeaderCard.create(Standard.TTYPEn.n(col + 1), c.name()));
            }
            hc.add(HeaderCard.create(Standard.TFORMn.n(col + 1), c.getTFORM()));
            String tdim = c.getTDIM();
            if (tdim != null) {
                hc.add(HeaderCard.create(Standard.TDIMn.n(col + 1), tdim));
            }
            if (c.quant != null) {
                c.quant.editTableHeader(header, col);
            }
        }
        finally {
            Standard.context(null);
        }
    }

    public ColumnDesc getDescriptor(int column) throws ArrayIndexOutOfBoundsException {
        return this.columns.get(column);
    }

    public ColumnDesc getDescriptor(String name) {
        int col = this.indexOf(name);
        return col < 0 ? null : this.getDescriptor(col);
    }

    public boolean convertToBits(int col) {
        ColumnDesc c = this.columns.get(col);
        if (c.isBits) {
            return true;
        }
        if (c.base != Boolean.TYPE) {
            return false;
        }
        c.isBits = true;
        return true;
    }

    public boolean setComplexColumn(int index) throws FitsException {
        int i;
        if (!this.validColumn(index)) {
            return false;
        }
        ColumnDesc c = this.columns.get(index);
        if (c.isComplex()) {
            return true;
        }
        if (c.base != Float.TYPE && c.base != Double.TYPE) {
            return false;
        }
        if (!c.isVariableSize()) {
            if (c.getLastFitsDim() != 2) {
                return false;
            }
            c.isComplex = true;
            c.setLegacyShape(c.fitsShape);
            return true;
        }
        for (i = 1; i < this.nRow; ++i) {
            if (this.getPointerCount(this.getRawElement(i, index)) % 2L == 0L) continue;
            return false;
        }
        for (i = 1; i < this.nRow; ++i) {
            Object p = this.getRawElement(i, index);
            long len = this.getPointerCount(p) >>> 1;
            if (c.hasLongPointers()) {
                ((long[])p)[0] = len;
            } else {
                ((int[])p)[0] = (int)len;
            }
            this.setTableElement(i, index, p);
        }
        c.isComplex = true;
        return true;
    }

    public final boolean containsHeap() {
        return this.getParameterSize() > 0L;
    }

    public synchronized long defragment() throws FitsException {
        if (!this.containsHeap()) {
            return 0L;
        }
        int[] eSize = new int[this.columns.size()];
        for (int j = 0; j < this.columns.size(); ++j) {
            ColumnDesc c = this.columns.get(j);
            if (!c.isVariableSize()) continue;
            eSize[j] = ElementType.forClass(c.getFitsBase()).size();
        }
        FitsHeap hp = this.getHeap();
        long oldSize = hp.size();
        FitsHeap compact = new FitsHeap(0);
        for (int i = 0; i < this.nRow; ++i) {
            for (int j = 0; j < this.columns.size(); ++j) {
                ColumnDesc c = this.columns.get(j);
                if (!c.isVariableSize()) continue;
                Object p = this.getRawElement(i, j);
                int len = (int)this.getPointerCount(p);
                int pos = compact.copyFrom(hp, (int)this.getPointerOffset(p), c.getFitsBaseCount(len) * eSize[j]);
                if (p instanceof long[]) {
                    ((long[])p)[1] = pos;
                } else {
                    ((int[])p)[1] = pos;
                }
                this.setTableElement(i, j, p);
            }
        }
        this.heap = compact;
        return oldSize - (long)compact.size();
    }

    public synchronized void compact() {
        this.heapFileSize = 0;
    }

    public BinaryTableHDU toHDU() throws FitsException {
        Header h = new Header();
        this.fillHeader(h);
        return new BinaryTableHDU(h, this);
    }

    public static class ColumnDesc
    implements Cloneable {
        private boolean warnedFlatten;
        private int offset;
        private int fitsCount;
        private int[] fitsShape = BinaryTable.access$000();
        private int[] legacyShape = BinaryTable.access$000();
        private int stringLength = -1;
        private Class<?> base;
        private Class<?> fitsBase;
        private char pointerType;
        private byte delimiter;
        private boolean isComplex;
        private boolean isBits;
        private String name;
        private Quantizer quant;

        protected ColumnDesc() {
        }

        private ColumnDesc(Class<?> type) throws FitsException {
            this();
            this.base = type;
            if (this.base == Boolean.TYPE) {
                this.fitsBase = Byte.TYPE;
                this.isBits = true;
            } else if (this.base == Boolean.class) {
                this.base = Boolean.TYPE;
                this.fitsBase = Byte.TYPE;
            } else if (this.base == String.class) {
                this.fitsBase = Byte.TYPE;
            } else if (this.base == ComplexValue.class) {
                this.base = Double.TYPE;
                this.fitsBase = Double.TYPE;
                this.isComplex = true;
            } else if (this.base == ComplexValue.Float.class) {
                this.base = Float.TYPE;
                this.fitsBase = Float.TYPE;
                this.isComplex = true;
            } else if (this.base.isPrimitive()) {
                this.fitsBase = type;
                if (this.base == Character.TYPE && FitsFactory.isUseUnicodeChars()) {
                    LOG.warning("char[] will be written as 16-bit integers (type 'I'), not as a ASCII bytes (type 'A') in the binary table. If that is not what you want, you should set FitsFactory.setUseUnicodeChars(false).");
                    LOG.warning("Future releases will disable Unicode support by default as it is not supported by the FITS standard. If you do want it still, use FitsFactory.setUseUnicodeChars(true) explicitly to keep the non-standard  behavior as is.");
                }
            } else {
                throw new TableException("Columns of type " + this.base + " are not supported.");
            }
        }

        public ColumnDesc(Class<?> base, int ... dim) throws FitsException {
            this(base);
            this.setBoxedShape(dim);
        }

        public ColumnDesc name(String value) throws IllegalArgumentException {
            HeaderCard.validateChars(value);
            this.name = value;
            return this;
        }

        public String name() {
            return this.name;
        }

        public Quantizer getQuantizer() {
            return this.quant;
        }

        public void setQuantizer(Quantizer q) {
            this.quant = q;
        }

        private void calcFitsCount() {
            this.fitsCount = 1;
            for (int size : this.fitsShape) {
                this.fitsCount *= size;
            }
        }

        private void setLegacyShape(int ... dim) {
            this.legacyShape = dim;
            this.calcFitsShape();
            this.calcFitsCount();
        }

        private void setFitsShape(int ... dim) {
            this.fitsShape = dim;
            this.calcLegacyShape();
            this.calcFitsCount();
        }

        private void setBoxedShape(int ... dim) {
            if (this.isComplex()) {
                this.setFitsShape(dim);
            } else {
                this.setLegacyShape(dim);
            }
        }

        public final int getStringLength() {
            return this.stringLength;
        }

        private void setStringLength(int len) {
            this.stringLength = len;
            if (!this.isVariableSize()) {
                this.calcFitsShape();
                this.calcFitsCount();
            }
        }

        public final byte getStringDelimiter() {
            return this.delimiter;
        }

        public static ColumnDesc createForScalars(Class<?> type) throws IllegalArgumentException, FitsException {
            if (String.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Use the createStrings(int) method for scalar strings.");
            }
            return new ColumnDesc(type, SINGLETON_SHAPE);
        }

        public static ColumnDesc createForFixedArrays(Class<?> type, int ... dim) throws IllegalArgumentException, FitsException {
            if (String.class.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Use the createStrings(int) method for scalar strings.");
            }
            return new ColumnDesc(type, dim);
        }

        public static ColumnDesc createForStrings(int len) throws FitsException {
            return ColumnDesc.createForStrings(len, SINGLETON_SHAPE);
        }

        public static ColumnDesc createForStrings(int len, int ... outerDims) throws FitsException {
            ColumnDesc c = new ColumnDesc(String.class);
            c.setLegacyShape(outerDims);
            c.setStringLength(len);
            return c;
        }

        public static ColumnDesc createForVariableStringArrays(int len) throws FitsException {
            ColumnDesc c = ColumnDesc.createForVariableSize(String.class);
            c.setStringLength(len);
            return c;
        }

        public static ColumnDesc createForDelimitedStringArrays(byte delim) throws FitsException {
            ColumnDesc c = ColumnDesc.createForVariableStringArrays(-1);
            c.setStringDelimiter(delim);
            return c;
        }

        public static ColumnDesc createForVariableSize(Class<?> type) throws FitsException {
            ColumnDesc c = new ColumnDesc(type);
            c.setVariableSize(false);
            return c;
        }

        private void calcLegacyShape() {
            if (this.isString()) {
                this.legacyShape = Arrays.copyOf(this.fitsShape, this.fitsShape.length - 1);
                this.stringLength = this.fitsShape[this.fitsShape.length - 1];
            } else if (this.isComplex()) {
                this.legacyShape = Arrays.copyOf(this.fitsShape, this.fitsShape.length + 1);
                this.legacyShape[this.fitsShape.length] = 2;
            } else {
                this.legacyShape = this.fitsShape;
            }
        }

        private void calcFitsShape() {
            if (this.isString()) {
                this.fitsShape = Arrays.copyOf(this.legacyShape, this.legacyShape.length + 1);
                this.fitsShape[this.legacyShape.length] = this.stringLength;
            } else {
                this.fitsShape = this.isComplex() ? Arrays.copyOf(this.legacyShape, this.legacyShape.length - 1) : this.legacyShape;
            }
        }

        private int getLastFitsDim() {
            return this.fitsShape[this.fitsShape.length - 1];
        }

        public ColumnDesc clone() {
            try {
                ColumnDesc copy = (ColumnDesc)super.clone();
                this.fitsShape = (int[])this.fitsShape.clone();
                this.legacyShape = (int[])this.legacyShape.clone();
                return copy;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        private void setSingleton() {
            this.setBoxedShape(SINGLETON_SHAPE);
        }

        public final boolean isSingleton() {
            if (this.isVariableSize()) {
                return this.isString() ? this.stringLength < 0 && this.delimiter == 0 : false;
            }
            if (this.isComplex()) {
                return this.fitsShape.length == 0;
            }
            return this.legacyShape.length == 0;
        }

        public final boolean isLogical() {
            return this.base == Boolean.class || this.base == Boolean.TYPE && !this.isBits;
        }

        public final boolean isBits() {
            return this.base == Boolean.TYPE && this.isBits;
        }

        public final boolean isString() {
            return this.base == String.class;
        }

        public final boolean isComplex() {
            return this.isComplex;
        }

        public final boolean isNumeric() {
            return !this.isLogical() && !this.isBits() && !this.isString();
        }

        public Class<?> getBase() {
            return this.getLegacyBase();
        }

        final Class<?> getFitsBase() {
            return this.fitsBase;
        }

        public Class<?> getLegacyBase() {
            return this.base;
        }

        private Class<?> getTableBase() {
            return this.isVariableSize() ? this.pointerClass() : this.getFitsBase();
        }

        public int[] getDimens() {
            return (int[])this.fitsShape.clone();
        }

        private int fitsDimension() {
            return this.fitsShape.length;
        }

        public final Class<?> getElementClass() {
            if (this.isLogical()) {
                return Boolean.class;
            }
            if (this.isComplex()) {
                return ComplexValue.class;
            }
            return this.base;
        }

        public final int getEntryDimension() {
            if (this.isVariableSize()) {
                return 1;
            }
            return this.isString() ? this.legacyShape.length : this.fitsShape.length;
        }

        public final int[] getEntryShape() {
            if (this.isVariableSize()) {
                return null;
            }
            if (this.isComplex) {
                return (int[])this.fitsShape.clone();
            }
            return (int[])this.legacyShape.clone();
        }

        public final int getElementWidth() {
            if (this.isComplex()) {
                return 2;
            }
            if (this.isString()) {
                return this.getStringLength();
            }
            return 1;
        }

        public final int getElementCount() {
            if (this.isVariableSize()) {
                return this.isString() ? 1 : -1;
            }
            if (this.isString()) {
                return this.fitsCount / this.getStringLength();
            }
            return this.fitsCount;
        }

        private int getFitsBaseCount(int fitsLen) {
            if (this.isBits) {
                return (fitsLen + 8 - 1) / 8;
            }
            if (this.isComplex) {
                return fitsLen << 1;
            }
            return fitsLen;
        }

        public final int getTableBaseCount() {
            if (this.isVariableSize()) {
                return 2;
            }
            return this.getFitsBaseCount(this.fitsCount);
        }

        public final boolean isVariableSize() {
            return this.pointerType != '\u0000';
        }

        public Object newInstance(int nRow) {
            return ArrayFuncs.newInstance(this.getTableBase(), this.getTableBaseCount() * nRow);
        }

        public int rowLen() {
            return this.getTableBaseCount() * ElementType.forClass(this.getTableBase()).size();
        }

        public boolean hasLongPointers() {
            return this.pointerType == 'Q';
        }

        private char pointerType() {
            return this.pointerType;
        }

        private Class<?> pointerClass() {
            return this.pointerType == 'Q' ? Long.TYPE : Integer.TYPE;
        }

        private void setVariableSize(boolean useLongPointers) {
            this.pointerType = (char)(useLongPointers ? 81 : 80);
            this.fitsCount = 2;
            this.fitsShape = new int[]{2};
            this.legacyShape = this.fitsShape;
            this.stringLength = -1;
        }

        private void setStringDelimiter(byte delim) {
            if (delim < 32 || delim > 126) {
                LOG.warning("WARNING! Substring terminator byte " + (delim & 0xFF) + " outside of the conventional range of " + 32 + " through " + 126 + " (inclusive)");
            }
            this.delimiter = delim;
        }

        private boolean isNullAllowed() {
            return this.isLogical() || this.isString();
        }

        private void parseSubstringConvention(String tform, ParsePosition pos, boolean setLength) {
            if (setLength) {
                this.setStringLength(this.isVariableSize() ? -1 : this.fitsCount);
            }
            if (pos.getIndex() >= tform.length()) {
                return;
            }
            try {
                int len = AsciiFuncs.parseInteger(tform, pos);
                if (setLength) {
                    this.setStringLength(len);
                }
                return;
            }
            catch (Exception len) {
                int iSub = tform.indexOf(BinaryTable.SUBSTRING_MARKER, pos.getIndex());
                if (iSub < 0) {
                    return;
                }
                pos.setIndex(iSub + BinaryTable.SUBSTRING_MARKER.length());
                try {
                    int len2 = AsciiFuncs.parseInteger(tform, pos);
                    if (setLength) {
                        this.setStringLength(len2);
                    }
                }
                catch (Exception e) {
                    LOG.warning("WARNING! Could not parse substring length from TFORM: [" + tform + "]");
                }
                if (pos.getIndex() >= tform.length()) {
                    return;
                }
                if (AsciiFuncs.extractChar(tform, pos) != '/') {
                    return;
                }
                try {
                    this.setStringDelimiter((byte)AsciiFuncs.parseInteger(tform, pos));
                }
                catch (NumberFormatException e) {
                    LOG.warning("WARNING! Could not parse substring terminator from TFORM: [" + tform + "]");
                }
                return;
            }
        }

        private void appendSubstringConvention(StringBuffer tform) {
            if (this.getStringLength() > 0) {
                tform.append(BinaryTable.SUBSTRING_MARKER);
                tform.append(this.getStringLength());
                if (this.delimiter != 0) {
                    tform.append('/');
                    tform.append(new DecimalFormat("000").format(this.delimiter & 0xFF));
                }
            }
        }

        String getTFORM() throws FitsException {
            StringBuffer tform = new StringBuffer();
            tform.append(this.isVariableSize() ? "1" + this.pointerType() : Integer.valueOf(this.fitsCount));
            if (this.base == Integer.TYPE) {
                tform.append('J');
            } else if (this.base == Short.TYPE) {
                tform.append('I');
            } else if (this.base == Byte.TYPE) {
                tform.append('B');
            } else if (this.base == Character.TYPE) {
                if (FitsFactory.isUseUnicodeChars()) {
                    tform.append('I');
                } else {
                    tform.append('A');
                }
            } else if (this.base == Float.TYPE) {
                tform.append(this.isComplex() ? (char)'C' : 'E');
            } else if (this.base == Double.TYPE) {
                tform.append(this.isComplex() ? (char)'M' : 'D');
            } else if (this.base == Long.TYPE) {
                tform.append('K');
            } else if (this.isLogical()) {
                tform.append('L');
            } else if (this.isBits()) {
                tform.append('X');
            } else if (this.isString()) {
                tform.append('A');
                if (this.isVariableSize()) {
                    this.appendSubstringConvention(tform);
                }
            } else {
                throw new FitsException("Invalid column data class:" + this.base);
            }
            return tform.toString();
        }

        String getTDIM() {
            if (this.isVariableSize()) {
                return null;
            }
            if (this.fitsShape.length < 2) {
                return null;
            }
            StringBuffer tdim = new StringBuffer();
            int prefix = 40;
            for (int i = this.fitsShape.length - 1; i >= 0; --i) {
                tdim.append((char)prefix);
                tdim.append(this.fitsShape[i]);
                prefix = 44;
            }
            tdim.append(')');
            return tdim.toString();
        }

        private boolean setFitsType(char type) throws FitsException {
            switch (type) {
                case 'A': {
                    this.fitsBase = Byte.TYPE;
                    this.base = String.class;
                    break;
                }
                case 'X': {
                    this.fitsBase = Byte.TYPE;
                    this.base = Boolean.TYPE;
                    break;
                }
                case 'L': {
                    this.fitsBase = Byte.TYPE;
                    this.base = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    this.fitsBase = Byte.TYPE;
                    this.base = Byte.TYPE;
                    break;
                }
                case 'I': {
                    this.fitsBase = Short.TYPE;
                    this.base = Short.TYPE;
                    break;
                }
                case 'J': {
                    this.fitsBase = Integer.TYPE;
                    this.base = Integer.TYPE;
                    break;
                }
                case 'K': {
                    this.fitsBase = Long.TYPE;
                    this.base = Long.TYPE;
                    break;
                }
                case 'C': 
                case 'E': {
                    this.fitsBase = Float.TYPE;
                    this.base = Float.TYPE;
                    break;
                }
                case 'D': 
                case 'M': {
                    this.fitsBase = Double.TYPE;
                    this.base = Double.TYPE;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    protected static class SaveState {
        public SaveState(List<ColumnDesc> columns, FitsHeap heap) {
        }
    }
}

