/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;

public class BinaryTableHDU
extends TableHDU<BinaryTable> {
    private static final IFitsHeader[] KEY_STEMS = new IFitsHeader[]{Standard.TTYPEn, Standard.TFORMn, Standard.TUNITn, Standard.TNULLn, Standard.TSCALn, Standard.TZEROn, Standard.TDISPn, Standard.TDIMn};

    public BinaryTableHDU(Header hdr, BinaryTable datum) {
        super(hdr, datum);
    }

    public static BinaryTableHDU wrap(BinaryTable tab) throws FitsException {
        BinaryTableHDU hdu = new BinaryTableHDU(new Header(), tab);
        tab.fillHeader(hdu.myHeader);
        return hdu;
    }

    @Override
    protected final String getCanonicalXtension() {
        return "BINTABLE";
    }

    @Deprecated
    public static BinaryTable encapsulate(Object o) throws FitsException {
        if (o instanceof ColumnTable) {
            return new BinaryTable((ColumnTable)o);
        }
        if (o instanceof Object[][]) {
            return BinaryTable.fromRowMajor((Object[][])o);
        }
        if (o instanceof Object[]) {
            return BinaryTable.fromColumnMajor((Object[])o);
        }
        throw new FitsException("Unable to encapsulate object of type:" + o.getClass().getName() + " as BinaryTable");
    }

    @Deprecated
    public static boolean isData(Object o) {
        return o instanceof ColumnTable || o instanceof Object[][] || o instanceof Object[];
    }

    @Deprecated
    public static boolean isHeader(Header header) {
        String xten = header.getStringValue(Standard.XTENSION);
        if (xten == null) {
            return false;
        }
        return (xten = xten.trim()).equals("BINTABLE") || xten.equals("A3DTABLE");
    }

    @Deprecated
    public static BinaryTable manufactureData(Header header) throws FitsException {
        return new BinaryTable(header);
    }

    @Deprecated
    public static Header manufactureHeader(Data data) throws FitsException {
        Header hdr = new Header();
        data.fillHeader(hdr);
        return hdr;
    }

    @Override
    public int addColumn(Object data) throws FitsException {
        int n = ((BinaryTable)this.myData).addColumn(data);
        this.myHeader.addValue(Standard.NAXISn.n(1), ((BinaryTable)this.myData).getRowBytes());
        Cursor<String, HeaderCard> c = this.myHeader.iterator();
        c.end();
        ((BinaryTable)this.myData).fillForColumn(this.myHeader, c, n - 1);
        return super.addColumn(data);
    }

    protected static IFitsHeader[] binaryTableColumnKeyStems() {
        return KEY_STEMS;
    }

    @Override
    protected IFitsHeader[] columnKeyStems() {
        return KEY_STEMS;
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("  Binary Table");
        stream.println("      Header Information:");
        int nhcol = this.myHeader.getIntValue(Standard.TFIELDS, -1);
        int nrow = this.myHeader.getIntValue(Standard.NAXIS2, -1);
        int rowsize = this.myHeader.getIntValue(Standard.NAXIS1, -1);
        stream.print("          " + nhcol + " fields");
        stream.println(", " + nrow + " rows of length " + rowsize);
        int i = 1;
        while (i <= nhcol) {
            stream.print("           " + i + ":");
            this.prtField(stream, "Name", Standard.TTYPEn.n(i).key());
            this.prtField(stream, "Format", Standard.TFORMn.n(i).key());
            this.prtField(stream, "Dimens", Standard.TDIMn.n(i++).key());
            stream.println("");
        }
        stream.println("      Data Information:");
        stream.println("          Number of rows=" + ((BinaryTable)this.myData).getNRows());
        stream.println("          Number of columns=" + ((BinaryTable)this.myData).getNCols());
        stream.println("          Heap size is: " + ((BinaryTable)this.myData).getParameterSize() + " bytes");
        Object[] cols = ((BinaryTable)this.myData).getFlatColumns();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            stream.println("           " + i2 + ":" + ArrayFuncs.arrayDescription(cols[i2]));
        }
    }

    @Deprecated
    public boolean isHeader() {
        return BinaryTableHDU.isHeader(this.myHeader);
    }

    private void prtField(PrintStream stream, String type, String field) {
        String val = this.myHeader.getStringValue(field);
        if (val != null) {
            stream.print(type + '=' + val + "; ");
        }
    }

    public BinaryTable.ColumnDesc getColumnDescriptor(int col) {
        return ((BinaryTable)this.myData).getDescriptor(col);
    }

    @Override
    public void setColumnName(int index, String name, String comment) throws IndexOutOfBoundsException, HeaderCardException {
        super.setColumnName(index, name, comment);
        this.getColumnDescriptor(index).name(name);
    }

    public final boolean convertToBits(int col) throws FitsException {
        if (!((BinaryTable)this.myData).convertToBits(col)) {
            return false;
        }
        this.myHeader.getCard(Standard.TFORMn.n(col + 1)).setValue(this.getColumnDescriptor(col).getTFORM());
        return true;
    }

    public boolean setComplexColumn(int index) throws FitsException {
        if (!((BinaryTable)this.myData).setComplexColumn(index)) {
            return false;
        }
        this.myHeader.getCard(Standard.TFORMn.n(index + 1)).setValue(this.getColumnDescriptor(index).getTFORM());
        if (this.myHeader.containsKey(Standard.TDIMn.n(index + 1))) {
            String tdim = this.getColumnDescriptor(index).getTDIM();
            if (tdim != null) {
                this.myHeader.getCard(Standard.TDIMn.n(index + 1)).setValue(tdim);
            } else {
                this.myHeader.deleteKey(Standard.TDIMn.n(index + 1));
            }
        }
        return true;
    }

    @Override
    public void write(ArrayDataOutput out) throws FitsException {
        ((BinaryTable)this.myData).fillHeader(this.myHeader, false);
        super.write(out);
    }
}

