/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.fits.utilities.FitsCheckSum;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.FitsInputStream;
import nom.tam.util.LoggerHelper;
import nom.tam.util.RandomAccess;

public abstract class Data
implements FitsElement {
    private static final Logger LOG = LoggerHelper.getLogger(Data.class);
    private static final int FITS_BLOCK_SIZE_MINUS_ONE = 2879;
    @Deprecated
    protected long fileOffset = -1L;
    @Deprecated
    protected long dataSize;
    @Deprecated
    protected RandomAccess input;
    private long streamSum = 0L;

    protected final RandomAccess getRandomAccessInput() {
        return this.input;
    }

    protected abstract void fillHeader(Header var1) throws FitsException;

    public boolean isDeferred() {
        return this.getTrueSize() != 0L && this.isEmpty() && this.getRandomAccessInput() != null;
    }

    public boolean isEmpty() {
        return this.getCurrentData() == null;
    }

    public long calcChecksum() throws FitsException {
        return FitsCheckSum.checksum(this);
    }

    final long getStreamChecksum() {
        return this.streamSum;
    }

    public Object getData() throws FitsException {
        this.ensureData();
        return this.getCurrentData();
    }

    protected abstract Object getCurrentData();

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public final Object getKernel() throws FitsException {
        return this.getData();
    }

    @Override
    public long getSize() {
        return FitsUtil.addPadding(this.getTrueSize());
    }

    protected abstract long getTrueSize();

    protected abstract void loadData(ArrayDataInput var1) throws IOException, FitsException;

    private void skipPadding(ArrayDataInput in) throws PaddingException, FitsException {
        try {
            in.skipAllBytes((long)FitsUtil.padding(this.getTrueSize()));
        }
        catch (EOFException e) {
            throw new PaddingException("EOF while skipping padding after data segment", e);
        }
        catch (IOException e) {
            throw new FitsException("IO error while skipping padding after data segment", e);
        }
    }

    protected void ensureData() throws FitsException {
        if (!this.isDeferred()) {
            return;
        }
        try {
            long pos = this.input.getFilePointer();
            this.input.seek(this.getFileOffset());
            this.loadData(this.input);
            this.input.seek(pos);
        }
        catch (IOException e) {
            throw new FitsException("error reading deferred data: " + e, e);
        }
    }

    @Override
    public void read(ArrayDataInput in) throws PaddingException, FitsException {
        this.detach();
        if (in == null) {
            return;
        }
        if (in instanceof FitsInputStream) {
            ((FitsInputStream)in).nextChecksum();
        }
        this.streamSum = 0L;
        this.setFileOffset(in);
        if (this.getTrueSize() == 0L) {
            return;
        }
        if (in instanceof RandomAccess) {
            try {
                in.skipAllBytes(this.getTrueSize());
            }
            catch (IOException e) {
                throw new FitsException("Unable to skip over data segment:" + e, e);
            }
        }
        try {
            this.loadData(in);
        }
        catch (IOException e) {
            throw new FitsException("error reading data: " + e, e);
        }
        this.skipPadding(in);
        if (in instanceof FitsInputStream) {
            this.streamSum = ((FitsInputStream)in).nextChecksum();
        }
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.getRandomAccessInput(), this.getFileOffset());
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to reset", e);
            return false;
        }
    }

    @Override
    public void rewrite() throws FitsException {
        if (this.isDeferred()) {
            return;
        }
        if (!this.rewriteable()) {
            throw new FitsException("Illegal attempt to rewrite data");
        }
        FitsUtil.reposition(this.getRandomAccessInput(), this.getFileOffset());
        this.write((ArrayDataOutput)((Object)this.getRandomAccessInput()));
        try {
            ((ArrayDataOutput)((Object)this.getRandomAccessInput())).flush();
        }
        catch (IOException e) {
            throw new FitsException("Error in rewrite flush: ", e);
        }
    }

    @Override
    public boolean rewriteable() {
        return this.input != null && this.getFileOffset() >= 0L && (this.getTrueSize() + 2879L) / 2880L == (this.getTrueSize() + 2879L) / 2880L;
    }

    public void detach() throws FitsException {
        this.ensureData();
        this.clearInput();
    }

    private void clearInput() {
        this.input = null;
        this.fileOffset = -1L;
        this.dataSize = 0L;
    }

    protected void setFileOffset(ArrayDataInput o) {
        if (o instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(o);
            this.dataSize = this.getTrueSize();
            this.input = (RandomAccess)o;
        } else {
            this.clearInput();
        }
    }

    @Override
    public abstract void write(ArrayDataOutput var1) throws FitsException;

    public abstract BasicHDU<?> toHDU() throws FitsException;
}

