/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsIntegrityException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.PaddingException;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.compress.CompressionManager;
import nom.tam.fits.header.Standard;
import nom.tam.fits.utilities.FitsCheckSum;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.FitsFile;
import nom.tam.util.FitsInputStream;
import nom.tam.util.FitsOutputStream;
import nom.tam.util.RandomAccess;
import nom.tam.util.RandomAccessFileIO;
import nom.tam.util.SafeClose;

public class Fits
implements Closeable {
    private static final Logger LOG = Logger.getLogger(Fits.class.getName());
    private ArrayDataInput dataStr;
    private final List<BasicHDU<?>> hduList = new ArrayList();
    private boolean atEOF;
    private long lastFileOffset = -1L;

    public Fits() {
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, CompressionManager.isCompressed(myFile));
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    public Fits(RandomAccessFileIO src) throws FitsException {
        this.randomInit(src);
    }

    public Fits(FitsFile src) throws FitsException {
        this.dataStr = src;
        try {
            src.seek(0L);
        }
        catch (Exception e) {
            throw new FitsException("Could not create Fits: " + e.getMessage(), e);
        }
    }

    public Fits(InputStream str) throws FitsException {
        this.streamInit(str);
    }

    @Deprecated
    public Fits(InputStream str, boolean compressed) throws FitsException {
        this(str);
        LOG.log(Level.INFO, "compression ignored, will be autodetected. was set to " + compressed);
    }

    public Fits(String filename) throws FitsException {
        this(filename, CompressionManager.isCompressed(filename));
    }

    public Fits(String filename, boolean compressed) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        try {
            File fil = new File(filename);
            if (fil.exists()) {
                this.fileInit(fil, compressed);
                return;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a file " + filename, e);
            throw new FitsException("could not detect type of " + filename, e);
        }
        try {
            InputStream str = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
            if (str != null) {
                this.streamInit(str);
                return;
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a resource " + filename, e);
            throw new FitsException("could not detect type of " + filename, e);
        }
        try {
            InputStream is = FitsUtil.getURLStream(new URL(filename), 0);
            this.streamInit(is);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "not a url " + filename, e);
            throw new FitsException("could not detect type of " + filename, e);
        }
    }

    public Fits(URL myURL) throws FitsException {
        try {
            this.streamInit(FitsUtil.getURLStream(myURL, 0));
        }
        catch (IOException e) {
            throw new FitsException("Unable to open input from URL:" + myURL, e);
        }
    }

    @Deprecated
    public Fits(URL myURL, boolean compressed) throws FitsException {
        this(myURL);
        LOG.log(Level.INFO, "compression ignored, will be autodetected. was set to " + compressed);
    }

    public static <DataClass extends Data> BasicHDU<DataClass> makeHDU(DataClass data) throws FitsException {
        Header hdr = new Header();
        data.fillHeader(hdr);
        return FitsFactory.hduFactory(hdr, data);
    }

    public static BasicHDU<?> makeHDU(Header h) throws FitsException {
        Data d = FitsFactory.dataFactory(h);
        return FitsFactory.hduFactory(h, d);
    }

    public static BasicHDU<?> makeHDU(Object o) throws FitsException {
        return FitsFactory.hduFactory(o);
    }

    public static String version() {
        String string;
        block8: {
            Properties props = new Properties();
            InputStream versionProperties = Fits.class.getResourceAsStream("/META-INF/maven/gov.nasa.gsfc.heasarc/nom-tam-fits/pom.properties");
            try {
                props.load(versionProperties);
                string = props.getProperty("version");
                if (versionProperties == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (versionProperties != null) {
                        try {
                            versionProperties.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "reading version failed, ignoring", e);
                    return "unknown";
                }
            }
            versionProperties.close();
        }
        return string;
    }

    public static void saveClose(InputStream in) {
        SafeClose.close(in);
    }

    public void addHDU(BasicHDU<?> myHDU) throws FitsException {
        this.insertHDU(myHDU, this.getNumberOfHDUs());
    }

    @Deprecated
    public int currentSize() {
        return this.getNumberOfHDUs();
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.getNumberOfHDUs();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        this.hduList.remove(n);
        if (n == 0 && size > 1) {
            BasicHDU<?> newFirst = this.hduList.get(0);
            if (newFirst.canBePrimary()) {
                newFirst.setPrimaryHDU(true);
            } else {
                this.insertHDU(BasicHDU.getDummyHDU(), 0);
            }
        }
    }

    @Deprecated
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="stream stays open, and will be read when nessesary.")
    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            if (compressed) {
                this.streamInit(Files.newInputStream(myFile.toPath(), new OpenOption[0]));
            } else {
                this.randomInit(myFile);
            }
        }
        catch (IOException e) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile, e);
        }
    }

    public BasicHDU<?> getHDU(int n) throws FitsException, IOException, IndexOutOfBoundsException {
        for (int i = this.getNumberOfHDUs(); i <= n; ++i) {
            BasicHDU<?> hdu = this.readHDU();
            if (hdu != null) continue;
            return null;
        }
        return this.hduList.get(n);
    }

    public Header getPrimaryHeader() throws FitsException, IOException {
        if (this.hduList.isEmpty()) {
            throw new FitsException("Empty Fits object");
        }
        BasicHDU<?> primary = this.getHDU(0);
        primary.setPrimaryHDU(true);
        return primary.getHeader();
    }

    public Header getCompleteHeader(int n) throws FitsException, IOException, IndexOutOfBoundsException {
        BasicHDU<?> hdu = this.getHDU(n);
        if (hdu == null) {
            throw new IndexOutOfBoundsException("FITS has no HDU index " + n);
        }
        return this.getCompleteHeader(hdu);
    }

    public Header getCompleteHeader(String name) throws FitsException, IOException, NoSuchElementException {
        BasicHDU<?> hdu = this.getHDU(name);
        if (hdu == null) {
            throw new NoSuchElementException("Fits contains no HDU named " + name);
        }
        return this.getCompleteHeader(hdu);
    }

    public Header getCompleteHeader(String name, int version) throws FitsException, IOException, NoSuchElementException {
        BasicHDU<?> hdu = this.getHDU(name, version);
        if (hdu == null) {
            throw new NoSuchElementException("Fits contains no HDU named " + name);
        }
        return this.getCompleteHeader(hdu);
    }

    private Header getCompleteHeader(BasicHDU<?> hdu) throws FitsException, IOException {
        if (hdu == this.getHDU(0)) {
            return this.getPrimaryHeader();
        }
        hdu.setPrimaryHDU(false);
        Header h = hdu.getHeader();
        if (h.getBooleanValue(Standard.INHERIT)) {
            Header merged = new Header();
            merged.mergeDistinct(h);
            merged.mergeDistinct(this.getPrimaryHeader());
            return merged;
        }
        return h;
    }

    private boolean isNameMatch(BasicHDU<?> hdu, String name) {
        Header h = hdu.getHeader();
        if (!h.containsKey(Standard.EXTNAME)) {
            return false;
        }
        return name.equals(hdu.getHeader().getStringValue(Standard.EXTNAME));
    }

    private boolean isNameVersionMatch(BasicHDU<?> hdu, String name, int version) {
        Header h = hdu.getHeader();
        if (!(h.containsKey(Standard.EXTNAME) && name.equals(h.getStringValue(Standard.EXTNAME)) && h.containsKey(Standard.EXTVER))) {
            return false;
        }
        return h.getIntValue(Standard.EXTVER) == version;
    }

    public BasicHDU<?> getHDU(String name) throws FitsException, IOException {
        BasicHDU<?> hdu;
        for (BasicHDU<?> hdu2 : this.hduList) {
            if (!this.isNameMatch(hdu2, name)) continue;
            return hdu2;
        }
        while ((hdu = this.readHDU()) != null) {
            if (!this.isNameMatch(hdu, name)) continue;
            return hdu;
        }
        return null;
    }

    public BasicHDU<?> getHDU(String name, int version) throws FitsException, IOException {
        BasicHDU<?> hdu;
        for (BasicHDU<?> hdu2 : this.hduList) {
            if (!this.isNameVersionMatch(hdu2, name, version)) continue;
            return hdu2;
        }
        while ((hdu = this.readHDU()) != null) {
            if (!this.isNameVersionMatch(hdu, name, version)) continue;
            return hdu;
        }
        return null;
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void insertHDU(BasicHDU<?> myHDU, int position) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (position < 0 || position > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + position);
        }
        if (myHDU instanceof RandomGroupsHDU && position != 0) {
            throw new FitsException("Random groups HDUs must be the first (primary) HDU. Requested pos: " + position);
        }
        try {
            if (position == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    this.hduList.get(0).setPrimaryHDU(false);
                }
                if (myHDU.canBePrimary()) {
                    myHDU.setPrimaryHDU(true);
                    this.hduList.add(0, myHDU);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    myHDU.setPrimaryHDU(false);
                    this.hduList.add(1, myHDU);
                }
            } else {
                myHDU.setPrimaryHDU(false);
                this.hduList.add(position, myHDU);
            }
        }
        catch (NoSuchElementException e) {
            throw new FitsException("hduList inconsistency in insertHDU", e);
        }
    }

    @Deprecated
    protected void randomInit(File file) throws FitsException {
        if (!file.exists() || !file.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        try {
            this.dataStr = new FitsFile(file, "rw");
            ((FitsFile)this.dataStr).seek(0L);
        }
        catch (IOException e) {
            try {
                this.dataStr = new FitsFile(file, "r");
                ((FitsFile)this.dataStr).seek(0L);
            }
            catch (IOException e2) {
                throw new FitsException("Unable to open file " + file.getPath(), e2);
            }
        }
    }

    protected void randomInit(RandomAccessFileIO src) throws FitsException {
        try {
            this.dataStr = new FitsFile(src, 23040);
            ((FitsFile)this.dataStr).seek(0L);
        }
        catch (IOException e) {
            throw new FitsException("Unable to open data " + src, e);
        }
    }

    public BasicHDU<?>[] read() throws FitsException {
        this.readToEnd();
        int size = this.getNumberOfHDUs();
        if (size == 0) {
            return new BasicHDU[0];
        }
        return this.hduList.toArray(new BasicHDU[size]);
    }

    public void read(InputStream is) throws FitsException {
        this.dataStr = (is = CompressionManager.decompress(is)) instanceof ArrayDataInput ? (ArrayDataInput)((Object)is) : new FitsInputStream(is);
        this.read();
    }

    public BasicHDU<?> readHDU() throws FitsException, IOException {
        Header hdr;
        if (this.dataStr == null || this.atEOF) {
            if (this.dataStr == null) {
                LOG.warning("trying to read a hdu, without an input source!");
            }
            return null;
        }
        if (this.dataStr instanceof RandomAccess && this.lastFileOffset > 0L) {
            FitsUtil.reposition(this.dataStr, this.lastFileOffset);
        }
        if ((hdr = Header.readHeader(this.dataStr)) == null) {
            this.atEOF = true;
            return null;
        }
        Data data = FitsFactory.dataFactory(hdr);
        try {
            data.read(this.dataStr);
            if (Fits.checkTruncated(this.dataStr)) {
                LOG.warning("Missing padding after data segment");
            }
        }
        catch (PaddingException e) {
            LOG.warning(e.getMessage());
        }
        this.lastFileOffset = FitsUtil.findOffset(this.dataStr);
        BasicHDU<Data> hdu = FitsFactory.hduFactory(hdr, data);
        this.hduList.add(hdu);
        return hdu;
    }

    private void readToEnd() throws FitsException {
        try {
            while (this.dataStr != null && !this.atEOF) {
                if (this.readHDU() != null) continue;
                if (this.getNumberOfHDUs() == 0) {
                    throw new FitsException("Not FITS file.");
                }
                return;
            }
        }
        catch (IOException e) {
            throw new FitsException("Corrupted FITS file: " + e, e);
        }
    }

    public void setChecksum(int hduIndex) throws FitsException, IOException {
        FitsCheckSum.setDatasum(this.getHDU(hduIndex).getHeader(), this.calcDatasum(hduIndex));
    }

    public void setChecksum() throws FitsException, IOException {
        int i;
        for (i = 0; i < this.getNumberOfHDUs(); ++i) {
            this.setChecksum(i);
        }
        if (this.dataStr == null) {
            return;
        }
        while (this.readHDU() != null) {
            this.setChecksum(i++);
        }
    }

    public long calcDatasum(int hduIndex) throws FitsException, IOException {
        BasicHDU<?> hdu = this.getHDU(hduIndex);
        Object data = hdu.getData();
        if (((Data)data).isDeferred()) {
            return FitsCheckSum.checksum((RandomAccess)this.dataStr, ((Data)data).getFileOffset(), ((Data)data).getSize());
        }
        return ((Data)data).calcChecksum();
    }

    public long calcChecksum(int hduIndex) throws FitsException, IOException {
        return FitsCheckSum.sumOf(FitsCheckSum.checksum(this.getHDU(hduIndex).getHeader()), this.calcDatasum(hduIndex));
    }

    public void verifyIntegrity() throws FitsIntegrityException, FitsException, IOException {
        BasicHDU<?> hdu;
        int i = 0;
        while ((hdu = this.readHDU()) != null) {
            try {
                hdu.verifyIntegrity();
            }
            catch (FitsIntegrityException e) {
                throw new FitsIntegrityException(i, e);
            }
            ++i;
        }
    }

    @Deprecated
    public void setStream(ArrayDataInput stream) {
        this.dataStr = stream;
        this.atEOF = false;
        this.lastFileOffset = -1L;
    }

    @Deprecated
    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header hdr = new Header(this.dataStr);
        int dataSize = (int)hdr.getDataSize();
        this.dataStr.skipAllBytes(dataSize);
        if (this.dataStr instanceof RandomAccess) {
            this.lastFileOffset = ((RandomAccess)this.dataStr).getFilePointer();
        }
    }

    public void skipHDU(int n) throws FitsException, IOException {
        for (int i = 0; i < n; ++i) {
            this.skipHDU();
        }
    }

    protected void streamInit(InputStream inputStream) throws FitsException {
        this.dataStr = new FitsInputStream(CompressionManager.decompress(inputStream));
    }

    public void write(FitsFile file) throws IOException, FitsException {
        this.write((ArrayDataOutput)file);
        file.setLength(file.getFilePointer());
    }

    public void write(FitsOutputStream out) throws IOException, FitsException {
        this.write((ArrayDataOutput)out);
        out.flush();
    }

    public void write(File file) throws IOException, FitsException {
        try (FileOutputStream o = new FileOutputStream(file);){
            this.write(new FitsOutputStream(o));
            o.flush();
        }
    }

    public void rewrite() throws FitsException, IOException {
        int i;
        for (i = 0; i < this.getNumberOfHDUs(); ++i) {
            if (this.getHDU(i).rewriteable()) continue;
            throw new FitsException("HDU[" + i + "] cannot be re-written in place. Aborting rewrite.");
        }
        for (i = 0; i < this.getNumberOfHDUs(); ++i) {
            this.getHDU(i).rewrite();
        }
    }

    public void write(String fileName) throws IOException, FitsException {
        this.write(new File(fileName));
    }

    private void write(ArrayDataOutput out) throws FitsException {
        for (BasicHDU<?> basicHDU : this.hduList) {
            basicHDU.write(out);
        }
    }

    @Deprecated
    public void write(DataOutput os) throws FitsException {
        if (os instanceof FitsFile) {
            try {
                this.write((FitsFile)os);
            }
            catch (IOException e) {
                throw new FitsException("Error writing to FITS file: " + e, e);
            }
            return;
        }
        if (os instanceof FitsOutputStream) {
            try {
                this.write((FitsOutputStream)os);
            }
            catch (IOException e) {
                throw new FitsException("Error writing to FITS output stream: " + e, e);
            }
            return;
        }
        if (!(os instanceof DataOutputStream)) {
            throw new FitsException("Cannot create FitsOutputStream from class " + os.getClass().getName());
        }
        try {
            this.write(new FitsOutputStream((DataOutputStream)os));
        }
        catch (IOException e) {
            throw new FitsException("Error writing to the FITS output stream: " + e, e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.dataStr != null) {
            this.dataStr.close();
        }
    }

    @Deprecated
    public static void setChecksum(BasicHDU<?> hdu) throws FitsException {
        FitsCheckSum.setChecksum(hdu);
    }

    @Deprecated
    public static long checksum(byte[] data) {
        return FitsCheckSum.checksum(data);
    }

    static boolean checkTruncated(ArrayDataInput in) throws IOException {
        long len;
        if (!(in instanceof RandomAccess)) {
            return false;
        }
        RandomAccess f = (RandomAccess)in;
        long pos = f.getFilePointer();
        if (pos > (len = f.length())) {
            LOG.log(Level.WARNING, "Premature file end at " + len + " (expected " + pos + ")", new Throwable());
            return true;
        }
        return false;
    }
}

