/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.fits.FitsException;

public class FitsDate
implements Comparable<FitsDate> {
    private static final int FIRST_THREE_CHARACTER_VALUE = 100;
    private static final int FIRST_TWO_CHARACTER_VALUE = 10;
    private static final int FITS_DATE_STRING_SIZE = 23;
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final int NEW_FORMAT_DAY_OF_MONTH_GROUP = 4;
    private static final int NEW_FORMAT_HOUR_GROUP = 6;
    private static final int NEW_FORMAT_MILLISECOND_GROUP = 10;
    private static final int NEW_FORMAT_MINUTE_GROUP = 7;
    private static final int NEW_FORMAT_MONTH_GROUP = 3;
    private static final int NEW_FORMAT_SECOND_GROUP = 8;
    private static final int NEW_FORMAT_YEAR_GROUP = 2;
    private static final Pattern NORMAL_REGEX = Pattern.compile("\\s*(([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9]))(T([0-9][0-9]):([0-9][0-9]):([0-9][0-9])(\\.([0-9]+))?)?\\s*");
    private static final int OLD_FORMAT_DAY_OF_MONTH_GROUP = 1;
    private static final int OLD_FORMAT_MONTH_GROUP = 2;
    private static final int OLD_FORMAT_YEAR_GROUP = 3;
    private static final Pattern OLD_REGEX = Pattern.compile("\\s*([0-9][0-9])/([0-9][0-9])/([0-9][0-9])\\s*");
    private static final int YEAR_OFFSET = 1900;
    private static final int NB_DIGITS_MILLIS = 3;
    private static final int POW_TEN = 10;
    private int hour = -1;
    private int mday = -1;
    private int millisecond = -1;
    private int minute = -1;
    private int month = -1;
    private int second = -1;
    private int year = -1;

    public static String getFitsDateString() {
        return FitsDate.getFitsDateString(new Date(), true);
    }

    public static String getFitsDateString(Date epoch) {
        return FitsDate.getFitsDateString(epoch, true);
    }

    public static String getFitsDateString(Date epoch, boolean timeOfDay) {
        Calendar cal = Calendar.getInstance(UTC);
        cal.setTime(epoch);
        StringBuilder fitsDate = new StringBuilder();
        DecimalFormat df = new DecimalFormat("0000");
        fitsDate.append(df.format(cal.get(1)));
        fitsDate.append("-");
        df = new DecimalFormat("00");
        fitsDate.append(df.format(cal.get(2) + 1));
        fitsDate.append("-");
        fitsDate.append(df.format(cal.get(5)));
        if (timeOfDay) {
            fitsDate.append("T");
            fitsDate.append(df.format(cal.get(11)));
            fitsDate.append(":");
            fitsDate.append(df.format(cal.get(12)));
            fitsDate.append(":");
            fitsDate.append(df.format(cal.get(13)));
            fitsDate.append(".");
            df = new DecimalFormat("000");
            fitsDate.append(df.format(cal.get(14)));
        }
        return fitsDate.toString();
    }

    public FitsDate(String dStr) throws FitsException {
        if (dStr == null || dStr.isEmpty()) {
            return;
        }
        Matcher match = NORMAL_REGEX.matcher(dStr);
        if (match.matches()) {
            this.year = FitsDate.getInt(match, 2);
            this.month = FitsDate.getInt(match, 3);
            this.mday = FitsDate.getInt(match, 4);
            this.hour = FitsDate.getInt(match, 6);
            this.minute = FitsDate.getInt(match, 7);
            this.second = FitsDate.getInt(match, 8);
            this.millisecond = FitsDate.getMilliseconds(match, 10);
        } else {
            match = OLD_REGEX.matcher(dStr);
            if (!match.matches()) {
                if (dStr.trim().isEmpty()) {
                    return;
                }
                throw new FitsException("Bad FITS date string \"" + dStr + '\"');
            }
            this.year = FitsDate.getInt(match, 3) + 1900;
            this.month = FitsDate.getInt(match, 2);
            this.mday = FitsDate.getInt(match, 1);
        }
    }

    private static int getInt(Matcher match, int groupIndex) {
        String value = match.group(groupIndex);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private static int getMilliseconds(Matcher match, int groupIndex) {
        String value = match.group(groupIndex);
        if (value != null) {
            value = String.format("%-3s", value).replace(' ', '0');
            int num = Integer.parseInt(value);
            if (value.length() > 3) {
                num = (int)Math.round((double)num / Math.pow(10.0, value.length() - 3));
            }
            return num;
        }
        return -1;
    }

    public Date toDate() {
        if (this.year == -1) {
            return null;
        }
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1, this.year);
        cal.set(2, this.month - 1);
        cal.set(5, this.mday);
        if (this.hour == -1) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal.set(11, this.hour);
            cal.set(12, this.minute);
            cal.set(13, this.second);
            if (this.millisecond == -1) {
                cal.set(14, 0);
            } else {
                cal.set(14, this.millisecond);
            }
        }
        return cal.getTime();
    }

    public String toString() {
        if (this.year == -1) {
            return "";
        }
        StringBuilder buf = new StringBuilder(23);
        buf.append(this.year);
        buf.append('-');
        this.appendTwoDigitValue(buf, this.month);
        buf.append('-');
        this.appendTwoDigitValue(buf, this.mday);
        if (this.hour != -1) {
            buf.append('T');
            this.appendTwoDigitValue(buf, this.hour);
            buf.append(':');
            this.appendTwoDigitValue(buf, this.minute);
            buf.append(':');
            this.appendTwoDigitValue(buf, this.second);
            if (this.millisecond != -1) {
                buf.append('.');
                this.appendThreeDigitValue(buf, this.millisecond);
            }
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FitsDate)) {
            return false;
        }
        return this.compareTo((FitsDate)o) == 0;
    }

    public int hashCode() {
        return Integer.hashCode(this.year) ^ Integer.hashCode(this.month) ^ Integer.hashCode(this.mday) ^ Integer.hashCode(this.hour) ^ Integer.hashCode(this.minute) ^ Integer.hashCode(this.second) ^ Integer.hashCode(this.millisecond);
    }

    @Override
    public int compareTo(FitsDate fitsDate) {
        int result = Integer.compare(this.year, fitsDate.year);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.month, fitsDate.month);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.mday, fitsDate.mday);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.hour, fitsDate.hour);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minute, fitsDate.minute);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.second, fitsDate.second);
        if (result != 0) {
            return result;
        }
        return Integer.compare(this.millisecond, fitsDate.millisecond);
    }

    private void appendThreeDigitValue(StringBuilder buf, int value) {
        if (value < 100) {
            buf.append('0');
        }
        this.appendTwoDigitValue(buf, value);
    }

    private void appendTwoDigitValue(StringBuilder buf, int value) {
        if (value < 10) {
            buf.append('0');
        }
        buf.append(value);
    }
}

