/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.NullData;
import nom.tam.fits.NullDataHDU;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.UndefinedHDU;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.hierarch.IHierarchKeyFormatter;
import nom.tam.fits.header.hierarch.StandardIHierarchKeyFormatter;
import nom.tam.image.compression.hdu.CompressedImageData;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.image.compression.hdu.CompressedTableHDU;

public final class FitsFactory {
    private static final boolean DEFAULT_USE_ASCII_TABLES = false;
    private static final boolean DEFAULT_USE_HIERARCH = true;
    private static final boolean DEFAULT_USE_EXPONENT_D = false;
    private static final boolean DEFAULT_LONG_STRINGS_ENABLED = true;
    private static final boolean DEFAULT_CHECK_ASCII_STRINGS = false;
    private static final boolean DEFAULT_ALLOW_TERMINAL_JUNK = true;
    private static final boolean DEFAULT_ALLOW_HEADER_REPAIRS = true;
    private static final boolean DEFAULT_SKIP_BLANK_AFTER_ASSIGN = false;
    private static final boolean DEFAULT_CASE_SENSITIVE_HIERARCH = false;
    private static final boolean DEFAULT_USE_UNICODE_CHARS = true;
    private static final IHierarchKeyFormatter DEFAULT_HIERARCH_FORMATTER = new StandardIHierarchKeyFormatter();
    private static final FitsSettings GLOBAL_SETTINGS = new FitsSettings();
    private static final ThreadLocal<FitsSettings> LOCAL_SETTINGS = new ThreadLocal();
    private static ExecutorService threadPool;
    public static final int FITS_BLOCK_SIZE = 2880;

    @Deprecated
    public static Data dataFactory(Header hdr) throws FitsException {
        if (ImageHDU.isHeader(hdr)) {
            if (hdr.getIntValue(Standard.NAXIS, 0) == 0) {
                return new NullData();
            }
            ImageData d = ImageHDU.manufactureData(hdr);
            if (hdr.findCard(Standard.EXTEND) != null) {
                hdr.nextCard();
            }
            return d;
        }
        if (RandomGroupsHDU.isHeader(hdr)) {
            return RandomGroupsHDU.manufactureData(hdr);
        }
        if (AsciiTableHDU.isHeader(hdr)) {
            return AsciiTableHDU.manufactureData(hdr);
        }
        if (CompressedImageHDU.isHeader(hdr)) {
            return CompressedImageHDU.manufactureData(hdr);
        }
        if (CompressedTableHDU.isHeader(hdr)) {
            return CompressedTableHDU.manufactureData(hdr);
        }
        if (BinaryTableHDU.isHeader(hdr)) {
            return BinaryTableHDU.manufactureData(hdr);
        }
        if (UndefinedHDU.isHeader(hdr)) {
            return UndefinedHDU.manufactureData(hdr);
        }
        throw new FitsException("Unrecognizable header in dataFactory");
    }

    public static boolean isUseExponentD() {
        return FitsFactory.current().isUseExponentD();
    }

    public static boolean isUseUnicodeChars() {
        return FitsFactory.current().isUseUnicodeChars();
    }

    public static boolean getAllowTerminalJunk() {
        return FitsFactory.current().isAllowTerminalJunk();
    }

    public static boolean isAllowHeaderRepairs() {
        return FitsFactory.current().isAllowHeaderRepairs();
    }

    public static IHierarchKeyFormatter getHierarchFormater() {
        return FitsFactory.current().getHierarchKeyFormatter();
    }

    public static boolean getUseHierarch() {
        return FitsFactory.current().isUseHierarch();
    }

    public static boolean getUseAsciiTables() {
        return FitsFactory.current().isUseAsciiTables();
    }

    public static boolean getCheckAsciiStrings() {
        return FitsFactory.current().isCheckAsciiStrings();
    }

    public static boolean isLongStringsEnabled() {
        return FitsFactory.current().isLongStringsEnabled();
    }

    @Deprecated
    public static boolean isSkipBlankAfterAssign() {
        return FitsFactory.current().isSkipBlankAfterAssign();
    }

    @Deprecated
    public static <DataClass extends Data> BasicHDU<DataClass> hduFactory(Header hdr, DataClass d) throws FitsException {
        if (d == null) {
            return new NullDataHDU(hdr);
        }
        if (d instanceof ImageData) {
            return new ImageHDU(hdr, (ImageData)d);
        }
        if (d instanceof CompressedImageData) {
            return new CompressedImageHDU(hdr, (CompressedImageData)d);
        }
        if (d instanceof RandomGroupsData) {
            return new RandomGroupsHDU(hdr, (RandomGroupsData)d);
        }
        if (d instanceof AsciiTable) {
            return new AsciiTableHDU(hdr, (AsciiTable)d);
        }
        if (d instanceof CompressedTableData) {
            return new CompressedTableHDU(hdr, (CompressedTableData)d);
        }
        if (d instanceof BinaryTable) {
            return new BinaryTableHDU(hdr, (BinaryTable)d);
        }
        if (d instanceof UndefinedData) {
            return new UndefinedHDU(hdr, (UndefinedData)d);
        }
        return null;
    }

    public static BasicHDU<?> hduFactory(Object o) throws FitsException {
        Data d;
        Header h;
        if (o == null) {
            return new NullDataHDU();
        }
        if (o instanceof Header) {
            h = (Header)o;
            d = FitsFactory.dataFactory(h);
        } else if (ImageHDU.isData(o)) {
            d = ImageHDU.encapsulate(o);
            h = ImageHDU.manufactureHeader(d);
        } else if (FitsFactory.current().isUseAsciiTables() && AsciiTableHDU.isData(o)) {
            d = AsciiTableHDU.encapsulate(o);
            h = AsciiTableHDU.manufactureHeader(d);
        } else if (BinaryTableHDU.isData(o)) {
            d = BinaryTableHDU.encapsulate(o);
            h = BinaryTableHDU.manufactureHeader(d);
        } else {
            throw new FitsException("This type of data is not supported for FITS representation");
        }
        return FitsFactory.hduFactory(h, d);
    }

    @Deprecated
    public static <DataClass extends Data> BasicHDU<DataClass> HDUFactory(Header hdr, DataClass d) throws FitsException {
        return FitsFactory.hduFactory(hdr, d);
    }

    @Deprecated
    public static BasicHDU<?> HDUFactory(Object o) throws FitsException {
        return FitsFactory.hduFactory(o);
    }

    public static void setDefaults() {
        FitsSettings s = FitsFactory.current();
        s.useExponentD = false;
        s.allowHeaderRepairs = true;
        s.allowTerminalJunk = true;
        s.checkAsciiStrings = false;
        s.longStringsEnabled = true;
        s.skipBlankAfterAssign = false;
        s.useAsciiTables = false;
        s.useHierarch = true;
        s.useUnicodeChars = true;
        s.hierarchKeyFormatter = FitsFactory.DEFAULT_HIERARCH_FORMATTER;
        s.hierarchKeyFormatter.setCaseSensitive(false);
    }

    public static void setUseExponentD(boolean allowExponentD) {
        FitsFactory.current().useExponentD = allowExponentD;
    }

    public static void setAllowTerminalJunk(boolean allowTerminalJunk) {
        FitsFactory.current().allowTerminalJunk = allowTerminalJunk;
    }

    public static void setAllowHeaderRepairs(boolean allowHeaderRepairs) {
        FitsFactory.current().allowHeaderRepairs = allowHeaderRepairs;
    }

    public static void setCheckAsciiStrings(boolean checkAsciiStrings) {
        FitsFactory.current().checkAsciiStrings = checkAsciiStrings;
    }

    public static void setHierarchFormater(IHierarchKeyFormatter formatter) {
        FitsFactory.current().hierarchKeyFormatter = formatter;
    }

    public static void setLongStringsEnabled(boolean longStringsEnabled) {
        FitsFactory.current().longStringsEnabled = longStringsEnabled;
    }

    @Deprecated
    public static void setSkipBlankAfterAssign(boolean skipBlankAfterAssign) {
        FitsFactory.current().skipBlankAfterAssign = skipBlankAfterAssign;
    }

    public static void setUseAsciiTables(boolean useAsciiTables) {
        FitsFactory.current().useAsciiTables = useAsciiTables;
    }

    public static void setUseHierarch(boolean useHierarch) {
        FitsFactory.current().useHierarch = useHierarch;
    }

    public static void setUseUnicodeChars(boolean value) {
        FitsFactory.current().useUnicodeChars = value;
    }

    public static ExecutorService threadPool() {
        if (threadPool == null) {
            FitsFactory.initializeThreadPool();
        }
        return threadPool;
    }

    public static void useThreadLocalSettings(boolean useThreadSettings) {
        if (useThreadSettings) {
            LOCAL_SETTINGS.set(FitsFactory.GLOBAL_SETTINGS.copy());
        } else {
            LOCAL_SETTINGS.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeThreadPool() {
        FitsSettings fitsSettings = GLOBAL_SETTINGS;
        synchronized (fitsSettings) {
            if (threadPool == null) {
                threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
                    private int counter = 1;

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r, "nom-tam-fits worker " + this.counter++);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
        }
    }

    protected static FitsSettings current() {
        FitsSettings settings = LOCAL_SETTINGS.get();
        if (settings == null) {
            return GLOBAL_SETTINGS;
        }
        return settings;
    }

    private FitsFactory() {
    }

    static /* synthetic */ IHierarchKeyFormatter access$000() {
        return DEFAULT_HIERARCH_FORMATTER;
    }

    protected static final class FitsSettings
    implements Cloneable {
        private boolean useAsciiTables = false;
        private boolean useHierarch = true;
        private boolean useExponentD = false;
        private boolean checkAsciiStrings = false;
        private boolean allowTerminalJunk = true;
        private boolean allowHeaderRepairs = true;
        private boolean longStringsEnabled = true;
        private boolean useUnicodeChars = true;
        @Deprecated
        private boolean skipBlankAfterAssign = false;
        private IHierarchKeyFormatter hierarchKeyFormatter = FitsFactory.access$000();

        private FitsSettings() {
            this.hierarchKeyFormatter.setCaseSensitive(false);
        }

        protected FitsSettings clone() {
            try {
                return (FitsSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        private FitsSettings copy() {
            return this.clone();
        }

        protected IHierarchKeyFormatter getHierarchKeyFormatter() {
            return this.hierarchKeyFormatter;
        }

        protected boolean isUseExponentD() {
            return this.useExponentD;
        }

        protected boolean isAllowTerminalJunk() {
            return this.allowTerminalJunk;
        }

        protected boolean isCheckAsciiStrings() {
            return this.checkAsciiStrings;
        }

        protected boolean isLongStringsEnabled() {
            return this.longStringsEnabled;
        }

        @Deprecated
        protected boolean isSkipBlankAfterAssign() {
            return this.skipBlankAfterAssign;
        }

        protected boolean isUseAsciiTables() {
            return this.useAsciiTables;
        }

        protected boolean isUseHierarch() {
            return this.useHierarch;
        }

        protected boolean isUseUnicodeChars() {
            return this.useUnicodeChars;
        }

        protected boolean isAllowHeaderRepairs() {
            return this.allowHeaderRepairs;
        }
    }
}

