/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ByteArrayIO;
import nom.tam.util.FitsDecoder;
import nom.tam.util.FitsEncoder;

public class FitsHeap
implements FitsElement {
    private static final int MIN_HEAP_CAPACITY = 16384;
    private ByteArrayIO store;
    private FitsEncoder encoder;
    private FitsDecoder decoder;

    private FitsHeap() {
    }

    FitsHeap(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Illegal size for FITS heap: " + size);
        }
        ByteArrayIO data = new ByteArrayIO(Math.max(size, 16384));
        data.setLength(Math.max(0, size));
        this.setData(data);
        this.encoder = new FitsEncoder(this.store);
        this.decoder = new FitsDecoder(this.store);
    }

    protected synchronized void setData(ByteArrayIO data) {
        this.store = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized FitsHeap copy() {
        FitsHeap copy;
        FitsHeap fitsHeap = copy = new FitsHeap();
        synchronized (fitsHeap) {
            copy.setData(this.store.copy());
            copy.encoder = new FitsEncoder(copy.store);
            copy.decoder = new FitsDecoder(copy.store);
        }
        return copy;
    }

    public synchronized void getData(int offset, Object array) throws FitsException {
        try {
            this.store.position(offset);
            this.decoder.readArrayFully(array);
        }
        catch (Exception e) {
            throw new FitsException("Error decoding heap area at offset=" + offset + ", size=" + FitsEncoder.computeSize(array) + " (heap size " + this.size() + "): " + e.getMessage(), e);
        }
    }

    @Override
    public long getFileOffset() {
        throw new IllegalStateException("FitsHeap should only be reset from inside its parent, never alone");
    }

    @Override
    public synchronized long getSize() {
        return this.size();
    }

    synchronized long putData(Object data) throws FitsException {
        return this.putData(data, this.store.length());
    }

    synchronized long putData(Object data, long pos) throws FitsException {
        long lsize = pos + FitsEncoder.computeSize(data);
        if (lsize > Integer.MAX_VALUE) {
            throw new FitsException("FITS Heap > 2 G");
        }
        try {
            this.store.position(pos);
            this.encoder.writeArray(data);
        }
        catch (Exception e) {
            throw new FitsException("Unable to write variable column length data: " + e.getMessage(), e);
        }
        return this.store.position() - pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int copyFrom(FitsHeap src, int offset, int len) {
        int pos = (int)this.store.length();
        this.store.setLength(pos + len);
        FitsHeap fitsHeap = src;
        synchronized (fitsHeap) {
            System.arraycopy(src.store.getBuffer(), offset, this.store.getBuffer(), pos, len);
        }
        return pos;
    }

    @Override
    @SuppressFBWarnings(value={"RR_NOT_CHECKED"}, justification="this read will never return less than the requested length")
    public synchronized void read(ArrayDataInput str) throws FitsException {
        if (this.store.length() == 0L) {
            return;
        }
        try {
            str.readFully(this.store.getBuffer(), 0, (int)this.store.length());
        }
        catch (IOException e) {
            throw new FitsException("Error reading heap " + e.getMessage(), e);
        }
    }

    @Override
    public boolean reset() {
        throw new IllegalStateException("FitsHeap should only be reset from inside its parent, never alone");
    }

    @Override
    public void rewrite() throws IOException, FitsException {
        throw new FitsException("FitsHeap should only be rewritten from inside its parent, never alone");
    }

    @Override
    public boolean rewriteable() {
        return false;
    }

    public synchronized int size() {
        return (int)this.store.length();
    }

    @Override
    public synchronized void write(ArrayDataOutput str) throws FitsException {
        try {
            str.write(this.store.getBuffer(), 0, (int)this.store.length());
        }
        catch (IOException e) {
            throw new FitsException("Error writing heap:" + e.getMessage(), e);
        }
    }
}

