/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.FitsDecoder;
import nom.tam.util.FitsEncoder;
import nom.tam.util.FitsIO;
import nom.tam.util.RandomAccess;

public final class FitsUtil {
    static final byte BLANK_SPACE = 32;
    static final byte MIN_ASCII_VALUE = 32;
    static final byte MAX_ASCII_VALUE = 126;
    static final byte ASCII_NULL = 0;
    private static final Logger LOG = Logger.getLogger(FitsUtil.class.getName());
    private static boolean wroteCheckingError = false;

    private FitsUtil() {
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static long addPadding(long size) {
        return size + (long)FitsUtil.padding(size);
    }

    static Object booleansToBytes(Object o) {
        if (o == null) {
            return FitsEncoder.byteForBoolean(null);
        }
        if (o instanceof Boolean) {
            return FitsEncoder.byteForBoolean((Boolean)o);
        }
        if (o instanceof boolean[]) {
            boolean[] bool = (boolean[])o;
            byte[] b = new byte[bool.length];
            for (int i = 0; i < bool.length; ++i) {
                b[i] = FitsEncoder.byteForBoolean(bool[i]);
            }
            return b;
        }
        if (o instanceof Boolean[]) {
            Boolean[] bool = (Boolean[])o;
            byte[] b = new byte[bool.length];
            for (int i = 0; i < bool.length; ++i) {
                b[i] = FitsEncoder.byteForBoolean(bool[i]);
            }
            return b;
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            Object[] b = null;
            for (int i = 0; i < array.length; ++i) {
                Object e = FitsUtil.booleansToBytes(array[i]);
                if (b == null) {
                    b = (Object[])Array.newInstance(e.getClass(), array.length);
                }
                b[i] = e;
            }
            return b;
        }
        throw new IllegalArgumentException("Not boolean values: " + o.getClass().getName());
    }

    static Object bytesToBooleanObjects(Object bytes) {
        if (bytes instanceof Byte) {
            return FitsDecoder.booleanObjectFor(((Number)bytes).intValue());
        }
        if (bytes instanceof byte[]) {
            byte[] b = (byte[])bytes;
            Boolean[] bool = new Boolean[b.length];
            for (int i = 0; i < b.length; ++i) {
                bool[i] = FitsDecoder.booleanObjectFor(b[i]);
            }
            return bool;
        }
        if (bytes instanceof Object[]) {
            Object[] array = (Object[])bytes;
            Object[] bool = null;
            for (int i = 0; i < array.length; ++i) {
                Object e = FitsUtil.bytesToBooleanObjects(array[i]);
                if (bool == null) {
                    bool = (Object[])Array.newInstance(e.getClass(), array.length);
                }
                bool[i] = e;
            }
            return bool;
        }
        throw new IllegalArgumentException("Cannot convert to boolean values: " + bytes.getClass().getName());
    }

    static byte[] bitsToBytes(boolean[] bits) throws IllegalArgumentException {
        byte[] bytes = new byte[(bits.length + 8 - 1) / 8];
        for (int i = 0; i < bits.length; ++i) {
            if (!bits[i]) continue;
            int pos = 7 - i % 8;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << pos);
        }
        return bytes;
    }

    static byte[] bitsToBytes(boolean[] bits, int l) throws IllegalArgumentException {
        int n = bits.length / l;
        int bl = (l + 8 - 1) / 8;
        byte[] bytes = new byte[n * bl];
        for (int i = 0; i < n; ++i) {
            int off = i * l;
            int boff = i * bl;
            for (int j = 0; j < l; ++j) {
                if (!bits[off + j]) continue;
                int pos = 7 - j % 8;
                int n2 = boff + j / 8;
                bytes[n2] = (byte)(bytes[n2] | 1 << pos);
            }
        }
        return bytes;
    }

    static boolean[] bytesToBits(byte[] bytes, int count) {
        boolean[] bits = new boolean[count];
        for (int i = 0; i < bits.length; ++i) {
            int pos = 7 - i % 8;
            bits[i] = (bytes[i / 8] >>> pos & 1) == 1;
        }
        return bits;
    }

    static String extractString(byte[] bytes, ParsePosition pos, int maxLen, byte terminator) {
        int offset = pos.getIndex();
        if (offset >= bytes.length) {
            return "";
        }
        if (offset + maxLen > bytes.length) {
            maxLen = bytes.length - offset;
        }
        int end = -1;
        for (int i = 0; i < maxLen; ++i) {
            byte b = bytes[offset + i];
            pos.setIndex(offset + i);
            if (b == terminator || b == 0) break;
            if (b == 32) continue;
            end = i;
        }
        pos.setIndex(pos.getIndex() + 1);
        byte[] sanitized = new byte[end + 1];
        boolean checking = FitsFactory.getCheckAsciiStrings();
        for (int i = 0; i <= end; ++i) {
            int b = bytes[offset + i];
            if (checking && (b < 32 || b > 126)) {
                if (!wroteCheckingError) {
                    LOG.warning("WARNING! Converting invalid table string character[s] to spaces.");
                    wroteCheckingError = true;
                }
                b = 32;
            }
            sanitized[i] = b;
        }
        return AsciiFuncs.asciiString(sanitized);
    }

    public static String[] byteArrayToStrings(byte[] bytes, int maxLen) {
        String[] res = new String[bytes.length / maxLen];
        for (int i = 0; i < res.length; ++i) {
            res[i] = FitsUtil.extractString(bytes, new ParsePosition(i * maxLen), maxLen, (byte)0).trim();
        }
        return res;
    }

    static boolean[] byteToBoolean(byte[] bytes) {
        boolean[] bool = new boolean[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bool[i] = FitsDecoder.booleanFor(bytes[i]);
        }
        return bool;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="null has specific meaning here")
    static Boolean parseLogical(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("t")) {
            return true;
        }
        if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("f")) {
            return false;
        }
        try {
            long l = Long.parseLong(s);
            return l != 0L;
        }
        catch (NumberFormatException l) {
            try {
                double d = Double.parseDouble(s);
                if (!Double.isNaN(d)) {
                    return d != 0.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
    }

    public static long findOffset(Closeable o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        URLConnection conn = null;
        int code = -1;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                code = ((HttpURLConnection)conn).getResponseCode();
            }
            return conn.getInputStream();
        }
        catch (ProtocolException e) {
            LOG.log(Level.WARNING, "could not connect to " + url + (code >= 0 ? " got responce-code" + code : ""), e);
            throw e;
        }
    }

    public static int maxLength(String[] strings) {
        int max = 0;
        for (String element : strings) {
            if (element == null || element.length() <= max) continue;
            max = element.length();
        }
        return max;
    }

    static int maxStringLength(Object o) {
        if (o instanceof String) {
            return ((String)o).length();
        }
        int max = 0;
        if (o instanceof Object[]) {
            for (Object e : (Object[])o) {
                int l;
                if (e == null || (l = FitsUtil.maxStringLength(e)) <= max) continue;
                max = l;
            }
        }
        return max;
    }

    static int minStringLength(Object o) {
        if (o instanceof String) {
            return ((String)o).length();
        }
        int min = -1;
        if (o instanceof Object[]) {
            for (Object e : (Object[])o) {
                if (e == null) {
                    return 0;
                }
                int l = FitsUtil.minStringLength(e);
                if (l == 0) {
                    return 0;
                }
                if (min >= 0 && l >= min) continue;
                min = l;
            }
        }
        return min < 0 ? 0 : min;
    }

    public static void pad(ArrayDataOutput stream, long size) throws FitsException {
        FitsUtil.pad(stream, size, (byte)0);
    }

    public static void pad(ArrayDataOutput stream, long size, byte fill) throws FitsException {
        int len = FitsUtil.padding(size);
        if (len > 0) {
            byte[] buf = new byte[len];
            Arrays.fill(buf, fill);
            try {
                stream.write(buf);
                stream.flush();
            }
            catch (Exception e) {
                throw new FitsException("Unable to write padding", e);
            }
        }
    }

    public static int padding(int size) {
        return FitsUtil.padding((long)size);
    }

    public static int padding(long size) {
        int mod = (int)(size % 2880L);
        if (mod > 0) {
            return 2880 - mod;
        }
        return 0;
    }

    @Deprecated
    public static void reposition(FitsIO o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + ": " + e.getMessage(), e);
        }
    }

    private static void stringToBytes(String s, byte[] res, int offset, int len, byte pad) {
        byte[] b;
        int l = 0;
        if (s != null && (l = Math.min((b = AsciiFuncs.getBytes(s)).length, len)) > 0) {
            System.arraycopy(b, 0, res, offset, l);
        }
        if (l < len) {
            Arrays.fill(res, offset + l, offset + len, pad);
        }
    }

    static byte[] stringToByteArray(String s, int len) {
        byte[] res = new byte[len];
        FitsUtil.stringToBytes(s, res, 0, len, (byte)32);
        return res;
    }

    public static byte[] stringsToByteArray(String[] stringArray, int len) {
        return FitsUtil.stringsToByteArray(stringArray, len, (byte)32);
    }

    static byte[] stringsToByteArray(String[] stringArray, int len, byte pad) {
        byte[] res = new byte[stringArray.length * len];
        for (int i = 0; i < stringArray.length; ++i) {
            FitsUtil.stringToBytes(stringArray[i], res, i * len, len, pad);
        }
        return res;
    }

    static byte[] stringsToDelimitedBytes(String[] array, int maxlen, byte delim) {
        int l = array.length - 1;
        for (String s : array) {
            l += s == null ? 1 : Math.max(s.length() + 1, maxlen);
        }
        byte[] b = new byte[l];
        l = 0;
        for (String s : array) {
            if (s != null) {
                FitsUtil.stringToBytes(s, b, l, s.length(), (byte)32);
                l += s.length();
            }
            b[l++] = delim;
        }
        b[l - 1] = 0;
        return b;
    }

    private static String[] delimitedBytesToStrings(byte[] bytes, byte delim) {
        ArrayList<String> s = new ArrayList<String>();
        ParsePosition pos = new ParsePosition(0);
        while (pos.getIndex() < bytes.length) {
            s.add(FitsUtil.extractString(bytes, pos, bytes.length, delim));
        }
        String[] a = new String[s.size()];
        s.toArray(a);
        return a;
    }

    static String[] delimitedBytesToStrings(byte[] bytes, int maxlen, byte delim) {
        if (maxlen <= 0) {
            return FitsUtil.delimitedBytesToStrings(bytes, delim);
        }
        String[] res = new String[(bytes.length + maxlen - 1) / maxlen];
        ParsePosition pos = new ParsePosition(0);
        for (int i = 0; i < res.length; ++i) {
            res[i] = FitsUtil.extractString(bytes, pos, maxlen, delim);
        }
        return res;
    }
}

