/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardCountingArrayDataInput;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderCardParser;
import nom.tam.fits.HeaderOrder;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.TableHDU;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.extra.CXCExt;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.ComplexValue;
import nom.tam.util.Cursor;
import nom.tam.util.FitsInputStream;
import nom.tam.util.HashedList;
import nom.tam.util.RandomAccess;

public class Header
implements FitsElement {
    public static final int DEFAULT_COMMENT_ALIGN = 30;
    public static final int MIN_COMMENT_ALIGN = 20;
    public static final int MAX_COMMENT_ALIGN = 70;
    private static int commentAlign = 30;
    private static final Logger LOG = Logger.getLogger(Header.class.getName());
    private static final int MIN_NUMBER_OF_CARDS_FOR_VALID_HEADER = 4;
    private final HashedList<HeaderCard> cards;
    private long fileOffset;
    private List<HeaderCard> duplicates = null;
    private HashSet<String> dupKeys;
    private ArrayDataInput input;
    private int minCards;
    private long readSize;
    private long streamSum = -1L;
    private Comparator<String> headerSorter;
    private BasicHDU<?> owner;
    public static final KeywordCheck DEFAULT_KEYWORD_CHECK_POLICY;
    private static KeywordCheck defaultKeyCheck;
    private KeywordCheck keyCheck = defaultKeyCheck;

    public static Header readHeader(ArrayDataInput dis) throws TruncatedFileException, IOException {
        Header myHeader = new Header();
        try {
            myHeader.read(dis);
        }
        catch (EOFException e) {
            return null;
        }
        return myHeader;
    }

    @Deprecated
    public static void setLongStringsEnabled(boolean flag) {
        FitsFactory.setLongStringsEnabled(flag);
    }

    public Header() {
        this.cards = new HashedList();
        this.headerSorter = new HeaderOrder();
        this.clear();
    }

    public Header(ArrayDataInput is) throws TruncatedFileException, IOException {
        this();
        this.read(is);
    }

    public Header(Data o) throws FitsException {
        this();
        o.fillHeader(this);
    }

    public Header(String[] newCards) {
        this();
        for (String newCard : newCards) {
            this.cards.add(HeaderCard.create(newCard));
        }
    }

    void assignTo(BasicHDU<?> hdu) {
        this.owner = hdu;
    }

    public void ensureCardSpace(int nCards) {
        if (nCards < 1) {
            nCards = 1;
        }
        this.minCards = nCards;
    }

    public void mergeDistinct(Header source) {
        this.seekTail();
        Cursor<String, HeaderCard> c = source.iterator();
        while (c.hasNext()) {
            HeaderCard card = (HeaderCard)c.next();
            if (!card.isCommentStyleCard() && this.containsKey(card.getKey()) || card.getKey().equals(Standard.SIMPLE.key()) || card.getKey().equals(Standard.XTENSION.key())) continue;
            this.addLine(card.copy());
        }
    }

    public void addLine(HeaderCard fcard) throws IllegalArgumentException {
        if (fcard == null) {
            return;
        }
        if (fcard.getStandardKey() != null) {
            this.checkKeyword(fcard.getStandardKey());
        }
        this.cursor().add(fcard);
    }

    public void setKeywordChecking(KeywordCheck mode) {
        this.keyCheck = mode;
    }

    public static void setDefaultKeywordChecking(KeywordCheck mode) {
        defaultKeyCheck = mode;
    }

    public final KeywordCheck getKeywordChecking() {
        return this.keyCheck;
    }

    private void checkKeyword(IFitsHeader keyword) throws IllegalArgumentException {
        if (this.keyCheck == KeywordCheck.NONE || this.owner == null) {
            return;
        }
        if (this.keyCheck == KeywordCheck.STRICT && (keyword.status() == IFitsHeader.SOURCE.MANDATORY || keyword.status() == IFitsHeader.SOURCE.INTEGRAL)) {
            throw new IllegalArgumentException("Keyword " + keyword + " should be set by the library only");
        }
        switch (keyword.hdu()) {
            case PRIMARY: {
                if (!this.owner.canBePrimary()) {
                    throw new IllegalArgumentException("Keyword " + keyword + " is a primary keyword and may not be used in extensions");
                }
                return;
            }
            case EXTENSION: {
                if (this.owner instanceof RandomGroupsHDU) {
                    throw new IllegalArgumentException("Keyword " + keyword + " is an extension keyword but random groups may only be primary");
                }
                return;
            }
            case IMAGE: {
                if (!(this.owner instanceof ImageHDU) && !(this.owner instanceof RandomGroupsHDU)) break;
                return;
            }
            case GROUPS: {
                if (!(this.owner instanceof RandomGroupsHDU)) break;
                return;
            }
            case TABLE: {
                if (!(this.owner instanceof TableHDU)) break;
                return;
            }
            case ASCII_TABLE: {
                if (!(this.owner instanceof AsciiTableHDU)) break;
                return;
            }
            case BINTABLE: {
                if (!(this.owner instanceof BinaryTableHDU)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new IllegalArgumentException("Keyword " + keyword.key() + " is not appropriate for " + this.owner.getClass().getName());
    }

    public HeaderCard addValue(IFitsHeader key, Boolean val) throws HeaderCardException, IllegalArgumentException {
        HeaderCard card = HeaderCard.create(key, val);
        this.addLine(card);
        return card;
    }

    public HeaderCard addValue(IFitsHeader key, Number val) throws HeaderCardException, IllegalArgumentException {
        HeaderCard card = HeaderCard.create(key, val);
        this.addLine(card);
        return card;
    }

    public HeaderCard addValue(IFitsHeader key, String val) throws HeaderCardException, IllegalArgumentException {
        HeaderCard card = HeaderCard.create(key, val);
        this.addLine(card);
        return card;
    }

    public HeaderCard addValue(IFitsHeader key, ComplexValue val) throws HeaderCardException, IllegalArgumentException {
        HeaderCard card = HeaderCard.create(key, val);
        this.addLine(card);
        return card;
    }

    public HeaderCard addValue(String key, Boolean val, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCard addValue(String key, Number val, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCard addValue(String key, Number val, int decimals, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, decimals, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCard addValue(String key, ComplexValue val, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCard addValue(String key, ComplexValue val, int decimals, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, decimals, comment);
        this.addLine(hc);
        return hc;
    }

    @Deprecated
    public HeaderCard addHexValue(String key, long val, String comment) throws HeaderCardException {
        HeaderCard hc = HeaderCard.createHexValueCard(key, val, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCard addValue(String key, String val, String comment) throws HeaderCardException {
        HeaderCard hc = new HeaderCard(key, val, comment);
        this.addLine(hc);
        return hc;
    }

    public HeaderCardBuilder card(IFitsHeader key) {
        return new HeaderCardBuilder(this, key);
    }

    public final boolean containsKey(IFitsHeader key) {
        return this.cards.containsKey(key.key());
    }

    public final boolean containsKey(String key) {
        return this.cards.containsKey(key);
    }

    public void deleteKey(IFitsHeader key) {
        this.deleteKey(key.key());
    }

    public void deleteKey(String key) {
        if (this.containsKey(key)) {
            this.cards.remove(this.cards.get(key));
        }
    }

    public void dumpHeader(PrintStream ps) {
        Cursor<String, HeaderCard> iter = this.iterator();
        while (iter.hasNext()) {
            ps.println(iter.next());
        }
    }

    public HeaderCard getCard(IFitsHeader key) {
        return this.getCard(key.key());
    }

    public HeaderCard findCard(IFitsHeader key) {
        return this.findCard(key.key());
    }

    public HeaderCard getCard(String key) {
        return this.cards.get(key);
    }

    public HeaderCard findCard(String key) {
        HeaderCard card = this.cards.get(key);
        if (card != null) {
            this.cursor().setKey(key);
        } else {
            this.cursor().end();
        }
        return card;
    }

    public HeaderCard[] findCards(String regex) {
        ArrayList<HeaderCard> crds = new ArrayList<HeaderCard>();
        Cursor<String, HeaderCard> iter = this.iterator();
        while (iter.hasNext()) {
            HeaderCard card = (HeaderCard)iter.next();
            if (!card.getKey().matches(regex)) continue;
            crds.add(card);
        }
        HeaderCard[] tmp = new HeaderCard[crds.size()];
        return crds.toArray(tmp);
    }

    @Deprecated
    public String findKey(String key) {
        HeaderCard card = this.findCard(key);
        if (card == null) {
            return null;
        }
        return card.toString();
    }

    public final BigDecimal getBigDecimalValue(IFitsHeader key) {
        return this.getBigDecimalValue(key.key());
    }

    public final BigDecimal getBigDecimalValue(IFitsHeader key, BigDecimal dft) {
        return this.getBigDecimalValue(key.key(), dft);
    }

    public final BigDecimal getBigDecimalValue(String key) {
        return this.getBigDecimalValue(key, BigDecimal.ZERO);
    }

    public BigDecimal getBigDecimalValue(String key, BigDecimal dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(BigDecimal.class, dft);
    }

    public final BigInteger getBigIntegerValue(IFitsHeader key) {
        return this.getBigIntegerValue(key.key());
    }

    public final BigInteger getBigIntegerValue(IFitsHeader key, BigInteger dft) {
        return this.getBigIntegerValue(key.key(), dft);
    }

    public final BigInteger getBigIntegerValue(String key) {
        return this.getBigIntegerValue(key, BigInteger.ZERO);
    }

    public BigInteger getBigIntegerValue(String key, BigInteger dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(BigInteger.class, dft);
    }

    public final ComplexValue getComplexValue(String key) {
        return this.getComplexValue(key, ComplexValue.ZERO);
    }

    public ComplexValue getComplexValue(String key, ComplexValue dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(ComplexValue.class, dft);
    }

    public final boolean getBooleanValue(IFitsHeader key) {
        return this.getBooleanValue(key.key());
    }

    public final boolean getBooleanValue(IFitsHeader key, boolean dft) {
        return this.getBooleanValue(key.key(), dft);
    }

    public final boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(String key, boolean dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Boolean.class, dft);
    }

    @Deprecated
    public String getCard(int n) {
        if (n >= 0 && n < this.cards.size()) {
            return this.cards.get(n).toString();
        }
        return null;
    }

    public long getDataSize() {
        return FitsUtil.addPadding(this.trueDataSize());
    }

    public final double getDoubleValue(IFitsHeader key) {
        return this.getDoubleValue(key.key());
    }

    public final double getDoubleValue(IFitsHeader key, double dft) {
        return this.getDoubleValue(key.key(), dft);
    }

    public final double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public double getDoubleValue(String key, double dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Double.class, dft);
    }

    public List<HeaderCard> getDuplicates() {
        return this.duplicates;
    }

    public Set<String> getDuplicateKeySet() {
        return this.dupKeys;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public final float getFloatValue(IFitsHeader key) {
        return this.getFloatValue(key.key());
    }

    public final float getFloatValue(IFitsHeader key, float dft) {
        return this.getFloatValue(key.key(), dft);
    }

    public final float getFloatValue(String key) {
        return this.getFloatValue(key, 0.0f);
    }

    public float getFloatValue(String key, float dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Float.class, Float.valueOf(dft)).floatValue();
    }

    public final int getIntValue(IFitsHeader key) {
        return (int)this.getLongValue(key);
    }

    public final int getIntValue(IFitsHeader key, int dft) {
        return (int)this.getLongValue(key, (long)dft);
    }

    public final int getIntValue(String key) {
        return (int)this.getLongValue(key);
    }

    public int getIntValue(String key, int dft) {
        return (int)this.getLongValue(key, (long)dft);
    }

    @Deprecated
    public String getKey(int n) {
        if (n >= 0 && n < this.cards.size()) {
            return this.cards.get(n).getKey();
        }
        return null;
    }

    public final long getLongValue(IFitsHeader key) {
        return this.getLongValue(key.key());
    }

    public final long getLongValue(IFitsHeader key, long dft) {
        return this.getLongValue(key.key(), dft);
    }

    public final long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Long.class, dft);
    }

    @Deprecated
    public final long getHexValue(String key) {
        return this.getHexValue(key, 0L);
    }

    public long getHexValue(String key, long dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            return fcard.getHexValue();
        }
        catch (NumberFormatException e) {
            return dft;
        }
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public int getNumberOfPhysicalCards() {
        int count = 0;
        for (HeaderCard card : this.cards) {
            count += card.cardSize();
        }
        if (!this.containsKey(Standard.END)) {
            ++count;
        }
        return count;
    }

    public long getMinimumSize() {
        return FitsUtil.addPadding((long)this.minCards * 80L);
    }

    @Deprecated
    public final long getOriginalSize() {
        return this.readSize;
    }

    @Override
    public final long getSize() {
        if (!this.isValidHeader()) {
            return 0L;
        }
        return FitsUtil.addPadding((long)Math.max(this.minCards, this.getNumberOfPhysicalCards()) * 80L);
    }

    public final String getStringValue(IFitsHeader key) {
        return this.getStringValue(key.key());
    }

    public final String getStringValue(IFitsHeader key, String dft) {
        return this.getStringValue(key.key(), dft);
    }

    public final String getStringValue(String key) {
        return this.getStringValue(key, null);
    }

    public String getStringValue(String key, String dft) {
        HeaderCard fcard = this.getCard(key);
        if (fcard == null || !fcard.isStringValue()) {
            return dft;
        }
        return fcard.getValue();
    }

    public boolean hadDuplicates() {
        return this.duplicates != null;
    }

    public HeaderCard insertCommentStyle(String key, String comment) {
        if (comment == null) {
            comment = "";
        } else if (comment.length() > 71) {
            comment = comment.substring(0, 71);
            LOG.warning("Truncated comment to fit card: [" + comment + "]");
        }
        try {
            HeaderCard hc = HeaderCard.createCommentStyleCard(key, HeaderCard.sanitize(comment));
            this.cursor().add(hc);
            return hc;
        }
        catch (HeaderCardException e) {
            LOG.log(Level.WARNING, "Ignoring comment card with invalid key [" + HeaderCard.sanitize(key) + "]", e);
            return null;
        }
    }

    public int insertCommentStyleMultiline(String key, String comment) {
        if (comment == null || comment.isEmpty()) {
            comment = " ";
        }
        int n = 0;
        int from = 0;
        while (from < comment.length()) {
            int to = from + 71;
            String part = null;
            part = to < comment.length() ? comment.substring(from, --to) + "&" : comment.substring(from);
            if (this.insertCommentStyle(key, part) == null) {
                return n;
            }
            from = to;
            ++n;
        }
        return n;
    }

    public int insertComment(String value) {
        return this.insertCommentStyleMultiline(Standard.COMMENT.key(), value);
    }

    public int insertUnkeyedComment(String value) {
        return this.insertCommentStyleMultiline(Standard.BLANKS.key(), value);
    }

    public void insertBlankCard() {
        this.insertCommentStyle(null, null);
    }

    public int insertHistory(String value) {
        return this.insertCommentStyleMultiline(Standard.HISTORY.key(), value);
    }

    public Cursor<String, HeaderCard> iterator() {
        return this.cards.iterator(0);
    }

    @Deprecated
    public Cursor<String, HeaderCard> iterator(int index) {
        return this.cards.iterator(index);
    }

    private Cursor<String, HeaderCard> cursor() {
        return this.cards.cursor();
    }

    public Cursor<String, HeaderCard> seekHead() {
        Cursor<String, HeaderCard> c = this.cursor();
        while (c.hasPrev()) {
            c.prev();
        }
        return c;
    }

    public Cursor<String, HeaderCard> seekTail() {
        this.cursor().end();
        return this.cursor();
    }

    @Deprecated
    public Data makeData() throws FitsException {
        return FitsFactory.dataFactory(this);
    }

    public HeaderCard nextCard() {
        if (this.cursor().hasNext()) {
            return (HeaderCard)this.cursor().next();
        }
        return null;
    }

    public HeaderCard prevCard() {
        if (this.cursor().hasPrev()) {
            return this.cursor().prev();
        }
        return null;
    }

    @Deprecated
    public void pointToData(Data o) throws FitsException {
        o.fillHeader(this);
    }

    private void clear() {
        this.cards.clear();
        this.duplicates = null;
        this.dupKeys = null;
        this.readSize = 0L;
        this.fileOffset = -1L;
        this.minCards = 0;
    }

    public boolean isEmpty() {
        return this.cards.isEmpty();
    }

    @Override
    public void read(ArrayDataInput dis) throws TruncatedFileException, IOException {
        this.clear();
        this.fileOffset = dis instanceof RandomAccess ? FitsUtil.findOffset(dis) : -1L;
        if (dis instanceof FitsInputStream) {
            ((FitsInputStream)dis).nextChecksum();
        }
        this.streamSum = -1L;
        int trailingBlanks = 0;
        this.minCards = 0;
        HeaderCardCountingArrayDataInput cardCountingArray = new HeaderCardCountingArrayDataInput(dis);
        try {
            while (true) {
                HeaderCard fcard = new HeaderCard(cardCountingArray);
                this.minCards += fcard.cardSize();
                String key = fcard.getKey();
                if (this.isEmpty()) {
                    this.checkFirstCard(key);
                } else {
                    if (fcard.isBlank()) {
                        ++trailingBlanks;
                        continue;
                    }
                    if (Standard.END.key().equals(key)) {
                        this.addLine(fcard);
                        break;
                    }
                    if (CXCExt.LONGSTRN.key().equals(key)) {
                        FitsFactory.setLongStringsEnabled(true);
                    }
                }
                for (int i = 0; i < trailingBlanks; ++i) {
                    this.insertBlankCard();
                }
                trailingBlanks = 0;
                if (this.cards.containsKey(key)) {
                    this.addDuplicate(this.cards.get(key));
                }
                this.addLine(fcard);
            }
        }
        catch (EOFException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.isEmpty() && FitsFactory.getAllowTerminalJunk()) {
                this.forceEOF("Junk detected where header was expected to start" + (this.fileOffset > 0L ? ": at " + this.fileOffset : ""), e);
            }
            if (e instanceof TruncatedFileException) {
                throw (TruncatedFileException)e;
            }
            throw new IOException("Invalid FITS Header" + (this.isEmpty() ? e : ":\n\n --> Try FitsFactory.setAllowTerminalJunk(true) prior to reading to work around.\n"), e);
        }
        if (this.fileOffset >= 0L) {
            this.input = dis;
        }
        this.ensureCardSpace(cardCountingArray.getPhysicalCardsRead());
        this.readSize = FitsUtil.addPadding((long)this.minCards * 80L);
        try {
            dis.skipAllBytes(FitsUtil.padding(this.minCards * 80));
        }
        catch (EOFException e) {
            LOG.log(Level.WARNING, "Premature end-of-file: no padding after header.", e);
        }
        if (dis instanceof FitsInputStream) {
            this.streamSum = ((FitsInputStream)dis).nextChecksum();
        }
        if (Fits.checkTruncated(dis)) {
            LOG.warning("Premature end-of-file: no padding after header.");
        }
        this.seekTail();
    }

    RandomAccess getRandomAccessInput() {
        return this.input instanceof RandomAccess ? (RandomAccess)this.input : null;
    }

    final long getStreamChecksum() {
        return this.streamSum;
    }

    private void forceEOF(String message, Exception cause) throws EOFException {
        LOG.log(Level.WARNING, message, cause);
        throw new EOFException("Forced EOF at " + this.fileOffset + " due to: " + message);
    }

    @Deprecated
    public void removeCard(String key) throws HeaderCardException {
        this.deleteKey(key);
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception while repositioning " + this.input, e);
            return false;
        }
    }

    @Deprecated
    public final void resetOriginalSize() {
        this.ensureCardSpace(1);
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        ArrayDataOutput dos = (ArrayDataOutput)((Object)this.input);
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite Header.");
        }
        FitsUtil.reposition(dos, this.fileOffset);
        this.write(dos);
        dos.flush();
    }

    @Override
    public boolean rewriteable() {
        long writeSize = FitsUtil.addPadding((long)Math.max(this.minCards, this.getNumberOfPhysicalCards()) * 80L);
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && writeSize == this.getOriginalSize();
    }

    @Deprecated
    public void setBitpix(int val) throws IllegalArgumentException {
        try {
            this.setBitpix(Bitpix.forValue(val));
        }
        catch (FitsException e) {
            throw new IllegalArgumentException("Invalid BITPIX value: " + val, e);
        }
    }

    @Deprecated
    public void setBitpix(Bitpix bitpix) {
        Cursor<String, HeaderCard> iter = this.iterator();
        iter.next();
        iter.add(bitpix.getHeaderCard());
    }

    public void setHeaderSorter(Comparator<String> headerSorter) {
        this.headerSorter = headerSorter;
    }

    @Deprecated
    public void setNaxes(int val) {
        Cursor<String, HeaderCard> iter = this.iterator();
        iter.setKey(Standard.BITPIX.key());
        if (iter.hasNext()) {
            iter.next();
        }
        iter.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, val));
    }

    @Deprecated
    public void setNaxis(int axis, int dim) {
        Cursor<String, HeaderCard> iter = this.iterator();
        if (axis <= 0) {
            LOG.warning("setNaxis ignored because axis less than 0");
            return;
        }
        if (axis == 1) {
            iter.setKey(Standard.NAXIS.key());
        } else if (axis > 1) {
            iter.setKey(Standard.NAXISn.n(axis - 1).key());
        }
        if (iter.hasNext()) {
            iter.next();
        }
        iter.add(HeaderCard.create(Standard.NAXISn.n(axis), dim));
    }

    @Deprecated
    public void setSimple(boolean val) {
        this.deleteKey(Standard.SIMPLE);
        this.deleteKey(Standard.XTENSION);
        this.deleteKey(Standard.EXTEND);
        Cursor<String, HeaderCard> iter = this.iterator();
        iter.add(HeaderCard.create((IFitsHeader)Standard.SIMPLE, val));
        if (this.findCard(Standard.NAXIS) != null && this.findCard(Standard.NAXISn.n(this.getIntValue(Standard.NAXIS))) != null) {
            iter.next();
        }
        iter.add(HeaderCard.create((IFitsHeader)Standard.EXTEND, true));
    }

    @Deprecated
    public void setXtension(String val) throws IllegalArgumentException {
        this.deleteKey(Standard.SIMPLE);
        this.deleteKey(Standard.XTENSION);
        this.deleteKey(Standard.EXTEND);
        this.iterator().add(HeaderCard.create((IFitsHeader)Standard.XTENSION, val));
    }

    @Deprecated
    public int size() {
        return this.cards.size();
    }

    public void updateLine(IFitsHeader key, HeaderCard card) throws HeaderCardException {
        this.updateLine(key.key(), card);
    }

    public final void updateLine(String key, HeaderCard card) throws HeaderCardException {
        this.cards.update(key, card);
    }

    public void updateLines(Header newHdr) throws HeaderCardException {
        Cursor<String, HeaderCard> j = newHdr.iterator();
        while (j.hasNext()) {
            HeaderCard card = (HeaderCard)j.next();
            if (card.isCommentStyleCard()) {
                this.insertCommentStyle(card.getKey(), card.getComment());
                continue;
            }
            this.updateLine(card.getKey(), card);
        }
    }

    private void writeBlankCards(ArrayDataOutput dos, int n) throws IOException {
        byte[] blank = new byte[80];
        Arrays.fill(blank, (byte)32);
        while (--n >= 0) {
            dos.write(blank);
        }
    }

    void setRequiredKeys(String xType) throws FitsException {
        if (xType == null) {
            this.deleteKey(Standard.XTENSION);
            if (!this.getBooleanValue(Standard.GROUPS, false)) {
                this.deleteKey(Standard.PCOUNT);
                this.deleteKey(Standard.GCOUNT);
            }
            this.addValue((IFitsHeader)Standard.SIMPLE, true);
        } else {
            this.deleteKey(Standard.SIMPLE);
            this.deleteKey(Standard.EXTEND);
            this.addValue((IFitsHeader)Standard.XTENSION, xType);
        }
        this.addValue((IFitsHeader)Standard.BITPIX, this.getIntValue(Standard.BITPIX, 32));
        int naxes = this.getIntValue(Standard.NAXIS, 0);
        this.addValue((IFitsHeader)Standard.NAXIS, naxes);
        int i = 1;
        while (i <= naxes) {
            IFitsHeader naxisi = Standard.NAXISn.n(i++);
            this.addValue(naxisi, this.getIntValue(naxisi, 1));
        }
        if (xType == null) {
            this.addValue((IFitsHeader)Standard.EXTEND, true);
        } else {
            this.addValue((IFitsHeader)Standard.PCOUNT, this.getIntValue(Standard.PCOUNT, 0));
            this.addValue((IFitsHeader)Standard.GCOUNT, this.getIntValue(Standard.GCOUNT, 1));
        }
    }

    public void validate(boolean asPrimary) throws FitsException {
        this.setRequiredKeys(asPrimary ? null : this.getStringValue(Standard.XTENSION, "UNKNOWN"));
        this.validate();
    }

    private void validate() throws FitsException {
        if (this.headerSorter != null) {
            this.cards.sort(this.headerSorter);
        }
        this.checkBeginning();
        this.checkEnd();
    }

    @Override
    public void write(ArrayDataOutput dos) throws FitsException {
        this.validate();
        FitsFactory.FitsSettings settings = FitsFactory.current();
        this.fileOffset = FitsUtil.findOffset(dos);
        Cursor<String, HeaderCard> writeIterator = this.cards.iterator(0);
        try {
            int size = 0;
            while (writeIterator.hasNext()) {
                HeaderCard card = (HeaderCard)writeIterator.next();
                byte[] b = AsciiFuncs.getBytes(card.toString(settings));
                if (Standard.END.key().equals(card.getKey()) && this.minCards * 80 > (size += b.length)) {
                    this.writeBlankCards(dos, this.minCards - size / 80);
                    size = this.minCards * 80;
                }
                dos.write(b);
            }
            FitsUtil.pad(dos, size, (byte)32);
            dos.flush();
        }
        catch (IOException e) {
            throw new FitsException("IO Error writing header", e);
        }
    }

    private void addDuplicate(HeaderCard dup) {
        if (dup.isCommentStyleCard()) {
            return;
        }
        if (this.duplicates == null) {
            this.duplicates = new ArrayList<HeaderCard>();
            this.dupKeys = new HashSet();
        }
        if (!this.dupKeys.contains(dup.getKey())) {
            HeaderCardParser.getLogger().log(Level.WARNING, "Multiple occurrences of key:" + dup.getKey());
            this.dupKeys.add(dup.getKey());
        }
        this.duplicates.add(dup);
    }

    private void cardCheck(Cursor<String, HeaderCard> iter, IFitsHeader key) throws FitsException {
        this.cardCheck(iter, key.key());
    }

    private void cardCheck(Cursor<String, HeaderCard> iter, String key) throws FitsException {
        if (!iter.hasNext()) {
            throw new FitsException("Header terminates before " + key);
        }
        HeaderCard card = (HeaderCard)iter.next();
        if (!card.getKey().equals(key)) {
            throw new FitsException("Key " + key + " not found where expected.Found " + card.getKey());
        }
    }

    private void checkFirstCard(String key) throws FitsException {
        if (!Standard.SIMPLE.key().equals(key) && !Standard.XTENSION.key().equals(key)) {
            throw new FitsException("Not a proper FITS header: " + HeaderCard.sanitize(key) + " at " + this.fileOffset);
        }
    }

    private void doCardChecks(Cursor<String, HeaderCard> iter, boolean isTable, boolean isExtension) throws FitsException {
        this.cardCheck(iter, Standard.BITPIX);
        this.cardCheck(iter, Standard.NAXIS);
        int nax = this.getIntValue(Standard.NAXIS);
        int i = 1;
        while (i <= nax) {
            this.cardCheck(iter, Standard.NAXISn.n(i++));
        }
        if (isExtension) {
            this.cardCheck(iter, Standard.PCOUNT);
            this.cardCheck(iter, Standard.GCOUNT);
            if (isTable) {
                this.cardCheck(iter, Standard.TFIELDS);
            }
        }
    }

    private void checkBeginning() throws FitsException {
        Cursor<String, HeaderCard> iter = this.iterator();
        if (!iter.hasNext()) {
            throw new FitsException("Empty Header");
        }
        HeaderCard card = (HeaderCard)iter.next();
        String key = card.getKey();
        if (!key.equals(Standard.SIMPLE.key()) && !key.equals(Standard.XTENSION.key())) {
            throw new FitsException("No SIMPLE or XTENSION at beginning of Header");
        }
        boolean isTable = false;
        boolean isExtension = false;
        if (key.equals(Standard.XTENSION.key())) {
            String value = card.getValue();
            if (value == null || value.isEmpty()) {
                throw new FitsException("Empty XTENSION keyword");
            }
            isExtension = true;
            if (value.equals("BINTABLE") || value.equals("A3DTABLE") || value.equals("TABLE")) {
                isTable = true;
            }
        }
        this.doCardChecks(iter, isTable, isExtension);
        Bitpix.fromHeader(this, false);
    }

    private void checkEnd() {
        Cursor<String, HeaderCard> iter = this.iterator();
        while (iter.hasNext()) {
            HeaderCard card = (HeaderCard)iter.next();
            if (card.isKeyValuePair() || !card.getKey().equals(Standard.END.key())) continue;
            iter.remove();
        }
        iter.add(HeaderCard.createCommentStyleCard(Standard.END.key(), null));
    }

    private boolean isValidHeader() {
        if (this.getNumberOfCards() < 4) {
            return false;
        }
        Cursor<String, HeaderCard> iter = this.iterator();
        String key = ((HeaderCard)iter.next()).getKey();
        if (!key.equals(Standard.SIMPLE.key()) && !key.equals(Standard.XTENSION.key())) {
            return false;
        }
        key = ((HeaderCard)iter.next()).getKey();
        if (!key.equals(Standard.BITPIX.key())) {
            return false;
        }
        key = ((HeaderCard)iter.next()).getKey();
        if (!key.equals(Standard.NAXIS.key())) {
            return false;
        }
        while (iter.hasNext()) {
            key = ((HeaderCard)iter.next()).getKey();
        }
        return key.equals(Standard.END.key());
    }

    @Deprecated
    void nullImage() {
        Cursor<String, HeaderCard> iter = this.iterator();
        iter.add(HeaderCard.create((IFitsHeader)Standard.SIMPLE, true));
        iter.add(Bitpix.BYTE.getHeaderCard());
        iter.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, 0));
        iter.add(HeaderCard.create((IFitsHeader)Standard.EXTEND, true));
    }

    Cursor<String, HeaderCard> positionAfterIndex(IFitsHeader prefix, int col) {
        String colnum = String.valueOf(col);
        this.cursor().setKey(prefix.n(col).key());
        if (this.cursor().hasNext()) {
            boolean toFar = false;
            while (this.cursor().hasNext()) {
                String key = ((HeaderCard)this.cursor().next()).getKey().trim();
                if (key.length() > colnum.length() && key.substring(key.length() - colnum.length()).equals(colnum)) continue;
                toFar = true;
                break;
            }
            if (toFar) {
                this.cursor().prev();
            }
        }
        return this.cursor();
    }

    boolean replaceKey(IFitsHeader oldKey, IFitsHeader newKey) throws HeaderCardException {
        if (oldKey.valueType() == IFitsHeader.VALUE.NONE) {
            throw new IllegalArgumentException("cannot replace comment-style " + oldKey.key());
        }
        HeaderCard card = this.getCard(oldKey);
        IFitsHeader.VALUE newType = newKey.valueType();
        if (card != null && oldKey.valueType() != newType && newType != IFitsHeader.VALUE.ANY) {
            Class<?> type = card.valueType();
            IllegalArgumentException e = null;
            if (newType == IFitsHeader.VALUE.NONE) {
                e = new IllegalArgumentException("comment-style " + newKey.key() + " cannot replace valued key " + oldKey.key());
            } else if (Boolean.class.isAssignableFrom(type) && newType != IFitsHeader.VALUE.LOGICAL) {
                e = new IllegalArgumentException(newKey.key() + " cannot not support the existing boolean value.");
            } else if (String.class.isAssignableFrom(type) && newType != IFitsHeader.VALUE.STRING) {
                e = new IllegalArgumentException(newKey.key() + " cannot not support the existing string value.");
            } else if (ComplexValue.class.isAssignableFrom(type) && newType != IFitsHeader.VALUE.COMPLEX) {
                e = new IllegalArgumentException(newKey.key() + " cannot not support the existing complex value.");
            } else if (card.isDecimalType() && newType != IFitsHeader.VALUE.REAL && newType != IFitsHeader.VALUE.COMPLEX) {
                e = new IllegalArgumentException(newKey.key() + " cannot not support the existing decimal values.");
            } else if (Number.class.isAssignableFrom(type) && newType != IFitsHeader.VALUE.REAL && newType != IFitsHeader.VALUE.INTEGER && newType != IFitsHeader.VALUE.COMPLEX) {
                e = new IllegalArgumentException(newKey.key() + " cannot not support the existing numerical value.");
            }
            if (e != null) {
                LOG.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return this.replaceKey(oldKey.key(), newKey.key());
    }

    boolean replaceKey(String oldKey, String newKey) throws HeaderCardException {
        HeaderCard oldCard = this.getCard(oldKey);
        if (oldCard == null) {
            return false;
        }
        if (!this.cards.replaceKey(oldKey, newKey)) {
            throw new HeaderCardException("Duplicate key [" + newKey + "] in replace");
        }
        try {
            oldCard.changeKey(newKey);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderCardException("New key [" + newKey + "] is invalid or too long for existing value.", e);
        }
        return true;
    }

    private long trueDataSize() {
        if (!this.containsKey(Standard.BITPIX.key()) || !this.containsKey(Standard.NAXIS.key())) {
            return 0L;
        }
        int naxis = this.getIntValue(Standard.NAXIS, 0);
        if (naxis == 0) {
            return 0L;
        }
        int[] axes = new int[naxis];
        for (int axis = 1; axis <= naxis; ++axis) {
            axes[axis - 1] = this.getIntValue(Standard.NAXISn.n(axis), 0);
        }
        boolean isGroup = this.getBooleanValue(Standard.GROUPS, false);
        int pcount = this.getIntValue(Standard.PCOUNT, 0);
        int gcount = this.getIntValue(Standard.GCOUNT, 1);
        int startAxis = 0;
        if (isGroup && naxis > 1 && axes[0] == 0) {
            startAxis = 1;
        }
        long size = 1L;
        for (int i = startAxis; i < naxis; ++i) {
            size *= (long)axes[i];
        }
        size += (long)pcount;
        size *= (long)gcount;
        return size *= (long)(Math.abs(this.getIntValue(Standard.BITPIX, 0)) / 8);
    }

    public static void setParserWarningsEnabled(boolean value) {
        Level level = value ? Level.WARNING : Level.SEVERE;
        HeaderCardParser.getLogger().setLevel(level);
        Logger.getLogger(ComplexValue.class.getName()).setLevel(level);
    }

    public static boolean isParserWarningsEnabled() {
        return !HeaderCardParser.getLogger().getLevel().equals(Level.SEVERE);
    }

    public static int getCommentAlignPosition() {
        return commentAlign;
    }

    public static void setCommentAlignPosition(int pos) throws IllegalArgumentException {
        if (pos < 20 || pos > 70) {
            throw new IllegalArgumentException("Comment alignment " + pos + " out of range (" + 20 + ":" + 70 + ").");
        }
        commentAlign = pos;
    }

    static {
        defaultKeyCheck = DEFAULT_KEYWORD_CHECK_POLICY = KeywordCheck.DATA_TYPE;
    }

    public static enum KeywordCheck {
        NONE,
        DATA_TYPE,
        STRICT;

    }
}

