/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Logger;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCardCountingArrayDataInput;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderCardFormatter;
import nom.tam.fits.HeaderCardParser;
import nom.tam.fits.HierarchNotEnabledException;
import nom.tam.fits.LongStringsNotEnabledException;
import nom.tam.fits.LongValueException;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.UnclosedQuoteException;
import nom.tam.fits.ValueTypeException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.NonStandard;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.ComplexValue;
import nom.tam.util.CursorValue;
import nom.tam.util.FitsInputStream;
import nom.tam.util.FlexFormat;
import nom.tam.util.InputReader;

public class HeaderCard
implements CursorValue<String>,
Cloneable {
    private static final Logger LOG = Logger.getLogger(HeaderCard.class.getName());
    public static final int FITS_HEADER_CARD_SIZE = 80;
    public static final int MAX_KEYWORD_LENGTH = 8;
    public static final int STRING_QUOTES_LENGTH = 2;
    public static final int MAX_VALUE_LENGTH = 70;
    public static final int MAX_COMMENT_CARD_COMMENT_LENGTH = 71;
    public static final int MAX_STRING_VALUE_LENGTH = 68;
    public static final int MAX_LONG_STRING_VALUE_LENGTH = 67;
    public static final int MAX_LONG_STRING_VALUE_WITH_COMMENT_LENGTH = 65;
    public static final int MAX_HIERARCH_KEYWORD_LENGTH = 74;
    public static final int MAX_LONG_STRING_CONTINUE_OVERHEAD = 3;
    public static final char MIN_VALID_CHAR = ' ';
    public static final char MAX_VALID_CHAR = '~';
    public static final String EMPTY_KEY = "";
    private static final String HIERARCH_WITH_DOT = NonStandard.HIERARCH.key() + ".";
    private String key;
    private String value;
    private String comment;
    private IFitsHeader standardKey;
    private Class<?> type;
    public static final ValueCheck DEFAULT_VALUE_CHECK_POLICY;
    private static ValueCheck valueCheck;

    private HeaderCard() {
    }

    public HeaderCard(ArrayDataInput dis) throws UnclosedQuoteException, TruncatedFileException, IOException {
        this(new HeaderCardCountingArrayDataInput(dis));
    }

    @Deprecated
    public HeaderCard(HeaderCardCountingArrayDataInput dis) throws UnclosedQuoteException, TruncatedFileException, IOException {
        this();
        this.key = null;
        this.value = null;
        this.comment = null;
        this.type = null;
        String card = HeaderCard.readOneHeaderLine(dis);
        HeaderCardParser parsed = new HeaderCardParser(card);
        this.key = parsed.getKey();
        this.type = parsed.getInferredType();
        if (FitsFactory.isLongStringsEnabled() && parsed.isString() && parsed.getValue().endsWith("&")) {
            this.parseLongStringCard(dis, parsed);
        } else {
            this.value = parsed.getValue();
            this.type = parsed.getInferredType();
            this.comment = parsed.getTrimmedComment();
        }
    }

    public HeaderCard(String key, Number value) throws HeaderCardException {
        this(key, value, -1, null);
    }

    public HeaderCard(String key, Number value, String comment) throws HeaderCardException {
        this(key, value, -1, comment);
    }

    public HeaderCard(String key, Number value, int decimals, String comment) throws HeaderCardException {
        if (value == null) {
            this.set(key, null, comment, Integer.class);
            return;
        }
        try {
            HeaderCard.checkNumber(value);
        }
        catch (NumberFormatException e) {
            throw new HeaderCardException("FITS headers may not contain NaN or Infinite values", e);
        }
        this.set(key, new FlexFormat().setWidth(HeaderCard.spaceForValue(key)).setPrecision(decimals).format(value), comment, value.getClass());
    }

    public HeaderCard(String key, Boolean value) throws HeaderCardException {
        this(key, value, null);
    }

    public HeaderCard(String key, Boolean value, String comment) throws HeaderCardException {
        this(key, value == null ? null : (value != false ? "T" : "F"), comment, Boolean.class);
    }

    public HeaderCard(String key, ComplexValue value) throws HeaderCardException {
        this(key, value, null);
    }

    public HeaderCard(String key, ComplexValue value, String comment) throws HeaderCardException {
        this();
        if (value == null) {
            this.set(key, null, comment, ComplexValue.class);
            return;
        }
        if (!value.isFinite()) {
            throw new HeaderCardException("Cannot represent " + value + " in FITS headers.");
        }
        this.set(key, value.toBoundedString(HeaderCard.spaceForValue(key)), comment, ComplexValue.class);
    }

    public HeaderCard(String key, ComplexValue value, int decimals, String comment) throws HeaderCardException {
        this();
        if (value == null) {
            this.set(key, null, comment, ComplexValue.class);
            return;
        }
        if (!value.isFinite()) {
            throw new HeaderCardException("Cannot represent " + value + " in FITS headers.");
        }
        this.set(key, value.toString(decimals), comment, ComplexValue.class);
    }

    @Deprecated
    public HeaderCard(String key, String comment, boolean withNullValue) throws HeaderCardException {
        this(key, null, comment, withNullValue);
    }

    @Deprecated
    public HeaderCard(String key, String value, String comment, boolean nullable) throws HeaderCardException {
        this(key, value, comment, nullable || value != null ? String.class : null);
    }

    public HeaderCard(String key, String value) throws HeaderCardException {
        this(key, value, null, String.class);
    }

    public HeaderCard(String key, String value, String comment) throws HeaderCardException {
        this(key, value, comment, String.class);
    }

    private HeaderCard(String key, String value, String comment, Class<?> type) throws HeaderCardException {
        this.set(key, value, comment, type);
        this.type = type;
    }

    private synchronized void set(String aKey, String aValue, String aComment, Class<?> aType) throws HeaderCardException {
        this.type = aType;
        if (aKey == null || aKey.trim().isEmpty()) {
            aKey = EMPTY_KEY;
        }
        if (aKey.isEmpty() && aValue != null) {
            throw new HeaderCardException("Blank or null key for value: [" + HeaderCard.sanitize(aValue) + "]");
        }
        try {
            HeaderCard.validateKey(aKey);
        }
        catch (RuntimeException e) {
            throw new HeaderCardException("Invalid FITS keyword: [" + HeaderCard.sanitize(aKey) + "]", e);
        }
        this.key = aKey;
        try {
            HeaderCard.validateChars(aComment);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderCardException("Invalid FITS comment: [" + HeaderCard.sanitize(aComment) + "]", e);
        }
        this.comment = aComment;
        try {
            HeaderCard.validateChars(aValue);
        }
        catch (IllegalArgumentException e) {
            throw new HeaderCardException("Invalid FITS value: [" + HeaderCard.sanitize(aValue) + "]", e);
        }
        if (aValue == null) {
            this.value = null;
            return;
        }
        if (this.isStringValue()) {
            aValue = this.trimEnd(aValue);
            String printValue = aValue.replace("'", "''");
            if (!FitsFactory.isLongStringsEnabled() && printValue.length() + 2 > this.spaceForValue()) {
                throw new HeaderCardException("value too long: [" + HeaderCard.sanitize(aValue) + "]", new LongStringsNotEnabledException(this.key));
            }
        } else if ((aValue = aValue.trim()).length() > this.spaceForValue()) {
            throw new HeaderCardException("Value too long: [" + HeaderCard.sanitize(aValue) + "]", new LongValueException(this.key, this.spaceForValue()));
        }
        this.value = aValue;
    }

    protected HeaderCard clone() {
        try {
            return (HeaderCard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public synchronized int cardSize() {
        if (FitsFactory.isLongStringsEnabled() && this.isStringValue() && this.value != null) {
            return this.toString().length() / 80;
        }
        return 1;
    }

    public HeaderCard copy() {
        HeaderCard copy = this.clone();
        return copy;
    }

    @Override
    public final synchronized String getKey() {
        return this.key;
    }

    public final synchronized String getValue() {
        return this.value;
    }

    public final synchronized String getComment() {
        return this.comment;
    }

    @Deprecated
    public final synchronized long getHexValue() throws NumberFormatException {
        if (this.value == null) {
            throw new NumberFormatException("Card has a null value");
        }
        return Long.decode("0x" + this.value);
    }

    public synchronized <T> T getValue(Class<T> asType, T defaultValue) throws IllegalArgumentException {
        if (this.value == null) {
            return defaultValue;
        }
        if (String.class.isAssignableFrom(asType)) {
            return asType.cast(this.value);
        }
        if (this.value.isEmpty()) {
            return defaultValue;
        }
        if (Boolean.class.isAssignableFrom(asType)) {
            return asType.cast(this.getBooleanValue((Boolean)defaultValue));
        }
        if (ComplexValue.class.isAssignableFrom(asType)) {
            return asType.cast(new ComplexValue(this.value));
        }
        if (Number.class.isAssignableFrom(asType)) {
            try {
                BigDecimal big = new BigDecimal(this.value.toUpperCase().replace('D', 'E'));
                if (Byte.class.isAssignableFrom(asType)) {
                    return asType.cast(big.byteValue());
                }
                if (Short.class.isAssignableFrom(asType)) {
                    return asType.cast(big.shortValue());
                }
                if (Integer.class.isAssignableFrom(asType)) {
                    return asType.cast(big.intValue());
                }
                if (Long.class.isAssignableFrom(asType)) {
                    return asType.cast(big.longValue());
                }
                if (Float.class.isAssignableFrom(asType)) {
                    return asType.cast(Float.valueOf(big.floatValue()));
                }
                if (Double.class.isAssignableFrom(asType)) {
                    return asType.cast(big.doubleValue());
                }
                if (BigInteger.class.isAssignableFrom(asType)) {
                    return asType.cast(big.toBigInteger());
                }
                return asType.cast(big);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        throw new IllegalArgumentException("unsupported class " + asType);
    }

    public synchronized boolean isKeyValuePair() {
        return !this.isCommentStyleCard() && !this.key.isEmpty() && this.value != null;
    }

    public synchronized boolean isStringValue() {
        if (this.type == null) {
            return false;
        }
        return String.class.isAssignableFrom(this.type);
    }

    public synchronized boolean isDecimalType() {
        if (this.type == null) {
            return false;
        }
        return Float.class.isAssignableFrom(this.type) || Double.class.isAssignableFrom(this.type) || BigDecimal.class.isAssignableFrom(this.type);
    }

    public synchronized boolean isIntegerType() {
        if (this.type == null) {
            return false;
        }
        return Number.class.isAssignableFrom(this.type) && !this.isDecimalType();
    }

    public final synchronized boolean isCommentStyleCard() {
        return this.type == null;
    }

    public final synchronized boolean hasHierarchKey() {
        return HeaderCard.isHierarchKey(this.key);
    }

    public synchronized void setComment(String comment) {
        this.comment = HeaderCard.sanitize(comment);
    }

    public final HeaderCard setValue(Number update) throws NumberFormatException, LongValueException {
        return this.setValue(update, -1);
    }

    public synchronized HeaderCard setValue(Number update, int decimals) throws NumberFormatException, LongValueException {
        if (update instanceof Float || update instanceof Double || update instanceof BigDecimal || update instanceof BigInteger) {
            this.checkValueType(IFitsHeader.VALUE.REAL);
        } else {
            this.checkValueType(IFitsHeader.VALUE.INTEGER);
        }
        if (update == null) {
            this.value = null;
            this.type = Integer.class;
        } else {
            this.type = update.getClass();
            HeaderCard.checkNumber(update);
            this.setUnquotedValue(new FlexFormat().forCard(this).setPrecision(decimals).format(update));
        }
        return this;
    }

    private static void checkKeyword(IFitsHeader keyword) throws IllegalArgumentException {
        if (keyword.key().contains("n")) {
            throw new IllegalArgumentException("Keyword " + keyword.key() + " has unfilled index(es)");
        }
    }

    private void checkValueType(IFitsHeader.VALUE valueType) throws ValueTypeException {
        if (this.standardKey != null) {
            HeaderCard.checkValueType(this.key, this.standardKey.valueType(), valueType);
        }
    }

    private static void checkValueType(String key, IFitsHeader.VALUE expect, IFitsHeader.VALUE valueType) throws ValueTypeException {
        if (expect == IFitsHeader.VALUE.ANY || valueCheck == ValueCheck.NONE) {
            return;
        }
        if (valueType != expect) {
            if (expect == IFitsHeader.VALUE.REAL && valueType == IFitsHeader.VALUE.INTEGER) {
                return;
            }
            ValueTypeException e = new ValueTypeException(key, valueType.name());
            if (valueCheck == ValueCheck.LOGGING) {
                LOG.warning(e.getMessage());
            } else {
                throw e;
            }
        }
    }

    public synchronized HeaderCard setValue(Boolean update) throws LongValueException, ValueTypeException {
        this.checkValueType(IFitsHeader.VALUE.LOGICAL);
        if (update == null) {
            this.value = null;
        } else {
            if (this.spaceForValue() < 1) {
                throw new LongValueException(this.key, this.spaceForValue());
            }
            this.value = update != false ? "T" : "F";
        }
        this.type = Boolean.class;
        return this;
    }

    public final HeaderCard setValue(ComplexValue update) throws NumberFormatException, LongValueException {
        return this.setValue(update, -1);
    }

    public synchronized HeaderCard setValue(ComplexValue update, int decimals) throws LongValueException {
        this.checkValueType(IFitsHeader.VALUE.COMPLEX);
        if (update == null) {
            this.value = null;
        } else {
            if (!update.isFinite()) {
                throw new NumberFormatException("Cannot represent " + update + " in FITS headers.");
            }
            this.setUnquotedValue(update.toString(decimals));
        }
        this.type = ComplexValue.class;
        return this;
    }

    private synchronized void setUnquotedValue(String update) throws LongValueException {
        if (update.length() > this.spaceForValue()) {
            throw new LongValueException(this.spaceForValue(), this.key, this.value);
        }
        this.value = update;
    }

    @Deprecated
    public synchronized HeaderCard setHexValue(long update) throws LongValueException {
        this.setUnquotedValue(Long.toHexString(update));
        this.type = update == (long)((int)update) ? Integer.class : Long.class;
        return this;
    }

    public synchronized HeaderCard setValue(String update) throws IllegalArgumentException, LongStringsNotEnabledException {
        this.checkValueType(IFitsHeader.VALUE.STRING);
        if (update == null) {
            this.value = null;
        } else {
            HeaderCard.validateChars(update);
            int l = 2 + update.length();
            if (!FitsFactory.isLongStringsEnabled() && l > HeaderCard.spaceForValue(this.key)) {
                throw new LongStringsNotEnabledException("New string value for [" + this.key + "] is too long.\n\n --> You can enable long string support by FitsFactory.setLongStringEnabled(true).\n");
            }
            this.value = this.trimEnd(update);
        }
        this.type = String.class;
        return this;
    }

    public String toString() throws LongValueException, LongStringsNotEnabledException, HierarchNotEnabledException {
        return this.toString(FitsFactory.current());
    }

    protected synchronized String toString(FitsFactory.FitsSettings settings) throws LongValueException, LongStringsNotEnabledException, HierarchNotEnabledException {
        return new HeaderCardFormatter(settings).toString(this);
    }

    public synchronized Class<?> valueType() {
        return this.type;
    }

    private Boolean getBooleanValue(Boolean defaultValue) {
        if ("T".equals(this.value)) {
            return true;
        }
        if ("F".equals(this.value)) {
            return false;
        }
        return defaultValue;
    }

    private synchronized void parseLongStringCard(HeaderCardCountingArrayDataInput dis, HeaderCardParser next) throws IOException, TruncatedFileException {
        StringBuilder longValue = new StringBuilder();
        StringBuilder longComment = null;
        while (next != null && next.isString()) {
            String valuePart = next.getValue();
            String untrimmedComment = next.getUntrimmedComment();
            if (valuePart == null) break;
            int valueEnd = valuePart.length();
            if (!dis.markSupported()) {
                throw new IOException("InputStream does not support mark/reset");
            }
            dis.mark();
            try {
                next = new HeaderCardParser(HeaderCard.readOneHeaderLine(dis));
                if (valuePart.endsWith("&") && Standard.CONTINUE.key().equals(next.getKey())) {
                    --valueEnd;
                } else {
                    dis.reset();
                    next = null;
                }
            }
            catch (EOFException e) {
                next = null;
            }
            longValue.append(valuePart, 0, valueEnd);
            if (untrimmedComment == null) continue;
            if (longComment == null) {
                longComment = new StringBuilder(untrimmedComment);
                continue;
            }
            longComment.append(untrimmedComment);
        }
        this.comment = longComment == null ? null : longComment.toString().trim();
        this.value = this.trimEnd(longValue.toString());
        this.type = String.class;
    }

    private String trimEnd(String s) {
        int end;
        for (end = s.length(); end > 0 && Character.isSpaceChar(s.charAt(end - 1)); --end) {
        }
        return end == s.length() ? s : s.substring(0, end);
    }

    private synchronized int getHeaderValueSize() {
        int n;
        if (this.isStringValue() && FitsFactory.isLongStringsEnabled()) {
            return Integer.MAX_VALUE;
        }
        int n2 = n = this.isStringValue() ? 2 : 0;
        if (this.value == null) {
            return n;
        }
        n += this.value.length();
        int i = this.value.length();
        while (--i >= 0) {
            if (this.value.charAt(i) != '\'') continue;
            ++n;
        }
        return n;
    }

    public final synchronized int spaceForValue() {
        return HeaderCard.spaceForValue(this.key);
    }

    public synchronized void changeKey(String newKey) throws HierarchNotEnabledException, LongValueException, LongStringsNotEnabledException, IllegalArgumentException {
        HeaderCard.validateKey(newKey);
        if (this.getHeaderValueSize() > HeaderCard.spaceForValue(newKey)) {
            if (!this.isStringValue()) {
                throw new LongValueException(HeaderCard.spaceForValue(newKey), newKey + "= " + this.value);
            }
            if (!FitsFactory.isLongStringsEnabled()) {
                throw new LongStringsNotEnabledException(newKey);
            }
        }
        this.key = newKey;
        this.standardKey = null;
    }

    public synchronized boolean isBlank() {
        if (!this.isCommentStyleCard() || !this.key.isEmpty()) {
            return false;
        }
        if (this.comment == null) {
            return true;
        }
        return this.comment.isEmpty();
    }

    public static ValueCheck getValueCheckingPolicy() {
        return valueCheck;
    }

    public static void setValueCheckingPolicy(ValueCheck policy) {
        valueCheck = policy;
    }

    public static HeaderCard create(String line) throws IllegalArgumentException {
        HeaderCard headerCard;
        block8: {
            ArrayDataInput in = HeaderCard.stringToArrayInputStream(line);
            try {
                headerCard = new HeaderCard(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("card not legal", e);
                }
            }
            in.close();
        }
        return headerCard;
    }

    final IFitsHeader getStandardKey() {
        return this.standardKey;
    }

    public static HeaderCard create(IFitsHeader key, Boolean value) throws IllegalArgumentException {
        HeaderCard.checkKeyword(key);
        try {
            HeaderCard hc = new HeaderCard(key.key(), (Boolean)null, key.comment());
            hc.standardKey = key;
            hc.setValue(value);
            return hc;
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static HeaderCard create(IFitsHeader key, Number value) throws IllegalArgumentException {
        HeaderCard.checkKeyword(key);
        try {
            HeaderCard hc = new HeaderCard(key.key(), (Number)null, key.comment());
            hc.standardKey = key;
            hc.setValue(value);
            return hc;
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static HeaderCard create(IFitsHeader key, ComplexValue value) throws IllegalArgumentException {
        HeaderCard.checkKeyword(key);
        try {
            HeaderCard hc = new HeaderCard(key.key(), (ComplexValue)null, key.comment());
            hc.standardKey = key;
            hc.setValue(value);
            return hc;
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static HeaderCard create(IFitsHeader key, String value) throws IllegalArgumentException {
        HeaderCard.checkKeyword(key);
        HeaderCard.validateChars(value);
        try {
            HeaderCard hc = new HeaderCard(key.key(), (String)null, key.comment());
            hc.standardKey = key;
            hc.setValue(value);
            return hc;
        }
        catch (HeaderCardException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static HeaderCard createCommentStyleCard(String key, String comment) throws HeaderCardException, LongValueException {
        if (comment == null) {
            comment = EMPTY_KEY;
        } else if (comment.length() > 71) {
            throw new LongValueException(71, key, comment);
        }
        HeaderCard card = new HeaderCard();
        card.set(key, null, comment, null);
        return card;
    }

    public static HeaderCard createUnkeyedCommentCard(String text) throws HeaderCardException, LongValueException {
        return HeaderCard.createCommentStyleCard(Standard.BLANKS.key(), text);
    }

    public static HeaderCard createCommentCard(String text) throws HeaderCardException, LongValueException {
        return HeaderCard.createCommentStyleCard(Standard.COMMENT.key(), text);
    }

    public static HeaderCard createHistoryCard(String text) throws HeaderCardException, LongValueException {
        return HeaderCard.createCommentStyleCard(Standard.HISTORY.key(), text);
    }

    @Deprecated
    public static HeaderCard createHexValueCard(String key, long value) throws HeaderCardException {
        return HeaderCard.createHexValueCard(key, value, null);
    }

    @Deprecated
    public static HeaderCard createHexValueCard(String key, long value, String comment) throws HeaderCardException {
        return new HeaderCard(key, Long.toHexString(value), comment, Long.class);
    }

    private static String readRecord(InputReader in) throws IOException, TruncatedFileException {
        int got;
        byte[] buffer = new byte[80];
        try {
            int n;
            for (got = 0; got < buffer.length && (n = in.read(buffer, got, buffer.length - got)) >= 0; got += n) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (got == 0) {
            throw new EOFException();
        }
        if (got < buffer.length) {
            throw new TruncatedFileException("Got only " + got + " of " + buffer.length + " bytes expected for a header card");
        }
        return AsciiFuncs.asciiString(buffer);
    }

    private static String readOneHeaderLine(HeaderCardCountingArrayDataInput dis) throws IOException, TruncatedFileException {
        String s = HeaderCard.readRecord(dis.in());
        dis.cardRead();
        return s;
    }

    private static int spaceForValue(String key) {
        if (key.length() > 8) {
            return 80 - (Math.max(key.length(), 8) + FitsFactory.getHierarchFormater().getExtraSpaceRequired(key));
        }
        return 80 - (Math.max(key.length(), 8) + HeaderCardFormatter.getAssignLength());
    }

    private static ArrayDataInput stringToArrayInputStream(String card) {
        byte[] bytes = AsciiFuncs.getBytes(card);
        if (bytes.length % 80 != 0) {
            byte[] newBytes = new byte[bytes.length + 80 - bytes.length % 80];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            Arrays.fill(newBytes, bytes.length, newBytes.length, (byte)32);
            bytes = newBytes;
        }
        return new FitsInputStream(new ByteArrayInputStream(bytes));
    }

    @Deprecated
    public static HeaderCard saveNewHeaderCard(String key, String comment, boolean hasValue) throws HeaderCardException {
        return new HeaderCard(key, null, comment, hasValue ? String.class : null);
    }

    private static boolean isHierarchKey(String key) {
        return key.toUpperCase().startsWith(HIERARCH_WITH_DOT);
    }

    public static String sanitize(String str) {
        int nc = str.length();
        char[] cbuf = new char[nc];
        for (int ic = 0; ic < nc; ++ic) {
            int c = str.charAt(ic);
            cbuf[ic] = HeaderCard.isValidChar((char)c) ? c : 63;
        }
        return new String(cbuf);
    }

    public static boolean isValidChar(char c) {
        return c >= ' ' && c <= '~';
    }

    public static void validateChars(String text) throws IllegalArgumentException {
        if (text == null) {
            return;
        }
        int i = text.length();
        while (--i >= 0) {
            char c = text.charAt(i);
            if (c < ' ') {
                throw new IllegalArgumentException("Non-printable character(s), e.g. 0x" + c + ", in [" + HeaderCard.sanitize(text) + "].");
            }
            if (c <= '~') continue;
            throw new IllegalArgumentException("Extendeed ASCII character(s) in [" + HeaderCard.sanitize(text) + "]. Only 0x20 through 0x7E are allowed.");
        }
    }

    public static void validateKey(String key) throws IllegalArgumentException {
        char c;
        int maxLength = 8;
        if (HeaderCard.isHierarchKey(key)) {
            if (!FitsFactory.getUseHierarch()) {
                throw new HierarchNotEnabledException(key);
            }
            maxLength = 74;
            HeaderCard.validateHierarchComponents(key);
        }
        if (key.length() > maxLength) {
            throw new IllegalArgumentException("Keyword is too long: [" + HeaderCard.sanitize(key) + "]");
        }
        int i = key.length();
        while (--i >= 0) {
            c = key.charAt(i);
            if (c < ' ') {
                throw new IllegalArgumentException("Keyword contains non-printable character 0x" + c + ": [" + HeaderCard.sanitize(key) + "].");
            }
            if (c <= '~') continue;
            throw new IllegalArgumentException("Keyword contains extendeed ASCII characters: [" + HeaderCard.sanitize(key) + "]. Only 0x20 through 0x7E are allowed.");
        }
        i = Math.min(8, key.length());
        while (--i >= 0) {
            c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            throw new IllegalArgumentException("Keyword [" + HeaderCard.sanitize(key) + "] contains invalid characters. Only [A-Z][a-z][0-9][-][_] are allowed.");
        }
    }

    private static void validateHierarchComponents(String key) throws IllegalArgumentException {
        int i = key.length();
        while (--i >= 0) {
            if (!Character.isSpaceChar(key.charAt(i))) continue;
            throw new IllegalArgumentException("No spaces allowed in HIERARCH keywords used internally: [" + HeaderCard.sanitize(key) + "].");
        }
        if (key.indexOf("..") >= 0) {
            throw new IllegalArgumentException("HIERARCH keywords with empty component: [" + HeaderCard.sanitize(key) + "].");
        }
    }

    private static void checkNumber(Number value) throws NumberFormatException {
        if (value instanceof Double ? !Double.isFinite(value.doubleValue()) : value instanceof Float && !Float.isFinite(value.floatValue())) {
            throw new NumberFormatException("Cannot represent " + value + " in FITS headers.");
        }
    }

    static {
        valueCheck = DEFAULT_VALUE_CHECK_POLICY = ValueCheck.EXCEPTION;
    }

    public static enum ValueCheck {
        NONE,
        LOGGING,
        EXCEPTION;

    }
}

