/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HierarchNotEnabledException;
import nom.tam.fits.LongStringsNotEnabledException;
import nom.tam.fits.LongValueException;
import nom.tam.fits.header.Standard;

class HeaderCardFormatter {
    private FitsFactory.FitsSettings settings;
    private static final int QUOTES_LENGTH = 2;
    private static final String COMMENT_PREFIX = " / ";
    private static final String LONG_COMMENT_PREFIX = " /";
    private static final int MIN_STRING_END = 19;
    private static final int MAX_LONG_END_COMMENT = 68 - " /".length();

    HeaderCardFormatter(FitsFactory.FitsSettings settings) {
        this.settings = settings;
    }

    String toString(HeaderCard card) throws HierarchNotEnabledException, LongValueException, LongStringsNotEnabledException {
        StringBuffer buf = new StringBuffer(80);
        this.appendKey(buf, card);
        int valueStart = this.appendValue(buf, card);
        int valueEnd = buf.length();
        this.appendComment(buf, card);
        if (!card.isCommentStyleCard()) {
            this.realign(buf, card.isStringValue() ? valueEnd : valueStart, valueEnd);
        }
        this.pad(buf);
        return HeaderCard.sanitize(new String(buf));
    }

    private void appendKey(StringBuffer buf, HeaderCard card) throws HierarchNotEnabledException, LongValueException {
        String key = card.getKey();
        if (card.hasHierarchKey()) {
            if (!this.settings.isUseHierarch()) {
                throw new HierarchNotEnabledException(key);
            }
            key = this.settings.getHierarchKeyFormatter().toHeaderString(key);
            if (key.length() > 74) {
                throw new LongValueException(key, 74);
            }
        } else {
            key = key.toUpperCase();
        }
        buf.append(key);
        this.padTo(buf, 8);
    }

    private int appendValue(StringBuffer buf, HeaderCard card) throws LongValueException, LongStringsNotEnabledException {
        String value = card.getValue();
        if (card.isCommentStyleCard()) {
            return buf.length();
        }
        buf.append(HeaderCardFormatter.getAssignString());
        if (value == null) {
            return buf.length();
        }
        int valueStart = buf.length();
        if (card.isStringValue()) {
            for (int from = this.appendQuotedValue(buf, card, 0); from < value.length(); from += this.appendQuotedValue(buf, card, from)) {
                this.pad(buf);
                buf.append(Standard.CONTINUE.key() + "  ");
            }
        } else {
            this.append(buf, value, 0);
        }
        return valueStart;
    }

    private int getMinTruncatedCommentSize(HeaderCard card) {
        String comment = card.getComment();
        int firstWordLength = comment.indexOf(32);
        if (firstWordLength < 0) {
            firstWordLength = comment.length();
        }
        return COMMENT_PREFIX.length() + firstWordLength;
    }

    private boolean appendComment(StringBuffer buf, HeaderCard card) {
        boolean longCommentOK;
        String comment = card.getComment();
        if (comment == null || comment.isEmpty()) {
            return true;
        }
        int available = this.getAvailable(buf);
        boolean bl = longCommentOK = FitsFactory.isLongStringsEnabled() && card.isStringValue();
        if (!card.isCommentStyleCard() && longCommentOK && COMMENT_PREFIX.length() + card.getComment().length() > available) {
            this.appendLongStringComment(buf, card);
            return true;
        }
        if (card.isCommentStyleCard()) {
            --available;
        } else if (this.getMinTruncatedCommentSize(card) > (available -= COMMENT_PREFIX.length()) && !longCommentOK) {
            return false;
        }
        if (card.isCommentStyleCard()) {
            buf.append(' ');
        } else {
            buf.append(COMMENT_PREFIX);
        }
        if (available >= comment.length()) {
            buf.append(comment);
            return true;
        }
        buf.append(comment.substring(0, available));
        return false;
    }

    private boolean realign(StringBuffer buf, int at, int from) {
        if (buf.length() >= 80 || from >= Header.getCommentAlignPosition()) {
            return false;
        }
        return this.realign(buf, at, from, Header.getCommentAlignPosition());
    }

    private boolean realign(StringBuffer buf, int at, int from, int to) {
        int spaces = to - from;
        if (spaces > this.getAvailable(buf)) {
            return false;
        }
        StringBuffer sBuf = new StringBuffer(spaces);
        while (--spaces >= 0) {
            sBuf.append(' ');
        }
        buf.insert(at, sBuf.toString());
        return true;
    }

    private void appendLongStringComment(StringBuffer buf, HeaderCard card) {
        int iLast = buf.length() - 1;
        String comment = card.getComment();
        if (this.getAvailable(buf) >= LONG_COMMENT_PREFIX.length() + comment.length()) {
            buf.append(LONG_COMMENT_PREFIX);
            this.append(buf, comment, 0);
            return;
        }
        buf.setCharAt(iLast, '&');
        buf.append("'");
        int from = 0;
        int available = this.getAvailable(buf);
        if (available < COMMENT_PREFIX.length()) {
            this.pad(buf);
            buf.append(Standard.CONTINUE.key() + "  ''");
            this.appendComment(buf, card);
            return;
        }
        buf.append(COMMENT_PREFIX);
        for (from = this.append(buf, comment, 0); from < comment.length(); from += this.append(buf, comment, from)) {
            this.pad(buf);
            buf.append(Standard.CONTINUE.key() + "  ");
            buf.append(comment.length() >= from + MAX_LONG_END_COMMENT ? "'&'" : "''");
            buf.append(LONG_COMMENT_PREFIX);
        }
    }

    private int append(StringBuffer buf, String text, int from) {
        int available = this.getAvailable(buf);
        int n = Math.min(available, text.length() - from);
        if (n < 1) {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            buf.append(text.charAt(from + i));
        }
        return n;
    }

    private int appendQuotedValue(StringBuffer buf, HeaderCard card, int from) {
        String escaped;
        String text;
        int available = this.getAvailable(buf) - 2;
        if (FitsFactory.isLongStringsEnabled() && card.getComment() != null && card.getComment().length() > 0) {
            --available;
        }
        if (available >= (text = card.getValue()).length() - from && (escaped = text.substring(from).replace("'", "''")).length() <= available) {
            buf.append('\'');
            buf.append(escaped);
            if (buf.length() < 19) {
                this.padTo(buf, 19);
            }
            buf.append('\'');
            return text.length() - from;
        }
        if (!FitsFactory.isLongStringsEnabled()) {
            throw new LongStringsNotEnabledException(card.getKey() + "= " + card.getValue());
        }
        available = this.getAvailable(buf) - 2 - 1;
        buf.append("'");
        int consumed = 0;
        int i = 0;
        while (i < available) {
            char c = text.charAt(from + consumed);
            if (c == '\'') {
                if (++i + 1 >= available) break;
                buf.append("''");
            } else {
                buf.append(c);
            }
            ++i;
            ++consumed;
        }
        buf.append("&'");
        return consumed;
    }

    private void pad(StringBuffer buf, int n) {
        int i = n;
        while (--i >= 0) {
            buf.append(' ');
        }
    }

    private void pad(StringBuffer buf) {
        this.pad(buf, this.getAvailable(buf));
    }

    private void padTo(StringBuffer buf, int to) {
        for (int pos = buf.length() % 80; pos < to; ++pos) {
            buf.append(' ');
        }
    }

    private int getAvailable(StringBuffer buf) {
        return (80 - buf.length() % 80) % 80;
    }

    static String getAssignString() {
        return FitsFactory.isSkipBlankAfterAssign() ? "=" : "= ";
    }

    static int getAssignLength() {
        int n = 1;
        if (!FitsFactory.isSkipBlankAfterAssign()) {
            ++n;
        }
        return n;
    }
}

