/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Hashtable;
import nom.tam.fits.header.Standard;

public class HeaderOrder
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = -5900038332559417655L;
    private static final String[] ORDER = new String[]{Standard.SIMPLE.key(), Standard.XTENSION.key(), Standard.BITPIX.key(), Standard.NAXIS.key(), Standard.PCOUNT.key(), Standard.GCOUNT.key(), Standard.EXTEND.key(), Standard.TFIELDS.key(), Standard.BLOCKED.key(), Standard.THEAP.key()};
    private static final int SPACING = 1000;
    private static final int UNORDERED = 1000 * ORDER.length;
    private static final int LAST = UNORDERED + 1000;
    private static final Hashtable<String, Integer> LOOKUP = new Hashtable();

    private static int indexOf(String key) {
        if (key == null) {
            return UNORDERED;
        }
        if (key.startsWith(Standard.NAXIS.key())) {
            if (Standard.NAXIS.key().length() == key.length()) {
                return LOOKUP.get(Standard.NAXIS.key());
            }
            try {
                int i = Integer.parseInt(key.substring(Standard.NAXIS.key().length()));
                if (i < 0 || i >= 1000) {
                    return UNORDERED;
                }
                return LOOKUP.get(Standard.NAXIS.key()) + i;
            }
            catch (NumberFormatException e) {
                return UNORDERED;
            }
        }
        if (key.equals(Standard.END.key())) {
            return LAST;
        }
        Integer i = LOOKUP.get(key);
        return i == null ? UNORDERED : i;
    }

    @Override
    public int compare(String c1, String c2) {
        int i2;
        int i1 = HeaderOrder.indexOf(c1);
        if (i1 == (i2 = HeaderOrder.indexOf(c2))) {
            return 0;
        }
        return i1 < i2 ? -1 : 1;
    }

    static {
        for (int i = 0; i < ORDER.length; ++i) {
            LOOKUP.put(ORDER[i], 1000 * i);
        }
    }
}

