/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.nio.Buffer;
import java.util.Arrays;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.StandardImageTiler;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.ComplexValue;
import nom.tam.util.Cursor;
import nom.tam.util.FitsEncoder;
import nom.tam.util.Quantizer;
import nom.tam.util.RandomAccess;
import nom.tam.util.array.MultiArrayIterator;
import nom.tam.util.type.ElementType;

public class ImageData
extends Data {
    private static final String COMPLEX_TYPE = "COMPLEX";
    private long byteSize;
    private Object dataArray;
    private ArrayDesc dataDescription;
    private StandardImageTiler tiler;

    public ImageData() {
        this(new byte[0]);
    }

    public ImageData(Header h) throws FitsException {
        this.dataDescription = this.parseHeader(h);
    }

    public ImageData(Object x) throws IllegalArgumentException {
        try {
            ImageData.checkCompatible(x);
        }
        catch (FitsException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.dataDescription = new ArrayDesc(ArrayFuncs.getDimensions(x), ArrayFuncs.getBaseClass(x));
        this.dataArray = x;
        this.byteSize = FitsEncoder.computeSize(x);
    }

    @Override
    protected void loadData(ArrayDataInput in) throws IOException, FitsException {
        if (this.tiler != null) {
            this.dataArray = this.tiler.getCompleteImage();
        } else {
            this.dataArray = ArrayFuncs.newInstance(this.getType(), this.getDimensions());
            in.readImage(this.dataArray);
        }
    }

    @Override
    public void read(ArrayDataInput in) throws FitsException {
        this.tiler = in instanceof RandomAccess ? new ImageDataTiler((RandomAccess)in, ((RandomAccess)in).getFilePointer(), this.dataDescription) : null;
        super.read(in);
    }

    @Override
    protected Object getCurrentData() {
        return this.dataArray;
    }

    public StandardImageTiler getTiler() {
        return this.tiler;
    }

    public void setBuffer(Buffer data) {
        ElementType<Buffer> elementType = ElementType.forClass(this.getType());
        this.dataArray = ArrayFuncs.newInstance(this.getType(), this.getDimensions());
        MultiArrayIterator<Object> iterator = new MultiArrayIterator<Object>(this.dataArray);
        Object array = iterator.next();
        while (array != null) {
            elementType.getArray(data, array);
            array = iterator.next();
        }
        this.tiler = new ImageDataTiler(null, 0L, this.dataDescription);
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (this.byteSize == 0L) {
            return;
        }
        if (o != this.getRandomAccessInput()) {
            this.ensureData();
        }
        try {
            o.writeArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on image write" + e);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }

    @Override
    protected void fillHeader(Header head) throws FitsException {
        if (this.dataArray == null) {
            head.nullImage();
            return;
        }
        Standard.context(ImageData.class);
        head.deleteKey(Standard.XTENSION);
        Cursor<String, HeaderCard> c = head.iterator();
        c.add(HeaderCard.create((IFitsHeader)Standard.SIMPLE, true));
        Class<Object> base = this.getType();
        int[] dims = this.getDimensions();
        if (ComplexValue.class.isAssignableFrom(base)) {
            dims = Arrays.copyOf(dims, dims.length + 1);
            dims[dims.length - 1] = 2;
            base = ComplexValue.Float.class.isAssignableFrom(base) ? Float.TYPE : Double.TYPE;
        }
        c.add(HeaderCard.create((IFitsHeader)Standard.BITPIX, Bitpix.forPrimitiveType(base).getHeaderValue()));
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, dims.length));
        for (int i = 1; i <= dims.length; ++i) {
            c.add(HeaderCard.create(Standard.NAXISn.n(i), dims[dims.length - i]));
        }
        c.add(HeaderCard.create((IFitsHeader)Standard.PCOUNT, 0));
        c.add(HeaderCard.create((IFitsHeader)Standard.GCOUNT, 1));
        c.add(HeaderCard.create((IFitsHeader)Standard.EXTEND, true));
        if (this.isComplexValued()) {
            c.add(HeaderCard.create(Standard.CTYPEn.n(dims.length - this.dataDescription.complexAxis), COMPLEX_TYPE));
        }
        if (this.dataDescription.quant != null) {
            this.dataDescription.quant.editImageHeader(head);
        }
        Standard.context(null);
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    protected ArrayDesc parseHeader(Header h) throws FitsException {
        String ext = h.getStringValue(Standard.XTENSION, "IMAGE");
        if (!ext.equalsIgnoreCase("IMAGE") && !ext.equalsIgnoreCase("IUEIMAGE")) {
            throw new FitsException("Not an image header (XTENSION = " + h.getStringValue(Standard.XTENSION) + ")");
        }
        int gCount = h.getIntValue(Standard.GCOUNT, 1);
        int pCount = h.getIntValue(Standard.PCOUNT, 0);
        if (gCount > 1 || pCount != 0) {
            throw new FitsException("Group data treated as images");
        }
        Bitpix bitpix = Bitpix.fromHeader(h);
        Class<?> baseClass = bitpix.getPrimitiveType();
        int ndim = h.getIntValue(Standard.NAXIS, 0);
        int[] dims = new int[ndim];
        this.byteSize = ndim > 0 ? 1L : 0L;
        for (int i = 1; i <= ndim; ++i) {
            int cdim = h.getIntValue(Standard.NAXISn.n(i), 0);
            if (cdim < 0) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            this.byteSize *= (long)cdim;
            dims[ndim - i] = cdim;
        }
        this.byteSize *= (long)bitpix.byteSize();
        ArrayDesc desc = new ArrayDesc(dims, baseClass);
        if (COMPLEX_TYPE.equals(h.getStringValue(Standard.CTYPEn.n(1))) && dims[ndim - 1] == 2) {
            desc.complexAxis = ndim - 1;
        } else if (COMPLEX_TYPE.equals(h.getStringValue(Standard.CTYPEn.n(ndim))) && dims[0] == 2) {
            desc.complexAxis = 0;
        }
        desc.quant = Quantizer.fromImageHeader(h);
        if (desc.quant.isDefault()) {
            desc.quant = null;
        }
        return desc;
    }

    void setTiler(StandardImageTiler tiler) {
        this.tiler = tiler;
    }

    public static void overrideHeaderAxes(Header header, int ... sizes) throws FitsException, IllegalArgumentException {
        String extType = header.getStringValue(Standard.XTENSION, "IMAGE");
        if (!extType.equals("IMAGE") && !extType.equals("IUEIMAGE")) {
            throw new FitsException("Not an image header (XTENSION = " + extType + ")");
        }
        int n = header.getIntValue(Standard.NAXIS);
        int i = 1;
        while (i <= n) {
            header.deleteKey(Standard.NAXISn.n(i++));
        }
        Cursor<String, HeaderCard> c = header.iterator();
        c.setKey(Standard.NAXIS.key());
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, sizes.length));
        int i2 = 1;
        while (i2 <= sizes.length) {
            int l = sizes[sizes.length - i2];
            if (l < 0) {
                throw new FitsException("Invalid size[ " + i2 + "] = " + l);
            }
            c.add(HeaderCard.create(Standard.NAXISn.n(i2++), l));
        }
    }

    public static ImageData from(Object data) throws IllegalArgumentException {
        return new ImageData(data);
    }

    static void checkCompatible(Object data) throws IllegalArgumentException, FitsException {
        if (data != null) {
            Class<Object> base = ArrayFuncs.getBaseClass(data);
            if (ComplexValue.Float.class.isAssignableFrom(base)) {
                base = Float.TYPE;
            } else if (ComplexValue.class.isAssignableFrom(base)) {
                base = Double.TYPE;
            }
            Bitpix.forPrimitiveType(base);
            ArrayFuncs.checkRegularArray(data, false);
        }
    }

    public ImageHDU toHDU() throws FitsException {
        Header h = new Header();
        this.fillHeader(h);
        return new ImageHDU(h, this);
    }

    public void setQuantizer(Quantizer quant) {
        this.dataDescription.quant = quant;
    }

    public final Quantizer getQuantizer() {
        return this.dataDescription.quant;
    }

    public final Class<?> getType() {
        return this.dataDescription.type;
    }

    public final int[] getDimensions() {
        return Arrays.copyOf(this.dataDescription.dims, this.dataDescription.dims.length);
    }

    public final boolean isComplexValued() {
        return this.dataDescription.complexAxis >= 0;
    }

    public ImageData convertTo(Class<?> type) throws FitsException {
        boolean toComplex;
        if (type.isAssignableFrom(this.getType())) {
            return this;
        }
        this.ensureData();
        ImageData typed = null;
        boolean bl = toComplex = ComplexValue.class.isAssignableFrom(type) && !ComplexValue.class.isAssignableFrom(this.getType());
        if (toComplex && this.dataDescription.complexAxis == 0) {
            Class<Number> numType = ComplexValue.Float.class.isAssignableFrom(type) ? Float.TYPE : Double.TYPE;
            Object[] t = (Object[])ArrayFuncs.convertArray(this.dataArray, numType, this.getQuantizer());
            ImageData f = new ImageData(ArrayFuncs.decimalsToComplex(t[0], t[1]));
            f.dataDescription.quant = this.getQuantizer();
            return f.convertTo(type);
        }
        typed = new ImageData(ArrayFuncs.convertArray(this.dataArray, type, this.getQuantizer()));
        typed.dataDescription.quant = this.getQuantizer();
        return typed;
    }

    protected static class ArrayDesc {
        private final Class<?> type;
        private int[] dims;
        private Quantizer quant;
        private int complexAxis = -1;

        ArrayDesc(int[] dims, Class<?> type) {
            this.dims = dims;
            this.type = type;
            if (ComplexValue.class.isAssignableFrom(type)) {
                this.complexAxis = dims.length;
            }
        }
    }

    protected class ImageDataTiler
    extends StandardImageTiler {
        ImageDataTiler(RandomAccess o, long offset, ArrayDesc d) {
            super(o, offset, d.dims, d.type);
        }

        @Override
        protected Object getMemoryImage() {
            return ImageData.this.dataArray;
        }
    }
}

