/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.header.Standard;
import nom.tam.image.StandardImageTiler;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.LoggerHelper;

public class ImageHDU
extends BasicHDU<ImageData> {
    private static final Logger LOG = LoggerHelper.getLogger(ImageHDU.class);

    @Override
    protected final String getCanonicalXtension() {
        return "IMAGE";
    }

    @Deprecated
    public static ImageData encapsulate(Object o) throws IllegalArgumentException, FitsException {
        return new ImageData(o);
    }

    @Deprecated
    public static boolean isData(Object o) {
        try {
            ImageData.checkCompatible(o);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isHeader(Header hdr) {
        boolean found = hdr.getBooleanValue(Standard.SIMPLE);
        if (!found) {
            String xtension = hdr.getStringValue(Standard.XTENSION);
            String string = xtension = xtension == null ? "" : xtension.trim();
            if ("IMAGE".equals(xtension) || "IUEIMAGE".equals(xtension)) {
                found = true;
            }
        }
        if (!found) {
            return false;
        }
        return !hdr.getBooleanValue(Standard.GROUPS);
    }

    @Deprecated
    public static ImageData manufactureData(Header hdr) throws FitsException {
        return new ImageData(hdr);
    }

    @Deprecated
    public static Header manufactureHeader(Data d) throws FitsException {
        if (d == null) {
            return null;
        }
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public ImageHDU(Header h, ImageData d) {
        super(h, d);
    }

    public StandardImageTiler getTiler() {
        return ((ImageData)this.myData).getTiler();
    }

    @Override
    public void info(PrintStream stream) {
        if (ImageHDU.isHeader(this.myHeader)) {
            stream.println("  Image");
        } else {
            stream.println("  Image (bad header)");
        }
        stream.println("      Header Information:");
        stream.println("         BITPIX=" + this.myHeader.getIntValue(Standard.BITPIX, -1));
        int naxis = this.myHeader.getIntValue(Standard.NAXIS, -1);
        stream.println("         NAXIS=" + naxis);
        for (int i = 1; i <= naxis; ++i) {
            stream.println("         NAXIS" + i + "=" + this.myHeader.getIntValue(Standard.NAXISn.n(i), -1));
        }
        stream.println("      Data information:");
        try {
            if (((ImageData)this.myData).getData() == null) {
                stream.println("        No Data");
            } else {
                stream.println("         " + ArrayFuncs.arrayDescription(((ImageData)this.myData).getData()));
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Unable to get image data", e);
            stream.println("      Unable to get data");
        }
    }

    @Override
    public String getBUnit() {
        return super.getBUnit();
    }

    @Override
    public long getBlankValue() throws FitsException {
        if (this.getBitpix().getHeaderValue() < 0) {
            throw new FitsException("No integer blanking value in floating-point images.");
        }
        return super.getBlankValue();
    }

    @Override
    public double getBScale() {
        return super.getBScale();
    }

    @Override
    public double getBZero() {
        return super.getBZero();
    }
}

