/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.RandomGroupsHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.FitsEncoder;

public class RandomGroupsData
extends Data {
    private int groups;
    private Object[] sampleRow;
    private Object[][] dataArray;

    public RandomGroupsData() {
        this.dataArray = new Object[0][];
    }

    RandomGroupsData(int gcount, Object[] sampleRow) {
        this();
        this.groups = gcount;
        this.sampleRow = sampleRow;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    public RandomGroupsData(Object[][] x) throws IllegalArgumentException {
        this.dataArray = x == null ? new Object[][]{} : x;
        this.groups = this.dataArray.length;
        if (this.groups > 0) {
            Class<?> dbase;
            Class<?> pbase;
            if (this.dataArray[0].length != 2) {
                throw new IllegalArgumentException("Second array dimension must be 2");
            }
            if (Array.getLength(ArrayFuncs.getDimensions(this.dataArray[0][0])) != 1) {
                throw new IllegalArgumentException("Expected 1D parameter array.");
            }
            if (this.dataArray[0][1] != null && (pbase = ArrayFuncs.getBaseClass(this.dataArray[0][0])) != (dbase = ArrayFuncs.getBaseClass(this.dataArray[0][1]))) {
                throw new IllegalArgumentException("Mismatched parameters and data types (" + pbase.getName() + " vs " + dbase.getName() + ")");
            }
            this.sampleRow = new Object[2];
            this.sampleRow[0] = ArrayFuncs.deepClone(this.dataArray[0][0]);
            this.sampleRow[1] = ArrayFuncs.deepClone(this.dataArray[0][1]);
        }
    }

    public Class<?> getElementType() {
        return this.sampleRow == null ? null : ArrayFuncs.getBaseClass(this.sampleRow[0]);
    }

    public int getParameterCount() {
        return this.sampleRow == null ? -1 : Array.getLength(this.sampleRow[0]);
    }

    public int[] getDataDims() {
        return this.sampleRow == null ? null : ArrayFuncs.getDimensions(this.sampleRow[1]);
    }

    @Override
    protected void fillHeader(Header h) throws FitsException {
        if (this.groups <= 0) {
            throw new FitsException("Invalid (empty) random group data");
        }
        Standard.context(RandomGroupsData.class);
        h.deleteKey(Standard.XTENSION);
        Cursor<String, HeaderCard> c = h.iterator();
        c.add(HeaderCard.create((IFitsHeader)Standard.SIMPLE, true));
        c.add(HeaderCard.create((IFitsHeader)Standard.BITPIX, Bitpix.forPrimitiveType(this.getElementType()).getHeaderValue()));
        int[] dims = this.getDataDims();
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, dims.length + 1));
        h.addValue(Standard.NAXIS1, 0);
        for (int i = 1; i <= dims.length; ++i) {
            c.add(HeaderCard.create(Standard.NAXISn.n(i + 1), dims[dims.length - i]));
        }
        c.add(HeaderCard.create((IFitsHeader)Standard.GROUPS, true));
        c.add(HeaderCard.create((IFitsHeader)Standard.PCOUNT, this.getParameterCount()));
        c.add(HeaderCard.create((IFitsHeader)Standard.GCOUNT, this.groups));
        c.add(HeaderCard.create((IFitsHeader)Standard.EXTEND, true));
        Standard.context(null);
    }

    @Override
    protected long getTrueSize() {
        if (this.sampleRow == null) {
            return 0L;
        }
        return (FitsEncoder.computeSize(this.sampleRow[0]) + FitsEncoder.computeSize(this.sampleRow[1])) * (long)this.groups;
    }

    @Override
    public boolean isEmpty() {
        return this.dataArray.length == 0;
    }

    @Override
    protected void loadData(ArrayDataInput in) throws IOException {
        this.dataArray = new Object[this.groups][2];
        for (int i = 0; i < this.groups; ++i) {
            this.dataArray[i][0] = ((Object[])ArrayFuncs.deepClone(this.sampleRow))[0];
            this.dataArray[i][1] = ((Object[])ArrayFuncs.deepClone(this.sampleRow))[1];
        }
        in.readImage(this.dataArray);
    }

    protected Object[][] getCurrentData() {
        return this.dataArray;
    }

    public Object[][] getData() throws FitsException {
        return (Object[][])super.getData();
    }

    @Override
    public void write(ArrayDataOutput str) throws FitsException {
        if (this.getTrueSize() <= 0L) {
            return;
        }
        if (str != this.getRandomAccessInput()) {
            this.ensureData();
        }
        try {
            str.writeArray(this.dataArray);
            FitsUtil.pad(str, this.getTrueSize());
        }
        catch (IOException e) {
            throw new FitsException("IO error writing random groups data ", e);
        }
    }

    public RandomGroupsHDU toHDU() throws FitsException {
        Header h = new Header();
        this.fillHeader(h);
        return new RandomGroupsHDU(h, this);
    }

    public Object getImage(int group) throws ArrayIndexOutOfBoundsException, FitsException {
        this.ensureData();
        return this.dataArray[group][1];
    }

    Object getParameterArray(int group) throws ArrayIndexOutOfBoundsException, FitsException {
        this.ensureData();
        return this.dataArray[group][0];
    }
}

