/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.FitsOutput;

public class RandomGroupsHDU
extends BasicHDU<RandomGroupsData> {
    private Hashtable<String, Parameter> parameters;

    @Override
    protected final String getCanonicalXtension() {
        return "IMAGE";
    }

    @Deprecated
    public static RandomGroupsData encapsulate(Object o) throws FitsException {
        if (o instanceof Object[][]) {
            return new RandomGroupsData((Object[][])o);
        }
        throw new FitsException("Attempt to encapsulate invalid data in Random Group");
    }

    static Object[] generateSampleRow(Header h) throws FitsException {
        int ndim = h.getIntValue(Standard.NAXIS, 0) - 1;
        int[] dims = new int[ndim];
        Class<? extends Number> baseClass = Bitpix.fromHeader(h).getNumberType();
        for (int i = 0; i < ndim; ++i) {
            long cdim = h.getIntValue(Standard.NAXISn.n(i + 2), 0);
            if (cdim < 0L) {
                throw new FitsException("Invalid array dimension:" + cdim);
            }
            dims[ndim - i - 1] = (int)cdim;
        }
        Object[] sample = new Object[]{ArrayFuncs.newInstance(baseClass, h.getIntValue(Standard.PCOUNT)), ArrayFuncs.newInstance(baseClass, dims)};
        return sample;
    }

    @Deprecated
    public static boolean isData(Object potentialData) {
        String cn;
        Object[][] o;
        return potentialData instanceof Object[][] && (o = (Object[][])potentialData).length > 0 && o[0].length == 2 && ArrayFuncs.getBaseClass(o[0][0]) == ArrayFuncs.getBaseClass(o[0][1]) && ((cn = o[0][0].getClass().getName()).length() == 2 && cn.charAt(1) != 'Z' || cn.charAt(1) != 'C');
    }

    @Deprecated
    public static boolean isHeader(Header hdr) {
        if (hdr.getBooleanValue(Standard.SIMPLE)) {
            return hdr.getBooleanValue(Standard.GROUPS);
        }
        String xtension = hdr.getStringValue(Standard.XTENSION);
        String string = xtension = xtension == null ? "" : xtension.trim();
        if ("IMAGE".equals(xtension)) {
            return hdr.getBooleanValue(Standard.GROUPS);
        }
        return false;
    }

    @Deprecated
    public static RandomGroupsData manufactureData(Header header) throws FitsException {
        int gcount = header.getIntValue(Standard.GCOUNT, -1);
        int pcount = header.getIntValue(Standard.PCOUNT, -1);
        if (!header.getBooleanValue(Standard.GROUPS) || header.getIntValue(Standard.NAXISn.n(1), -1) != 0 || gcount < 0 || pcount < 0 || header.getIntValue(Standard.NAXIS) < 2) {
            throw new FitsException("Invalid Random Groups Parameters");
        }
        return new RandomGroupsData(gcount, RandomGroupsHDU.generateSampleRow(header));
    }

    @Deprecated
    static Header manufactureHeader(Data d) throws FitsException {
        if (d == null) {
            throw new FitsException("Attempt to create null Random Groups data");
        }
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public static RandomGroupsHDU createFrom(Object[][] data) throws FitsException {
        if (!RandomGroupsHDU.isData(data)) {
            throw new FitsException("Type or layout of data is not random groups compatible.");
        }
        RandomGroupsData d = RandomGroupsHDU.encapsulate(data);
        return new RandomGroupsHDU(RandomGroupsHDU.manufactureHeader(d), d);
    }

    private void parseParameters(Header header) {
        int nparms = header.getIntValue(Standard.PCOUNT);
        this.parameters = new Hashtable();
        for (int i = 1; i <= nparms; ++i) {
            String name = header.getStringValue(Standard.PTYPEn.n(i));
            if (name == null) continue;
            Parameter p = this.parameters.get(name);
            if (p == null) {
                p = new Parameter();
                this.parameters.put(name, p);
            }
            p.components.add(new ParameterConversion(header, i));
        }
    }

    public RandomGroupsHDU(Header header, RandomGroupsData data) {
        super(header, data);
        if (header == null) {
            return;
        }
        this.parseParameters(header);
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("Random Groups HDU");
        if (this.myHeader != null) {
            stream.println("   HeaderInformation:");
            stream.println("     Ngroups:" + this.myHeader.getIntValue(Standard.GCOUNT));
            stream.println("     Npar:   " + this.myHeader.getIntValue(Standard.PCOUNT));
            stream.println("     BITPIX: " + this.myHeader.getIntValue(Standard.BITPIX));
            stream.println("     NAXIS:  " + this.myHeader.getIntValue(Standard.NAXIS));
            for (int i = 0; i < this.myHeader.getIntValue(Standard.NAXIS); ++i) {
                stream.println("      NAXIS" + (i + 1) + "= " + this.myHeader.getIntValue(Standard.NAXISn.n(i + 1)));
            }
        } else {
            stream.println("    No Header Information");
        }
        Object[][] data = null;
        if (this.myData != null) {
            try {
                data = ((RandomGroupsData)this.myData).getData();
            }
            catch (FitsException fitsException) {
                // empty catch block
            }
        }
        if (data == null || data.length < 1 || data[0].length != 2) {
            stream.println("    Invalid/unreadable data");
        } else {
            stream.println("    Number of groups:" + data.length);
            stream.println("    Parameters: " + ArrayFuncs.arrayDescription(data[0][0]));
            stream.println("    Data:" + ArrayFuncs.arrayDescription(data[0][1]));
        }
    }

    @Override
    public int getParameterCount() {
        return super.getParameterCount();
    }

    @Override
    public int getGroupCount() {
        return super.getGroupCount();
    }

    public boolean isHeader() {
        return RandomGroupsHDU.isHeader(this.myHeader);
    }

    @Override
    public String getBUnit() {
        return super.getBUnit();
    }

    @Override
    public long getBlankValue() throws FitsException {
        if (this.getBitpix().getHeaderValue() < 0) {
            throw new FitsException("No integer blanking value in floating-point images.");
        }
        return super.getBlankValue();
    }

    @Override
    public double getBScale() {
        return super.getBScale();
    }

    @Override
    public double getBZero() {
        return super.getBZero();
    }

    @Override
    public void write(ArrayDataOutput stream) throws FitsException {
        if (stream instanceof FitsOutput && !((FitsOutput)stream).isAtStart()) {
            throw new FitsException("Random groups are only permitted in the primary HDU");
        }
        super.write(stream);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public double getParameter(String name, int group) throws ArrayIndexOutOfBoundsException, FitsException {
        Parameter p = this.parameters.get(name);
        if (p == null) {
            return Double.NaN;
        }
        return p.getValue(((RandomGroupsData)this.getData()).getParameterArray(group));
    }

    private static final class Parameter {
        private ArrayList<ParameterConversion> components = new ArrayList();

        private Parameter() {
        }

        private double getValue(Object array) {
            double value = 0.0;
            for (ParameterConversion c : this.components) {
                double x = Array.getDouble(array, c.index);
                value += c.scaling * x + c.offset;
            }
            return value;
        }
    }

    private static final class ParameterConversion {
        private int index;
        private double scaling;
        private double offset;

        private ParameterConversion(Header h, int n) {
            this.index = n - 1;
            this.scaling = h.getDoubleValue(Standard.PSCALn.n(n), 1.0);
            this.offset = h.getDoubleValue(Standard.PZEROn.n(n), 0.0);
        }
    }
}

