/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.UndefinedHDU;
import nom.tam.fits.header.Bitpix;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.FitsEncoder;

public class UndefinedData
extends Data {
    private static final String XTENSION_UNKNOWN = "UNKNOWN";
    private Bitpix bitpix = Bitpix.BYTE;
    private int[] dims;
    private int byteSize = 0;
    private byte[] data;
    private int pCount = 0;
    private int gCount = 1;
    private String extensionType = "UNKNOWN";

    public UndefinedData(Header h) throws FitsException {
        this.extensionType = h.getStringValue(Standard.XTENSION, XTENSION_UNKNOWN);
        int naxis = h.getIntValue(Standard.NAXIS);
        this.dims = new int[naxis];
        int size = naxis > 0 ? 1 : 0;
        for (int i = 1; i <= naxis; ++i) {
            this.dims[naxis - i] = h.getIntValue(Standard.NAXISn.n(i));
            size *= this.dims[naxis - i];
        }
        this.pCount = h.getIntValue(Standard.PCOUNT);
        size += this.pCount;
        this.gCount = h.getIntValue(Standard.GCOUNT);
        if (this.gCount > 1) {
            size *= h.getIntValue(Standard.GCOUNT);
        }
        this.bitpix = Bitpix.fromHeader(h);
        this.byteSize = size *= this.bitpix.byteSize();
    }

    public UndefinedData(Object x) throws IllegalArgumentException {
        this.byteSize = (int)FitsEncoder.computeSize(x);
        this.dims = ArrayFuncs.getDimensions(x);
        this.data = new byte[this.byteSize];
        ArrayFuncs.copyInto(x, this.data);
    }

    @Override
    protected void fillHeader(Header head) {
        head.deleteKey(Standard.SIMPLE);
        head.deleteKey(Standard.EXTEND);
        Standard.context(UndefinedData.class);
        Cursor<String, HeaderCard> c = head.iterator();
        c.add(HeaderCard.create((IFitsHeader)Standard.XTENSION, this.extensionType));
        c.add(HeaderCard.create((IFitsHeader)Standard.BITPIX, this.bitpix.getHeaderValue()));
        c.add(HeaderCard.create((IFitsHeader)Standard.NAXIS, this.dims.length));
        for (int i = 1; i <= this.dims.length; ++i) {
            c.add(HeaderCard.create(Standard.NAXISn.n(i), this.dims[this.dims.length - i]));
        }
        c.add(HeaderCard.create((IFitsHeader)Standard.PCOUNT, this.pCount));
        c.add(HeaderCard.create((IFitsHeader)Standard.GCOUNT, this.gCount));
        Standard.context(null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="intended exposure of mutable data")
    protected byte[] getCurrentData() {
        return this.data;
    }

    @Override
    protected long getTrueSize() {
        return this.byteSize;
    }

    public final String getXtension() {
        return this.extensionType;
    }

    public final Bitpix getBitpix() {
        return this.bitpix;
    }

    public final int getParameterCount() {
        return this.pCount;
    }

    public final int getGroupCount() {
        return this.gCount;
    }

    public final int[] getDimensions() {
        return this.dims;
    }

    public byte[] getData() throws FitsException {
        byte[] bytes = (byte[])super.getData();
        if (bytes != null) {
            return bytes;
        }
        this.data = new byte[this.byteSize];
        return this.data;
    }

    @Override
    protected void loadData(ArrayDataInput in) throws IOException {
        this.data = new byte[this.byteSize];
        in.readFully(this.data);
    }

    @Override
    public void write(ArrayDataOutput o) throws FitsException {
        if (o != this.getRandomAccessInput()) {
            this.ensureData();
        }
        try {
            o.write(this.data);
        }
        catch (IOException e) {
            throw new FitsException("IO Error on unknown data write", e);
        }
        FitsUtil.pad(o, this.getTrueSize());
    }

    public UndefinedHDU toHDU() {
        Header h = new Header();
        this.fillHeader(h);
        return new UndefinedHDU(h, this);
    }
}

