/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.compress.CloseIS;
import nom.tam.fits.compress.CompressionManager;
import nom.tam.fits.compress.ICompressProvider;

@Deprecated
public class ExternalBZip2CompressionProvider
implements ICompressProvider {
    private static final int PRIORITY = 10;
    private static final Logger LOG = Logger.getLogger(ExternalBZip2CompressionProvider.class.getName());

    private InputStream bunzipper(InputStream compressed) throws IOException, FitsException {
        String cmd = this.getBzip2Cmd();
        if (cmd.indexOf(" -") < 0) {
            cmd = cmd + " -";
        }
        String[] flds = cmd.split(" +");
        try {
            Process proc = new ProcessBuilder(flds).start();
            return new CloseIS(proc, compressed);
        }
        catch (Exception e) {
            ICompressProvider next = CompressionManager.nextCompressionProvider(66, 90, this);
            if (next != null) {
                LOG.warning("Error initiating BZIP decompression: " + e.getMessage() + " trying alternative decompressor");
                return next.decompress(compressed);
            }
            throw new FitsException("Error initiating BZIP decompression: " + e);
        }
    }

    public String getBzip2Cmd() {
        return System.getProperty("BZIP_DECOMPRESSOR", System.getenv("BZIP_DECOMPRESSOR"));
    }

    @Override
    public InputStream decompress(InputStream in) throws IOException, FitsException {
        return this.bunzipper(in);
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public boolean provides(int mag1, int mag2) {
        return mag1 == 66 && mag2 == 90 && this.getBzip2Cmd() != null;
    }
}

