/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.hcompress;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.hcompress.HCompressParameters;

public class HCompressorOption
implements ICompressOption {
    private final Config config = new Config();
    private HCompressParameters parameters;
    private int tileHeight;
    private int tileWidth;

    public HCompressorOption() {
        this.setParameters(new HCompressParameters(this));
    }

    @Override
    public HCompressorOption copy() {
        try {
            HCompressorOption copy = (HCompressorOption)this.clone();
            copy.parameters = this.parameters.copy(copy);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    @Override
    public HCompressParameters getCompressionParameters() {
        return this.parameters;
    }

    public int getScale() {
        return this.config.scale;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public boolean isLossyCompression() {
        return this.config.scale > 0 || this.config.smooth;
    }

    public boolean isSmooth() {
        return this.config.smooth;
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        if (!(parameters instanceof HCompressParameters)) {
            throw new IllegalArgumentException("Wrong type of parameters: " + parameters.getClass().getName());
        }
        this.parameters = (HCompressParameters)parameters;
    }

    public HCompressorOption setScale(double value) throws IllegalArgumentException {
        if (value < 0.0) {
            throw new IllegalArgumentException("Scale value cannot be negative: " + value);
        }
        this.config.scale = (int)Math.round(value);
        return this;
    }

    public HCompressorOption setSmooth(boolean value) {
        this.config.smooth = value;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public HCompressorOption setTileHeight(int value) {
        this.tileHeight = value;
        return this;
    }

    @Override
    public HCompressorOption setTileWidth(int value) {
        this.tileWidth = value;
        return this;
    }

    private static final class Config {
        private int scale;
        private boolean smooth;

        private Config() {
        }
    }
}

