/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.quant;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.base.BundledParameters;
import nom.tam.fits.compression.provider.param.quant.QuantizeParameters;

public class QuantizeOption
implements ICompressOption {
    private static final int NULL_VALUE = -2147483647;
    private Config config;
    protected QuantizeParameters parameters;
    private ICompressOption compressOption;
    private double bScale = Double.NaN;
    private double bZero = Double.NaN;
    private double nullValue = Double.NaN;
    private Integer nullValueIndicator;
    private boolean checkNull;
    private int intMaxValue;
    private int intMinValue;
    private double maxValue;
    private double minValue;
    private int tileIndex = 0;
    private int tileHeight;
    private int tileWidth;

    QuantizeOption() {
        this(null);
    }

    public QuantizeOption(ICompressOption compressOption) {
        this.parameters = new QuantizeParameters(this);
        this.config = new Config();
        this.compressOption = compressOption;
    }

    @Override
    public QuantizeOption copy() {
        try {
            QuantizeOption copy = (QuantizeOption)this.clone();
            if (this.compressOption != null) {
                copy.compressOption = this.compressOption.copy();
            }
            copy.parameters = this.parameters.copy(copy);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    public Integer getBNull() {
        return this.nullValueIndicator;
    }

    public double getBScale() {
        return this.bScale;
    }

    public double getBZero() {
        return this.bZero;
    }

    @Override
    public ICompressParameters getCompressionParameters() {
        if (this.compressOption == null) {
            return this.parameters;
        }
        return new BundledParameters(this.parameters, this.compressOption.getCompressionParameters());
    }

    public <T> T getCompressOption(Class<T> clazz) {
        return this.unwrap(clazz);
    }

    public final ICompressOption getCompressOption() {
        return this.compressOption;
    }

    public int getIntMaxValue() {
        return this.intMaxValue;
    }

    public int getIntMinValue() {
        return this.intMinValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getNullValue() {
        return this.nullValue;
    }

    public final Integer getNullValueIndicator() {
        return this.getBNull();
    }

    public double getQLevel() {
        return this.config.qlevel;
    }

    public long getSeed() {
        return this.config.seed;
    }

    public long getTileIndex() {
        return this.tileIndex;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    public boolean isCenterOnZero() {
        return this.config.centerOnZero;
    }

    public boolean isCheckNull() {
        return this.checkNull;
    }

    public boolean isCheckZero() {
        return this.config.checkZero;
    }

    public boolean isDither() {
        return this.config.dither;
    }

    public boolean isDither2() {
        return this.config.dither2;
    }

    @Override
    public boolean isLossyCompression() {
        return true;
    }

    public ICompressOption setBNull(Integer blank) {
        if (blank != null) {
            this.nullValueIndicator = blank;
            this.checkNull = true;
        } else {
            this.checkNull = false;
        }
        return this;
    }

    public QuantizeOption setBScale(double value) {
        this.bScale = value;
        return this;
    }

    public QuantizeOption setBZero(double value) {
        this.bZero = value;
        return this;
    }

    public QuantizeOption setCenterOnZero(boolean value) {
        this.config.centerOnZero = value;
        return this;
    }

    public QuantizeOption setCheckNull(boolean value) {
        this.checkNull = value;
        if (this.nullValueIndicator == null) {
            this.nullValueIndicator = -2147483647;
        }
        return this;
    }

    public QuantizeOption setCheckZero(boolean value) {
        this.config.checkZero = value;
        return this;
    }

    public QuantizeOption setDither(boolean value) {
        this.config.dither = value;
        return this;
    }

    public QuantizeOption setDither2(boolean value) {
        this.config.dither2 = value;
        return this;
    }

    public QuantizeOption setIntMaxValue(int value) {
        this.intMaxValue = value;
        return this;
    }

    public QuantizeOption setIntMinValue(int value) {
        this.intMinValue = value;
        return this;
    }

    public QuantizeOption setMaxValue(double value) {
        this.maxValue = value;
        return this;
    }

    public QuantizeOption setMinValue(double value) {
        this.minValue = value;
        return this;
    }

    public QuantizeOption setNullValue(double value) {
        this.nullValue = value;
        return this;
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        if (parameters instanceof QuantizeParameters) {
            this.parameters = (QuantizeParameters)parameters.copy(this);
        } else if (parameters instanceof BundledParameters) {
            BundledParameters bundle = (BundledParameters)parameters;
            for (int i = 0; i < bundle.size(); ++i) {
                this.setParameters(bundle.get(i));
            }
        } else if (this.compressOption != null) {
            this.compressOption.setParameters(parameters);
        }
    }

    public QuantizeOption setQlevel(double value) {
        this.config.qlevel = value;
        return this;
    }

    public QuantizeOption setSeed(long value) {
        this.config.seed = value;
        return this;
    }

    public QuantizeOption setTileIndex(int index) {
        this.tileIndex = index;
        return this;
    }

    @Override
    public QuantizeOption setTileHeight(int value) {
        this.tileHeight = value;
        if (this.compressOption != null) {
            this.compressOption.setTileHeight(value);
        }
        return this;
    }

    @Override
    public QuantizeOption setTileWidth(int value) {
        this.tileWidth = value;
        if (this.compressOption != null) {
            this.compressOption.setTileWidth(value);
        }
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        if (this.compressOption != null && clazz.isAssignableFrom(this.compressOption.getClass())) {
            return clazz.cast(this.compressOption);
        }
        return null;
    }

    private static final class Config {
        private boolean centerOnZero;
        private boolean checkZero;
        private boolean dither;
        private boolean dither2;
        private double qlevel = Double.NaN;
        private long seed = 1L;

        private Config() {
        }
    }
}

