/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.rice;

import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.rice.RiceCompressParameters;
import nom.tam.util.type.ElementType;

public class RiceCompressOption
implements ICompressOption {
    public static final int DEFAULT_RICE_BLOCKSIZE = 32;
    public static final int DEFAULT_RICE_BYTEPIX = ElementType.INT.size();
    private static final int[] VALID_BYTEPIX = new int[]{1, 2, 4, 8};
    private static final int[] VALID_BLOCKSIZE = new int[]{16, 32};
    private RiceCompressParameters parameters;
    private final Config config = new Config();

    public RiceCompressOption() {
        this.parameters = new RiceCompressParameters(this);
    }

    @Override
    public RiceCompressOption copy() {
        try {
            RiceCompressOption copy = (RiceCompressOption)this.clone();
            copy.parameters = this.parameters.copy(copy);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("option could not be cloned", e);
        }
    }

    public final int getBlockSize() {
        return this.config.blockSize;
    }

    public final int getBytePix() {
        return this.config.bytePix;
    }

    @Override
    public RiceCompressParameters getCompressionParameters() {
        return this.parameters;
    }

    @Override
    public boolean isLossyCompression() {
        return false;
    }

    public RiceCompressOption setBlockSize(int value) throws IllegalArgumentException {
        for (int i : VALID_BLOCKSIZE) {
            if (value != i) continue;
            this.config.blockSize = value;
            return this;
        }
        throw new IllegalArgumentException("Invalid BYTEPIX value: " + value + " (must be 16 or 32)");
    }

    public RiceCompressOption setBytePix(int value) throws IllegalArgumentException {
        for (int i : VALID_BYTEPIX) {
            if (value != i) continue;
            this.config.bytePix = value;
            return this;
        }
        throw new IllegalArgumentException("Invalid BYTEPIX value: " + value + " (must be 1, 2, 4, or 8)");
    }

    @Override
    public void setParameters(ICompressParameters parameters) {
        if (!(parameters instanceof RiceCompressParameters)) {
            throw new IllegalArgumentException("Wrong type of parameters: " + parameters.getClass().getName());
        }
        this.parameters = (RiceCompressParameters)parameters.copy(this);
    }

    @Override
    public RiceCompressOption setTileHeight(int value) {
        return this;
    }

    @Override
    public RiceCompressOption setTileWidth(int value) {
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        return null;
    }

    private static final class Config {
        private int bytePix = DEFAULT_RICE_BYTEPIX;
        private int blockSize = 32;

        private Config() {
        }
    }
}

