/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.uncompressed;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.util.type.ElementType;

public abstract class NoCompressCompressor<T extends Buffer>
implements ICompressor<T> {

    public static class ShortNoCompressCompressor
    extends NoCompressCompressor<ShortBuffer> {
        @Override
        public boolean compress(ShortBuffer pixelData, ByteBuffer compressed) {
            int size = pixelData.remaining();
            compressed.asShortBuffer().put(pixelData);
            compressed.position(compressed.position() + size * ElementType.SHORT.size());
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, ShortBuffer pixelData) {
            pixelData.put(compressed.asShortBuffer());
        }
    }

    public static class LongNoCompressCompressor
    extends NoCompressCompressor<LongBuffer> {
        @Override
        public boolean compress(LongBuffer pixelData, ByteBuffer compressed) {
            int size = pixelData.remaining();
            compressed.asLongBuffer().put(pixelData);
            compressed.position(compressed.position() + size * ElementType.LONG.size());
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, LongBuffer pixelData) {
            pixelData.put(compressed.asLongBuffer());
        }
    }

    public static class IntNoCompressCompressor
    extends NoCompressCompressor<IntBuffer> {
        @Override
        public boolean compress(IntBuffer pixelData, ByteBuffer compressed) {
            int size = pixelData.remaining();
            compressed.asIntBuffer().put(pixelData);
            compressed.position(compressed.position() + size * ElementType.INT.size());
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, IntBuffer pixelData) {
            pixelData.put(compressed.asIntBuffer());
        }
    }

    public static class FloatNoCompressCompressor
    extends NoCompressCompressor<FloatBuffer> {
        @Override
        public boolean compress(FloatBuffer pixelData, ByteBuffer compressed) {
            int size = pixelData.remaining();
            compressed.asFloatBuffer().put(pixelData);
            compressed.position(compressed.position() + size * ElementType.FLOAT.size());
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, FloatBuffer pixelData) {
            pixelData.put(compressed.asFloatBuffer());
        }
    }

    public static class DoubleNoCompressCompressor
    extends NoCompressCompressor<DoubleBuffer> {
        @Override
        public boolean compress(DoubleBuffer pixelData, ByteBuffer compressed) {
            int size = pixelData.remaining();
            compressed.asDoubleBuffer().put(pixelData);
            compressed.position(compressed.position() + size * ElementType.DOUBLE.size());
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, DoubleBuffer pixelData) {
            pixelData.put(compressed.asDoubleBuffer());
        }
    }

    public static class ByteNoCompressCompressor
    extends NoCompressCompressor<ByteBuffer> {
        @Override
        public boolean compress(ByteBuffer pixelData, ByteBuffer compressed) {
            compressed.put(pixelData);
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, ByteBuffer pixelData) {
            pixelData.put(compressed);
        }
    }
}

