/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.algorithm.gzip.GZipCompressor;
import nom.tam.fits.compression.algorithm.gzip2.GZip2Compressor;
import nom.tam.fits.compression.algorithm.hcompress.HCompressor;
import nom.tam.fits.compression.algorithm.hcompress.HCompressorQuantizeOption;
import nom.tam.fits.compression.algorithm.plio.PLIOCompress;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;
import nom.tam.fits.compression.algorithm.quant.QuantizeProcessor;
import nom.tam.fits.compression.algorithm.rice.RiceCompressor;
import nom.tam.fits.compression.algorithm.rice.RiceQuantizeCompressOption;
import nom.tam.fits.compression.algorithm.uncompressed.NoCompressCompressor;
import nom.tam.fits.compression.provider.CompressorControlNameComputer;
import nom.tam.fits.compression.provider.api.ICompressorProvider;
import nom.tam.fits.compression.provider.param.api.ICompressHeaderParameter;
import nom.tam.fits.compression.provider.param.api.ICompressParameters;
import nom.tam.fits.compression.provider.param.base.CompressParameters;
import nom.tam.fits.compression.provider.param.hcompress.HCompressParameters;
import nom.tam.fits.compression.provider.param.rice.RiceCompressParameters;

public class CompressorProvider
implements ICompressorProvider {
    private static final ICompressOption NULL_OPTION = new ICompressOption(){

        @Override
        public ICompressOption copy() {
            return this;
        }

        @Override
        public ICompressParameters getCompressionParameters() {
            return NULL_PARAMETERS;
        }

        @Override
        public boolean isLossyCompression() {
            return false;
        }

        @Override
        public void setParameters(ICompressParameters parameters) {
        }

        @Override
        public ICompressOption setTileHeight(int value) {
            return this;
        }

        @Override
        public ICompressOption setTileWidth(int value) {
            return this;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return clazz.isAssignableFrom(this.getClass()) ? (T)clazz.cast(this) : null;
        }
    };
    private static final ICompressParameters NULL_PARAMETERS = new CompressParameters(){

        @Override
        protected ICompressHeaderParameter[] headerParameters() {
            return new ICompressHeaderParameter[0];
        }

        @Override
        public ICompressParameters copy(ICompressOption option) {
            return this;
        }
    };
    private static final Class<?>[][] AVAILABLE_COMPRESSORS = new Class[][]{{RiceCompressor.ByteRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.ShortRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.IntRiceCompressor.class, RiceCompressParameters.class}, {RiceCompressor.FloatRiceCompressor.class, RiceQuantizeCompressOption.class}, {RiceCompressor.DoubleRiceCompressor.class, RiceQuantizeCompressOption.class}, {PLIOCompress.BytePLIOCompressor.class}, {PLIOCompress.ShortPLIOCompressor.class}, {PLIOCompress.IntPLIOCompressor.class}, {HCompressor.ByteHCompressor.class, HCompressParameters.class}, {HCompressor.ShortHCompressor.class, HCompressParameters.class}, {HCompressor.IntHCompressor.class, HCompressParameters.class}, {HCompressor.FloatHCompressor.class, HCompressorQuantizeOption.class}, {HCompressor.DoubleHCompressor.class, HCompressorQuantizeOption.class}, {GZip2Compressor.ByteGZip2Compressor.class}, {GZip2Compressor.ShortGZip2Compressor.class}, {GZip2Compressor.IntGZip2Compressor.class}, {GZip2Compressor.FloatGZip2Compressor.class}, {GZip2Compressor.DoubleGZip2Compressor.class}, {GZip2Compressor.LongGZip2Compressor.class}, {GZipCompressor.ByteGZipCompressor.class}, {GZipCompressor.ShortGZipCompressor.class}, {GZipCompressor.IntGZipCompressor.class}, {GZipCompressor.LongGZipCompressor.class}, {GZipCompressor.FloatGZipCompressor.class}, {GZipCompressor.DoubleGZipCompressor.class}, {NoCompressCompressor.ByteNoCompressCompressor.class}, {NoCompressCompressor.ShortNoCompressCompressor.class}, {NoCompressCompressor.IntNoCompressCompressor.class}, {NoCompressCompressor.LongNoCompressCompressor.class}, {NoCompressCompressor.FloatNoCompressCompressor.class}, {NoCompressCompressor.DoubleNoCompressCompressor.class}};
    private static final CompressorControlNameComputer NAME_COMPUTER = new CompressorControlNameComputer();
    private static final Logger LOG = Logger.getLogger(CompressorProvider.class.getName());

    public static ICompressorControl findCompressorControl(String quantAlgorithm, String compressionAlgorithm, Class<?> baseType) {
        for (ICompressorProvider iTileCompressorProvider : ServiceLoader.load(ICompressorProvider.class, Thread.currentThread().getContextClassLoader())) {
            ICompressorControl result = iTileCompressorProvider.createCompressorControl(quantAlgorithm, compressionAlgorithm, baseType);
            if (result == null) continue;
            return result;
        }
        return new CompressorProvider().createCompressorControl(quantAlgorithm, compressionAlgorithm, baseType);
    }

    @Override
    public ICompressorControl createCompressorControl(String quantAlgorithm, String compressionAlgorithm, Class<?> baseType) {
        Class<?> quantType = null;
        if (quantAlgorithm != null && (baseType.equals(Double.TYPE) || baseType.equals(Float.TYPE))) {
            quantType = baseType;
            baseType = Integer.TYPE;
            quantAlgorithm = null;
        }
        String className = NAME_COMPUTER.createCompressorClassName(quantAlgorithm, compressionAlgorithm, baseType);
        for (Class<?>[] types : AVAILABLE_COMPRESSORS) {
            Class<?> compressorClass = types[0];
            if (!compressorClass.getSimpleName().equals(className)) continue;
            TileCompressorControl tc = new TileCompressorControl(compressorClass);
            tc.setQuantType(quantType);
            return tc;
        }
        return null;
    }

    protected static class TileCompressorControl
    implements ICompressorControl {
        private final Constructor<ICompressor<Buffer>>[] constructors;
        private Class<? extends ICompressOption> optionClass;
        private Class<?> quantType;

        protected TileCompressorControl(Class<?> compressorClass) {
            this.constructors = compressorClass.getConstructors();
            for (Constructor<ICompressor<Buffer>> c : this.constructors) {
                if (c.getParameterTypes().length != 1) continue;
                this.optionClass = c.getParameterTypes()[0];
                break;
            }
        }

        protected TileCompressorControl setQuantType(Class<?> floatingPointType) {
            this.quantType = floatingPointType;
            return this;
        }

        @Override
        public boolean compress(Buffer in, ByteBuffer out, ICompressOption option) {
            try {
                return this.newCompressor(option).compress(in, out);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "could not compress using " + this.constructors[0].getName() + " must fallback to other compression method", e);
                return false;
            }
        }

        @Override
        public void decompress(ByteBuffer in, Buffer out, ICompressOption option) {
            try {
                this.newCompressor(option).decompress(in, out);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not decompress " + this.constructors[0].getName(), e);
            }
        }

        @Override
        public ICompressOption option() {
            ICompressOption option = null;
            if (this.optionClass != null) {
                try {
                    option = this.optionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("could not instantiate option class for " + this.constructors[0].getName(), e);
                }
            }
            if (option == null) {
                option = NULL_OPTION;
            }
            if (this.quantType != null) {
                return new QuantizeOption(option);
            }
            return option;
        }

        private ICompressor<Buffer> newCompressor(ICompressOption option) throws InstantiationException, IllegalAccessException, InvocationTargetException {
            ICompressor<Buffer> compressor = null;
            QuantizeOption quantOption = null;
            if (option == NULL_OPTION) {
                option = null;
            } else if (option instanceof QuantizeOption) {
                quantOption = (QuantizeOption)option;
                option = quantOption.getCompressOption();
            }
            try {
                for (Constructor<ICompressor<Buffer>> c : this.constructors) {
                    Class<?>[] parms = c.getParameterTypes();
                    if (option == null && parms.length == 0) {
                        compressor = c.newInstance(new Object[0]);
                        break;
                    }
                    if (option == null || parms.length != 1) continue;
                    Class<?> p = parms[0];
                    if (quantOption != null && p.isAssignableFrom(quantOption.getClass())) {
                        compressor = c.newInstance(quantOption);
                        quantOption = null;
                        break;
                    }
                    if (!p.isAssignableFrom(option.getClass())) continue;
                    compressor = c.newInstance(option);
                    break;
                }
                if (quantOption != null && this.quantType != null) {
                    if (this.quantType.equals(Double.TYPE)) {
                        return new QuantizeProcessor.DoubleQuantCompressor(quantOption, compressor);
                    }
                    if (this.quantType.equals(Float.TYPE)) {
                        return new QuantizeProcessor.FloatQuantCompressor(quantOption, compressor);
                    }
                }
                return compressor;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

